<?php


/**
 * LearnDash Version Constant
 */

add_action( 'admin_init', 'ldlawpf_learndash_check' );

/**
 * LearnDash Dependency Check
 * Must have LearnDash active. Otherwise, deactivate plugin.
 */
function ldlawpf_learndash_check() {

	if ( is_admin() && current_user_can( 'activate_plugins' ) && ! class_exists( 'SFWD_LMS' ) ) {
		deactivate_plugins( plugin_basename( __FILE__ ) );

		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}
	}
}


if ( ! defined( 'ABZARWP_LD_LMS_FONT' ) ) {
	define( 'ABZARWP_LD_LMS_FONT', trailingslashit( str_replace( '\\', '/', WP_PLUGIN_DIR ) . '/' . basename( dirname( __FILE__ ) ) ) );
}
if ( ! defined( 'ABZARWP_LD_LMS_FONT_FOLDER' ) ) {
	define( 'ABZARWP_LD_LMS_FONT_FOLDER', ABZARWP_LD_LMS_FONT . 'tcpdf/fonts/' );

}


require_once ABZARWP_LD_LMS_FONT . 'framework/codestar/codestar-framework.php';
require_once ABZARWP_LD_LMS_FONT . 'admin/metabox.php';

add_action( 'plugins_loaded', 'ldlawpf_load_plugin_textdomain' );
function ldlawpf_load_plugin_textdomain() {
	load_plugin_textdomain(
		'abzarwp-ldlawpf',
		false,
		dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/lang/'
	);
}

function ldlawpf_get_fonts() {
	$fonts = [
		'vazir',
		'gandom'
	];

	return $fonts;
}

function add_font() {
	$fonts = ldlawpf_get_fonts();
	foreach ( $fonts as $font ) {
		$font_file = ABZARWP_LD_LMS_FONT_FOLDER . $font . '.ttf';
		if ( file_exists( $font_file ) ) {
			TCPDF_FONTS::addTTFfont( $font_file, 'TrueTypeUnicode', '', 96 );
		}
	}

}

function ldlawpf_metabox_get_option( $id ) {
	$option = get_post_meta( $id, 'abzarwp_ldlawpf', true );
	if ( is_array( $option ) ) {
		if ( isset( $option['ldlawpf_font'] ) && isset( $option['ldlawpf_font_size'] ) ) {
			return $option;
		} else {
			return false;
		}
	}

	return false;
}

add_filter( 'learndash_certification_created', 'ldlawpf_add_font', 1, 2 );
function ldlawpf_add_font( $pdf, $id ) {
	$option = ldlawpf_metabox_get_option( $id );
	add_font();
	if ( $option === false ) {
		return $pdf;
	}
	$font = strtolower( $option['ldlawpf_font'] );
	$size = (int) $option['ldlawpf_font_size'];
	$pdf->SetFont( $font, '', $size );
}