<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

  //
  // Set a unique slug-like ID
  $prefix = 'abzarwp_ldlawpf';

  //
  // Create a metabox
  CSF::createMetabox($prefix, array(
    'title'     => esc_html__('Fonts', ' abzarwp-ldlawpf'),
    'post_type' => 'sfwd-certificates',
  ));

  //
  // Create a section

  $fonts = ldlawpf_get_fonts();
  $options=[];
  if (is_array($fonts)) {
    $fonts=array_unique($fonts);
    foreach ($fonts as $font) {
      $options[$font]=ucfirst($font);
    }
  }

  CSF::createSection($prefix, array(

    'fields' => array(
      array(
        'id'          => 'ldlawpf_font',
        'type'        => 'select',
        'title'       => esc_html__('Font', ' abzarwp-ldlawpf'),
        'placeholder' => 'Select an option',
        'options'     => $options,
        'default'     => 'samim'
      ),
      array(
        'id'    => 'ldlawpf_font_size',
        'type'  => 'slider',
        'title'       => esc_html__('Size', ' abzarwp-ldlawpf'),
        'min' => '1',
        'max' => '100',
        'default'     => '10'
      ),
    )
  ));
}
