/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2022-03-14 06:51:57 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `esduc_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=208 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=16000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=601 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `esduc_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_addon_feed` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `feed_order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `addon_slug` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `addon_form` (`addon_slug`,`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_draft_submissions` (
  `uuid` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `submission` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_agent` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `currency` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_status` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_index` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entries_grid_meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmations` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notifications` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_ir_paypal_payouts_transactions` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `batch_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` float NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `labels` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `args` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_fields` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_type` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `labels` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `args` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_fields` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_ld_achievements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `post_id` int(10) unsigned NOT NULL,
  `trigger` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `points` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_category` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_form` (
  `form_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `fieldname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(4) NOT NULL,
  `required` tinyint(1) unsigned NOT NULL,
  `sort` tinyint(4) NOT NULL,
  `data` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`form_id`),
  KEY `quiz_id` (`quiz_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_lock` (
  `quiz_id` int(11) NOT NULL,
  `lock_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `lock_type` tinyint(3) unsigned NOT NULL,
  `lock_date` int(11) NOT NULL,
  PRIMARY KEY (`quiz_id`,`lock_ip`,`user_id`,`lock_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `result_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `result_grade_enabled` tinyint(1) NOT NULL,
  `title_hidden` tinyint(1) NOT NULL,
  `btn_restart_quiz_hidden` tinyint(1) NOT NULL,
  `btn_view_question_hidden` tinyint(1) NOT NULL,
  `question_random` tinyint(1) NOT NULL,
  `answer_random` tinyint(1) NOT NULL,
  `time_limit` int(11) NOT NULL,
  `statistics_on` tinyint(1) NOT NULL,
  `statistics_ip_lock` int(10) unsigned NOT NULL,
  `show_points` tinyint(1) NOT NULL,
  `quiz_run_once` tinyint(1) NOT NULL,
  `quiz_run_once_type` tinyint(4) NOT NULL,
  `quiz_run_once_cookie` tinyint(1) NOT NULL,
  `quiz_run_once_time` int(10) unsigned NOT NULL,
  `numbered_answer` tinyint(1) NOT NULL,
  `hide_answer_message_box` tinyint(1) NOT NULL,
  `disabled_answer_mark` tinyint(1) NOT NULL,
  `show_max_question` tinyint(1) NOT NULL,
  `show_max_question_value` int(10) unsigned NOT NULL,
  `show_max_question_percent` tinyint(1) NOT NULL,
  `toplist_activated` tinyint(1) NOT NULL,
  `toplist_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_average_result` tinyint(1) NOT NULL,
  `prerequisite` tinyint(1) NOT NULL,
  `quiz_modus` tinyint(3) unsigned NOT NULL,
  `show_review_question` tinyint(1) NOT NULL,
  `quiz_summary_hide` tinyint(1) NOT NULL,
  `skip_question_disabled` tinyint(1) NOT NULL,
  `email_notification` tinyint(3) unsigned NOT NULL,
  `user_email_notification` tinyint(1) unsigned NOT NULL,
  `show_category_score` tinyint(1) unsigned NOT NULL,
  `hide_result_correct_question` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hide_result_quiz_time` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hide_result_points` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `autostart` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `forcing_question_solve` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hide_question_position_overview` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hide_question_numbering` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `form_activated` tinyint(1) unsigned NOT NULL,
  `form_show_position` tinyint(3) unsigned NOT NULL,
  `start_only_registered_user` tinyint(1) unsigned NOT NULL,
  `questions_per_page` tinyint(3) unsigned NOT NULL,
  `sort_categories` tinyint(1) unsigned NOT NULL,
  `show_category` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_prerequisite` (
  `prerequisite_quiz_id` int(11) NOT NULL,
  `quiz_id` int(11) NOT NULL,
  PRIMARY KEY (`prerequisite_quiz_id`,`quiz_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `online` tinyint(1) unsigned NOT NULL,
  `previous_id` int(11) NOT NULL,
  `sort` smallint(5) unsigned NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `points` int(11) NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `correct_msg` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `incorrect_msg` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `correct_same_text` tinyint(1) NOT NULL,
  `tip_enabled` tinyint(1) NOT NULL,
  `tip_msg` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_points_in_box` tinyint(1) NOT NULL,
  `answer_points_activated` tinyint(1) NOT NULL,
  `answer_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `answer_points_diff_modus_activated` tinyint(1) unsigned NOT NULL,
  `disable_correct` tinyint(1) unsigned NOT NULL,
  `matrix_sort_answer_criteria_width` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `quiz_id` (`quiz_id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_statistic` (
  `statistic_ref_id` int(10) unsigned NOT NULL,
  `question_id` int(11) NOT NULL,
  `question_post_id` int(11) NOT NULL,
  `correct_count` int(10) unsigned NOT NULL,
  `incorrect_count` int(10) unsigned NOT NULL,
  `hint_count` int(10) unsigned NOT NULL,
  `points` int(10) unsigned NOT NULL,
  `question_time` int(10) unsigned NOT NULL,
  `answer_data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`statistic_ref_id`,`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_statistic_ref` (
  `statistic_ref_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `quiz_post_id` int(11) NOT NULL,
  `course_post_id` int(11) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `create_time` int(11) NOT NULL,
  `is_old` tinyint(1) unsigned NOT NULL,
  `form_data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`statistic_ref_id`),
  KEY `quiz_id` (`quiz_id`,`user_id`),
  KEY `time` (`create_time`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_template` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_pro_quiz_toplist` (
  `toplist_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `points` int(10) unsigned NOT NULL,
  `result` float unsigned NOT NULL,
  `ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`toplist_id`,`quiz_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_user_activity` (
  `activity_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `course_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `activity_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activity_status` tinyint(1) unsigned DEFAULT NULL,
  `activity_started` int(11) unsigned DEFAULT NULL,
  `activity_completed` int(11) unsigned DEFAULT NULL,
  `activity_updated` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`activity_id`),
  KEY `user_id` (`user_id`),
  KEY `post_id` (`post_id`),
  KEY `course_id` (`course_id`),
  KEY `activity_status` (`activity_status`),
  KEY `activity_type` (`activity_type`),
  KEY `activity_started` (`activity_started`),
  KEY `activity_completed` (`activity_completed`),
  KEY `activity_updated` (`activity_updated`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_learndash_user_activity_meta` (
  `activity_meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `activity_meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activity_meta_value` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`activity_meta_id`),
  KEY `activity_id` (`activity_id`),
  KEY `activity_meta_key` (`activity_meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=31559 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=22598 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=4381 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_signups` (
  `signup_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `domain` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `activation_key` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`signup_id`),
  KEY `activation_key` (`activation_key`),
  KEY `user_email` (`user_email`),
  KEY `user_login_email` (`user_login`,`user_email`),
  KEY `domain_path` (`domain`(140),`path`(51))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=688 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=811 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  KEY `product_or_parent_id_term_id` (`product_or_parent_id`,`term_id`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wdm_instructor_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `actual_price` float DEFAULT NULL,
  `commission_price` float DEFAULT NULL,
  `transaction_time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `product_type` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `esduc_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wpfm_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backup_date` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `esduc_wppcp_group_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

CREATE TABLE `esduc_wppcp_private_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `content` longtext NOT NULL,
  `type` varchar(20) NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;


/* INSERT TABLE DATA: esduc_actionscheduler_actions */
INSERT INTO `esduc_actionscheduler_actions` VALUES("186", "woocommerce_update_db_to_current_version", "complete", "2022-03-13 06:01:04", "2022-03-13 09:31:04", "{\"version\":\"6.3.1\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647151264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647151264;}", "3", "1", "2022-03-13 06:01:54", "2022-03-13 09:31:54", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("152", "wc-admin_import_customers", "complete", "2022-02-11 07:53:12", "2022-02-11 11:23:12", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644565992;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644565992;}", "2", "1", "2022-02-11 07:53:53", "2022-02-11 11:23:53", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("155", "wc-admin_import_customers", "complete", "2022-02-12 07:03:39", "2022-02-12 10:33:39", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644649419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644649419;}", "2", "1", "2022-02-12 07:04:03", "2022-02-12 10:34:03", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("153", "action_scheduler/migration_hook", "complete", "2022-02-11 09:10:50", "2022-02-11 12:40:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644570650;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644570650;}", "1", "1", "2022-02-11 09:10:55", "2022-02-11 12:40:55", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("156", "wc-admin_import_customers", "complete", "2022-02-12 08:39:43", "2022-02-12 12:09:43", "[9]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644655183;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644655183;}", "2", "1", "2022-02-12 08:44:08", "2022-02-12 12:14:08", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("158", "wc-admin_import_customers", "complete", "2022-02-13 18:55:05", "2022-02-13 22:25:05", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644778505;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644778505;}", "2", "1", "2022-02-13 18:58:56", "2022-02-13 22:28:56", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("166", "action_scheduler/migration_hook", "complete", "2022-02-14 15:19:01", "2022-02-14 18:49:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644851941;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644851941;}", "1", "1", "2022-02-14 15:19:45", "2022-02-14 18:49:45", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("165", "action_scheduler/migration_hook", "complete", "2022-02-14 15:14:53", "2022-02-14 18:44:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644851693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644851693;}", "1", "1", "2022-02-14 15:14:58", "2022-02-14 18:44:58", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("164", "action_scheduler/migration_hook", "complete", "2022-02-14 15:13:49", "2022-02-14 18:43:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644851629;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644851629;}", "1", "1", "2022-02-14 15:13:52", "2022-02-14 18:43:52", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("167", "wc-admin_import_customers", "complete", "2022-02-15 11:37:10", "2022-02-15 15:07:10", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644925030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644925030;}", "2", "1", "2022-02-15 11:37:49", "2022-02-15 15:07:49", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("170", "wc-admin_import_customers", "complete", "2022-02-18 09:28:04", "2022-02-18 12:58:04", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645176484;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645176484;}", "2", "1", "2022-02-18 09:29:01", "2022-02-18 12:59:01", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("182", "wc-admin_import_customers", "complete", "2022-03-09 09:20:12", "2022-03-09 12:50:12", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646817612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646817612;}", "2", "1", "2022-03-09 09:20:18", "2022-03-09 12:50:18", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("185", "woocommerce_run_update_callback", "complete", "2022-03-13 06:01:03", "2022-03-13 09:31:03", "{\"update_callback\":\"wc_update_630_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647151263;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647151263;}", "3", "1", "2022-03-13 06:01:54", "2022-03-13 09:31:54", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("184", "woocommerce_run_update_callback", "complete", "2022-03-13 06:01:02", "2022-03-13 09:31:02", "{\"update_callback\":\"wc_update_630_create_product_attributes_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647151262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647151262;}", "3", "1", "2022-03-13 06:01:54", "2022-03-13 09:31:54", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("183", "wc-admin_import_customers", "complete", "2022-03-13 05:57:36", "2022-03-13 09:27:36", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647151056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647151056;}", "2", "1", "2022-03-13 05:59:37", "2022-03-13 09:29:37", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("190", "wc-admin_import_customers", "complete", "2022-03-14 06:07:43", "2022-03-14 09:37:43", "[9]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647238063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647238063;}", "2", "1", "2022-03-14 06:07:52", "2022-03-14 09:37:52", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("154", "wc-admin_import_customers", "complete", "2022-02-11 16:31:11", "2022-02-11 20:01:11", "[9]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644597071;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644597071;}", "2", "1", "2022-02-11 16:31:48", "2022-02-11 20:01:48", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("157", "wc-admin_import_customers", "complete", "2022-02-13 04:42:12", "2022-02-13 08:12:12", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644727332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644727332;}", "2", "1", "2022-02-13 04:43:11", "2022-02-13 08:13:11", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("159", "wc-admin_import_customers", "complete", "2022-02-14 06:36:25", "2022-02-14 10:06:25", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644820585;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644820585;}", "2", "1", "2022-02-14 06:36:51", "2022-02-14 10:06:51", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("160", "action_scheduler/migration_hook", "complete", "2022-02-14 06:41:16", "2022-02-14 10:11:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644820876;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644820876;}", "1", "1", "2022-02-14 06:41:47", "2022-02-14 10:11:47", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("161", "action_scheduler/migration_hook", "complete", "2022-02-14 07:31:31", "2022-02-14 11:01:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644823891;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644823891;}", "1", "1", "2022-02-14 07:32:15", "2022-02-14 11:02:15", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("162", "action_scheduler/migration_hook", "complete", "2022-02-14 07:48:31", "2022-02-14 11:18:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644824911;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644824911;}", "1", "1", "2022-02-14 07:48:35", "2022-02-14 11:18:35", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("163", "action_scheduler/migration_hook", "complete", "2022-02-14 08:18:02", "2022-02-14 11:48:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644826682;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644826682;}", "1", "1", "2022-02-14 08:19:05", "2022-02-14 11:49:05", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("168", "wc-admin_import_customers", "complete", "2022-02-16 09:08:14", "2022-02-16 12:38:14", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645002494;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645002494;}", "2", "1", "2022-02-16 09:08:20", "2022-02-16 12:38:20", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("169", "wc-admin_import_customers", "complete", "2022-02-17 05:53:11", "2022-02-17 09:23:11", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645077191;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645077191;}", "2", "1", "2022-02-17 05:53:48", "2022-02-17 09:23:48", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("171", "wc-admin_import_customers", "complete", "2022-02-19 08:21:16", "2022-02-19 11:51:16", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645258876;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645258876;}", "2", "1", "2022-02-19 08:22:12", "2022-02-19 11:52:12", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("172", "wc-admin_import_customers", "complete", "2022-02-20 12:09:21", "2022-02-20 15:39:21", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645358961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645358961;}", "2", "1", "2022-02-20 12:10:29", "2022-02-20 15:40:29", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("173", "wc-admin_import_customers", "complete", "2022-02-21 08:13:44", "2022-02-21 11:43:44", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645431224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645431224;}", "2", "1", "2022-02-21 08:14:46", "2022-02-21 11:44:46", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("174", "action_scheduler/migration_hook", "complete", "2022-02-21 09:00:12", "2022-02-21 12:30:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645434012;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645434012;}", "1", "1", "2022-02-21 09:00:14", "2022-02-21 12:30:14", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("175", "action_scheduler/migration_hook", "canceled", "2022-02-21 09:00:12", "2022-02-21 12:30:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645434012;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645434012;}", "1", "0", "2022-02-21 09:00:14", "2022-02-21 12:30:14", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("176", "wc-admin_import_customers", "complete", "2022-02-22 05:44:09", "2022-02-22 09:14:09", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645508649;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645508649;}", "2", "1", "2022-02-22 05:44:49", "2022-02-22 09:14:49", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("177", "wc-admin_import_customers", "complete", "2022-02-23 07:10:50", "2022-02-23 10:40:50", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645600250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645600250;}", "2", "1", "2022-02-23 07:22:40", "2022-02-23 10:52:40", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("178", "wc-admin_import_customers", "complete", "2022-02-26 06:32:18", "2022-02-26 10:02:18", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645857138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645857138;}", "2", "1", "2022-02-26 06:32:22", "2022-02-26 10:02:22", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("179", "wc-admin_import_customers", "complete", "2022-02-27 06:14:01", "2022-02-27 09:44:01", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645942441;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645942441;}", "2", "1", "2022-02-27 06:14:58", "2022-02-27 09:44:58", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("180", "wc-admin_import_customers", "complete", "2022-03-07 09:35:30", "2022-03-07 13:05:30", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646645730;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646645730;}", "2", "1", "2022-03-07 09:35:48", "2022-03-07 13:05:48", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("181", "wc-admin_import_customers", "complete", "2022-03-08 07:59:04", "2022-03-08 11:29:04", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646726344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646726344;}", "2", "1", "2022-03-08 07:59:24", "2022-03-08 11:29:24", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("187", "woocommerce_run_update_callback", "failed", "2022-03-13 06:01:17", "2022-03-13 09:31:17", "{\"update_callback\":\"wc_update_630_create_product_attributes_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647151277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647151277;}", "3", "1", "2022-03-13 06:01:54", "2022-03-13 09:31:54", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("188", "woocommerce_run_update_callback", "complete", "2022-03-13 06:01:18", "2022-03-13 09:31:18", "{\"update_callback\":\"wc_update_630_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647151278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647151278;}", "3", "1", "2022-03-13 06:01:54", "2022-03-13 09:31:54", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("189", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2022-03-13 06:01:55", "2022-03-13 09:31:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647151315;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647151315;}", "3", "1", "2022-03-13 06:02:00", "2022-03-13 09:32:00", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("191", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:20", "2022-03-14 10:04:20", "[9]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239660;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239660;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("192", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:21", "2022-03-14 10:04:21", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239661;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239661;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("193", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:22", "2022-03-14 10:04:22", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239662;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("194", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:22", "2022-03-14 10:04:22", "[11]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239662;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("195", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:22", "2022-03-14 10:04:22", "[3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239662;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("196", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:22", "2022-03-14 10:04:22", "[12]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239662;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("197", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:22", "2022-03-14 10:04:22", "[4]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239662;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("198", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:22", "2022-03-14 10:04:22", "[13]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239662;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("199", "wc-admin_delete_user_customers", "complete", "2022-03-14 06:34:22", "2022-03-14 10:04:22", "[10]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647239662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647239662;}", "2", "1", "2022-03-14 06:34:57", "2022-03-14 10:04:57", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("200", "wc-admin_import_orders", "complete", "2022-03-14 06:48:20", "2022-03-14 10:18:20", "[2350]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647240500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647240500;}", "2", "1", "2022-03-14 06:48:51", "2022-03-14 10:18:51", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("201", "wc-admin_import_orders", "complete", "2022-03-14 06:48:20", "2022-03-14 10:18:20", "[1907]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647240500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647240500;}", "2", "1", "2022-03-14 06:48:51", "2022-03-14 10:18:51", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("202", "wc-admin_import_orders", "complete", "2022-03-14 06:48:20", "2022-03-14 10:18:20", "[1388]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647240500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647240500;}", "2", "1", "2022-03-14 06:48:51", "2022-03-14 10:18:51", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("203", "wc-admin_import_orders", "complete", "2022-03-14 06:48:20", "2022-03-14 10:18:20", "[1387]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647240500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647240500;}", "2", "1", "2022-03-14 06:48:51", "2022-03-14 10:18:51", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("204", "wc-admin_import_orders", "complete", "2022-03-14 06:48:20", "2022-03-14 10:18:20", "[1386]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647240500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647240500;}", "2", "1", "2022-03-14 06:48:51", "2022-03-14 10:18:51", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("205", "wc-admin_import_orders", "complete", "2022-03-14 06:48:20", "2022-03-14 10:18:20", "[1385]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647240500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647240500;}", "2", "1", "2022-03-14 06:48:51", "2022-03-14 10:18:51", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("206", "wc-admin_import_orders", "complete", "2022-03-14 06:48:20", "2022-03-14 10:18:20", "[1384]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647240500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647240500;}", "2", "1", "2022-03-14 06:48:51", "2022-03-14 10:18:51", "0", NULL);
INSERT INTO `esduc_actionscheduler_actions` VALUES("207", "wc-admin_import_orders", "complete", "2022-03-14 06:48:20", "2022-03-14 10:18:20", "[1271]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1647240500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1647240500;}", "2", "1", "2022-03-14 06:48:51", "2022-03-14 10:18:51", "0", NULL);

/* INSERT TABLE DATA: esduc_actionscheduler_groups */
INSERT INTO `esduc_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `esduc_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `esduc_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");

/* INSERT TABLE DATA: esduc_actionscheduler_logs */
INSERT INTO `esduc_actionscheduler_logs` VALUES("537", "185", "عملیات توسط Async Request کامل شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("536", "185", "عملیات توسط Async Request شروع شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("434", "152", "عملیات توسط WP Cron شروع شد", "2022-02-11 07:53:53", "2022-02-11 11:23:53");
INSERT INTO `esduc_actionscheduler_logs` VALUES("433", "152", "ایجاد فعالیت", "2022-02-11 07:53:07", "2022-02-11 11:23:07");
INSERT INTO `esduc_actionscheduler_logs` VALUES("443", "155", "عملیات توسط WP Cron شروع شد", "2022-02-12 07:04:03", "2022-02-12 10:34:03");
INSERT INTO `esduc_actionscheduler_logs` VALUES("442", "155", "ایجاد فعالیت", "2022-02-12 07:03:34", "2022-02-12 10:33:34");
INSERT INTO `esduc_actionscheduler_logs` VALUES("477", "166", "action complete via Async Request", "2022-02-14 15:19:45", "2022-02-14 18:49:45");
INSERT INTO `esduc_actionscheduler_logs` VALUES("513", "178", "عملیات توسط Async Request کامل شد", "2022-02-26 06:32:22", "2022-02-26 10:02:22");
INSERT INTO `esduc_actionscheduler_logs` VALUES("512", "178", "عملیات توسط Async Request شروع شد", "2022-02-26 06:32:22", "2022-02-26 10:02:22");
INSERT INTO `esduc_actionscheduler_logs` VALUES("549", "190", "عملیات توسط Async Request کامل شد", "2022-03-14 06:07:52", "2022-03-14 09:37:52");
INSERT INTO `esduc_actionscheduler_logs` VALUES("437", "153", "عملیات توسط WP Cron شروع شد", "2022-02-11 09:10:55", "2022-02-11 12:40:55");
INSERT INTO `esduc_actionscheduler_logs` VALUES("436", "153", "ایجاد فعالیت", "2022-02-11 09:09:50", "2022-02-11 12:39:50");
INSERT INTO `esduc_actionscheduler_logs` VALUES("446", "156", "عملیات توسط WP Cron شروع شد", "2022-02-12 08:44:08", "2022-02-12 12:14:08");
INSERT INTO `esduc_actionscheduler_logs` VALUES("445", "156", "ایجاد فعالیت", "2022-02-12 08:39:38", "2022-02-12 12:09:38");
INSERT INTO `esduc_actionscheduler_logs` VALUES("451", "158", "ایجاد فعالیت", "2022-02-13 18:55:00", "2022-02-13 22:25:00");
INSERT INTO `esduc_actionscheduler_logs` VALUES("476", "166", "action started via Async Request", "2022-02-14 15:19:45", "2022-02-14 18:49:45");
INSERT INTO `esduc_actionscheduler_logs` VALUES("475", "166", "action created", "2022-02-14 15:18:01", "2022-02-14 18:48:01");
INSERT INTO `esduc_actionscheduler_logs` VALUES("473", "165", "عملیات توسط WP Cron شروع شد", "2022-02-14 15:14:58", "2022-02-14 18:44:58");
INSERT INTO `esduc_actionscheduler_logs` VALUES("474", "165", "عملیات توسط WP Cron کامل شد", "2022-02-14 15:14:58", "2022-02-14 18:44:58");
INSERT INTO `esduc_actionscheduler_logs` VALUES("472", "165", "ایجاد فعالیت", "2022-02-14 15:13:53", "2022-02-14 18:43:53");
INSERT INTO `esduc_actionscheduler_logs` VALUES("471", "164", "عملیات توسط WP Cron کامل شد", "2022-02-14 15:13:52", "2022-02-14 18:43:52");
INSERT INTO `esduc_actionscheduler_logs` VALUES("470", "164", "عملیات توسط WP Cron شروع شد", "2022-02-14 15:13:52", "2022-02-14 18:43:52");
INSERT INTO `esduc_actionscheduler_logs` VALUES("469", "164", "ایجاد فعالیت", "2022-02-14 15:12:49", "2022-02-14 18:42:49");
INSERT INTO `esduc_actionscheduler_logs` VALUES("480", "167", "عملیات توسط Async Request کامل شد", "2022-02-15 11:37:49", "2022-02-15 15:07:49");
INSERT INTO `esduc_actionscheduler_logs` VALUES("478", "167", "ایجاد فعالیت", "2022-02-15 11:37:05", "2022-02-15 15:07:05");
INSERT INTO `esduc_actionscheduler_logs` VALUES("479", "167", "عملیات توسط Async Request شروع شد", "2022-02-15 11:37:49", "2022-02-15 15:07:49");
INSERT INTO `esduc_actionscheduler_logs` VALUES("489", "170", "عملیات توسط WP Cron کامل شد", "2022-02-18 09:29:01", "2022-02-18 12:59:01");
INSERT INTO `esduc_actionscheduler_logs` VALUES("488", "170", "عملیات توسط WP Cron شروع شد", "2022-02-18 09:29:01", "2022-02-18 12:59:01");
INSERT INTO `esduc_actionscheduler_logs` VALUES("487", "170", "ایجاد فعالیت", "2022-02-18 09:27:59", "2022-02-18 12:57:59");
INSERT INTO `esduc_actionscheduler_logs` VALUES("525", "182", "عملیات توسط Async Request کامل شد", "2022-03-09 09:20:18", "2022-03-09 12:50:18");
INSERT INTO `esduc_actionscheduler_logs` VALUES("524", "182", "عملیات توسط Async Request شروع شد", "2022-03-09 09:20:18", "2022-03-09 12:50:18");
INSERT INTO `esduc_actionscheduler_logs` VALUES("523", "182", "ایجاد فعالیت", "2022-03-09 09:20:07", "2022-03-09 12:50:07");
INSERT INTO `esduc_actionscheduler_logs` VALUES("535", "186", "عملیات توسط Async Request کامل شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("534", "186", "عملیات توسط Async Request شروع شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("531", "186", "ایجاد فعالیت", "2022-03-13 06:01:02", "2022-03-13 09:31:02");
INSERT INTO `esduc_actionscheduler_logs` VALUES("532", "187", "ایجاد فعالیت", "2022-03-13 06:01:17", "2022-03-13 09:31:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("533", "188", "ایجاد فعالیت", "2022-03-13 06:01:17", "2022-03-13 09:31:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("530", "185", "ایجاد فعالیت", "2022-03-13 06:01:02", "2022-03-13 09:31:02");
INSERT INTO `esduc_actionscheduler_logs` VALUES("529", "184", "ایجاد فعالیت", "2022-03-13 06:01:02", "2022-03-13 09:31:02");
INSERT INTO `esduc_actionscheduler_logs` VALUES("528", "183", "عملیات توسط WP Cron کامل شد", "2022-03-13 05:59:37", "2022-03-13 09:29:37");
INSERT INTO `esduc_actionscheduler_logs` VALUES("527", "183", "عملیات توسط WP Cron شروع شد", "2022-03-13 05:59:37", "2022-03-13 09:29:37");
INSERT INTO `esduc_actionscheduler_logs` VALUES("526", "183", "ایجاد فعالیت", "2022-03-13 05:57:31", "2022-03-13 09:27:31");
INSERT INTO `esduc_actionscheduler_logs` VALUES("548", "190", "عملیات توسط Async Request شروع شد", "2022-03-14 06:07:52", "2022-03-14 09:37:52");
INSERT INTO `esduc_actionscheduler_logs` VALUES("547", "190", "ایجاد فعالیت", "2022-03-14 06:07:38", "2022-03-14 09:37:38");
INSERT INTO `esduc_actionscheduler_logs` VALUES("435", "152", "عملیات توسط WP Cron کامل شد", "2022-02-11 07:53:53", "2022-02-11 11:23:53");
INSERT INTO `esduc_actionscheduler_logs` VALUES("438", "153", "عملیات توسط WP Cron کامل شد", "2022-02-11 09:10:55", "2022-02-11 12:40:55");
INSERT INTO `esduc_actionscheduler_logs` VALUES("439", "154", "ایجاد فعالیت", "2022-02-11 16:31:06", "2022-02-11 20:01:06");
INSERT INTO `esduc_actionscheduler_logs` VALUES("440", "154", "عملیات توسط WP Cron شروع شد", "2022-02-11 16:31:48", "2022-02-11 20:01:48");
INSERT INTO `esduc_actionscheduler_logs` VALUES("441", "154", "عملیات توسط WP Cron کامل شد", "2022-02-11 16:31:48", "2022-02-11 20:01:48");
INSERT INTO `esduc_actionscheduler_logs` VALUES("444", "155", "عملیات توسط WP Cron کامل شد", "2022-02-12 07:04:03", "2022-02-12 10:34:03");
INSERT INTO `esduc_actionscheduler_logs` VALUES("447", "156", "عملیات توسط WP Cron کامل شد", "2022-02-12 08:44:08", "2022-02-12 12:14:08");
INSERT INTO `esduc_actionscheduler_logs` VALUES("448", "157", "ایجاد فعالیت", "2022-02-13 04:42:07", "2022-02-13 08:12:07");
INSERT INTO `esduc_actionscheduler_logs` VALUES("449", "157", "عملیات توسط WP Cron شروع شد", "2022-02-13 04:43:11", "2022-02-13 08:13:11");
INSERT INTO `esduc_actionscheduler_logs` VALUES("450", "157", "عملیات توسط WP Cron کامل شد", "2022-02-13 04:43:11", "2022-02-13 08:13:11");
INSERT INTO `esduc_actionscheduler_logs` VALUES("452", "158", "عملیات توسط WP Cron شروع شد", "2022-02-13 18:58:56", "2022-02-13 22:28:56");
INSERT INTO `esduc_actionscheduler_logs` VALUES("453", "158", "عملیات توسط WP Cron کامل شد", "2022-02-13 18:58:56", "2022-02-13 22:28:56");
INSERT INTO `esduc_actionscheduler_logs` VALUES("454", "159", "ایجاد فعالیت", "2022-02-14 06:36:20", "2022-02-14 10:06:20");
INSERT INTO `esduc_actionscheduler_logs` VALUES("455", "159", "عملیات توسط WP Cron شروع شد", "2022-02-14 06:36:51", "2022-02-14 10:06:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("456", "159", "عملیات توسط WP Cron کامل شد", "2022-02-14 06:36:51", "2022-02-14 10:06:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("457", "160", "ایجاد فعالیت", "2022-02-14 06:40:16", "2022-02-14 10:10:16");
INSERT INTO `esduc_actionscheduler_logs` VALUES("458", "160", "عملیات توسط WP Cron شروع شد", "2022-02-14 06:41:47", "2022-02-14 10:11:47");
INSERT INTO `esduc_actionscheduler_logs` VALUES("459", "160", "عملیات توسط WP Cron کامل شد", "2022-02-14 06:41:47", "2022-02-14 10:11:47");
INSERT INTO `esduc_actionscheduler_logs` VALUES("460", "161", "ایجاد فعالیت", "2022-02-14 07:30:31", "2022-02-14 11:00:31");
INSERT INTO `esduc_actionscheduler_logs` VALUES("461", "161", "عملیات توسط WP Cron شروع شد", "2022-02-14 07:32:15", "2022-02-14 11:02:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("462", "161", "عملیات توسط WP Cron کامل شد", "2022-02-14 07:32:15", "2022-02-14 11:02:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("463", "162", "ایجاد فعالیت", "2022-02-14 07:47:31", "2022-02-14 11:17:31");
INSERT INTO `esduc_actionscheduler_logs` VALUES("464", "162", "عملیات توسط Async Request شروع شد", "2022-02-14 07:48:35", "2022-02-14 11:18:35");
INSERT INTO `esduc_actionscheduler_logs` VALUES("465", "162", "عملیات توسط Async Request کامل شد", "2022-02-14 07:48:35", "2022-02-14 11:18:35");
INSERT INTO `esduc_actionscheduler_logs` VALUES("466", "163", "ایجاد فعالیت", "2022-02-14 08:17:02", "2022-02-14 11:47:02");
INSERT INTO `esduc_actionscheduler_logs` VALUES("467", "163", "عملیات توسط WP Cron شروع شد", "2022-02-14 08:19:05", "2022-02-14 11:49:05");
INSERT INTO `esduc_actionscheduler_logs` VALUES("468", "163", "عملیات توسط WP Cron کامل شد", "2022-02-14 08:19:05", "2022-02-14 11:49:05");
INSERT INTO `esduc_actionscheduler_logs` VALUES("481", "168", "ایجاد فعالیت", "2022-02-16 09:08:09", "2022-02-16 12:38:09");
INSERT INTO `esduc_actionscheduler_logs` VALUES("482", "168", "عملیات توسط Async Request شروع شد", "2022-02-16 09:08:20", "2022-02-16 12:38:20");
INSERT INTO `esduc_actionscheduler_logs` VALUES("483", "168", "عملیات توسط Async Request کامل شد", "2022-02-16 09:08:20", "2022-02-16 12:38:20");
INSERT INTO `esduc_actionscheduler_logs` VALUES("484", "169", "ایجاد فعالیت", "2022-02-17 05:53:06", "2022-02-17 09:23:06");
INSERT INTO `esduc_actionscheduler_logs` VALUES("485", "169", "عملیات توسط Async Request شروع شد", "2022-02-17 05:53:48", "2022-02-17 09:23:48");
INSERT INTO `esduc_actionscheduler_logs` VALUES("486", "169", "عملیات توسط Async Request کامل شد", "2022-02-17 05:53:48", "2022-02-17 09:23:48");
INSERT INTO `esduc_actionscheduler_logs` VALUES("490", "171", "ایجاد فعالیت", "2022-02-19 08:21:11", "2022-02-19 11:51:11");
INSERT INTO `esduc_actionscheduler_logs` VALUES("491", "171", "عملیات توسط WP Cron شروع شد", "2022-02-19 08:22:12", "2022-02-19 11:52:12");
INSERT INTO `esduc_actionscheduler_logs` VALUES("492", "171", "عملیات توسط WP Cron کامل شد", "2022-02-19 08:22:12", "2022-02-19 11:52:12");
INSERT INTO `esduc_actionscheduler_logs` VALUES("493", "172", "ایجاد فعالیت", "2022-02-20 12:09:16", "2022-02-20 15:39:16");
INSERT INTO `esduc_actionscheduler_logs` VALUES("494", "172", "عملیات توسط WP Cron شروع شد", "2022-02-20 12:10:29", "2022-02-20 15:40:29");
INSERT INTO `esduc_actionscheduler_logs` VALUES("495", "172", "عملیات توسط WP Cron کامل شد", "2022-02-20 12:10:29", "2022-02-20 15:40:29");
INSERT INTO `esduc_actionscheduler_logs` VALUES("496", "173", "ایجاد فعالیت", "2022-02-21 08:13:39", "2022-02-21 11:43:39");
INSERT INTO `esduc_actionscheduler_logs` VALUES("497", "173", "عملیات توسط Async Request شروع شد", "2022-02-21 08:14:46", "2022-02-21 11:44:46");
INSERT INTO `esduc_actionscheduler_logs` VALUES("498", "173", "عملیات توسط Async Request کامل شد", "2022-02-21 08:14:46", "2022-02-21 11:44:46");
INSERT INTO `esduc_actionscheduler_logs` VALUES("499", "174", "ایجاد فعالیت", "2022-02-21 08:59:12", "2022-02-21 12:29:12");
INSERT INTO `esduc_actionscheduler_logs` VALUES("500", "175", "ایجاد فعالیت", "2022-02-21 08:59:12", "2022-02-21 12:29:12");
INSERT INTO `esduc_actionscheduler_logs` VALUES("501", "174", "عملیات توسط Async Request شروع شد", "2022-02-21 09:00:14", "2022-02-21 12:30:14");
INSERT INTO `esduc_actionscheduler_logs` VALUES("502", "175", "لغو فعالیت", "2022-02-21 09:00:14", "2022-02-21 12:30:14");
INSERT INTO `esduc_actionscheduler_logs` VALUES("503", "174", "عملیات توسط Async Request کامل شد", "2022-02-21 09:00:14", "2022-02-21 12:30:14");
INSERT INTO `esduc_actionscheduler_logs` VALUES("504", "175", "عملیات از طریق Async Request نادیده گرفته شد", "2022-02-21 09:00:14", "2022-02-21 12:30:14");
INSERT INTO `esduc_actionscheduler_logs` VALUES("505", "176", "ایجاد فعالیت", "2022-02-22 05:44:04", "2022-02-22 09:14:04");
INSERT INTO `esduc_actionscheduler_logs` VALUES("506", "176", "عملیات توسط WP Cron شروع شد", "2022-02-22 05:44:49", "2022-02-22 09:14:49");
INSERT INTO `esduc_actionscheduler_logs` VALUES("507", "176", "عملیات توسط WP Cron کامل شد", "2022-02-22 05:44:49", "2022-02-22 09:14:49");
INSERT INTO `esduc_actionscheduler_logs` VALUES("508", "177", "ایجاد فعالیت", "2022-02-23 07:10:45", "2022-02-23 10:40:45");
INSERT INTO `esduc_actionscheduler_logs` VALUES("509", "177", "عملیات توسط WP Cron شروع شد", "2022-02-23 07:22:40", "2022-02-23 10:52:40");
INSERT INTO `esduc_actionscheduler_logs` VALUES("510", "177", "عملیات توسط WP Cron کامل شد", "2022-02-23 07:22:40", "2022-02-23 10:52:40");
INSERT INTO `esduc_actionscheduler_logs` VALUES("511", "178", "ایجاد فعالیت", "2022-02-26 06:32:13", "2022-02-26 10:02:13");
INSERT INTO `esduc_actionscheduler_logs` VALUES("514", "179", "ایجاد فعالیت", "2022-02-27 06:13:56", "2022-02-27 09:43:56");
INSERT INTO `esduc_actionscheduler_logs` VALUES("515", "179", "عملیات توسط WP Cron شروع شد", "2022-02-27 06:14:58", "2022-02-27 09:44:58");
INSERT INTO `esduc_actionscheduler_logs` VALUES("516", "179", "عملیات توسط WP Cron کامل شد", "2022-02-27 06:14:58", "2022-02-27 09:44:58");
INSERT INTO `esduc_actionscheduler_logs` VALUES("517", "180", "ایجاد فعالیت", "2022-03-07 09:35:25", "2022-03-07 13:05:25");
INSERT INTO `esduc_actionscheduler_logs` VALUES("518", "180", "عملیات توسط WP Cron شروع شد", "2022-03-07 09:35:48", "2022-03-07 13:05:48");
INSERT INTO `esduc_actionscheduler_logs` VALUES("519", "180", "عملیات توسط WP Cron کامل شد", "2022-03-07 09:35:48", "2022-03-07 13:05:48");
INSERT INTO `esduc_actionscheduler_logs` VALUES("520", "181", "ایجاد فعالیت", "2022-03-08 07:58:59", "2022-03-08 11:28:59");
INSERT INTO `esduc_actionscheduler_logs` VALUES("521", "181", "عملیات توسط Async Request شروع شد", "2022-03-08 07:59:24", "2022-03-08 11:29:24");
INSERT INTO `esduc_actionscheduler_logs` VALUES("522", "181", "عملیات توسط Async Request کامل شد", "2022-03-08 07:59:24", "2022-03-08 11:29:24");
INSERT INTO `esduc_actionscheduler_logs` VALUES("538", "184", "عملیات توسط Async Request شروع شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("539", "189", "ایجاد فعالیت", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("540", "184", "عملیات توسط Async Request کامل شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("541", "187", "عملیات توسط Async Request شروع شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("542", "187", "action failed via Async Request: Can\'t enable or disable the attributes lookup table usage while it\'s regenerating.", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("543", "188", "عملیات توسط Async Request شروع شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("544", "188", "عملیات توسط Async Request کامل شد", "2022-03-13 06:01:54", "2022-03-13 09:31:54");
INSERT INTO `esduc_actionscheduler_logs` VALUES("545", "189", "عملیات توسط Async Request شروع شد", "2022-03-13 06:02:00", "2022-03-13 09:32:00");
INSERT INTO `esduc_actionscheduler_logs` VALUES("546", "189", "عملیات توسط Async Request کامل شد", "2022-03-13 06:02:00", "2022-03-13 09:32:00");
INSERT INTO `esduc_actionscheduler_logs` VALUES("550", "191", "ایجاد فعالیت", "2022-03-14 06:34:15", "2022-03-14 10:04:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("551", "192", "ایجاد فعالیت", "2022-03-14 06:34:16", "2022-03-14 10:04:16");
INSERT INTO `esduc_actionscheduler_logs` VALUES("552", "193", "ایجاد فعالیت", "2022-03-14 06:34:17", "2022-03-14 10:04:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("553", "194", "ایجاد فعالیت", "2022-03-14 06:34:17", "2022-03-14 10:04:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("554", "195", "ایجاد فعالیت", "2022-03-14 06:34:17", "2022-03-14 10:04:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("555", "196", "ایجاد فعالیت", "2022-03-14 06:34:17", "2022-03-14 10:04:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("556", "197", "ایجاد فعالیت", "2022-03-14 06:34:17", "2022-03-14 10:04:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("557", "198", "ایجاد فعالیت", "2022-03-14 06:34:17", "2022-03-14 10:04:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("558", "199", "ایجاد فعالیت", "2022-03-14 06:34:17", "2022-03-14 10:04:17");
INSERT INTO `esduc_actionscheduler_logs` VALUES("559", "191", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("560", "191", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("561", "192", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("562", "192", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("563", "193", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("564", "193", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("565", "194", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("566", "194", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("567", "195", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("568", "195", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("569", "196", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("570", "196", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("571", "197", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("572", "197", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("573", "198", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("574", "198", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("575", "199", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("576", "199", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:34:57", "2022-03-14 10:04:57");
INSERT INTO `esduc_actionscheduler_logs` VALUES("577", "200", "ایجاد فعالیت", "2022-03-14 06:48:15", "2022-03-14 10:18:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("578", "201", "ایجاد فعالیت", "2022-03-14 06:48:15", "2022-03-14 10:18:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("579", "202", "ایجاد فعالیت", "2022-03-14 06:48:15", "2022-03-14 10:18:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("580", "203", "ایجاد فعالیت", "2022-03-14 06:48:15", "2022-03-14 10:18:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("581", "204", "ایجاد فعالیت", "2022-03-14 06:48:15", "2022-03-14 10:18:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("582", "205", "ایجاد فعالیت", "2022-03-14 06:48:15", "2022-03-14 10:18:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("583", "206", "ایجاد فعالیت", "2022-03-14 06:48:15", "2022-03-14 10:18:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("584", "207", "ایجاد فعالیت", "2022-03-14 06:48:15", "2022-03-14 10:18:15");
INSERT INTO `esduc_actionscheduler_logs` VALUES("585", "200", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("586", "200", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("587", "201", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("588", "201", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("589", "202", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("590", "202", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("591", "203", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("592", "203", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("593", "204", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("594", "204", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("595", "205", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("596", "205", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("597", "206", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("598", "206", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("599", "207", "عملیات توسط WP Cron شروع شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");
INSERT INTO `esduc_actionscheduler_logs` VALUES("600", "207", "عملیات توسط WP Cron کامل شد", "2022-03-14 06:48:51", "2022-03-14 10:18:51");

/* INSERT TABLE DATA: esduc_commentmeta */
INSERT INTO `esduc_commentmeta` VALUES("1", "14", "akismet_result", "false");
INSERT INTO `esduc_commentmeta` VALUES("2", "14", "akismet_history", "a:3:{s:4:\"time\";d:1642054158.4331629;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:5:\"demo2\";}");

/* INSERT TABLE DATA: esduc_comments */
INSERT INTO `esduc_comments` VALUES("1", "1", "یک نویسندهٔ دیدگاه در وردپرس", "wapuu@wordpress.example", "https://wordpress.org/", "", "2021-11-03 10:52:08", "2021-11-03 07:22:08", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");
INSERT INTO `esduc_comments` VALUES("2", "1271", "ووکامرس", "", "", "", "2021-12-30 18:09:55", "2021-12-30 14:39:55", "وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("3", "1271", "ووکامرس", "", "", "", "2021-12-30 18:09:55", "2021-12-30 14:39:55", "وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("4", "1384", "ووکامرس", "", "", "", "2022-01-01 08:58:32", "2022-01-01 05:28:32", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("5", "1385", "ووکامرس", "", "", "", "2022-01-01 09:02:14", "2022-01-01 05:32:14", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("6", "1386", "ووکامرس", "", "", "", "2022-01-01 09:07:02", "2022-01-01 05:37:02", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("7", "1387", "ووکامرس", "", "", "", "2022-01-01 09:15:22", "2022-01-01 05:45:22", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("8", "1388", "ووکامرس", "", "", "", "2022-01-01 09:18:00", "2022-01-01 05:48:00", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("9", "1384", "شهاب جعفری", "user-demo@abzarwp.com", "", "", "2022-01-01 11:02:52", "2022-01-01 07:32:52", "وضعیت سفارش توسط ویرایش توده‌ای تغییر یافت: وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("10", "1385", "شهاب جعفری", "user-demo@abzarwp.com", "", "", "2022-01-01 11:02:52", "2022-01-01 07:32:52", "وضعیت سفارش توسط ویرایش توده‌ای تغییر یافت: وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("11", "1386", "شهاب جعفری", "user-demo@abzarwp.com", "", "", "2022-01-01 11:02:52", "2022-01-01 07:32:52", "وضعیت سفارش توسط ویرایش توده‌ای تغییر یافت: وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("12", "1387", "شهاب جعفری", "user-demo@abzarwp.com", "", "", "2022-01-01 11:02:53", "2022-01-01 07:32:53", "وضعیت سفارش توسط ویرایش توده‌ای تغییر یافت: وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("13", "1388", "شهاب جعفری", "user-demo@abzarwp.com", "", "", "2022-01-01 11:02:53", "2022-01-01 07:32:53", "وضعیت سفارش توسط ویرایش توده‌ای تغییر یافت: وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("14", "314", "محمد قاسمی", "user-demo@abzarwp.com", "", "94.183.93.8", "2022-01-13 09:39:18", "2022-01-13 06:09:18", "این مقاله بسیار مناسب بود.", "0", "1", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.55", "comment", "0", "2");
INSERT INTO `esduc_comments` VALUES("15", "1907", "ووکامرس", "", "", "", "2022-01-13 11:57:05", "2022-01-13 08:27:05", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");
INSERT INTO `esduc_comments` VALUES("16", "2350", "ووکامرس", "", "", "", "2022-02-10 13:42:23", "2022-02-10 10:12:23", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "post-trashed", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: esduc_duplicator_packages */
INSERT INTO `esduc_duplicator_packages` VALUES("6", "20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8", "d01918fceeec7c519509_20220314065134", "21", "2022-03-14 06:51:57", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-03-14 06:51:34\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.2\";s:9:\"VersionDB\";s:7:\"10.4.22\";s:10:\"VersionPHP\";s:6:\"7.4.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:39:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"d01918fceeec7c519509_20220314065134\";s:8:\"NameHash\";s:75:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.8\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:70:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-03-14 06:51:34\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.2\";s:9:\"VersionDB\";s:7:\"10.4.22\";s:10:\"VersionPHP\";s:6:\"7.4.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"d01918fceeec7c519509_20220314065134\";s:8:\"NameHash\";s:75:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:89:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:5:{s:29:\"esduc_actionscheduler_actions\";s:2:\"56\";s:28:\"esduc_actionscheduler_claims\";s:1:\"0\";s:28:\"esduc_actionscheduler_groups\";s:1:\"3\";s:26:\"esduc_actionscheduler_logs\";s:3:\"168\";s:17:\"esduc_commentmeta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:191:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/backups-dup-lite/tmp/20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:79:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-admin\";i:1;s:89:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/uploads\";i:2;s:91:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/languages\";i:3;s:88:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/themes\";i:4;s:82:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:70:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash\";i:1;s:81:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:135;}");

/* INSERT TABLE DATA: esduc_gf_addon_feed */
INSERT INTO `esduc_gf_addon_feed` VALUES("1", "1", "1", "0", "{\"feedName\":\"User Registration\",\"feedType\":\"create\",\"username\":\"5\",\"first_name\":\"1\",\"last_name\":\"\",\"nickname\":\"1\",\"displayname\":\"nickname\",\"email\":\"4\",\"password\":\"3\",\"role\":\"customer\",\"userMeta\":[{\"key\":\"\",\"custom_key\":\"\",\"value\":\"\",\"custom_value\":\"\"}],\"sendEmailEnable\":\"0\",\"sendEmailValue\":\"default\",\"userActivationEnable\":\"0\",\"feed_condition_conditional_logic_object\":[],\"feed_condition_conditional_logic\":\"0\",\"sendEmail\":\"\",\"userActivation\":\"\",\"registrationCondition\":\"\"}", "gravityformsuserregistration", NULL);
INSERT INTO `esduc_gf_addon_feed` VALUES("2", "3", "1", "0", "{\"feedName\":\"\\u0628\\u0631\\u0648\\u0632\\u0631\\u0633\\u0627\\u0646\\u06cc \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u06a9\\u0627\\u0631\\u0628\\u0631\",\"feedType\":\"update\",\"first_name\":\"4\",\"last_name\":\"5\",\"nickname\":\"\",\"displayname\":\"nickname\",\"email\":\"\",\"password\":\"3\",\"role\":\"customer\",\"userMeta\":[{\"key\":\"shipping_phone\",\"custom_key\":\"\",\"value\":\"7\",\"custom_value\":\"\"}],\"feed_condition_conditional_logic_object\":[],\"feed_condition_conditional_logic\":\"0\",\"registrationCondition\":\"\"}", "gravityformsuserregistration", NULL);

/* INSERT TABLE DATA: esduc_gf_form */
INSERT INTO `esduc_gf_form` VALUES("1", "فرم ثبت نام سایت", "2021-12-31 08:42:43", NULL, "1", "0");
INSERT INTO `esduc_gf_form` VALUES("2", "فرم ثبت نام استاد", "2022-01-11 05:28:15", NULL, "1", "0");
INSERT INTO `esduc_gf_form` VALUES("3", "فرم ویرایش اطلاعات کاربر", "2022-01-11 07:53:10", NULL, "1", "0");
INSERT INTO `esduc_gf_form` VALUES("4", "فرم تماس", "2022-01-11 15:14:26", NULL, "1", "0");

/* INSERT TABLE DATA: esduc_gf_form_meta */
INSERT INTO `esduc_gf_form_meta` VALUES("1", "{\"title\":\"\\u0641\\u0631\\u0645 \\u062b\\u0628\\u062a \\u0646\\u0627\\u0645 \\u0633\\u0627\\u06cc\\u062a\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"\\u0639\\u0636\\u0648\\u06cc\\u062a \\u062f\\u0631 \\u0633\\u0627\\u06cc\\u062a\",\"imageUrl\":\"\",\"conditionalLogic\":null},\"fields\":[{\"type\":\"name\",\"id\":1,\"formId\":1,\"label\":\"\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"nameFormat\":\"advanced\",\"inputs\":[{\"id\":\"1.2\",\"label\":\"\\u067e\\u06cc\\u0634\\u0648\\u0646\\u062f\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-prefix\",\"choices\":[{\"text\":\"\\u0622\\u0642\\u0627\\u06cc.\",\"value\":\"\\u0622\\u0642\\u0627\\u06cc.\"},{\"text\":\"\\u062e\\u0627\\u0646\\u0645\",\"value\":\"\\u062e\\u0627\\u0646\\u0645\"},{\"text\":\"\\u062e\\u0627\\u0646\\u0645.\",\"value\":\"\\u062e\\u0627\\u0646\\u0645.\"},{\"text\":\"\\u062f\\u06a9\\u062a\\u0631.\",\"value\":\"\\u062f\\u06a9\\u062a\\u0631.\"},{\"text\":\"\\u067e\\u0631\\u0648\\u0641\\u0633\\u0648\\u0631.\",\"value\":\"\\u067e\\u0631\\u0648\\u0641\\u0633\\u0648\\u0631.\"},{\"text\":\"\\u06a9\\u0634\\u06cc\\u0634.\",\"value\":\"\\u06a9\\u0634\\u06cc\\u0634.\"}],\"isHidden\":true,\"inputType\":\"radio\"},{\"id\":\"1.3\",\"label\":\"\\u0627\\u0648\\u0644\",\"name\":\"\",\"autocompleteAttribute\":\"given-name\",\"isHidden\":false,\"customLabel\":\"\\u0646\\u0627\\u0645\"},{\"id\":\"1.4\",\"label\":\"\\u0648\\u0633\\u0637\",\"name\":\"\",\"autocompleteAttribute\":\"additional-name\",\"isHidden\":true},{\"id\":\"1.6\",\"label\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646\",\"name\":\"\",\"autocompleteAttribute\":\"family-name\",\"isHidden\":true,\"customLabel\":\"\\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\"},{\"id\":\"1.8\",\"label\":\"\\u067e\\u0633\\u0648\\u0646\\u062f\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-suffix\",\"isHidden\":true}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"hidden_label\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableEnhancedUI\":0,\"layoutGroupId\":\"8f381042\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"username\",\"id\":5,\"formId\":1,\"label\":\"\\u0646\\u0627\\u0645 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u06cc\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0641\\u0642\\u0637 \\u0644\\u0627\\u062a\\u06cc\\u0646 ( \\u0645\\u062b\\u0644\\u0627 alireza45 )\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"8f381042\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"phone\",\"id\":2,\"formId\":1,\"label\":\"\\u062a\\u0644\\u0641\\u0646\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"international\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableEnhancedUI\":0,\"layoutGroupId\":\"c53b2161\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"email\",\"id\":4,\"formId\":1,\"label\":\"\\u0627\\u06cc\\u0645\\u06cc\\u0644\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"c53b2161\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"password\",\"id\":3,\"formId\":1,\"label\":\"\\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":[{\"id\":\"3\",\"label\":\"\\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631 \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\",\"name\":\"\"},{\"id\":\"3.2\",\"label\":\"\\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631 \\u0631\\u0627 \\u062a\\u0623\\u06cc\\u06cc\\u062f \\u06a9\\u0646\\u06cc\\u062f\",\"name\":\"\",\"isHidden\":true}],\"displayOnly\":true,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"passwordStrengthEnabled\":false,\"passwordVisibilityEnabled\":true,\"enableEnhancedUI\":0,\"layoutGroupId\":\"8142f603\",\"pageNumber\":1,\"fields\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"minPasswordStrength\":\"\"}],\"version\":\"2.5.15.3\",\"id\":1,\"markupVersion\":2,\"nextFieldId\":6,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(\\u0636\\u0631\\u0648\\u0631\\u06cc)\",\"cssClass\":\"\",\"buttonType\":\"text\",\"buttonText\":\"\\u0639\\u0636\\u0648\\u06cc\\u062a \\u062f\\u0631 \\u0633\\u0627\\u06cc\\u062a\",\"buttonImageURL\":\"\",\"form_button_conditional_logic_object\":\"\",\"form_button_conditional_logic\":\"0\",\"saveButtonText\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647 \\u0628\\u0639\\u062f\\u0627\\u064b\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"validationSummary\":false,\"saveEnabled\":\"\",\"enableHoneypot\":false,\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647 \\u0628\\u0639\\u062f\\u0627\\u064b\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}", NULL, "{\"61cec2831d81f\":{\"id\":\"61cec2831d81f\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"page\",\"message\":\"\",\"url\":\"\",\"pageId\":\"398\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"398\",\"conditionalLogic\":[]}}", "{\"61cec2831d5a5\":{\"id\":\"61cec2831d5a5\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u06cc\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0627\\u0631\\u0633\\u0627\\u0644 \\u062c\\u062f\\u06cc\\u062f \\u0627\\u0632 {form_title}\",\"message\":\"{all_fields}\"}}");
INSERT INTO `esduc_gf_form_meta` VALUES("2", "{\"title\":\"\\u0641\\u0631\\u0645 \\u062b\\u0628\\u062a \\u0646\\u0627\\u0645 \\u0627\\u0633\\u062a\\u0627\\u062f\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"\\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a \\u0627\\u0631\\u062a\\u0642\\u0627 \\u062d\\u0633\\u0627\\u0628\",\"imageUrl\":\"\",\"conditionalLogic\":null},\"fields\":[{\"type\":\"text\",\"id\":1,\"formId\":2,\"label\":\"\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"af9fb57d\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"email\",\"id\":2,\"formId\":2,\"label\":\"\\u0627\\u06cc\\u0645\\u06cc\\u0644\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0622\\u062f\\u0631\\u0633 \\u0627\\u06cc\\u0645\\u06cc\\u0644\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"af9fb57d\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\",\"layoutSpacerGridColumnSpan\":0},{\"type\":\"phone\",\"id\":8,\"formId\":2,\"label\":\"\\u062a\\u0644\\u0641\\u0646\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"international\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u062a\\u0644\\u0641\\u0646 \\u062a\\u0645\\u0627\\u0633\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableEnhancedUI\":0,\"layoutGroupId\":\"8d70868c\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"select\",\"id\":10,\"formId\":2,\"label\":\"\\u062d\\u0648\\u0632\\u0647 \\u062a\\u062f\\u0631\\u06cc\\u0633\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"choices\":[{\"text\":\"\\u0648\\u0628\",\"value\":\"\\u0648\\u0628\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u0646\\u0648\\u06cc\\u0633\\u06cc\",\"value\":\"\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u0646\\u0648\\u06cc\\u0633\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0646\\u0631\\u0645 \\u0627\\u0641\\u0632\\u0627\\u0631\",\"value\":\"\\u0646\\u0631\\u0645 \\u0627\\u0641\\u0632\\u0627\\u0631\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0633\\u0627\\u06cc\\u0631 \\u0645\\u0648\\u0627\\u0631\\u062f\",\"value\":\"\\u0633\\u0627\\u06cc\\u0631 \\u0645\\u0648\\u0627\\u0631\\u062f\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u062d\\u0648\\u0632\\u0647 \\u062a\\u062f\\u0631\\u06cc\\u0633\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"8d70868c\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\",\"errors\":[]},{\"type\":\"textarea\",\"id\":7,\"formId\":2,\"label\":\"\\u0628\\u062f\\u0648\\u0646 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"small\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0631\\u0632\\u0648\\u0645\\u0647 \\u0634\\u0645\\u0627\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"form_id\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"34a65cfa\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"fileupload\",\"id\":4,\"formId\":2,\"label\":\"\\u0622\\u067e\\u0644\\u0648\\u062f \\u062a\\u0635\\u0648\\u06cc\\u0631 \\u06a9\\u0627\\u0631\\u062a \\u0645\\u0644\\u06cc\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"maxFileSize\":1,\"maxFiles\":\"\",\"multipleFiles\":false,\"allowedExtensions\":\"jpg,gif,png\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableEnhancedUI\":0,\"layoutGroupId\":\"3039b2e8\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"html\",\"id\":9,\"formId\":2,\"label\":\"\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"content\":\"<hr\\/>\",\"disableMargins\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableEnhancedUI\":0,\"layoutGroupId\":\"957b5733\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"checkbox\",\"id\":6,\"formId\":2,\"label\":\"\\u0628\\u062f\\u0648\\u0646 \\u0639\\u0646\\u0648\\u0627\\u0646\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"choices\":[{\"text\":\"\\u0642\\u0648\\u0627\\u0646\\u06cc\\u0646 \\u0645\\u0631\\u0628\\u0648\\u0637 \\u0628\\u0647 \\u0645\\u062f\\u0631\\u0633 \\u0631\\u0627 \\u062e\\u0648\\u0627\\u0646\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0648 \\u0622\\u0646 \\u0631\\u0627 \\u0645\\u06cc \\u067e\\u0630\\u06cc\\u0631\\u0645.\",\"value\":\"\\u0642\\u0648\\u0627\\u0646\\u06cc\\u0646 \\u0645\\u0631\\u0628\\u0648\\u0637 \\u0628\\u0647 \\u0645\\u062f\\u0631\\u0633 \\u0631\\u0627 \\u062e\\u0648\\u0627\\u0646\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0648 \\u0622\\u0646 \\u0631\\u0627 \\u0645\\u06cc \\u067e\\u0630\\u06cc\\u0631\\u0645.\",\"isSelected\":false,\"price\":\"\"}],\"inputs\":[{\"id\":\"6.1\",\"label\":\"\\u0642\\u0648\\u0627\\u0646\\u06cc\\u0646 \\u0645\\u0631\\u0628\\u0648\\u0637 \\u0628\\u0647 \\u0645\\u062f\\u0631\\u0633 \\u0631\\u0627 \\u062e\\u0648\\u0627\\u0646\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0648 \\u0622\\u0646 \\u0631\\u0627 \\u0645\\u06cc \\u067e\\u0630\\u06cc\\u0631\\u0645.\",\"name\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableSelectAll\":\"\",\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"4d023ecf\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"}],\"version\":\"2.5.15.3\",\"id\":2,\"markupVersion\":2,\"nextFieldId\":11,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(\\u0636\\u0631\\u0648\\u0631\\u06cc)\",\"cssClass\":\"\",\"buttonType\":\"text\",\"buttonText\":\"\\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a \\u0627\\u0631\\u062a\\u0642\\u0627 \\u062d\\u0633\\u0627\\u0628\",\"buttonImageURL\":\"\",\"form_button_conditional_logic_object\":\"\",\"form_button_conditional_logic\":\"0\",\"saveButtonText\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647 \\u0628\\u0639\\u062f\\u0627\\u064b\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"validationSummary\":false,\"saveEnabled\":\"\",\"enableHoneypot\":false,\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647 \\u0628\\u0639\\u062f\\u0627\\u064b\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}", NULL, "{\"61dd156f91edc\":{\"id\":\"61dd156f91edc\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"page\",\"message\":\"{\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc:1} \\u0639\\u0632\\u06cc\\u0632\\u060c \\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a \\u0634\\u0645\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u0641\\u0639\\u0627\\u0644\\u06cc\\u062a \\u0628\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0627\\u0633\\u062a\\u0627\\u062f \\u062b\\u0628\\u062a \\u06af\\u0631\\u062f\\u06cc\\u062f \\u0648 \\u0628\\u0632\\u0648\\u062f\\u06cc \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u067e\\u0627\\u0633\\u062e \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u062f\\u0627\\u062f.\",\"url\":\"\",\"pageId\":\"2454\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"2454\",\"conditionalLogic\":[]}}", "{\"61dd156f91cc5\":{\"id\":\"61dd156f91cc5\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u06cc\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0627\\u0631\\u0633\\u0627\\u0644 \\u062c\\u062f\\u06cc\\u062f \\u0627\\u0632 {form_title}\",\"message\":\"{all_fields}\"}}");
INSERT INTO `esduc_gf_form_meta` VALUES("3", "{\"title\":\"\\u0641\\u0631\\u0645 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u06a9\\u0627\\u0631\\u0628\\u0631\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"\\u0628\\u0631\\u0648\\u0632\\u0631\\u0633\\u0627\\u0646\\u06cc \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a\",\"imageUrl\":\"\",\"conditionalLogic\":null},\"fields\":[{\"type\":\"text\",\"id\":4,\"formId\":3,\"label\":\"\\u0646\\u0627\\u0645 \\u0634\\u0645\\u0627\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0646\\u0627\\u0645 \\u0634\\u0645\\u0627\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"8f381042\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"text\",\"id\":5,\"formId\":3,\"label\":\"\\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc \\u0634\\u0645\\u0627\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc \\u0634\\u0645\\u0627\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"8f381042\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"number\",\"id\":7,\"formId\":3,\"label\":\"\\u0634\\u0645\\u0627\\u0631\\u0647 \\u062a\\u0644\\u0641\\u0646\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"numberFormat\":\"decimal_dot\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0634\\u0645\\u0627\\u0631\\u0647 \\u062a\\u0644\\u0641\\u0646\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"enableCalculation\":false,\"rangeMin\":\"\",\"rangeMax\":\"\",\"calculationFormula\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableEnhancedUI\":0,\"layoutGroupId\":\"2ae8fcd2\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationRounding\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"password\",\"id\":3,\"formId\":3,\"label\":\"\\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":[{\"id\":\"3\",\"label\":\"\\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631 \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\",\"name\":\"\",\"placeholder\":\"\\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631 \\u062c\\u062f\\u06cc\\u062f\"},{\"id\":\"3.2\",\"label\":\"\\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631 \\u0631\\u0627 \\u062a\\u0623\\u06cc\\u06cc\\u062f \\u06a9\\u0646\\u06cc\\u062f\",\"name\":\"\",\"isHidden\":true,\"placeholder\":\"\\u062a\\u06a9\\u0631\\u0627\\u0631 \\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631 \\u062c\\u062f\\u06cc\\u062f\"}],\"displayOnly\":true,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"hidden_label\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"passwordStrengthEnabled\":false,\"passwordVisibilityEnabled\":true,\"enableEnhancedUI\":0,\"layoutGroupId\":\"2ae8fcd2\",\"pageNumber\":1,\"fields\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"minPasswordStrength\":\"\",\"checkboxLabel\":\"\"}],\"version\":\"2.5.15.3\",\"id\":3,\"markupVersion\":2,\"nextFieldId\":8,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(\\u0636\\u0631\\u0648\\u0631\\u06cc)\",\"cssClass\":\"\",\"buttonType\":\"text\",\"buttonText\":\"\\u0628\\u0631\\u0648\\u0632\\u0631\\u0633\\u0627\\u0646\\u06cc \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a\",\"buttonImageURL\":\"\",\"form_button_conditional_logic_object\":\"\",\"form_button_conditional_logic\":\"0\",\"saveButtonText\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647 \\u0628\\u0639\\u062f\\u0627\\u064b\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"validationSummary\":false,\"saveEnabled\":\"\",\"enableHoneypot\":false,\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647 \\u0628\\u0639\\u062f\\u0627\\u064b\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}", NULL, "{\"61cec2831d81f\":{\"id\":\"61cec2831d81f\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"page\",\"message\":\"{\\u0646\\u0627\\u0645 \\u0634\\u0645\\u0627:4} \\u0639\\u0632\\u06cc\\u0632\\u060c \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0634\\u0645\\u0627 \\u0628\\u0627 \\u0645\\u0648\\u0641\\u0642\\u06cc\\u062a \\u0628\\u0631\\u0648\\u0632\\u0631\\u0633\\u0627\\u0646\\u06cc \\u06af\\u0631\\u062f\\u06cc\\u062f.\",\"url\":\"\",\"pageId\":\"2461\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"2461\",\"conditionalLogic\":[]}}", "{\"61cec2831d5a5\":{\"id\":\"61cec2831d5a5\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u06cc\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0627\\u0631\\u0633\\u0627\\u0644 \\u062c\\u062f\\u06cc\\u062f \\u0627\\u0632 {form_title}\",\"message\":\"{all_fields}\"}}");
INSERT INTO `esduc_gf_form_meta` VALUES("4", "{\"title\":\"\\u0641\\u0631\\u0645 \\u062a\\u0645\\u0627\\u0633\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"\\u0627\\u0631\\u0633\\u0627\\u0644 \\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a\",\"imageUrl\":\"\",\"conditionalLogic\":null},\"fields\":[{\"type\":\"text\",\"id\":1,\"formId\":4,\"label\":\"\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"f1123dc1\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"number\",\"id\":2,\"formId\":4,\"label\":\"\\u0634\\u0645\\u0627\\u0631\\u0647 \\u062a\\u0644\\u0641\\u0646\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"numberFormat\":\"decimal_dot\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"enableCalculation\":false,\"rangeMin\":\"\",\"rangeMax\":\"\",\"calculationFormula\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableEnhancedUI\":0,\"layoutGroupId\":\"f1123dc1\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationRounding\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"email\",\"id\":3,\"formId\":4,\"label\":\"\\u0622\\u062f\\u0631\\u0633 \\u0627\\u06cc\\u0645\\u06cc\\u0644\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"4d3c0a7a\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"textarea\",\"id\":4,\"formId\":4,\"label\":\"\\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"small\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"form_id\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"6e8cedbe\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"}],\"version\":\"2.5.15.3\",\"id\":4,\"markupVersion\":2,\"nextFieldId\":5,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"notifications\":{\"61dd9ed2c2760\":{\"id\":\"61dd9ed2c2760\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u06cc\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0627\\u0631\\u0633\\u0627\\u0644 \\u062c\\u062f\\u06cc\\u062f \\u0627\\u0632 {form_title}\",\"message\":\"{all_fields}\"}},\"confirmations\":{\"61dd9ed2c295e\":{\"id\":\"61dd9ed2c295e\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"message\",\"message\":\"\\u0627\\u0632 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u0628\\u0627 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u06af\\u0631\\u0641\\u062a\\u06cc\\u062f \\u0645\\u062a\\u0634\\u06a9\\u0631\\u06cc\\u0645 !\\u0628\\u0647 \\u0632\\u0648\\u062f\\u06cc \\u0628\\u0627 \\u0634\\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u06af\\u0631\\u0641\\u062a.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}},\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(\\u0636\\u0631\\u0648\\u0631\\u06cc)\",\"cssClass\":\"\",\"buttonType\":\"text\",\"buttonText\":\"\\u0627\\u0631\\u0633\\u0627\\u0644 \\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a\",\"buttonImageURL\":\"\",\"form_button_conditional_logic_object\":\"\",\"form_button_conditional_logic\":\"0\",\"saveButtonText\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647 \\u0628\\u0639\\u062f\\u0627\\u064b\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"validationSummary\":false,\"saveEnabled\":\"\",\"enableHoneypot\":false,\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0648 \\u0627\\u062f\\u0627\\u0645\\u0647 \\u0628\\u0639\\u062f\\u0627\\u064b\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}", NULL, "{\"61dd9ed2c295e\":{\"id\":\"61dd9ed2c295e\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"message\",\"message\":\"\\u0627\\u0632 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u0628\\u0627 \\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u06af\\u0631\\u0641\\u062a\\u06cc\\u062f \\u0645\\u062a\\u0634\\u06a9\\u0631\\u06cc\\u0645 !\\u0628\\u0647 \\u0632\\u0648\\u062f\\u06cc \\u0628\\u0627 \\u0634\\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u06af\\u0631\\u0641\\u062a.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"61dd9ed2c2760\":{\"id\":\"61dd9ed2c2760\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0637\\u0644\\u0627\\u0639\\u06cc\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0627\\u0631\\u0633\\u0627\\u0644 \\u062c\\u062f\\u06cc\\u062f \\u0627\\u0632 {form_title}\",\"message\":\"{all_fields}\"}}");

/* INSERT TABLE DATA: esduc_gf_form_revisions */
INSERT INTO `esduc_gf_form_revisions` VALUES("1", "2", "{\"title\":\"\\u0641\\u0631\\u0645 \\u062b\\u0628\\u062a \\u0646\\u0627\\u0645 \\u0627\\u0633\\u062a\\u0627\\u062f\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"\\u0627\\u0631\\u0633\\u0627\\u0644\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":1,\"formId\":2,\"label\":\"\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"af9fb57d\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"email\",\"id\":2,\"formId\":2,\"label\":\"\\u0627\\u06cc\\u0645\\u06cc\\u0644\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0622\\u062f\\u0631\\u0633 \\u0627\\u06cc\\u0645\\u06cc\\u0644\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"af9fb57d\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"consent\",\"checked_indicator_url\":\"http:\\/\\/abzarwp.net\\/pre-learning\\/wp-content\\/plugins\\/gravityforms\\/images\\/tick.png\",\"checked_indicator_markup\":\"<img src=\\\"http:\\/\\/abzarwp.net\\/pre-learning\\/wp-content\\/plugins\\/gravityforms\\/images\\/tick.png\\\" \\/>\",\"id\":5,\"formId\":2,\"label\":\"\\u0631\\u0636\\u0627\\u06cc\\u062a\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":[{\"id\":\"5.1\",\"label\":\"\\u0631\\u0636\\u0627\\u06cc\\u062a\",\"name\":\"\"},{\"id\":\"5.2\",\"label\":\"\\u0645\\u062a\\u0646\",\"name\":\"\",\"isHidden\":true},{\"id\":\"5.3\",\"label\":\"\\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a\",\"name\":\"\",\"isHidden\":true}],\"checkboxLabel\":\"\\u0642\\u0648\\u0627\\u0646\\u06cc\\u0646 \\u0645\\u0631\\u0628\\u0648\\u0637 \\u0628\\u0647 \\u0627\\u0633\\u062a\\u0627\\u062f\\u0627\\u0646 \\u0631\\u0627 \\u062e\\u0648\\u0627\\u0646\\u062f\\u0647\\u200c\\u0627\\u0645 \\u0648 \\u0622\\u0646 \\u0631\\u0627 \\u0645\\u06cc \\u067e\\u0630\\u06cc\\u0631\\u0645.\",\"descriptionPlaceholder\":\"\\u0645\\u062a\\u0646 \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0646\\u0627\\u0645\\u0647 \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f. \\u0641\\u06cc\\u0644\\u062f \\u0631\\u0636\\u0627\\u06cc\\u062a \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0646\\u0627\\u0645\\u0647 \\u0631\\u0627 \\u0628\\u0627 \\u0648\\u0631\\u0648\\u062f\\u06cc \\u0641\\u0631\\u0645 \\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0645\\u06cc \\u06a9\\u0646\\u062f \\u062a\\u0627 \\u067e\\u06cc\\u06af\\u06cc\\u0631\\u06cc \\u06a9\\u0646\\u06cc\\u062f \\u06a9\\u0647 \\u06a9\\u0627\\u0631\\u0628\\u0631 \\u0628\\u0627 \\u0686\\u0647 \\u0645\\u0648\\u0627\\u0641\\u0642\\u062a \\u06a9\\u0631\\u062f\\u0647 \\u0627\\u0633\\u062a.\",\"inputType\":\"consent\",\"choices\":[{\"text\":\"\\u0628\\u0631\\u0631\\u0633\\u06cc \\u0634\\u062f\\u0647\",\"value\":\"1\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableEnhancedUI\":0,\"layoutGroupId\":\"19c01fb9\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"layoutSpacerGridColumnSpan\":6,\"pageNumber\":1,\"fields\":\"\",\"validateState\":true},{\"type\":\"fileupload\",\"id\":4,\"formId\":2,\"label\":\"\\u0622\\u067e\\u0644\\u0648\\u062f \\u062a\\u0635\\u0648\\u06cc\\u0631 \\u06a9\\u0627\\u0631\\u062a \\u0645\\u0644\\u06cc\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\\u062a\\u0635\\u0648\\u06cc\\u0631 \\u0628\\u0627\\u06cc\\u062f \\u062e\\u0648\\u0627\\u0646\\u0627 \\u0628\\u0648\\u062f\\u0647 \\u0628\\u0627\\u0634\\u062f.\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"maxFileSize\":1,\"maxFiles\":\"\",\"multipleFiles\":false,\"allowedExtensions\":\"jpg,gif,png\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableEnhancedUI\":0,\"layoutGroupId\":\"3039b2e8\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"errors\":[],\"pageNumber\":1,\"fields\":\"\"}],\"version\":\"2.5.15.3\",\"id\":2,\"markupVersion\":2,\"nextFieldId\":6,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null}", "2022-01-11 05:35:50");

/* INSERT TABLE DATA: esduc_gf_form_view */
INSERT INTO `esduc_gf_form_view` VALUES("1", "1", "2021-12-31 09:18:46", "", "5");
INSERT INTO `esduc_gf_form_view` VALUES("2", "1", "2022-01-09 13:04:49", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("3", "2", "2022-01-11 08:47:46", "", "5");
INSERT INTO `esduc_gf_form_view` VALUES("4", "3", "2022-01-11 08:47:46", "", "5");
INSERT INTO `esduc_gf_form_view` VALUES("5", "1", "2022-01-11 16:19:53", "", "17");
INSERT INTO `esduc_gf_form_view` VALUES("6", "4", "2022-01-12 10:15:14", "", "16");
INSERT INTO `esduc_gf_form_view` VALUES("7", "1", "2022-01-13 04:57:50", "", "10");
INSERT INTO `esduc_gf_form_view` VALUES("8", "2", "2022-01-13 04:59:08", "", "14");
INSERT INTO `esduc_gf_form_view` VALUES("9", "3", "2022-01-13 04:59:08", "", "14");
INSERT INTO `esduc_gf_form_view` VALUES("10", "4", "2022-01-13 15:34:09", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("11", "2", "2022-01-14 12:03:11", "", "14");
INSERT INTO `esduc_gf_form_view` VALUES("12", "3", "2022-01-14 12:03:11", "", "13");
INSERT INTO `esduc_gf_form_view` VALUES("13", "1", "2022-01-14 12:11:35", "", "30");
INSERT INTO `esduc_gf_form_view` VALUES("14", "4", "2022-01-14 20:11:29", "", "4");
INSERT INTO `esduc_gf_form_view` VALUES("15", "4", "2022-01-15 20:32:07", "", "2");
INSERT INTO `esduc_gf_form_view` VALUES("16", "1", "2022-01-15 20:33:03", "", "2");
INSERT INTO `esduc_gf_form_view` VALUES("17", "1", "2022-01-19 12:45:02", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("18", "1", "2022-01-24 15:39:40", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("19", "2", "2022-01-24 15:41:08", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("20", "3", "2022-01-24 15:41:08", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("21", "4", "2022-01-27 13:28:22", "", "2");
INSERT INTO `esduc_gf_form_view` VALUES("22", "2", "2022-01-27 13:28:53", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("23", "1", "2022-01-27 13:28:54", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("24", "1", "2022-01-31 09:12:22", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("25", "4", "2022-01-31 11:47:52", "", "3");
INSERT INTO `esduc_gf_form_view` VALUES("26", "1", "2022-02-01 16:25:51", "", "4");
INSERT INTO `esduc_gf_form_view` VALUES("27", "4", "2022-02-01 16:33:01", "", "4");
INSERT INTO `esduc_gf_form_view` VALUES("28", "2", "2022-02-08 09:35:21", "", "3");
INSERT INTO `esduc_gf_form_view` VALUES("29", "3", "2022-02-08 09:35:21", "", "3");
INSERT INTO `esduc_gf_form_view` VALUES("30", "1", "2022-02-08 09:39:49", "", "3");
INSERT INTO `esduc_gf_form_view` VALUES("31", "4", "2022-02-09 20:03:54", "", "2");
INSERT INTO `esduc_gf_form_view` VALUES("32", "1", "2022-02-09 20:04:03", "", "3");
INSERT INTO `esduc_gf_form_view` VALUES("33", "1", "2022-02-11 09:10:45", "", "5");
INSERT INTO `esduc_gf_form_view` VALUES("34", "4", "2022-02-11 10:24:39", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("35", "2", "2022-02-11 13:08:17", "", "10");
INSERT INTO `esduc_gf_form_view` VALUES("36", "3", "2022-02-11 13:08:17", "", "10");
INSERT INTO `esduc_gf_form_view` VALUES("37", "4", "2022-02-12 13:01:37", "", "2");
INSERT INTO `esduc_gf_form_view` VALUES("38", "1", "2022-02-12 13:01:49", "", "3");
INSERT INTO `esduc_gf_form_view` VALUES("39", "2", "2022-02-12 14:36:45", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("40", "3", "2022-02-12 14:36:45", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("41", "1", "2022-02-13 15:04:27", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("42", "1", "2022-02-21 16:54:44", "", "2");
INSERT INTO `esduc_gf_form_view` VALUES("43", "1", "2022-03-07 13:31:18", "", "2");
INSERT INTO `esduc_gf_form_view` VALUES("44", "1", "2022-03-09 09:19:57", "", "1");
INSERT INTO `esduc_gf_form_view` VALUES("45", "1", "2022-03-13 05:56:57", "", "1");

/* INSERT TABLE DATA: esduc_ld_achievements */
INSERT INTO `esduc_ld_achievements` VALUES("1", "2", "1326", "log_in", "10", "2021-12-31 11:53:10");
INSERT INTO `esduc_ld_achievements` VALUES("2", "2", "1323", "complete_course", "25", "2021-12-31 11:54:32");
INSERT INTO `esduc_ld_achievements` VALUES("3", "1", "1326", "log_in", "10", "2021-12-31 13:31:39");
INSERT INTO `esduc_ld_achievements` VALUES("4", "4", "1326", "log_in", "10", "2022-01-01 05:36:04");
INSERT INTO `esduc_ld_achievements` VALUES("5", "4", "1323", "complete_course", "25", "2022-01-01 05:37:53");
INSERT INTO `esduc_ld_achievements` VALUES("6", "3", "1326", "log_in", "10", "2022-01-01 07:32:26");
INSERT INTO `esduc_ld_achievements` VALUES("7", "5", "1327", "register", "20", "2022-01-10 14:49:30");
INSERT INTO `esduc_ld_achievements` VALUES("8", "5", "1326", "log_in", "10", "2022-01-10 15:17:47");
INSERT INTO `esduc_ld_achievements` VALUES("9", "6", "1327", "register", "20", "2022-01-13 08:27:05");
INSERT INTO `esduc_ld_achievements` VALUES("10", "7", "1327", "register", "20", "2022-01-13 12:23:47");
INSERT INTO `esduc_ld_achievements` VALUES("11", "8", "1327", "register", "20", "2022-01-14 12:30:45");
INSERT INTO `esduc_ld_achievements` VALUES("12", "9", "1327", "register", "20", "2022-01-19 12:42:59");
INSERT INTO `esduc_ld_achievements` VALUES("13", "9", "1326", "log_in", "10", "2022-01-19 12:45:43");
INSERT INTO `esduc_ld_achievements` VALUES("14", "10", "1327", "register", "20", "2022-01-24 15:41:07");
INSERT INTO `esduc_ld_achievements` VALUES("15", "11", "1327", "register", "20", "2022-01-29 15:49:55");
INSERT INTO `esduc_ld_achievements` VALUES("16", "11", "1326", "log_in", "10", "2022-01-29 16:31:39");

/* INSERT TABLE DATA: esduc_learndash_pro_quiz_master */
INSERT INTO `esduc_learndash_pro_quiz_master` VALUES("1", "آزمون فتوشاپ مقدماتی", " AAZZAAZZ", "a:3:{s:4:\"text\";a:1:{i:0;s:0:\"\";}s:7:\"prozent\";a:1:{i:0;i:0;}s:5:\"activ\";a:1:{i:0;i:1;}}", "1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "a:8:{s:25:\"toplistDataAddPermissions\";i:1;s:15:\"toplistDataSort\";i:1;s:22:\"toplistDataAddMultiple\";b:0;s:19:\"toplistDataAddBlock\";i:0;s:20:\"toplistDataShowLimit\";i:0;s:17:\"toplistDataShowIn\";i:0;s:18:\"toplistDataCaptcha\";b:0;s:23:\"toplistDataAddAutomatic\";b:0;}", "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0");
INSERT INTO `esduc_learndash_pro_quiz_master` VALUES("2", "آزمون", "AAZZAAZZ", "a:3:{s:4:\"text\";a:1:{i:0;s:0:\"\";}s:7:\"prozent\";a:1:{i:0;i:0;}s:5:\"activ\";a:1:{i:0;i:1;}}", "1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "a:8:{s:25:\"toplistDataAddPermissions\";i:1;s:15:\"toplistDataSort\";i:1;s:22:\"toplistDataAddMultiple\";b:0;s:19:\"toplistDataAddBlock\";i:1;s:20:\"toplistDataShowLimit\";i:1;s:17:\"toplistDataShowIn\";i:0;s:18:\"toplistDataCaptcha\";b:0;s:23:\"toplistDataAddAutomatic\";b:0;}", "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0");
INSERT INTO `esduc_learndash_pro_quiz_master` VALUES("3", "آزمون نهایی دوره جامع و رایگان طراحی سایت", " AAZZAAZZ", "a:3:{s:4:\"text\";a:1:{i:0;s:0:\"\";}s:7:\"prozent\";a:1:{i:0;i:0;}s:5:\"activ\";a:1:{i:0;i:1;}}", "1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "a:8:{s:25:\"toplistDataAddPermissions\";i:1;s:15:\"toplistDataSort\";i:1;s:22:\"toplistDataAddMultiple\";b:0;s:19:\"toplistDataAddBlock\";i:0;s:20:\"toplistDataShowLimit\";i:0;s:17:\"toplistDataShowIn\";i:0;s:18:\"toplistDataCaptcha\";b:0;s:23:\"toplistDataAddAutomatic\";b:0;}", "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0");
INSERT INTO `esduc_learndash_pro_quiz_master` VALUES("4", "آزمون", "AAZZAAZZ", "a:3:{s:4:\"text\";a:1:{i:0;s:0:\"\";}s:7:\"prozent\";a:1:{i:0;i:0;}s:5:\"activ\";a:1:{i:0;i:1;}}", "1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "a:8:{s:25:\"toplistDataAddPermissions\";i:1;s:15:\"toplistDataSort\";i:1;s:22:\"toplistDataAddMultiple\";b:0;s:19:\"toplistDataAddBlock\";i:1;s:20:\"toplistDataShowLimit\";i:1;s:17:\"toplistDataShowIn\";i:0;s:18:\"toplistDataCaptcha\";b:0;s:23:\"toplistDataAddAutomatic\";b:0;}", "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", "0", "0");

/* INSERT TABLE DATA: esduc_learndash_pro_quiz_question */
INSERT INTO `esduc_learndash_pro_quiz_question` VALUES("1", "1", "1", "0", "1", "فتوشاپ برای کار چه نوع فایل هایی میباشد؟", "1", "<p>فتوشاپ برای چه نوع فایل هایی است؟</p>", "", "", "0", "0", "", "single", "0", "0", "a:4:{i:0;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:8:\"صوتی\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:1;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:1;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:12:\"تصویری\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:1;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:2;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:14:\"ویدیویی\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:3;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:4:\"وب\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}}", "0", "0", "0", "20");
INSERT INTO `esduc_learndash_pro_quiz_question` VALUES("2", "1", "1", "0", "2", "در فتوشاپ کدام پسوند باز نمیشود؟", "1", "<p>در فتوشاپ کدام پسوند باز نمیشود؟</p>", "", "", "0", "0", "", "single", "0", "0", "a:4:{i:0;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:3:\"jpg\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:1;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:1;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:3:\"mp3\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:1;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:2;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:3:\"gif\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:3;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:3:\"png\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}}", "0", "0", "0", "20");
INSERT INTO `esduc_learndash_pro_quiz_question` VALUES("3", "1", "1", "0", "3", "سازنده فتوشاپ کدام شرکت است؟", "1", "<p>سازنده فتوشاپ کدام شرکت است؟</p>", "", "", "0", "0", "", "single", "0", "0", "a:4:{i:0;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:20:\"مایکروسافت\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:1;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:1;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:10:\"ادوبی\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:1;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:2;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:12:\"اوراکل\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:3;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:6:\"اپل\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}}", "0", "0", "0", "20");
INSERT INTO `esduc_learndash_pro_quiz_question` VALUES("4", "3", "1", "0", "1", "وردپرس در چه سالی منتشر شد؟", "1", "<p>وردپرس در چه سالی منتشر شد؟</p>", "", "", "0", "0", "", "single", "0", "0", "a:4:{i:0;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:4:\"2003\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:1;s:11:\"\0*\0_correct\";b:1;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:1;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:4:\"2002\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:2;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:4:\"2005\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:3;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:4:\"2000\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}}", "0", "0", "0", "20");
INSERT INTO `esduc_learndash_pro_quiz_question` VALUES("5", "3", "1", "0", "2", "حدود چند درصد سایت های جهان وردپرسی است؟", "1", "<p>حدود چند درصد سایت های جهان وردپرسی است؟</p>", "", "", "0", "0", "", "single", "0", "0", "a:4:{i:0;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:2:\"40\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:1;s:11:\"\0*\0_correct\";b:1;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:1;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:2:\"60\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:2;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:2:\"10\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:3;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:2:\"25\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}}", "0", "0", "0", "20");
INSERT INTO `esduc_learndash_pro_quiz_question` VALUES("6", "3", "1", "0", "3", "برای راه اندازی وردپرس نیاز به چه چیزی داریم؟", "1", "<p>برای راه اندازی وردپرس نیاز به چه چیزی داریم؟</p>", "", "", "0", "0", "", "single", "0", "0", "a:4:{i:0;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:10:\"دامنه\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:1;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:1;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:8:\"هاست\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:2;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:14:\"هیچکدام\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:3;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:17:\"گزینه 1 و 2\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:1;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}}", "0", "0", "0", "20");
INSERT INTO `esduc_learndash_pro_quiz_question` VALUES("7", "3", "1", "0", "4", "کدام سایت با وردپرس طراحی شده است؟", "1", "<p>کدام سایت با وردپرس طراحی شده است؟</p>", "", "", "0", "0", "", "single", "0", "0", "a:4:{i:0;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:23:\"ابزار وردپرس\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:1;s:11:\"\0*\0_correct\";b:1;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:1;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:17:\"دیجی کالا\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:2;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:21:\"سازمان سنجش\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:3;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:25:\"خبرگزاری فارس\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}}", "0", "0", "0", "20");
INSERT INTO `esduc_learndash_pro_quiz_question` VALUES("9", "3", "1", "0", "5", "وردپرس با چه زبان برنامه نویسی نوشته شده است؟", "1", "<p>وردپرس با چه زبان برنامه نویسی نوشته شده است؟</p>", "", "", "0", "0", "", "single", "0", "0", "a:4:{i:0;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:3:\"PHP\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:1;s:11:\"\0*\0_correct\";b:1;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:1;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:2:\"JS\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:2;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:3:\"ASP\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}i:3;O:27:\"WpProQuiz_Model_AnswerTypes\":10:{s:10:\"\0*\0_answer\";s:3:\"CSS\";s:8:\"\0*\0_html\";b:0;s:10:\"\0*\0_points\";i:0;s:11:\"\0*\0_correct\";b:0;s:14:\"\0*\0_sortString\";s:0:\"\";s:18:\"\0*\0_sortStringHtml\";b:0;s:10:\"\0*\0_graded\";s:1:\"1\";s:22:\"\0*\0_gradingProgression\";s:15:\"not-graded-none\";s:14:\"\0*\0_gradedType\";s:4:\"text\";s:10:\"\0*\0_mapper\";N;}}", "0", "0", "0", "20");

/* INSERT TABLE DATA: esduc_options */
INSERT INTO `esduc_options` VALUES("1", "siteurl", "https://pre-websites.ir/elementor/learndash", "yes");
INSERT INTO `esduc_options` VALUES("2", "home", "https://pre-websites.ir/elementor/learndash", "yes");
INSERT INTO `esduc_options` VALUES("3", "blogname", "سایت آماده آموزش آنلاین", "yes");
INSERT INTO `esduc_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `esduc_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `esduc_options` VALUES("6", "admin_email", "test-theme@demoabzar.com", "yes");
INSERT INTO `esduc_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `esduc_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `esduc_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `esduc_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `esduc_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `esduc_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `esduc_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `esduc_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `esduc_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `esduc_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `esduc_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `esduc_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `esduc_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `esduc_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `esduc_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `esduc_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `esduc_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `esduc_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `esduc_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `esduc_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `esduc_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `esduc_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `esduc_options` VALUES("29", "rewrite_rules", "a:465:{s:15:\"sfwd-lms/paypal\";s:25:\"index.php?sfwd-lms=paypal\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:10:\"courses/?$\";s:32:\"index.php?post_type=sfwd-courses\";s:40:\"courses/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=sfwd-courses&feed=$matches[1]\";s:35:\"courses/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=sfwd-courses&feed=$matches[1]\";s:27:\"courses/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=sfwd-courses&paged=$matches[1]\";s:9:\"groups/?$\";s:26:\"index.php?post_type=groups\";s:39:\"groups/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=groups&feed=$matches[1]\";s:34:\"groups/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=groups&feed=$matches[1]\";s:26:\"groups/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=groups&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:22:\"^instructor/([^/]+)/?$\";s:60:\"index.php?author_name=$matches[1]&ir_instructor_profile=true\";s:14:\"wppcp_group/?$\";s:31:\"index.php?post_type=wppcp_group\";s:44:\"wppcp_group/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=wppcp_group&feed=$matches[1]\";s:39:\"wppcp_group/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=wppcp_group&feed=$matches[1]\";s:31:\"wppcp_group/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=wppcp_group&paged=$matches[1]\";s:22:\"wppcp_fproduct_tabs/?$\";s:39:\"index.php?post_type=wppcp_fproduct_tabs\";s:52:\"wppcp_fproduct_tabs/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?post_type=wppcp_fproduct_tabs&feed=$matches[1]\";s:47:\"wppcp_fproduct_tabs/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?post_type=wppcp_fproduct_tabs&feed=$matches[1]\";s:39:\"wppcp_fproduct_tabs/page/([0-9]{1,})/?$\";s:57:\"index.php?post_type=wppcp_fproduct_tabs&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"courses/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"courses/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"courses/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"courses/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"courses/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"courses/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"courses/([^/]+)/embed/?$\";s:45:\"index.php?sfwd-courses=$matches[1]&embed=true\";s:28:\"courses/([^/]+)/trackback/?$\";s:39:\"index.php?sfwd-courses=$matches[1]&tb=1\";s:48:\"courses/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?sfwd-courses=$matches[1]&feed=$matches[2]\";s:43:\"courses/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?sfwd-courses=$matches[1]&feed=$matches[2]\";s:36:\"courses/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?sfwd-courses=$matches[1]&paged=$matches[2]\";s:43:\"courses/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?sfwd-courses=$matches[1]&cpage=$matches[2]\";s:33:\"courses/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?sfwd-courses=$matches[1]&wc-api=$matches[3]\";s:39:\"courses/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"courses/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"courses/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?sfwd-courses=$matches[1]&page=$matches[2]\";s:24:\"courses/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"courses/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"courses/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"courses/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"courses/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"courses/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"lessons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"lessons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"lessons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"lessons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"lessons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"lessons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"lessons/([^/]+)/embed/?$\";s:45:\"index.php?sfwd-lessons=$matches[1]&embed=true\";s:28:\"lessons/([^/]+)/trackback/?$\";s:39:\"index.php?sfwd-lessons=$matches[1]&tb=1\";s:36:\"lessons/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?sfwd-lessons=$matches[1]&paged=$matches[2]\";s:43:\"lessons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?sfwd-lessons=$matches[1]&cpage=$matches[2]\";s:33:\"lessons/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?sfwd-lessons=$matches[1]&wc-api=$matches[3]\";s:39:\"lessons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"lessons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"lessons/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?sfwd-lessons=$matches[1]&page=$matches[2]\";s:24:\"lessons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"lessons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"lessons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"lessons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"lessons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"lessons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"topic/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"topic/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"topic/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"topic/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"topic/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"topic/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"topic/([^/]+)/embed/?$\";s:43:\"index.php?sfwd-topic=$matches[1]&embed=true\";s:26:\"topic/([^/]+)/trackback/?$\";s:37:\"index.php?sfwd-topic=$matches[1]&tb=1\";s:34:\"topic/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?sfwd-topic=$matches[1]&paged=$matches[2]\";s:41:\"topic/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?sfwd-topic=$matches[1]&cpage=$matches[2]\";s:31:\"topic/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?sfwd-topic=$matches[1]&wc-api=$matches[3]\";s:37:\"topic/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"topic/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:30:\"topic/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?sfwd-topic=$matches[1]&page=$matches[2]\";s:22:\"topic/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"topic/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"topic/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"topic/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"topic/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"topic/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"quizzes/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"quizzes/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"quizzes/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"quizzes/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"quizzes/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"quizzes/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"quizzes/([^/]+)/embed/?$\";s:42:\"index.php?sfwd-quiz=$matches[1]&embed=true\";s:28:\"quizzes/([^/]+)/trackback/?$\";s:36:\"index.php?sfwd-quiz=$matches[1]&tb=1\";s:36:\"quizzes/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?sfwd-quiz=$matches[1]&paged=$matches[2]\";s:43:\"quizzes/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?sfwd-quiz=$matches[1]&cpage=$matches[2]\";s:33:\"quizzes/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?sfwd-quiz=$matches[1]&wc-api=$matches[3]\";s:39:\"quizzes/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"quizzes/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"quizzes/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?sfwd-quiz=$matches[1]&page=$matches[2]\";s:24:\"quizzes/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"quizzes/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"quizzes/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"quizzes/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"quizzes/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"quizzes/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"sfwd-question/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"sfwd-question/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"sfwd-question/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"sfwd-question/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"sfwd-question/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"sfwd-question/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"sfwd-question/([^/]+)/embed/?$\";s:46:\"index.php?sfwd-question=$matches[1]&embed=true\";s:34:\"sfwd-question/([^/]+)/trackback/?$\";s:40:\"index.php?sfwd-question=$matches[1]&tb=1\";s:42:\"sfwd-question/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?sfwd-question=$matches[1]&paged=$matches[2]\";s:49:\"sfwd-question/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?sfwd-question=$matches[1]&cpage=$matches[2]\";s:39:\"sfwd-question/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?sfwd-question=$matches[1]&wc-api=$matches[3]\";s:45:\"sfwd-question/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"sfwd-question/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"sfwd-question/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?sfwd-question=$matches[1]&page=$matches[2]\";s:30:\"sfwd-question/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"sfwd-question/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"sfwd-question/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"sfwd-question/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"sfwd-question/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"sfwd-question/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"certificates/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"certificates/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"certificates/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"certificates/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"certificates/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"certificates/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"certificates/([^/]+)/embed/?$\";s:50:\"index.php?sfwd-certificates=$matches[1]&embed=true\";s:33:\"certificates/([^/]+)/trackback/?$\";s:44:\"index.php?sfwd-certificates=$matches[1]&tb=1\";s:41:\"certificates/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?sfwd-certificates=$matches[1]&paged=$matches[2]\";s:48:\"certificates/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?sfwd-certificates=$matches[1]&cpage=$matches[2]\";s:38:\"certificates/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?sfwd-certificates=$matches[1]&wc-api=$matches[3]\";s:44:\"certificates/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"certificates/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"certificates/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?sfwd-certificates=$matches[1]&page=$matches[2]\";s:29:\"certificates/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"certificates/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"certificates/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"certificates/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"certificates/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"certificates/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"groups/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"groups/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"groups/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"groups/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"groups/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"groups/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"groups/([^/]+)/embed/?$\";s:39:\"index.php?groups=$matches[1]&embed=true\";s:27:\"groups/([^/]+)/trackback/?$\";s:33:\"index.php?groups=$matches[1]&tb=1\";s:47:\"groups/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?groups=$matches[1]&feed=$matches[2]\";s:42:\"groups/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?groups=$matches[1]&feed=$matches[2]\";s:35:\"groups/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?groups=$matches[1]&paged=$matches[2]\";s:42:\"groups/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?groups=$matches[1]&cpage=$matches[2]\";s:32:\"groups/([^/]+)/wc-api(/(.*))?/?$\";s:47:\"index.php?groups=$matches[1]&wc-api=$matches[3]\";s:38:\"groups/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"groups/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"groups/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?groups=$matches[1]&page=$matches[2]\";s:23:\"groups/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"groups/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"groups/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"groups/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"groups/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"groups/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"essay/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"essay/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"essay/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"essay/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"essay/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"essay/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"essay/([^/]+)/embed/?$\";s:44:\"index.php?sfwd-essays=$matches[1]&embed=true\";s:26:\"essay/([^/]+)/trackback/?$\";s:38:\"index.php?sfwd-essays=$matches[1]&tb=1\";s:34:\"essay/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?sfwd-essays=$matches[1]&paged=$matches[2]\";s:41:\"essay/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?sfwd-essays=$matches[1]&cpage=$matches[2]\";s:31:\"essay/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?sfwd-essays=$matches[1]&wc-api=$matches[3]\";s:37:\"essay/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"essay/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:30:\"essay/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?sfwd-essays=$matches[1]&page=$matches[2]\";s:22:\"essay/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"essay/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"essay/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"essay/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"essay/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"essay/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"assignment/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"assignment/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"assignment/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"assignment/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"assignment/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"assignment/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"assignment/([^/]+)/embed/?$\";s:48:\"index.php?sfwd-assignment=$matches[1]&embed=true\";s:31:\"assignment/([^/]+)/trackback/?$\";s:42:\"index.php?sfwd-assignment=$matches[1]&tb=1\";s:39:\"assignment/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?sfwd-assignment=$matches[1]&paged=$matches[2]\";s:46:\"assignment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?sfwd-assignment=$matches[1]&cpage=$matches[2]\";s:36:\"assignment/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?sfwd-assignment=$matches[1]&wc-api=$matches[3]\";s:42:\"assignment/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"assignment/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"assignment/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?sfwd-assignment=$matches[1]&page=$matches[2]\";s:27:\"assignment/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"assignment/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"assignment/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"assignment/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"assignment/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"assignment/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"wppcp_group/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"wppcp_group/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"wppcp_group/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"wppcp_group/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"wppcp_group/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"wppcp_group/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"wppcp_group/([^/]+)/embed/?$\";s:44:\"index.php?wppcp_group=$matches[1]&embed=true\";s:32:\"wppcp_group/([^/]+)/trackback/?$\";s:38:\"index.php?wppcp_group=$matches[1]&tb=1\";s:52:\"wppcp_group/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wppcp_group=$matches[1]&feed=$matches[2]\";s:47:\"wppcp_group/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wppcp_group=$matches[1]&feed=$matches[2]\";s:40:\"wppcp_group/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?wppcp_group=$matches[1]&paged=$matches[2]\";s:47:\"wppcp_group/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?wppcp_group=$matches[1]&cpage=$matches[2]\";s:37:\"wppcp_group/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?wppcp_group=$matches[1]&wc-api=$matches[3]\";s:43:\"wppcp_group/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"wppcp_group/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"wppcp_group/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?wppcp_group=$matches[1]&page=$matches[2]\";s:28:\"wppcp_group/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"wppcp_group/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"wppcp_group/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"wppcp_group/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"wppcp_group/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"wppcp_group/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"wppcp_fproduct_tabs/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"wppcp_fproduct_tabs/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"wppcp_fproduct_tabs/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"wppcp_fproduct_tabs/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"wppcp_fproduct_tabs/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"wppcp_fproduct_tabs/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"wppcp_fproduct_tabs/([^/]+)/embed/?$\";s:52:\"index.php?wppcp_fproduct_tabs=$matches[1]&embed=true\";s:40:\"wppcp_fproduct_tabs/([^/]+)/trackback/?$\";s:46:\"index.php?wppcp_fproduct_tabs=$matches[1]&tb=1\";s:60:\"wppcp_fproduct_tabs/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?wppcp_fproduct_tabs=$matches[1]&feed=$matches[2]\";s:55:\"wppcp_fproduct_tabs/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?wppcp_fproduct_tabs=$matches[1]&feed=$matches[2]\";s:48:\"wppcp_fproduct_tabs/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?wppcp_fproduct_tabs=$matches[1]&paged=$matches[2]\";s:55:\"wppcp_fproduct_tabs/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?wppcp_fproduct_tabs=$matches[1]&cpage=$matches[2]\";s:45:\"wppcp_fproduct_tabs/([^/]+)/wc-api(/(.*))?/?$\";s:60:\"index.php?wppcp_fproduct_tabs=$matches[1]&wc-api=$matches[3]\";s:51:\"wppcp_fproduct_tabs/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:62:\"wppcp_fproduct_tabs/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:44:\"wppcp_fproduct_tabs/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?wppcp_fproduct_tabs=$matches[1]&page=$matches[2]\";s:36:\"wppcp_fproduct_tabs/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"wppcp_fproduct_tabs/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"wppcp_fproduct_tabs/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"wppcp_fproduct_tabs/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"wppcp_fproduct_tabs/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"wppcp_fproduct_tabs/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"course-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?ld_course_category=$matches[1]&feed=$matches[2]\";s:51:\"course-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?ld_course_category=$matches[1]&feed=$matches[2]\";s:32:\"course-category/([^/]+)/embed/?$\";s:51:\"index.php?ld_course_category=$matches[1]&embed=true\";s:44:\"course-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?ld_course_category=$matches[1]&paged=$matches[2]\";s:26:\"course-category/([^/]+)/?$\";s:40:\"index.php?ld_course_category=$matches[1]\";s:51:\"course-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?ld_course_tag=$matches[1]&feed=$matches[2]\";s:46:\"course-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?ld_course_tag=$matches[1]&feed=$matches[2]\";s:27:\"course-tag/([^/]+)/embed/?$\";s:46:\"index.php?ld_course_tag=$matches[1]&embed=true\";s:39:\"course-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?ld_course_tag=$matches[1]&paged=$matches[2]\";s:21:\"course-tag/([^/]+)/?$\";s:35:\"index.php?ld_course_tag=$matches[1]\";s:56:\"lesson-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?ld_lesson_category=$matches[1]&feed=$matches[2]\";s:51:\"lesson-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?ld_lesson_category=$matches[1]&feed=$matches[2]\";s:32:\"lesson-category/([^/]+)/embed/?$\";s:51:\"index.php?ld_lesson_category=$matches[1]&embed=true\";s:44:\"lesson-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?ld_lesson_category=$matches[1]&paged=$matches[2]\";s:26:\"lesson-category/([^/]+)/?$\";s:40:\"index.php?ld_lesson_category=$matches[1]\";s:51:\"lesson-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?ld_lesson_tag=$matches[1]&feed=$matches[2]\";s:46:\"lesson-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?ld_lesson_tag=$matches[1]&feed=$matches[2]\";s:27:\"lesson-tag/([^/]+)/embed/?$\";s:46:\"index.php?ld_lesson_tag=$matches[1]&embed=true\";s:39:\"lesson-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?ld_lesson_tag=$matches[1]&paged=$matches[2]\";s:21:\"lesson-tag/([^/]+)/?$\";s:35:\"index.php?ld_lesson_tag=$matches[1]\";s:55:\"topic-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?ld_topic_category=$matches[1]&feed=$matches[2]\";s:50:\"topic-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?ld_topic_category=$matches[1]&feed=$matches[2]\";s:31:\"topic-category/([^/]+)/embed/?$\";s:50:\"index.php?ld_topic_category=$matches[1]&embed=true\";s:43:\"topic-category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?ld_topic_category=$matches[1]&paged=$matches[2]\";s:25:\"topic-category/([^/]+)/?$\";s:39:\"index.php?ld_topic_category=$matches[1]\";s:50:\"topic-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?ld_topic_tag=$matches[1]&feed=$matches[2]\";s:45:\"topic-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?ld_topic_tag=$matches[1]&feed=$matches[2]\";s:26:\"topic-tag/([^/]+)/embed/?$\";s:45:\"index.php?ld_topic_tag=$matches[1]&embed=true\";s:38:\"topic-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?ld_topic_tag=$matches[1]&paged=$matches[2]\";s:20:\"topic-tag/([^/]+)/?$\";s:34:\"index.php?ld_topic_tag=$matches[1]\";s:55:\"group-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?ld_group_category=$matches[1]&feed=$matches[2]\";s:50:\"group-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?ld_group_category=$matches[1]&feed=$matches[2]\";s:31:\"group-category/([^/]+)/embed/?$\";s:50:\"index.php?ld_group_category=$matches[1]&embed=true\";s:43:\"group-category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?ld_group_category=$matches[1]&paged=$matches[2]\";s:25:\"group-category/([^/]+)/?$\";s:39:\"index.php?ld_group_category=$matches[1]\";s:50:\"group-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?ld_group_tag=$matches[1]&feed=$matches[2]\";s:45:\"group-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?ld_group_tag=$matches[1]&feed=$matches[2]\";s:26:\"group-tag/([^/]+)/embed/?$\";s:45:\"index.php?ld_group_tag=$matches[1]&embed=true\";s:38:\"group-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?ld_group_tag=$matches[1]&paged=$matches[2]\";s:20:\"group-tag/([^/]+)/?$\";s:34:\"index.php?ld_group_tag=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1090&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `esduc_options` VALUES("23186", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.4.4\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:6;}", "yes");
INSERT INTO `esduc_options` VALUES("23187", "duplicator_version_plugin", "1.4.4", "yes");
INSERT INTO `esduc_options` VALUES("23188", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-03-14 06:51:34\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.2\";s:9:\"VersionDB\";s:7:\"10.4.22\";s:10:\"VersionPHP\";s:6:\"7.4.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"d01918fceeec7c519509_20220314065134\";s:8:\"NameHash\";s:75:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:70:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-03-14 06:51:34\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.2\";s:9:\"VersionDB\";s:7:\"10.4.22\";s:10:\"VersionPHP\";s:6:\"7.4.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"d01918fceeec7c519509_20220314065134\";s:8:\"NameHash\";s:75:\"20220211_d8b3d8a7db8cd8aad8a2d985d8a7d8_d01918fceeec7c519509_20220314065134\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:63;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:79:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-admin\";i:1;s:89:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/uploads\";i:2;s:91:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/languages\";i:3;s:88:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/themes\";i:4;s:82:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:70:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash\";i:1;s:81:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:129;}", "yes");
INSERT INTO `esduc_options` VALUES("14100", "gform_email_count", "20", "yes");
INSERT INTO `esduc_options` VALUES("2899", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `esduc_options` VALUES("2784", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("2785", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("7387", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `esduc_options` VALUES("333", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("334", "default_product_cat", "15", "yes");
INSERT INTO `esduc_options` VALUES("374", "wc_blocks_surface_cart_checkout_probability", "2", "yes");
INSERT INTO `esduc_options` VALUES("336", "woocommerce_refund_returns_page_id", "12", "yes");
INSERT INTO `esduc_options` VALUES("376", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("339", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:24:\"test-theme@demoabzar.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:24:\"test-theme@demoabzar.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `esduc_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `esduc_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `esduc_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `esduc_options` VALUES("33", "active_plugins", "a:18:{i:0;s:29:\"gravityforms/gravityforms.php\";i:1;s:37:\"abzarwp-learndash-pdf-font/plugin.php\";i:2;s:34:\"abzarwp_learning_presite/index.php\";i:3;s:19:\"akismet/akismet.php\";i:4;s:33:\"classic-editor/classic-editor.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:31:\"elementor-pro/elementor-pro.php\";i:7;s:23:\"elementor/elementor.php\";i:8;s:49:\"gravityformsuserregistration/userregistration.php\";i:9;s:30:\"instructor-role/instructor.php\";i:10;s:25:\"jet-engine/jet-engine.php\";i:11;s:24:\"jet-plugin-pro/index.php\";i:12;s:21:\"jet-tabs/jet-tabs.php\";i:13;s:47:\"learndash-woocommerce/learndash_woocommerce.php\";i:14;s:21:\"sfwd-lms/sfwd_lms.php\";i:15;s:56:\"woo-checkout-field-editor-pro/checkout-form-designer.php\";i:16;s:27:\"woocommerce/woocommerce.php\";i:17;s:51:\"wp-private-content-plus/wp-private-content-plus.php\";}", "yes");
INSERT INTO `esduc_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `esduc_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `esduc_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `esduc_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `esduc_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `esduc_options` VALUES("39", "recently_edited", "a:5:{i:0;s:124:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/plugins/abzarwp_learning_presite/index.php\";i:2;s:109:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/learndash/wp-content/plugins/akismet/akismet.php\";i:3;s:114:\"/home2/abzarwpn/domains/abzarwp.net/public_html/pre-learning/wp-content/plugins/abzarwp_learning_presite/index.php\";i:4;s:110:\"/home2/abzarwpn/domains/abzarwp.net/public_html/pre-learning/wp-content/plugins/advanced-custom-fields/acf.php\";i:5;s:110:\"/home2/abzarwpn/domains/abzarwp.net/public_html/pre-learning/wp-content/plugins/us-core/templates/comments.php\";}", "no");
INSERT INTO `esduc_options` VALUES("40", "template", "hello-elementor", "yes");
INSERT INTO `esduc_options` VALUES("41", "stylesheet", "hello-elementor", "yes");
INSERT INTO `esduc_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `esduc_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `esduc_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `esduc_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `esduc_options` VALUES("46", "db_version", "51917", "yes");
INSERT INTO `esduc_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `esduc_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `esduc_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `esduc_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `esduc_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `esduc_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `esduc_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `esduc_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `esduc_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `esduc_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `esduc_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `esduc_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `esduc_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `esduc_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `esduc_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `esduc_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `esduc_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `esduc_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `esduc_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `esduc_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `esduc_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `esduc_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `esduc_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `esduc_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `esduc_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `esduc_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `esduc_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `esduc_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `esduc_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("79", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `esduc_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `esduc_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `esduc_options` VALUES("82", "page_on_front", "1090", "yes");
INSERT INTO `esduc_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `esduc_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `esduc_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `esduc_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `esduc_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `esduc_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `esduc_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `esduc_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `esduc_options` VALUES("91", "admin_email_lifespan", "1651476127", "yes");
INSERT INTO `esduc_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `esduc_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `esduc_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `esduc_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `esduc_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `esduc_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `esduc_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `esduc_options` VALUES("100", "esduc_user_roles", "a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:192:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:9:\"edit_post\";b:1;s:9:\"read_post\";b:1;s:11:\"delete_post\";b:1;s:18:\"edit_us_page_block\";b:1;s:18:\"read_us_page_block\";b:1;s:20:\"delete_us_page_block\";b:1;s:19:\"edit_us_page_blocks\";b:1;s:26:\"edit_others_us_page_blocks\";b:1;s:21:\"delete_us_page_blocks\";b:1;s:22:\"publish_us_page_blocks\";b:1;s:27:\"read_private_us_page_blocks\";b:1;s:29:\"delete_private_us_page_blocks\";b:1;s:31:\"delete_published_us_page_blocks\";b:1;s:28:\"delete_others_us_page_blocks\";b:1;s:27:\"edit_private_us_page_blocks\";b:1;s:29:\"edit_published_us_page_blocks\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:14:\"wpProQuiz_show\";b:1;s:18:\"wpProQuiz_add_quiz\";b:1;s:19:\"wpProQuiz_edit_quiz\";b:1;s:21:\"wpProQuiz_delete_quiz\";b:1;s:25:\"wpProQuiz_show_statistics\";b:1;s:26:\"wpProQuiz_reset_statistics\";b:1;s:16:\"wpProQuiz_import\";b:1;s:16:\"wpProQuiz_export\";b:1;s:25:\"wpProQuiz_change_settings\";b:1;s:22:\"wpProQuiz_toplist_edit\";b:1;s:12:\"enroll_users\";b:1;s:11:\"read_course\";b:1;s:15:\"publish_courses\";b:1;s:12:\"edit_courses\";b:1;s:19:\"edit_others_courses\";b:1;s:14:\"delete_courses\";b:1;s:21:\"delete_others_courses\";b:1;s:20:\"read_private_courses\";b:1;s:20:\"edit_private_courses\";b:1;s:22:\"delete_private_courses\";b:1;s:13:\"delete_course\";b:1;s:22:\"edit_published_courses\";b:1;s:24:\"delete_published_courses\";b:1;s:10:\"read_group\";b:1;s:14:\"publish_groups\";b:1;s:11:\"edit_groups\";b:1;s:10:\"edit_group\";b:1;s:18:\"edit_others_groups\";b:1;s:13:\"delete_groups\";b:1;s:20:\"delete_others_groups\";b:1;s:19:\"read_private_groups\";b:1;s:12:\"delete_group\";b:1;s:21:\"edit_published_groups\";b:1;s:23:\"delete_published_groups\";b:1;s:15:\"edit_assignment\";b:1;s:16:\"edit_assignments\";b:1;s:23:\"edit_others_assignments\";b:1;s:19:\"publish_assignments\";b:1;s:15:\"read_assignment\";b:1;s:24:\"read_private_assignments\";b:1;s:17:\"delete_assignment\";b:1;s:26:\"edit_published_assignments\";b:1;s:25:\"delete_others_assignments\";b:1;s:28:\"delete_published_assignments\";b:1;s:29:\"manage_terms_group_categories\";b:1;s:27:\"edit_terms_group_categories\";b:1;s:29:\"delete_terms_group_categories\";b:1;s:29:\"assign_terms_group_categories\";b:1;s:11:\"edit_essays\";b:1;s:18:\"edit_others_essays\";b:1;s:14:\"publish_essays\";b:1;s:11:\"read_essays\";b:1;s:19:\"read_private_essays\";b:1;s:13:\"delete_essays\";b:1;s:21:\"edit_published_essays\";b:1;s:20:\"delete_others_essays\";b:1;s:23:\"delete_published_essays\";b:1;s:10:\"copy_posts\";b:1;s:10:\"loco_admin\";b:1;s:20:\"wppcp_manage_options\";b:1;s:15:\"instructor_page\";b:1;s:18:\"instructor_reports\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:12:\"group_leader\";a:2:{s:4:\"name\";s:12:\"Group Leader\";s:12:\"capabilities\";a:19:{s:4:\"read\";b:1;s:12:\"group_leader\";b:1;s:7:\"level_1\";b:0;s:7:\"level_0\";b:1;s:15:\"read_assignment\";b:1;s:16:\"edit_assignments\";b:1;s:23:\"edit_others_assignments\";b:1;s:26:\"edit_published_assignments\";b:1;s:25:\"delete_others_assignments\";b:1;s:28:\"delete_published_assignments\";b:1;s:11:\"edit_essays\";b:1;s:18:\"edit_others_essays\";b:1;s:14:\"publish_essays\";b:1;s:11:\"read_essays\";b:1;s:19:\"read_private_essays\";b:1;s:13:\"delete_essays\";b:1;s:21:\"edit_published_essays\";b:1;s:20:\"delete_others_essays\";b:1;s:23:\"delete_published_essays\";b:1;}}s:14:\"wdm_instructor\";a:2:{s:4:\"name\";s:10:\"Instructor\";s:12:\"capabilities\";a:65:{s:4:\"read\";b:1;s:14:\"wpProQuiz_show\";b:1;s:18:\"wpProQuiz_add_quiz\";b:1;s:19:\"wpProQuiz_edit_quiz\";b:1;s:21:\"wpProQuiz_delete_quiz\";b:1;s:25:\"wpProQuiz_show_statistics\";b:1;s:16:\"wpProQuiz_import\";b:1;s:16:\"wpProQuiz_export\";b:1;s:11:\"read_course\";b:1;s:15:\"publish_courses\";b:1;s:12:\"edit_courses\";b:1;s:14:\"delete_courses\";b:1;s:11:\"edit_course\";b:1;s:13:\"delete_course\";b:1;s:22:\"edit_published_courses\";b:1;s:24:\"delete_published_courses\";b:1;s:15:\"edit_assignment\";b:1;s:16:\"edit_assignments\";b:1;s:19:\"publish_assignments\";b:1;s:15:\"read_assignment\";b:1;s:17:\"delete_assignment\";b:1;s:26:\"edit_published_assignments\";b:1;s:28:\"delete_published_assignments\";b:1;s:23:\"edit_others_assignments\";b:1;s:18:\"instructor_reports\";b:1;s:15:\"instructor_page\";b:1;s:17:\"manage_categories\";b:1;s:22:\"wpProQuiz_toplist_edit\";b:1;s:12:\"upload_files\";b:1;s:13:\"delete_essays\";b:1;s:20:\"delete_others_essays\";b:1;s:21:\"delete_private_essays\";b:1;s:23:\"delete_published_essays\";b:1;s:11:\"edit_essays\";b:1;s:18:\"edit_others_essays\";b:1;s:19:\"edit_private_essays\";b:1;s:21:\"edit_published_essays\";b:1;s:14:\"publish_essays\";b:1;s:11:\"read_essays\";b:1;s:19:\"read_private_essays\";b:1;s:10:\"edit_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"view_h5p_contents\";b:1;s:17:\"edit_h5p_contents\";b:1;s:15:\"unfiltered_html\";b:1;s:14:\"delete_product\";b:1;s:15:\"delete_products\";b:1;s:25:\"delete_published_products\";b:1;s:12:\"edit_product\";b:1;s:13:\"edit_products\";b:1;s:23:\"edit_published_products\";b:1;s:16:\"publish_products\";b:1;s:12:\"read_product\";b:1;s:20:\"assign_product_terms\";b:1;s:10:\"read_group\";b:1;s:14:\"publish_groups\";b:1;s:11:\"edit_groups\";b:1;s:13:\"delete_groups\";b:1;s:12:\"delete_group\";b:1;s:21:\"edit_published_groups\";b:1;s:23:\"delete_published_groups\";b:1;s:12:\"group_leader\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "yes");
INSERT INTO `esduc_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `esduc_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `esduc_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("104", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";i:5;s:13:\"custom_html-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `esduc_options` VALUES("105", "cron", "a:20:{i:1647240647;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1647240700;a:1:{s:26:\"learndash_woocommerce_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"per_minute\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1647241300;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1647241306;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1647241610;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1647242529;a:6:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1647242630;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647244658;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647247336;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647247406;a:1:{s:27:\"gform_userregistration_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1647248379;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647248454;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647259254;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1647273700;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647291600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647324064;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647324558;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647501729;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1648447314;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `esduc_options` VALUES("10000", "ld_achievements_db_version", "1.0", "yes");
INSERT INTO `esduc_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("117", "widget_custom_html", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:280:\"<p>[vc_row][vc_column width=\"1/2\"][vc_column_text]</p>\r\n<p>I am text block. Click edit button to change this text. Lorem ipsum dolor sit</p>\r\n<p>[/vc_column_text][us_btn link=\"url:%23\"][/vc_column][vc_column width=\"1/2\"][us_image image=\"26\" size=\"full\"][/vc_column][/vc_row]</p>\r\n\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("120", "https_detection_errors", "a:2:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:35:\"تأیید SSL ناموفق بود.\";}s:17:\"bad_response_code\";a:1:{i:0;s:9:\"Not Found\";}}", "yes");
INSERT INTO `esduc_options` VALUES("215", "action_scheduler_hybrid_store_demarkation", "7", "yes");
INSERT INTO `esduc_options` VALUES("216", "schema-ActionScheduler_StoreSchema", "6.0.1642175204", "yes");
INSERT INTO `esduc_options` VALUES("217", "schema-ActionScheduler_LoggerSchema", "3.0.1638201699", "yes");
INSERT INTO `esduc_options` VALUES("220", "woocommerce_schema_version", "430", "yes");
INSERT INTO `esduc_options` VALUES("221", "woocommerce_store_address", "", "yes");
INSERT INTO `esduc_options` VALUES("222", "woocommerce_store_address_2", "", "yes");
INSERT INTO `esduc_options` VALUES("223", "woocommerce_store_city", "", "yes");
INSERT INTO `esduc_options` VALUES("224", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `esduc_options` VALUES("225", "woocommerce_store_postcode", "", "yes");
INSERT INTO `esduc_options` VALUES("226", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `esduc_options` VALUES("227", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("228", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("229", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `esduc_options` VALUES("230", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("231", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `esduc_options` VALUES("232", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `esduc_options` VALUES("233", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `esduc_options` VALUES("234", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `esduc_options` VALUES("235", "woocommerce_currency", "IRT", "yes");
INSERT INTO `esduc_options` VALUES("236", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `esduc_options` VALUES("237", "woocommerce_price_thousand_sep", "،", "yes");
INSERT INTO `esduc_options` VALUES("238", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `esduc_options` VALUES("239", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `esduc_options` VALUES("240", "woocommerce_shop_page_id", "8", "yes");
INSERT INTO `esduc_options` VALUES("241", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `esduc_options` VALUES("242", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `esduc_options` VALUES("243", "woocommerce_placeholder_image", "7", "yes");
INSERT INTO `esduc_options` VALUES("244", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `esduc_options` VALUES("245", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `esduc_options` VALUES("246", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `esduc_options` VALUES("247", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `esduc_options` VALUES("248", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `esduc_options` VALUES("249", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `esduc_options` VALUES("250", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `esduc_options` VALUES("251", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `esduc_options` VALUES("252", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `esduc_options` VALUES("253", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `esduc_options` VALUES("254", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `esduc_options` VALUES("255", "woocommerce_stock_email_recipient", "test-theme@demoabzar.com", "no");
INSERT INTO `esduc_options` VALUES("256", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `esduc_options` VALUES("257", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `esduc_options` VALUES("258", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `esduc_options` VALUES("259", "woocommerce_stock_format", "", "yes");
INSERT INTO `esduc_options` VALUES("260", "woocommerce_file_download_method", "force", "no");
INSERT INTO `esduc_options` VALUES("261", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `esduc_options` VALUES("262", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `esduc_options` VALUES("263", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `esduc_options` VALUES("264", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `esduc_options` VALUES("265", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `esduc_options` VALUES("266", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `esduc_options` VALUES("267", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `esduc_options` VALUES("268", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `esduc_options` VALUES("269", "woocommerce_tax_classes", "", "yes");
INSERT INTO `esduc_options` VALUES("270", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `esduc_options` VALUES("271", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `esduc_options` VALUES("272", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `esduc_options` VALUES("273", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `esduc_options` VALUES("274", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `esduc_options` VALUES("275", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `esduc_options` VALUES("276", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `esduc_options` VALUES("277", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `esduc_options` VALUES("278", "woocommerce_enable_guest_checkout", "no", "no");
INSERT INTO `esduc_options` VALUES("279", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `esduc_options` VALUES("280", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `esduc_options` VALUES("281", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `esduc_options` VALUES("282", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `esduc_options` VALUES("283", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `esduc_options` VALUES("284", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `esduc_options` VALUES("285", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `esduc_options` VALUES("286", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `esduc_options` VALUES("287", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `esduc_options` VALUES("288", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `esduc_options` VALUES("289", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `esduc_options` VALUES("290", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `esduc_options` VALUES("291", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `esduc_options` VALUES("292", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `esduc_options` VALUES("293", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `esduc_options` VALUES("294", "woocommerce_email_from_name", "سایت آماده آموزش آنلاین", "no");
INSERT INTO `esduc_options` VALUES("295", "woocommerce_email_from_address", "test-theme@demoabzar.com", "no");
INSERT INTO `esduc_options` VALUES("296", "woocommerce_email_header_image", "", "no");
INSERT INTO `esduc_options` VALUES("297", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `esduc_options` VALUES("298", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `esduc_options` VALUES("299", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `esduc_options` VALUES("300", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `esduc_options` VALUES("301", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `esduc_options` VALUES("302", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `esduc_options` VALUES("303", "woocommerce_cart_page_id", "9", "no");
INSERT INTO `esduc_options` VALUES("304", "woocommerce_checkout_page_id", "10", "no");
INSERT INTO `esduc_options` VALUES("305", "woocommerce_myaccount_page_id", "", "no");
INSERT INTO `esduc_options` VALUES("306", "woocommerce_terms_page_id", "", "no");
INSERT INTO `esduc_options` VALUES("307", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `esduc_options` VALUES("308", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `esduc_options` VALUES("309", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `esduc_options` VALUES("310", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `esduc_options` VALUES("311", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `esduc_options` VALUES("312", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `esduc_options` VALUES("313", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `esduc_options` VALUES("314", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `esduc_options` VALUES("315", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `esduc_options` VALUES("316", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `esduc_options` VALUES("317", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `esduc_options` VALUES("318", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `esduc_options` VALUES("319", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `esduc_options` VALUES("320", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `esduc_options` VALUES("321", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `esduc_options` VALUES("322", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `esduc_options` VALUES("323", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `esduc_options` VALUES("324", "woocommerce_show_marketplace_suggestions", "no", "no");
INSERT INTO `esduc_options` VALUES("325", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `esduc_options` VALUES("326", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `esduc_options` VALUES("327", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `esduc_options` VALUES("328", "woocommerce_demo_store", "no", "no");
INSERT INTO `esduc_options` VALUES("329", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `esduc_options` VALUES("330", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `esduc_options` VALUES("331", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `esduc_options` VALUES("340", "woocommerce_version", "6.3.1", "yes");
INSERT INTO `esduc_options` VALUES("341", "woocommerce_db_version", "6.3.0", "yes");
INSERT INTO `esduc_options` VALUES("342", "woocommerce_inbox_variant_assignment", "3", "yes");
INSERT INTO `esduc_options` VALUES("349", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"hFnz42RM2QINXntMCgBOZaN0esZahXca\";}", "yes");
INSERT INTO `esduc_options` VALUES("347", "action_scheduler_lock_async-request-runner", "1647240776", "yes");
INSERT INTO `esduc_options` VALUES("348", "woocommerce_admin_notices", "a:1:{i:1;s:20:\"no_secure_connection\";}", "yes");
INSERT INTO `esduc_options` VALUES("351", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("352", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("353", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("354", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("355", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("356", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("357", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("358", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("359", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("360", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("361", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("362", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("366", "woocommerce_admin_install_timestamp", "1638201700", "yes");
INSERT INTO `esduc_options` VALUES("367", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `esduc_options` VALUES("31363", "woocommerce_admin_version", "3.2.1", "yes");
INSERT INTO `esduc_options` VALUES("368", "wc_remote_inbox_notifications_specs", "a:30:{s:27:\"stripe_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"stripe_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:380:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/stripe/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#apple-pay\">enable Apple Pay with Stripe</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"stripe_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}s:27:\"square_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"square_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:393:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/woocommerce-square/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#section-14\">enable Apple Pay with Square</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"square_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}}}}s:26:\"wcpay_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"wcpay_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:338:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/payments/apple-pay/\">enable Apple Pay with WooCommerce Payments</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"wcpay_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}s:27:\"new_in_app_marketplace_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"new_in_app_marketplace_2021\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Customize your store with extensions\";s:7:\"content\";s:164:\"Check out our NEW Extensions tab to see our favorite extensions for customizing your store, and discover the most popular extensions in the WooCommerce Marketplace.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"browse_extensions\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Browse extensions\";}}s:3:\"url\";s:15:\"&page=wc-addons\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.7\";}}}s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:259:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store\'s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:42:\"https://woocommerce.com/products/wayflyer/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:45:\"https://woocommerce.com/woocommerce-shipping/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:30:\"wc_shipping_mobile_app_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:69:\"Print and manage your shipping labels with the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:30:\"Get the WooCommerce Mobile App\";}}s:3:\"url\";s:31:\"https://woocommerce.com/mobile/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:255:\"WooCommerce Shipping & Tax helps get your store “ready to sell” as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:274:\"Product Add-Ons allow your customers to personalize products while they’re shopping on your online store. No more follow-up email requests—customers get what they want, before they’re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:461:\"That\'s huge! You\'re well on your way to building a successful online store — now it’s time to think about how you\'ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:171:\"It\'s crucial to get your store\'s checkout as smooth as possible to avoid losing sales. Let\'s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:78:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:39:\"wc-admin-first-five-things-to-customize\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-admin-first-five-things-to-customize\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"The first 5 things to customize in your store\";s:7:\"content\";s:173:\"Deciding what to start with first is tricky. To help you properly prioritize, we\'ve put together this short list of the first few things you should customize in WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/first-things-customize-woocommerce/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:2;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:5:\"value\";s:9:\"NOT EMPTY\";s:7:\"default\";s:9:\"NOT EMPTY\";s:9:\"operation\";s:2:\"!=\";}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:56:\"https://woocommerce.com/products/google-listings-and-ads\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:736:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site\'s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:5:\"rules\";a:0:{}}s:30:\"wcpay-promo-2021-6-incentive-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-1\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:702:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies.\n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a>\n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:25:\"get-woo-commerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"1\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"3\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"5\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"7\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"9\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"11\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:30:\"wcpay-promo-2021-6-incentive-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-2\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:702:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies.\n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a>\n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"get-woocommerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"2\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"4\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"6\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"8\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"10\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"12\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:440:\"Heads up! There\'s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:513:\"We\'ve developed a whole new <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension for WooCommerce</a> that combines the best features of our many PayPal extensions into just one extension.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br/><br/>Start using our latest PayPal today to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:38:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"We\'re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:134:\"We\'d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}}", "no");
INSERT INTO `esduc_options` VALUES("369", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}", "no");
INSERT INTO `esduc_options` VALUES("375", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `esduc_options` VALUES("162", "theme_switched", "", "yes");
INSERT INTO `esduc_options` VALUES("124", "theme_mods_twentytwentyone", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1638808924;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-2\";a:0:{}}}s:18:\"nav_menu_locations\";a:0:{}}", "yes");
INSERT INTO `esduc_options` VALUES("138", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"test-theme@demoabzar.com\";s:7:\"version\";s:5:\"5.9.2\";s:9:\"timestamp\";i:1647151017;}", "no");
INSERT INTO `esduc_options` VALUES("160", "current_theme", "Hello Elementor", "yes");
INSERT INTO `esduc_options` VALUES("161", "theme_mods_Zephyr", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:18:\"ir-instructor-menu\";i:16;}s:18:\"custom_css_post_id\";i:1390;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1644820931;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"default_sidebar\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:24:\"us_widget_area_mega_menu\";a:1:{i:0;s:13:\"custom_html-2\";}}}}", "yes");
INSERT INTO `esduc_options` VALUES("153", "akismet_strictness", "0", "yes");
INSERT INTO `esduc_options` VALUES("152", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("154", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `esduc_options` VALUES("155", "akismet_comment_form_privacy_notice", "hide", "yes");
INSERT INTO `esduc_options` VALUES("156", "wordpress_api_key", "befb5f95e15e", "yes");
INSERT INTO `esduc_options` VALUES("157", "akismet_spam_count", "0", "yes");
INSERT INTO `esduc_options` VALUES("159", "finished_updating_comment_type", "1", "yes");
INSERT INTO `esduc_options` VALUES("149", "recently_activated", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("165", "usof_options_Zephyr", "a:512:{s:16:\"maintenance_mode\";i:0;s:22:\"maintenance_mode_alert\";s:0:\"\";s:16:\"maintenance_page\";i:1961;s:15:\"maintenance_503\";i:0;s:9:\"site_icon\";s:1:\"0\";s:10:\"dark_theme\";s:4:\"none\";s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:15:\"img_placeholder\";s:88:\"http://abzarwp.net/pre-learning/wp-content/plugins/us-core/assets/images/placeholder.svg\";s:13:\"ripple_effect\";i:0;s:15:\"rounded_corners\";i:1;s:15:\"links_underline\";i:0;s:22:\"keyboard_accessibility\";i:0;s:11:\"back_to_top\";i:1;s:25:\"wrapper_back_to_top_start\";s:0:\"\";s:17:\"back_to_top_style\";s:0:\"\";s:15:\"back_to_top_pos\";s:5:\"right\";s:17:\"back_to_top_color\";s:15:\"rgba(0,0,0,0.3)\";s:19:\"back_to_top_display\";s:5:\"100vh\";s:23:\"wrapper_back_to_top_end\";s:0:\"\";s:13:\"cookie_notice\";i:0;s:20:\"wrapper_cookie_start\";s:0:\"\";s:14:\"cookie_message\";s:106:\"This website uses cookies to improve your experience. If you continue to use this site, you agree with it.\";s:14:\"cookie_privacy\";s:0:\"\";s:18:\"cookie_message_pos\";s:6:\"bottom\";s:16:\"cookie_btn_label\";s:2:\"Ok\";s:16:\"cookie_btn_style\";s:1:\"1\";s:18:\"wrapper_cookie_end\";s:0:\"\";s:22:\"smooth_scroll_duration\";s:6:\"1000ms\";s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:15:\"_content_bg_alt\";s:13:\"body_bg_image\";s:0:\"\";s:21:\"wrapper_body_bg_start\";s:0:\"\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:8:\"top left\";s:24:\"body_bg_image_attachment\";i:1;s:19:\"wrapper_body_bg_end\";s:0:\"\";s:17:\"site_canvas_width\";s:6:\"1300px\";s:18:\"site_content_width\";s:6:\"1140px\";s:13:\"sidebar_width\";s:3:\"25%\";s:10:\"row_height\";s:6:\"medium\";s:17:\"row_height_custom\";s:5:\"5vmax\";s:18:\"text_bottom_indent\";s:6:\"1.5rem\";s:13:\"footer_reveal\";b:0;s:21:\"disable_effects_width\";s:5:\"900px\";s:22:\"columns_stacking_width\";s:5:\"768px\";s:18:\"laptops_breakpoint\";s:6:\"1280px\";s:18:\"tablets_breakpoint\";s:6:\"1024px\";s:18:\"mobiles_breakpoint\";s:5:\"600px\";s:11:\"search_page\";s:4:\"1842\";s:28:\"exclude_post_types_in_search\";s:113:\"product,sfwd-topic,sfwd-quiz,sfwd-certificates,groups,sfwd-essays,sfwd-assignment,wppcp_group,wppcp_fproduct_tabs\";s:10:\"posts_page\";s:7:\"default\";s:8:\"page_404\";s:4:\"1961\";s:10:\"h_defaults\";s:0:\"\";s:9:\"header_id\";s:2:\"29\";s:11:\"titlebar_id\";s:0:\"\";s:10:\"content_id\";s:0:\"\";s:10:\"sidebar_id\";s:0:\"\";s:11:\"sidebar_pos\";s:5:\"right\";s:9:\"footer_id\";s:3:\"246\";s:6:\"h_post\";s:0:\"\";s:14:\"header_post_id\";s:12:\"__defaults__\";s:16:\"titlebar_post_id\";s:12:\"__defaults__\";s:15:\"content_post_id\";s:3:\"450\";s:15:\"sidebar_post_id\";s:12:\"__defaults__\";s:16:\"sidebar_post_pos\";s:5:\"right\";s:14:\"footer_post_id\";s:4:\"1085\";s:14:\"h_sfwd-courses\";s:0:\"\";s:22:\"header_sfwd-courses_id\";s:2:\"29\";s:24:\"titlebar_sfwd-courses_id\";s:12:\"__defaults__\";s:23:\"content_sfwd-courses_id\";s:2:\"28\";s:23:\"sidebar_sfwd-courses_id\";s:12:\"__defaults__\";s:24:\"sidebar_sfwd-courses_pos\";s:5:\"right\";s:22:\"footer_sfwd-courses_id\";s:4:\"1085\";s:14:\"h_sfwd-lessons\";s:0:\"\";s:22:\"header_sfwd-lessons_id\";s:12:\"__defaults__\";s:24:\"titlebar_sfwd-lessons_id\";s:12:\"__defaults__\";s:23:\"content_sfwd-lessons_id\";s:4:\"1258\";s:23:\"sidebar_sfwd-lessons_id\";s:12:\"__defaults__\";s:24:\"sidebar_sfwd-lessons_pos\";s:5:\"right\";s:22:\"footer_sfwd-lessons_id\";s:12:\"__defaults__\";s:12:\"h_sfwd-topic\";s:0:\"\";s:20:\"header_sfwd-topic_id\";s:12:\"__defaults__\";s:22:\"titlebar_sfwd-topic_id\";s:12:\"__defaults__\";s:21:\"content_sfwd-topic_id\";s:4:\"1258\";s:21:\"sidebar_sfwd-topic_id\";s:12:\"__defaults__\";s:22:\"sidebar_sfwd-topic_pos\";s:5:\"right\";s:20:\"footer_sfwd-topic_id\";s:12:\"__defaults__\";s:11:\"h_sfwd-quiz\";s:0:\"\";s:19:\"header_sfwd-quiz_id\";s:12:\"__defaults__\";s:21:\"titlebar_sfwd-quiz_id\";s:12:\"__defaults__\";s:20:\"content_sfwd-quiz_id\";s:4:\"1640\";s:20:\"sidebar_sfwd-quiz_id\";s:12:\"__defaults__\";s:21:\"sidebar_sfwd-quiz_pos\";s:5:\"right\";s:19:\"footer_sfwd-quiz_id\";s:4:\"1085\";s:19:\"h_sfwd-certificates\";s:0:\"\";s:27:\"header_sfwd-certificates_id\";s:12:\"__defaults__\";s:29:\"titlebar_sfwd-certificates_id\";s:12:\"__defaults__\";s:28:\"content_sfwd-certificates_id\";s:12:\"__defaults__\";s:28:\"sidebar_sfwd-certificates_id\";s:12:\"__defaults__\";s:29:\"sidebar_sfwd-certificates_pos\";s:5:\"right\";s:27:\"footer_sfwd-certificates_id\";s:12:\"__defaults__\";s:8:\"h_groups\";s:0:\"\";s:16:\"header_groups_id\";s:12:\"__defaults__\";s:18:\"titlebar_groups_id\";s:12:\"__defaults__\";s:17:\"content_groups_id\";s:12:\"__defaults__\";s:17:\"sidebar_groups_id\";s:12:\"__defaults__\";s:18:\"sidebar_groups_pos\";s:5:\"right\";s:16:\"footer_groups_id\";s:12:\"__defaults__\";s:13:\"h_sfwd-essays\";s:0:\"\";s:21:\"header_sfwd-essays_id\";s:12:\"__defaults__\";s:23:\"titlebar_sfwd-essays_id\";s:12:\"__defaults__\";s:22:\"content_sfwd-essays_id\";s:12:\"__defaults__\";s:22:\"sidebar_sfwd-essays_id\";s:12:\"__defaults__\";s:23:\"sidebar_sfwd-essays_pos\";s:5:\"right\";s:21:\"footer_sfwd-essays_id\";s:12:\"__defaults__\";s:17:\"h_sfwd-assignment\";s:0:\"\";s:25:\"header_sfwd-assignment_id\";s:12:\"__defaults__\";s:27:\"titlebar_sfwd-assignment_id\";s:12:\"__defaults__\";s:26:\"content_sfwd-assignment_id\";s:12:\"__defaults__\";s:26:\"sidebar_sfwd-assignment_id\";s:12:\"__defaults__\";s:27:\"sidebar_sfwd-assignment_pos\";s:5:\"right\";s:25:\"footer_sfwd-assignment_id\";s:12:\"__defaults__\";s:13:\"h_wppcp_group\";s:0:\"\";s:21:\"header_wppcp_group_id\";s:12:\"__defaults__\";s:23:\"titlebar_wppcp_group_id\";s:12:\"__defaults__\";s:22:\"content_wppcp_group_id\";s:12:\"__defaults__\";s:22:\"sidebar_wppcp_group_id\";s:12:\"__defaults__\";s:23:\"sidebar_wppcp_group_pos\";s:5:\"right\";s:21:\"footer_wppcp_group_id\";s:12:\"__defaults__\";s:21:\"h_wppcp_fproduct_tabs\";s:0:\"\";s:29:\"header_wppcp_fproduct_tabs_id\";s:12:\"__defaults__\";s:31:\"titlebar_wppcp_fproduct_tabs_id\";s:12:\"__defaults__\";s:30:\"content_wppcp_fproduct_tabs_id\";s:12:\"__defaults__\";s:30:\"sidebar_wppcp_fproduct_tabs_id\";s:12:\"__defaults__\";s:31:\"sidebar_wppcp_fproduct_tabs_pos\";s:5:\"right\";s:29:\"footer_wppcp_fproduct_tabs_id\";s:12:\"__defaults__\";s:18:\"h_archive_defaults\";s:0:\"\";s:17:\"header_archive_id\";s:2:\"29\";s:19:\"titlebar_archive_id\";s:0:\"\";s:18:\"content_archive_id\";s:0:\"\";s:18:\"sidebar_archive_id\";s:0:\"\";s:19:\"sidebar_archive_pos\";s:5:\"right\";s:17:\"footer_archive_id\";s:4:\"1547\";s:14:\"h_tax_category\";s:0:\"\";s:22:\"header_tax_category_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_category_id\";s:12:\"__defaults__\";s:23:\"content_tax_category_id\";s:4:\"1551\";s:23:\"sidebar_tax_category_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_category_pos\";s:5:\"right\";s:22:\"footer_tax_category_id\";s:12:\"__defaults__\";s:14:\"h_tax_post_tag\";s:0:\"\";s:22:\"header_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"content_tax_post_tag_id\";s:4:\"1551\";s:23:\"sidebar_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_post_tag_pos\";s:5:\"right\";s:22:\"footer_tax_post_tag_id\";s:12:\"__defaults__\";s:17:\"h_tax_post_format\";s:0:\"\";s:25:\"header_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"content_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_post_format_pos\";s:5:\"right\";s:25:\"footer_tax_post_format_id\";s:12:\"__defaults__\";s:28:\"h_tax_product_shipping_class\";s:0:\"\";s:36:\"header_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:38:\"titlebar_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:37:\"content_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:37:\"sidebar_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:38:\"sidebar_tax_product_shipping_class_pos\";s:5:\"right\";s:36:\"footer_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:24:\"h_tax_ld_course_category\";s:0:\"\";s:32:\"header_tax_ld_course_category_id\";s:12:\"__defaults__\";s:34:\"titlebar_tax_ld_course_category_id\";s:12:\"__defaults__\";s:33:\"content_tax_ld_course_category_id\";s:4:\"1549\";s:33:\"sidebar_tax_ld_course_category_id\";s:12:\"__defaults__\";s:34:\"sidebar_tax_ld_course_category_pos\";s:5:\"right\";s:32:\"footer_tax_ld_course_category_id\";s:12:\"__defaults__\";s:19:\"h_tax_ld_course_tag\";s:0:\"\";s:27:\"header_tax_ld_course_tag_id\";s:12:\"__defaults__\";s:29:\"titlebar_tax_ld_course_tag_id\";s:12:\"__defaults__\";s:28:\"content_tax_ld_course_tag_id\";s:4:\"1549\";s:28:\"sidebar_tax_ld_course_tag_id\";s:12:\"__defaults__\";s:29:\"sidebar_tax_ld_course_tag_pos\";s:5:\"right\";s:27:\"footer_tax_ld_course_tag_id\";s:12:\"__defaults__\";s:24:\"h_tax_ld_lesson_category\";s:0:\"\";s:32:\"header_tax_ld_lesson_category_id\";s:12:\"__defaults__\";s:34:\"titlebar_tax_ld_lesson_category_id\";s:12:\"__defaults__\";s:33:\"content_tax_ld_lesson_category_id\";s:4:\"1549\";s:33:\"sidebar_tax_ld_lesson_category_id\";s:12:\"__defaults__\";s:34:\"sidebar_tax_ld_lesson_category_pos\";s:5:\"right\";s:32:\"footer_tax_ld_lesson_category_id\";s:12:\"__defaults__\";s:19:\"h_tax_ld_lesson_tag\";s:0:\"\";s:27:\"header_tax_ld_lesson_tag_id\";s:12:\"__defaults__\";s:29:\"titlebar_tax_ld_lesson_tag_id\";s:12:\"__defaults__\";s:28:\"content_tax_ld_lesson_tag_id\";s:4:\"1549\";s:28:\"sidebar_tax_ld_lesson_tag_id\";s:12:\"__defaults__\";s:29:\"sidebar_tax_ld_lesson_tag_pos\";s:5:\"right\";s:27:\"footer_tax_ld_lesson_tag_id\";s:12:\"__defaults__\";s:23:\"h_tax_ld_topic_category\";s:0:\"\";s:31:\"header_tax_ld_topic_category_id\";s:12:\"__defaults__\";s:33:\"titlebar_tax_ld_topic_category_id\";s:12:\"__defaults__\";s:32:\"content_tax_ld_topic_category_id\";s:12:\"__defaults__\";s:32:\"sidebar_tax_ld_topic_category_id\";s:12:\"__defaults__\";s:33:\"sidebar_tax_ld_topic_category_pos\";s:5:\"right\";s:31:\"footer_tax_ld_topic_category_id\";s:12:\"__defaults__\";s:18:\"h_tax_ld_topic_tag\";s:0:\"\";s:26:\"header_tax_ld_topic_tag_id\";s:12:\"__defaults__\";s:28:\"titlebar_tax_ld_topic_tag_id\";s:12:\"__defaults__\";s:27:\"content_tax_ld_topic_tag_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_ld_topic_tag_id\";s:12:\"__defaults__\";s:28:\"sidebar_tax_ld_topic_tag_pos\";s:5:\"right\";s:26:\"footer_tax_ld_topic_tag_id\";s:12:\"__defaults__\";s:23:\"h_tax_ld_group_category\";s:0:\"\";s:31:\"header_tax_ld_group_category_id\";s:12:\"__defaults__\";s:33:\"titlebar_tax_ld_group_category_id\";s:12:\"__defaults__\";s:32:\"content_tax_ld_group_category_id\";s:12:\"__defaults__\";s:32:\"sidebar_tax_ld_group_category_id\";s:12:\"__defaults__\";s:33:\"sidebar_tax_ld_group_category_pos\";s:5:\"right\";s:31:\"footer_tax_ld_group_category_id\";s:12:\"__defaults__\";s:18:\"h_tax_ld_group_tag\";s:0:\"\";s:26:\"header_tax_ld_group_tag_id\";s:12:\"__defaults__\";s:28:\"titlebar_tax_ld_group_tag_id\";s:12:\"__defaults__\";s:27:\"content_tax_ld_group_tag_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_ld_group_tag_id\";s:12:\"__defaults__\";s:28:\"sidebar_tax_ld_group_tag_pos\";s:5:\"right\";s:26:\"footer_tax_ld_group_tag_id\";s:12:\"__defaults__\";s:9:\"h_authors\";s:0:\"\";s:16:\"header_author_id\";s:12:\"__defaults__\";s:18:\"titlebar_author_id\";s:12:\"__defaults__\";s:17:\"content_author_id\";s:12:\"__defaults__\";s:17:\"sidebar_author_id\";s:12:\"__defaults__\";s:18:\"sidebar_author_pos\";s:5:\"right\";s:16:\"footer_author_id\";s:12:\"__defaults__\";s:19:\"color_header_top_bg\";s:7:\"#fe4641\";s:21:\"color_header_top_text\";s:22:\"rgba(255,255,255,0.75)\";s:27:\"color_header_top_text_hover\";s:7:\"#ffffff\";s:22:\"color_header_middle_bg\";s:7:\"#ffffff\";s:24:\"color_header_middle_text\";s:7:\"#444444\";s:30:\"color_header_middle_text_hover\";s:7:\"#f2950f\";s:29:\"color_header_transparent_text\";s:7:\"#ffffff\";s:35:\"color_header_transparent_text_hover\";s:7:\"#f59102\";s:20:\"color_chrome_toolbar\";s:7:\"#fe4641\";s:16:\"color_content_bg\";s:7:\"#ffffff\";s:20:\"color_content_bg_alt\";s:7:\"#f5f5f5\";s:20:\"color_content_border\";s:7:\"#e5e5e5\";s:21:\"color_content_heading\";s:7:\"#222222\";s:18:\"color_content_text\";s:7:\"#444444\";s:18:\"color_content_link\";s:7:\"#fe4641\";s:24:\"color_content_link_hover\";s:7:\"#fda527\";s:21:\"color_content_primary\";s:7:\"#fe4641\";s:23:\"color_content_secondary\";s:7:\"#fda527\";s:19:\"color_content_faded\";s:7:\"#999999\";s:21:\"color_content_overlay\";s:16:\"rgba(0,0,0,0.75)\";s:20:\"color_alt_content_bg\";s:7:\"#f5f5f5\";s:24:\"color_alt_content_bg_alt\";s:7:\"#ffffff\";s:24:\"color_alt_content_border\";s:7:\"#dddddd\";s:25:\"color_alt_content_heading\";s:7:\"#222222\";s:22:\"color_alt_content_text\";s:7:\"#444444\";s:22:\"color_alt_content_link\";s:7:\"#fe4641\";s:28:\"color_alt_content_link_hover\";s:7:\"#fda527\";s:25:\"color_alt_content_primary\";s:7:\"#fe4641\";s:27:\"color_alt_content_secondary\";s:7:\"#fda527\";s:23:\"color_alt_content_faded\";s:7:\"#999999\";s:25:\"color_alt_content_overlay\";s:20:\"rgba(254,70,65,0.85)\";s:15:\"color_footer_bg\";s:7:\"#181818\";s:19:\"color_footer_bg_alt\";s:7:\"#252525\";s:19:\"color_footer_border\";s:7:\"#252525\";s:20:\"color_footer_heading\";s:0:\"\";s:17:\"color_footer_text\";s:7:\"#666666\";s:17:\"color_footer_link\";s:7:\"#aaaaaa\";s:23:\"color_footer_link_hover\";s:7:\"#fda527\";s:18:\"color_subfooter_bg\";s:7:\"#252525\";s:22:\"color_subfooter_bg_alt\";s:7:\"#1c1c1c\";s:22:\"color_subfooter_border\";s:7:\"#333333\";s:23:\"color_subfooter_heading\";s:0:\"\";s:20:\"color_subfooter_text\";s:7:\"#999999\";s:20:\"color_subfooter_link\";s:7:\"#dddddd\";s:26:\"color_subfooter_link_hover\";s:7:\"#fda527\";s:12:\"style_scheme\";i:3;s:26:\"change_header_colors_start\";s:0:\"\";s:10:\"h_colors_1\";s:0:\"\";s:27:\"color_header_transparent_bg\";s:11:\"transparent\";s:24:\"change_header_colors_end\";s:0:\"\";s:30:\"change_header_alt_colors_start\";s:0:\"\";s:10:\"h_colors_2\";s:0:\"\";s:31:\"color_header_top_transparent_bg\";s:15:\"rgba(0,0,0,0.2)\";s:33:\"color_header_top_transparent_text\";s:22:\"rgba(255,255,255,0.66)\";s:39:\"color_header_top_transparent_text_hover\";s:4:\"#fff\";s:28:\"change_header_alt_colors_end\";s:0:\"\";s:27:\"change_content_colors_start\";s:0:\"\";s:10:\"h_colors_3\";s:0:\"\";s:25:\"change_content_colors_end\";s:0:\"\";s:31:\"change_alt_content_colors_start\";s:0:\"\";s:10:\"h_colors_4\";s:0:\"\";s:29:\"change_alt_content_colors_end\";s:0:\"\";s:26:\"change_footer_colors_start\";s:0:\"\";s:10:\"h_colors_6\";s:0:\"\";s:24:\"change_footer_colors_end\";s:0:\"\";s:29:\"change_subfooter_colors_start\";s:0:\"\";s:10:\"h_colors_5\";s:0:\"\";s:27:\"change_subfooter_colors_end\";s:0:\"\";s:16:\"body_font_family\";s:26:\"iranyekanwebregular_FaNum|\";s:13:\"body_fontsize\";s:4:\"18px\";s:20:\"body_fontsize_mobile\";s:4:\"16px\";s:15:\"body_lineheight\";s:4:\"28px\";s:22:\"body_lineheight_mobile\";s:4:\"28px\";s:14:\"h1_font_family\";s:25:\"iranyekanwebmedium_FaNum|\";s:11:\"h1_fontsize\";s:4:\"20px\";s:18:\"h1_fontsize_mobile\";s:0:\"\";s:13:\"h1_lineheight\";s:3:\"1.2\";s:16:\"h1_letterspacing\";s:1:\"0\";s:13:\"h1_fontweight\";s:3:\"400\";s:16:\"h1_bottom_indent\";s:6:\"1.5rem\";s:8:\"h1_color\";s:0:\"\";s:12:\"h1_transform\";s:0:\"\";s:17:\"h1_color_override\";s:0:\"\";s:14:\"h2_font_family\";s:25:\"iranyekanwebmedium_FaNum|\";s:11:\"h2_fontsize\";s:4:\"17px\";s:18:\"h2_fontsize_mobile\";s:0:\"\";s:13:\"h2_lineheight\";s:3:\"1.2\";s:16:\"h2_letterspacing\";s:1:\"0\";s:13:\"h2_fontweight\";s:3:\"400\";s:16:\"h2_bottom_indent\";s:6:\"1.5rem\";s:8:\"h2_color\";s:0:\"\";s:12:\"h2_transform\";s:0:\"\";s:17:\"h2_color_override\";s:0:\"\";s:14:\"h3_font_family\";s:25:\"iranyekanwebmedium_FaNum|\";s:11:\"h3_fontsize\";s:4:\"16px\";s:18:\"h3_fontsize_mobile\";s:0:\"\";s:13:\"h3_lineheight\";s:3:\"1.2\";s:16:\"h3_letterspacing\";s:1:\"0\";s:13:\"h3_fontweight\";s:3:\"400\";s:16:\"h3_bottom_indent\";s:6:\"1.5rem\";s:8:\"h3_color\";s:0:\"\";s:12:\"h3_transform\";s:0:\"\";s:17:\"h3_color_override\";s:0:\"\";s:14:\"h4_font_family\";s:25:\"iranyekanwebmedium_FaNum|\";s:11:\"h4_fontsize\";s:4:\"15px\";s:18:\"h4_fontsize_mobile\";s:0:\"\";s:13:\"h4_lineheight\";s:3:\"1.2\";s:16:\"h4_letterspacing\";s:1:\"0\";s:13:\"h4_fontweight\";s:3:\"400\";s:16:\"h4_bottom_indent\";s:6:\"1.5rem\";s:8:\"h4_color\";s:0:\"\";s:12:\"h4_transform\";s:0:\"\";s:17:\"h4_color_override\";s:0:\"\";s:14:\"h5_font_family\";s:25:\"iranyekanwebmedium_FaNum|\";s:11:\"h5_fontsize\";s:4:\"15px\";s:18:\"h5_fontsize_mobile\";s:0:\"\";s:13:\"h5_lineheight\";s:3:\"1.2\";s:16:\"h5_letterspacing\";s:1:\"0\";s:13:\"h5_fontweight\";s:3:\"400\";s:16:\"h5_bottom_indent\";s:6:\"1.5rem\";s:8:\"h5_color\";s:0:\"\";s:12:\"h5_transform\";s:0:\"\";s:17:\"h5_color_override\";s:0:\"\";s:14:\"h6_font_family\";s:7:\"get_h1|\";s:11:\"h6_fontsize\";s:4:\"15px\";s:18:\"h6_fontsize_mobile\";s:0:\"\";s:13:\"h6_lineheight\";s:3:\"1.2\";s:16:\"h6_letterspacing\";s:1:\"0\";s:13:\"h6_fontweight\";s:3:\"400\";s:16:\"h6_bottom_indent\";s:6:\"1.5rem\";s:8:\"h6_color\";s:0:\"\";s:12:\"h6_transform\";s:0:\"\";s:17:\"h6_color_override\";s:0:\"\";s:14:\"h_typography_3\";s:0:\"\";s:11:\"custom_font\";a:0:{}s:14:\"h_typography_4\";s:0:\"\";s:14:\"uploaded_fonts\";a:0:{}s:14:\"h_typography_5\";s:0:\"\";s:12:\"font_display\";s:4:\"swap\";s:7:\"buttons\";a:16:{i:0;a:23:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"Default Button\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#2575fc\";s:14:\"color_bg_hover\";s:7:\"#F14D5D\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:16:\"rgba(0,0,0,0.25)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"1em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.8em\";s:9:\"font_size\";s:4:\"15px\";s:5:\"width\";s:5:\"1.8em\";s:11:\"line_height\";s:3:\"1.2\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:1;a:23:{s:2:\"id\";s:2:\"16\";s:4:\"name\";s:20:\"Default Button - Red\";s:5:\"hover\";s:5:\"slide\";s:8:\"color_bg\";s:39:\"linear-gradient(200deg,#e63946,#ff6600)\";s:14:\"color_bg_hover\";s:7:\"#e63946\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:16:\"rgba(0,0,0,0.25)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"1em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.8em\";s:9:\"font_size\";s:4:\"15px\";s:5:\"width\";s:5:\"1.8em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:2;a:23:{s:2:\"id\";s:2:\"12\";s:4:\"name\";s:34:\"آبی با گوشه های گرد\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#007bec\";s:14:\"color_bg_hover\";s:7:\"#007bec\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"1.5em\";s:9:\"font_size\";s:4:\"15px\";s:5:\"width\";s:3:\"3em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:5:\"1.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:3;a:23:{s:2:\"id\";s:2:\"13\";s:4:\"name\";s:36:\"قرمز با گوشه های گرد\";s:5:\"hover\";s:5:\"slide\";s:8:\"color_bg\";s:39:\"linear-gradient(200deg,#e63946,#ff6600)\";s:14:\"color_bg_hover\";s:7:\"#e63946\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:16:\"rgba(0,0,0,0.20)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:5:\"0.8em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"15px\";s:5:\"width\";s:5:\"1.5em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:4:\"20px\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:4;a:23:{s:2:\"id\";s:2:\"14\";s:4:\"name\";s:26:\"صفحه بندی قرمز\";s:5:\"hover\";s:5:\"slide\";s:8:\"color_bg\";s:39:\"linear-gradient(200deg,#e63946,#ff6600)\";s:14:\"color_bg_hover\";s:7:\"#e63946\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:16:\"rgba(0,0,0,0.20)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:5:\"0.8em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.6em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"0.6em\";s:11:\"line_height\";s:1:\"1\";s:13:\"border_radius\";s:4:\"30px\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:5;a:23:{s:2:\"id\";s:2:\"11\";s:4:\"name\";s:17:\"دکمه مشکی\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#120f2d\";s:14:\"color_bg_hover\";s:7:\"#120f2d\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:19:\"rgba(18,15,45,0.15)\";s:6:\"shadow\";s:5:\"0.5em\";s:12:\"shadow_hover\";s:3:\"1em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.6em\";s:9:\"font_size\";s:4:\"15px\";s:5:\"width\";s:5:\"1.2em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:6;a:23:{s:2:\"id\";s:2:\"15\";s:4:\"name\";s:39:\"دکمه مشکی - پنل کاربری\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#120f2d\";s:14:\"color_bg_hover\";s:7:\"#ffffff\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#120f2d\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:19:\"rgba(18,15,45,0.15)\";s:6:\"shadow\";s:5:\"0.5em\";s:12:\"shadow_hover\";s:3:\"1em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.6em\";s:9:\"font_size\";s:4:\"12px\";s:5:\"width\";s:6:\"1.20em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:7;a:23:{s:2:\"id\";s:1:\"9\";s:4:\"name\";s:28:\"آبی - قرمز - شفاف\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:21:\"rgba(37,117,252,0.15)\";s:14:\"color_bg_hover\";s:20:\"rgba(241,77,93,0.15)\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#2575fc\";s:16:\"color_text_hover\";s:7:\"#F14D5D\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.6em\";s:9:\"font_size\";s:4:\"15px\";s:5:\"width\";s:5:\"1.2em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:8;a:23:{s:2:\"id\";s:1:\"3\";s:4:\"name\";s:32:\"استایل صفحه اصلی 1\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:20:\"rgba(241,77,93,0.15)\";s:14:\"color_bg_hover\";s:7:\"#F14D5D\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#F14D5D\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.5em\";s:9:\"font_size\";s:4:\"13px\";s:5:\"width\";s:3:\"1em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:9;a:23:{s:2:\"id\";s:1:\"8\";s:4:\"name\";s:30:\"استایل شفاف قرمز\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:20:\"rgba(241,77,93,0.15)\";s:14:\"color_bg_hover\";s:7:\"#F14D5D\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#F14D5D\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.4em\";s:9:\"font_size\";s:4:\"11px\";s:5:\"width\";s:5:\"0.5em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:6:\"0.3rem\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:10;a:23:{s:2:\"id\";s:1:\"4\";s:4:\"name\";s:43:\"استایل صفحه اصلی 1 - بزرگ\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#F14D5D\";s:14:\"color_bg_hover\";s:7:\"#2575fc\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"1.2em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:3:\"2em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:11;a:23:{s:2:\"id\";s:1:\"7\";s:4:\"name\";s:44:\"دکمه دسته بندی باکس دوره\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#F14D5D\";s:14:\"color_bg_hover\";s:7:\"#2575fc\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.5em\";s:9:\"font_size\";s:4:\"13px\";s:5:\"width\";s:3:\"1em\";s:11:\"line_height\";s:1:\"1\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:12;a:23:{s:2:\"id\";s:1:\"5\";s:4:\"name\";s:65:\"استایل صفحه اصلی 1 - بزرگ - آبی - دورخط\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:0:\"\";s:12:\"color_border\";s:7:\"#2575fc\";s:18:\"color_border_hover\";s:7:\"#F14D5D\";s:10:\"color_text\";s:7:\"#2575fc\";s:16:\"color_text_hover\";s:7:\"#F14D5D\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:6:\"1.20em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:3:\"2em\";s:11:\"line_height\";s:4:\"1.20\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"2px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:13;a:23:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:15:\"دکمه گرد\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#F14D5D\";s:14:\"color_bg_hover\";s:7:\"#2575fc\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.5em\";s:9:\"font_size\";s:4:\"13px\";s:5:\"width\";s:3:\"1em\";s:11:\"line_height\";s:1:\"1\";s:13:\"border_radius\";s:3:\"5px\";s:11:\"font_weight\";s:3:\"100\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:14;a:23:{s:2:\"id\";s:1:\"6\";s:4:\"name\";s:35:\"دکمه درون باکس دوره\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:7:\"#ffffff\";s:14:\"color_bg_hover\";s:7:\"#ffffff\";s:12:\"color_border\";s:7:\"#F14D5D\";s:18:\"color_border_hover\";s:7:\"#2575fc\";s:10:\"color_text\";s:7:\"#F14D5D\";s:16:\"color_text_hover\";s:7:\"#2575fc\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:19:\"rgba(51,51,51,0.10)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:5:\"0.5em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:3:\"1em\";s:9:\"font_size\";s:4:\"15px\";s:5:\"width\";s:5:\"0.5em\";s:11:\"line_height\";s:1:\"0\";s:13:\"border_radius\";s:3:\"5px\";s:11:\"font_weight\";s:3:\"400\";s:12:\"border_width\";s:3:\"2px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:15;a:23:{s:2:\"id\";s:2:\"10\";s:4:\"name\";s:26:\"دکمه شفاف مشکی\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:0:\"\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#120F2D\";s:16:\"color_text_hover\";s:7:\"#120F2D\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.5em\";s:9:\"font_size\";s:4:\"15px\";s:5:\"width\";s:5:\"0.5em\";s:11:\"line_height\";s:1:\"0\";s:13:\"border_radius\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"400\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}}s:12:\"input_fields\";a:1:{i:0;a:26:{s:8:\"color_bg\";s:11:\"transparent\";s:14:\"color_bg_focus\";s:0:\"\";s:12:\"color_border\";s:7:\"#e8e8e8\";s:18:\"color_border_focus\";s:7:\"#e8e8e8\";s:10:\"color_text\";s:7:\"inherit\";s:16:\"color_text_focus\";s:0:\"\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_focus\";s:7:\"#e95095\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"1px\";s:21:\"shadow_focus_offset_h\";s:3:\"0px\";s:21:\"shadow_focus_offset_v\";s:3:\"0px\";s:17:\"shadow_focus_blur\";s:3:\"0px\";s:19:\"shadow_focus_spread\";s:3:\"1px\";s:12:\"shadow_inset\";s:1:\"1\";s:18:\"shadow_focus_inset\";s:1:\"1\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:3:\"3em\";s:9:\"font_size\";s:4:\"15px\";s:7:\"padding\";s:3:\"1em\";s:11:\"font_weight\";s:3:\"100\";s:13:\"border_radius\";s:3:\"5px\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"1px\";}}s:26:\"portfolio_breadcrumbs_page\";s:0:\"\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:18:\"portfolio_tag_slug\";s:13:\"portfolio_tag\";s:16:\"portfolio_rename\";i:0;s:20:\"portfolio_label_name\";s:9:\"Portfolio\";s:29:\"portfolio_label_singular_name\";s:14:\"Portfolio Page\";s:23:\"portfolio_label_add_new\";s:18:\"Add Portfolio Page\";s:25:\"portfolio_label_edit_item\";s:19:\"Edit Portfolio Page\";s:24:\"portfolio_label_category\";s:20:\"Portfolio Categories\";s:19:\"portfolio_label_tag\";s:14:\"Portfolio Tags\";s:6:\"h_more\";s:0:\"\";s:12:\"shop_catalog\";i:0;s:22:\"shop_primary_btn_style\";s:1:\"1\";s:24:\"shop_secondary_btn_style\";s:1:\"2\";s:15:\"product_gallery\";s:6:\"slider\";s:29:\"wrapper_product_gallery_start\";s:0:\"\";s:26:\"product_gallery_thumbs_pos\";s:6:\"bottom\";s:27:\"product_gallery_thumbs_cols\";s:1:\"4\";s:28:\"product_gallery_thumbs_width\";s:4:\"6rem\";s:26:\"product_gallery_thumbs_gap\";s:3:\"4px\";s:23:\"product_gallery_options\";s:13:\"zoom,lightbox\";s:27:\"wrapper_product_gallery_end\";s:0:\"\";s:9:\"h_product\";s:0:\"\";s:17:\"header_product_id\";s:12:\"__defaults__\";s:19:\"titlebar_product_id\";s:12:\"__defaults__\";s:18:\"content_product_id\";s:0:\"\";s:18:\"sidebar_product_id\";s:12:\"__defaults__\";s:19:\"sidebar_product_pos\";s:5:\"right\";s:17:\"footer_product_id\";s:12:\"__defaults__\";s:6:\"h_shop\";s:0:\"\";s:14:\"header_shop_id\";s:12:\"__defaults__\";s:16:\"titlebar_shop_id\";s:12:\"__defaults__\";s:15:\"content_shop_id\";s:0:\"\";s:18:\"wrapper_shop_start\";s:0:\"\";s:12:\"shop_columns\";s:1:\"3\";s:16:\"wrapper_shop_end\";s:0:\"\";s:15:\"sidebar_shop_id\";s:12:\"__defaults__\";s:16:\"sidebar_shop_pos\";s:5:\"right\";s:14:\"footer_shop_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_cat\";s:0:\"\";s:25:\"header_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_cat_id\";s:12:\"__defaults__\";s:26:\"content_tax_product_cat_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_cat_pos\";s:5:\"right\";s:25:\"footer_tax_product_cat_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_tag\";s:0:\"\";s:25:\"header_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"content_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_tag_pos\";s:5:\"right\";s:25:\"footer_tax_product_tag_id\";s:12:\"__defaults__\";s:6:\"h_cart\";s:0:\"\";s:9:\"shop_cart\";s:7:\"compact\";s:19:\"product_related_qty\";s:1:\"3\";s:15:\"used_icons_info\";s:0:\"\";s:9:\"h_icons_2\";s:0:\"\";s:9:\"icons_fas\";s:7:\"default\";s:21:\"icons_fas_custom_font\";s:0:\"\";s:9:\"icons_far\";s:7:\"default\";s:21:\"icons_far_custom_font\";s:0:\"\";s:9:\"icons_fab\";s:7:\"default\";s:21:\"icons_fab_custom_font\";s:0:\"\";s:14:\"icons_material\";s:7:\"default\";s:26:\"icons_material_custom_font\";s:0:\"\";s:18:\"fallback_icon_font\";i:1;s:13:\"img_size_info\";s:0:\"\";s:13:\"h_image_sizes\";s:0:\"\";s:8:\"img_size\";a:1:{i:0;a:3:{s:5:\"width\";s:5:\"600px\";s:6:\"height\";s:5:\"400px\";s:4:\"crop\";s:0:\"\";}}s:14:\"h_more_options\";s:0:\"\";s:24:\"big_image_size_threshold\";s:6:\"2560px\";s:20:\"delete_unused_images\";i:0;s:12:\"h_advanced_1\";s:0:\"\";s:12:\"live_builder\";i:1;s:19:\"grid_columns_layout\";s:0:\"\";s:12:\"block_editor\";i:0;s:23:\"enable_sidebar_titlebar\";i:0;s:31:\"enable_page_blocks_for_sidebars\";i:0;s:16:\"enable_portfolio\";s:0:\"\";s:19:\"enable_testimonials\";i:1;s:14:\"media_category\";i:1;s:10:\"og_enabled\";s:0:\"\";s:13:\"schema_markup\";i:1;s:12:\"h_advanced_2\";s:0:\"\";s:13:\"gmaps_api_key\";s:0:\"\";s:15:\"facebook_app_id\";s:0:\"\";s:22:\"grid_filter_url_prefix\";s:0:\"\";s:21:\"grid_order_url_prefix\";s:0:\"\";s:12:\"h_advanced_3\";s:0:\"\";s:17:\"keep_url_protocol\";b:1;s:22:\"disable_jquery_migrate\";s:0:\"\";s:13:\"jquery_footer\";s:0:\"\";s:12:\"ajax_load_js\";s:0:\"\";s:16:\"disable_extra_vc\";b:1;s:15:\"optimize_assets\";b:0;s:21:\"optimize_assets_alert\";s:0:\"\";s:21:\"optimize_assets_start\";s:0:\"\";s:6:\"assets\";a:55:{s:12:\"font-awesome\";i:1;s:9:\"actionbox\";i:1;s:9:\"animation\";i:1;s:7:\"buttons\";i:1;s:8:\"carousel\";i:1;s:6:\"charts\";i:1;s:7:\"columns\";i:1;s:8:\"comments\";i:1;s:8:\"contacts\";i:1;s:7:\"counter\";i:1;s:8:\"dropdown\";i:1;s:5:\"forms\";i:1;s:7:\"flipbox\";i:1;s:5:\"gmaps\";i:1;s:4:\"grid\";i:1;s:11:\"grid_filter\";i:1;s:10:\"grid_order\";i:1;s:14:\"grid_templates\";i:1;s:15:\"grid_pagination\";i:1;s:10:\"grid_popup\";i:1;s:6:\"header\";i:1;s:12:\"hor_parallax\";i:1;s:8:\"hwrapper\";i:1;s:7:\"iconbox\";i:1;s:5:\"image\";i:1;s:13:\"image_gallery\";i:1;s:12:\"image_slider\";i:1;s:7:\"ibanner\";i:1;s:5:\"itext\";i:1;s:5:\"login\";i:1;s:14:\"magnific_popup\";i:1;s:4:\"menu\";i:1;s:7:\"message\";i:1;s:5:\"lmaps\";i:1;s:8:\"scroller\";i:1;s:6:\"person\";i:1;s:9:\"preloader\";i:1;s:5:\"print\";i:1;s:5:\"popup\";i:1;s:13:\"post_elements\";i:1;s:15:\"post_navigation\";i:1;s:7:\"pricing\";i:1;s:7:\"progbar\";i:1;s:6:\"scroll\";i:1;s:6:\"search\";i:1;s:9:\"separator\";i:1;s:7:\"sharing\";i:1;s:11:\"simple_menu\";i:1;s:7:\"socials\";i:1;s:4:\"tabs\";i:1;s:4:\"text\";i:1;s:5:\"video\";i:1;s:12:\"ver_parallax\";i:1;s:8:\"vwrapper\";i:1;s:10:\"wp_widgets\";i:1;}s:19:\"optimize_assets_end\";s:0:\"\";s:18:\"include_gfonts_css\";b:0;s:10:\"custom_css\";s:2063:\".header_search_cu #us_form_search_s {\n    font-size: 13px;\n}\n.widget_shopping_cart p.buttons .button {\n    padding: 10px;\n    border-radius: 5px;\n    width: 70%;\n    margin: auto;\n	font-size:13px;\n}\na.button.checkout {\n    background: #404040 !important;\n}\n.woocommerce ul.product_list_widget li {\n    font-size: 0.8rem;\n}\n.woocommerce-mini-cart .quantity {\n    font-size: 11px;\n    margin-right: 10px;\n}\n.widget.widget_shopping_cart p.total {\n    font-size: 15px;\n}\n.w-cart-dropdown .widget_shopping_cart {\n    border: 1px solid #f5f5f5;\n    border-radius: 10px;\n    padding: 20px 0;\n}\n.w-cart-dropdown {\n    text-align: right;\n    padding: 10px;\n}\n.layout-5:hover .layout-5-img{\n	transform:rotate(5deg);\n}\n.course-box-price-btn{\n	box-shadow: 0 5px 15px rgb(241 77 93 / 41%);\n}\n.owl-carousel.navpos_outside .owl-prev {\n    right: 100%;\n    left: auto;\n}\n.owl-carousel.navpos_outside .owl-next {\n    right: auto;\n    left: 100%;\n}\n#box-bg-effect::before {\n    content: \'\';\n    background: #f44336;\n    position: absolute;\n    width: 250px;\n    height: 250px;\n    top: -15px;\n    left: -10px;\n    right: auto;\n    transform: rotate(85deg);\n    z-index: 1;\n    border-radius: 15px;\n}\n#text-shadow{\n	text-shadow: 0px 5px 5px #003bb2;\n}\n@media screen and (max-width: 600px){\n.post_author.avapos_left {\n    display: inherit;\n}\n}\n.ld-achievement-tooltip .ld-achievement-tooltiptext {\n    font-size: 10px;\n    min-width: 120px;\n}\n.blur{\n	filter: blur(3px);\n	pointer-events: none;\n	user-select: none;\n}\n.fa-star {\n  color: #ffffff;\n  -webkit-text-stroke: 1px #FF912C;\n}\n.checked {\n  color: #FF912C;\n}\n\n.woocommerce .login, .woocommerce .track_order, .woocommerce .checkout_coupon, .woocommerce .lost_reset_password, .woocommerce .register {\n    padding: 1.5rem 1.5rem 1.5rem;\n    margin: 1.5rem 0;\n    font-size: 14px;\n    border-radius: 10px;\n}\n.woocommerce-mini-cart__empty-message {\n  padding: 15px;\n  font-size:13px;\n}\n.learndash-wrapper .ld-course-status.ld-course-status-not-enrolled .ld-course-status-price .ld-currency {\n  margin-right: .25em;\n  margin-left: 0;\n}\";s:16:\"custom_html_head\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:8:\"of_reset\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:11:\"white_label\";i:0;s:22:\"white_label_theme_name\";s:0:\"\";s:28:\"white_label_theme_screenshot\";s:0:\"\";s:22:\"white_label_theme_icon\";s:0:\"\";s:22:\"white_label_login_icon\";s:0:\"\";s:16:\"schema_faqs_page\";s:0:\"\";s:11:\"h_portfolio\";s:0:\"\";s:19:\"header_portfolio_id\";s:12:\"__defaults__\";s:21:\"titlebar_portfolio_id\";s:12:\"__defaults__\";s:20:\"content_portfolio_id\";s:12:\"__defaults__\";s:20:\"sidebar_portfolio_id\";s:12:\"__defaults__\";s:21:\"sidebar_portfolio_pos\";s:5:\"right\";s:19:\"footer_portfolio_id\";s:12:\"__defaults__\";s:27:\"h_tax_us_portfolio_category\";s:0:\"\";s:35:\"header_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"titlebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"content_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"sidebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"sidebar_tax_us_portfolio_category_pos\";s:5:\"right\";s:35:\"footer_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:22:\"h_tax_us_portfolio_tag\";s:0:\"\";s:30:\"header_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"titlebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"content_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"sidebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"sidebar_tax_us_portfolio_tag_pos\";s:5:\"right\";s:30:\"footer_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";}", "yes");
INSERT INTO `esduc_options` VALUES("166", "widget_us_contacts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("167", "widget_us_login", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("168", "widget_us_portfolio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("169", "widget_us_blog", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("170", "widget_us_socials", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("171", "vc_version", "6.7.0", "yes");
INSERT INTO `esduc_options` VALUES("172", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `esduc_options` VALUES("173", "usof_color_palette_Zephyr", "a:8:{i:0;s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";i:1;s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";i:2;s:7:\"#1a1a1a\";i:3;s:4:\"#333\";i:4;s:4:\"#999\";i:5;s:7:\"#e8e8e8\";i:6;s:7:\"#f5f5f5\";i:7;s:4:\"#fff\";}", "yes");
INSERT INTO `esduc_options` VALUES("174", "us_theme_options_css", ":root{--color-header-middle-bg:#ffffff;--color-header-middle-bg-grad:#ffffff;--color-header-middle-text:#444444;--color-header-middle-text-hover:#f2950f;--color-header-transparent-bg:transparent;--color-header-transparent-bg-grad:transparent;--color-header-transparent-text:#ffffff;--color-header-transparent-text-hover:#f59102;--color-chrome-toolbar:#fe4641;--color-chrome-toolbar-grad:#fe4641;--color-header-top-bg:#fe4641;--color-header-top-bg-grad:#fe4641;--color-header-top-text:rgba(255,255,255,0.75);--color-header-top-text-hover:#ffffff;--color-header-top-transparent-bg:rgba(0,0,0,0.2);--color-header-top-transparent-bg-grad:rgba(0,0,0,0.2);--color-header-top-transparent-text:rgba(255,255,255,0.66);--color-header-top-transparent-text-hover:#fff;--color-content-bg:#ffffff;--color-content-bg-grad:#ffffff;--color-content-bg-alt:#f5f5f5;--color-content-bg-alt-grad:#f5f5f5;--color-content-border:#e5e5e5;--color-content-heading:#222222;--color-content-heading-grad:#222222;--color-content-text:#444444;--color-content-link:#fe4641;--color-content-link-hover:#fda527;--color-content-primary:#fe4641;--color-content-primary-grad:#fe4641;--color-content-secondary:#fda527;--color-content-secondary-grad:#fda527;--color-content-faded:#999999;--color-content-overlay:rgba(0,0,0,0.75);--color-content-overlay-grad:rgba(0,0,0,0.75);--color-alt-content-bg:#f5f5f5;--color-alt-content-bg-grad:#f5f5f5;--color-alt-content-bg-alt:#ffffff;--color-alt-content-bg-alt-grad:#ffffff;--color-alt-content-border:#dddddd;--color-alt-content-heading:#222222;--color-alt-content-heading-grad:#222222;--color-alt-content-text:#444444;--color-alt-content-link:#fe4641;--color-alt-content-link-hover:#fda527;--color-alt-content-primary:#fe4641;--color-alt-content-primary-grad:#fe4641;--color-alt-content-secondary:#fda527;--color-alt-content-secondary-grad:#fda527;--color-alt-content-faded:#999999;--color-alt-content-overlay:rgba(254,70,65,0.85);--color-alt-content-overlay-grad:rgba(254,70,65,0.85);--color-footer-bg:#181818;--color-footer-bg-grad:#181818;--color-footer-bg-alt:#252525;--color-footer-bg-alt-grad:#252525;--color-footer-border:#252525;--color-footer-text:#666666;--color-footer-link:#aaaaaa;--color-footer-link-hover:#fda527;--color-subfooter-bg:#252525;--color-subfooter-bg-grad:#252525;--color-subfooter-bg-alt:#1c1c1c;--color-subfooter-bg-alt-grad:#1c1c1c;--color-subfooter-border:#333333;--color-subfooter-text:#999999;--color-subfooter-link:#dddddd;--color-subfooter-link-hover:#fda527;--color-content-primary-faded:rgba(254,70,65,0.15);--box-shadow:0 5px 15px rgba(0,0,0,.15);--box-shadow-up:0 -5px 15px rgba(0,0,0,.15);--site-content-width:1140px;--inputs-font-size:15px;--inputs-height:3em;--inputs-padding:1em;--inputs-border-width:1px;--inputs-text-color:inherit;--font-body:\"iranyekanwebregular_FaNum\";--font-h1:\"iranyekanwebmedium_FaNum\";--font-h2:\"iranyekanwebmedium_FaNum\";--font-h3:\"iranyekanwebmedium_FaNum\";--font-h4:\"iranyekanwebmedium_FaNum\";--font-h5:\"iranyekanwebmedium_FaNum\";--font-h6:\"iranyekanwebmedium_FaNum\"}html,.l-header .widget,.menu-item-object-us_page_block{font-family:var(--font-body);font-weight:;font-size:18px;line-height:28px}h1{font-family:var(--font-h1);font-weight:400;font-size:20px;line-height:1.2;letter-spacing:0;margin-bottom:1.5rem}h2{font-family:var(--font-h2);font-weight:400;font-size:17px;line-height:1.2;letter-spacing:0;margin-bottom:1.5rem}h3{font-family:var(--font-h3);font-weight:400;font-size:16px;line-height:1.2;letter-spacing:0;margin-bottom:1.5rem}.woocommerce-Reviews-title,.widgettitle,h4{font-family:var(--font-h4);font-weight:400;font-size:15px;line-height:1.2;letter-spacing:0;margin-bottom:1.5rem}h5{font-family:var(--font-h5);font-weight:400;font-size:15px;line-height:1.2;letter-spacing:0;margin-bottom:1.5rem}h6{font-family:var(--font-h6);font-weight:400;font-size:15px;line-height:1.2;letter-spacing:0;margin-bottom:1.5rem}@media (max-width:600px){html{font-size:16px;line-height:28px}}body{background:var(--color-content-bg-alt)}.l-canvas.type_boxed,.l-canvas.type_boxed .l-subheader,.l-canvas.type_boxed~.l-footer{max-width:1300px}.l-subheader-h,.l-section-h,.l-main .aligncenter,.w-tabs-section-content-h{max-width:1140px}.post-password-form{max-width:calc(1140px + 5rem)}@media screen and (max-width:1230px){.l-main .aligncenter{max-width:calc(100vw - 5rem)}}.wpb_text_column:not(:last-child){margin-bottom:1.5rem}@media (min-width:1281px){body.usb_preview .hide_on_default{opacity:0.25!important}body:not(.usb_preview) .hide_on_default{display:none!important}}@media (min-width:1025px) and (max-width:1280px){body.usb_preview .hide_on_laptops{opacity:0.25!important}body:not(.usb_preview) .hide_on_laptops{display:none!important}}@media (min-width:601px) and (max-width:1024px){body.usb_preview .hide_on_tablets{opacity:0.25!important}body:not(.usb_preview) .hide_on_tablets{display:none!important}}@media (max-width:600px){body.usb_preview .hide_on_mobiles{opacity:0.25!important}body:not(.usb_preview) .hide_on_mobiles{display:none!important}}@media (max-width:767px){.l-canvas{overflow:hidden}.g-cols.via_flex.reversed{flex-direction:column-reverse}.g-cols.via_grid.reversed>div:last-of-type{order:-1}.g-cols.via_flex>div:not([class*=\" vc_col-\"]){width:100%;margin:0 0 1.5rem}.g-cols.via_grid.tablets-cols_inherit.mobiles-cols_1{grid-template-columns:100%}.g-cols.via_flex.type_boxes>div,.g-cols.via_flex.reversed>div:first-child,.g-cols.via_flex:not(.reversed)>div:last-child,.g-cols.via_flex>div.has_bg_color{margin-bottom:0}.g-cols.via_flex.type_default>.wpb_column.stretched{margin-left:-1rem;margin-right:-1rem}.g-cols.via_grid>.wpb_column.stretched,.g-cols.via_flex.type_boxes>.wpb_column.stretched{margin-left:-2.5rem;margin-right:-2.5rem;width:auto}.vc_column-inner.type_sticky>.wpb_wrapper,.vc_column_container.type_sticky>.vc_column-inner{top:0!important}}@media (min-width:768px){body:not(.rtl) .l-section.for_sidebar.at_left>div>.l-sidebar,.rtl .l-section.for_sidebar.at_right>div>.l-sidebar{order:-1}.vc_column_container.type_sticky>.vc_column-inner,.vc_column-inner.type_sticky>.wpb_wrapper{position:-webkit-sticky;position:sticky}.l-section.type_sticky{position:-webkit-sticky;position:sticky;top:0;z-index:11;transform:translateZ(0); transition:top 0.3s cubic-bezier(.78,.13,.15,.86) 0.1s}.admin-bar .l-section.type_sticky{top:32px}.l-section.type_sticky>.l-section-h{transition:padding-top 0.3s}.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:var(--header-sticky-height)}.admin-bar.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:calc( var(--header-sticky-height) + 32px )}.header_hor .l-header.pos_fixed.sticky:not(.down)~.l-main .l-section.type_sticky:first-of-type>.l-section-h{padding-top:var(--header-sticky-height)}}@media screen and (min-width:1230px){.g-cols.via_flex.type_default>.wpb_column.stretched:first-of-type{margin-left:calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw)}.g-cols.via_flex.type_default>.wpb_column.stretched:last-of-type{margin-right:calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw)}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:first-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:first-of-type{margin-left:calc( var(--site-content-width) / 2 + 0px / 2 - 50vw )}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:last-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:last-of-type{margin-right:calc( var(--site-content-width) / 2 + 0px / 2 - 50vw )}}@media (max-width:600px){.w-form-row.for_submit .w-btn{font-size:var(--btn-size-mobiles)!important}}a,button,input[type=\"submit\"],.ui-slider-handle{outline:none!important}.w-toplink,.w-header-show{background:rgba(0,0,0,0.3)}.no-touch .w-toplink.active:hover,.no-touch .w-header-show:hover{background:var(--color-content-primary-grad)}button[type=\"submit\"]:not(.w-btn),input[type=\"submit\"]{font-family:var(--font-body);font-size:15px;line-height:1.2!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.8em 1.8em;box-shadow:0 0em 0em rgba(0,0,0,0.2);background:#2575fc;border-color:transparent;color:#ffffff!important}button[type=\"submit\"]:not(.w-btn):before,input[type=\"submit\"]{border-width:0px}.no-touch button[type=\"submit\"]:not(.w-btn):hover,.no-touch input[type=\"submit\"]:hover{box-shadow:0 0.5em 1em rgba(0,0,0,0.25);background:#F14D5D;border-color:transparent;color:#ffffff!important}.woocommerce .button.alt,.woocommerce .button.checkout,.woocommerce .button.add_to_cart_button,.us-nav-style_1>*,.navstyle_1>.owl-nav div,.us-btn-style_1{font-family:var(--font-body);font-size:15px;line-height:1.2!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.8em 1.8em;background:#2575fc;border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.woocommerce .button.alt:before,.woocommerce .button.checkout:before,.woocommerce .button.add_to_cart_button:before,.us-nav-style_1>*:before,.navstyle_1>.owl-nav div:before,.us-btn-style_1:before{border-width:0px}.no-touch .woocommerce .button.alt:hover,.no-touch .woocommerce .button.checkout:hover,.no-touch .woocommerce .button.add_to_cart_button:hover,.us-nav-style_1>span.current,.no-touch .us-nav-style_1>a:hover,.no-touch .navstyle_1>.owl-nav div:hover,.no-touch .us-btn-style_1:hover{box-shadow:0 0.5em 1em rgba(0,0,0,0.25);background:#F14D5D;border-color:transparent;color:#ffffff!important}.us-nav-style_1>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_16>*,.navstyle_16>.owl-nav div,.us-btn-style_16{font-family:var(--font-body);font-size:15px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.8em 1.8em;background:linear-gradient(200deg,#e63946,#ff6600);border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_16>*:before,.navstyle_16>.owl-nav div:before,.us-btn-style_16:before{border-width:0px}.us-nav-style_16>span.current,.no-touch .us-nav-style_16>a:hover,.no-touch .navstyle_16>.owl-nav div:hover,.no-touch .us-btn-style_16:hover{box-shadow:0 0.5em 1em rgba(0,0,0,0.25);background:#e63946;border-color:transparent;color:#ffffff!important}.us-nav-style_16>*{min-width:calc(1.20em + 2 * 0.8em)}.us-btn-style_16{overflow:hidden;-webkit-transform:translateZ(0)}.us-btn-style_16>*{position:relative;z-index:1}.no-touch .us-btn-style_16:hover{background:linear-gradient(200deg,#e63946,#ff6600)}.no-touch .us-btn-style_16:after{content:\"\";position:absolute;top:0;left:0;right:0;height:0;transition:height 0.3s;background:#e63946}.no-touch .us-btn-style_16:hover:after{height:100%}.us-nav-style_12>*,.navstyle_12>.owl-nav div,.us-btn-style_12{font-family:var(--font-body);font-size:15px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:1.3em;padding:1.5em 3em;background:#007bec;border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_12>*:before,.navstyle_12>.owl-nav div:before,.us-btn-style_12:before{border-width:0px}.us-nav-style_12>span.current,.no-touch .us-nav-style_12>a:hover,.no-touch .navstyle_12>.owl-nav div:hover,.no-touch .us-btn-style_12:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:#007bec;border-color:transparent;color:#ffffff!important}.us-nav-style_12>*{min-width:calc(1.20em + 2 * 1.5em)}.us-nav-style_13>*,.navstyle_13>.owl-nav div,.us-btn-style_13{font-family:var(--font-body);font-size:15px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:20px;padding:0.9em 1.5em;background:linear-gradient(200deg,#e63946,#ff6600);border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_13>*:before,.navstyle_13>.owl-nav div:before,.us-btn-style_13:before{border-width:0px}.us-nav-style_13>span.current,.no-touch .us-nav-style_13>a:hover,.no-touch .navstyle_13>.owl-nav div:hover,.no-touch .us-btn-style_13:hover{box-shadow:0 0.4em 0.8em rgba(0,0,0,0.20);background:#e63946;border-color:transparent;color:#ffffff!important}.us-nav-style_13>*{min-width:calc(1.20em + 2 * 0.9em)}.us-btn-style_13{overflow:hidden;-webkit-transform:translateZ(0)}.us-btn-style_13>*{position:relative;z-index:1}.no-touch .us-btn-style_13:hover{background:linear-gradient(200deg,#e63946,#ff6600)}.no-touch .us-btn-style_13:after{content:\"\";position:absolute;top:0;left:0;right:0;height:0;transition:height 0.3s;background:#e63946}.no-touch .us-btn-style_13:hover:after{height:100%}.us-nav-style_14>*,.navstyle_14>.owl-nav div,.us-btn-style_14{font-family:var(--font-body);font-size:14px;line-height:1!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:30px;padding:0.6em 0.6em;background:linear-gradient(200deg,#e63946,#ff6600);border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_14>*:before,.navstyle_14>.owl-nav div:before,.us-btn-style_14:before{border-width:0px}.us-nav-style_14>span.current,.no-touch .us-nav-style_14>a:hover,.no-touch .navstyle_14>.owl-nav div:hover,.no-touch .us-btn-style_14:hover{box-shadow:0 0.4em 0.8em rgba(0,0,0,0.20);background:#e63946;border-color:transparent;color:#ffffff!important}.us-nav-style_14>*{min-width:calc(1em + 2 * 0.6em)}.us-btn-style_14{overflow:hidden;-webkit-transform:translateZ(0)}.us-btn-style_14>*{position:relative;z-index:1}.no-touch .us-btn-style_14:hover{background:linear-gradient(200deg,#e63946,#ff6600)}.no-touch .us-btn-style_14:after{content:\"\";position:absolute;top:0;left:0;right:0;height:0;transition:height 0.3s;background:#e63946}.no-touch .us-btn-style_14:hover:after{height:100%}.us-nav-style_11>*,.navstyle_11>.owl-nav div,.us-btn-style_11{font-family:var(--font-body);font-size:15px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.6em 1.2em;background:#120f2d;border-color:transparent;color:#ffffff!important;box-shadow:0 0.25em 0.5em rgba(0,0,0,0.2)}.us-nav-style_11>*:before,.navstyle_11>.owl-nav div:before,.us-btn-style_11:before{border-width:0px}.us-nav-style_11>span.current,.no-touch .us-nav-style_11>a:hover,.no-touch .navstyle_11>.owl-nav div:hover,.no-touch .us-btn-style_11:hover{box-shadow:0 0.5em 1em rgba(18,15,45,0.15);background:#120f2d;border-color:transparent;color:#ffffff!important}.us-nav-style_11>*{min-width:calc(1.20em + 2 * 0.6em)}.us-nav-style_15>*,.navstyle_15>.owl-nav div,.us-btn-style_15{font-family:var(--font-body);font-size:12px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.6em 1.20em;background:#120f2d;border-color:transparent;color:#ffffff!important;box-shadow:0 0.25em 0.5em rgba(0,0,0,0.2)}.us-nav-style_15>*:before,.navstyle_15>.owl-nav div:before,.us-btn-style_15:before{border-width:0px}.us-nav-style_15>span.current,.no-touch .us-nav-style_15>a:hover,.no-touch .navstyle_15>.owl-nav div:hover,.no-touch .us-btn-style_15:hover{box-shadow:0 0.5em 1em rgba(18,15,45,0.15);background:#ffffff;border-color:transparent;color:#120f2d!important}.us-nav-style_15>*{min-width:calc(1.20em + 2 * 0.6em)}.us-nav-style_9>*,.navstyle_9>.owl-nav div,.us-btn-style_9{font-family:var(--font-body);font-size:15px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.6em 1.2em;background:rgba(37,117,252,0.15);border-color:transparent;color:#2575fc!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_9>*:before,.navstyle_9>.owl-nav div:before,.us-btn-style_9:before{border-width:0px}.us-nav-style_9>span.current,.no-touch .us-nav-style_9>a:hover,.no-touch .navstyle_9>.owl-nav div:hover,.no-touch .us-btn-style_9:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:rgba(241,77,93,0.15);border-color:transparent;color:#F14D5D!important}.us-nav-style_9>*{min-width:calc(1.20em + 2 * 0.6em)}.us-nav-style_3>*,.navstyle_3>.owl-nav div,.us-btn-style_3{font-family:var(--font-body);font-size:13px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.5em 1em;background:rgba(241,77,93,0.15);border-color:transparent;color:#F14D5D!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_3>*:before,.navstyle_3>.owl-nav div:before,.us-btn-style_3:before{border-width:0px}.us-nav-style_3>span.current,.no-touch .us-nav-style_3>a:hover,.no-touch .navstyle_3>.owl-nav div:hover,.no-touch .us-btn-style_3:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:#F14D5D;border-color:transparent;color:#ffffff!important}.us-nav-style_3>*{min-width:calc(1.20em + 2 * 0.5em)}.us-nav-style_8>*,.navstyle_8>.owl-nav div,.us-btn-style_8{font-family:var(--font-body);font-size:11px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3rem;padding:0.4em 0.5em;background:rgba(241,77,93,0.15);border-color:transparent;color:#F14D5D!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_8>*:before,.navstyle_8>.owl-nav div:before,.us-btn-style_8:before{border-width:0px}.us-nav-style_8>span.current,.no-touch .us-nav-style_8>a:hover,.no-touch .navstyle_8>.owl-nav div:hover,.no-touch .us-btn-style_8:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:#F14D5D;border-color:transparent;color:#ffffff!important}.us-nav-style_8>*{min-width:calc(1.20em + 2 * 0.4em)}.us-nav-style_4>*,.navstyle_4>.owl-nav div,.us-btn-style_4{font-family:var(--font-body);font-size:14px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:1.2em 2em;background:#F14D5D;border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_4>*:before,.navstyle_4>.owl-nav div:before,.us-btn-style_4:before{border-width:0px}.us-nav-style_4>span.current,.no-touch .us-nav-style_4>a:hover,.no-touch .navstyle_4>.owl-nav div:hover,.no-touch .us-btn-style_4:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:#2575fc;border-color:transparent;color:#ffffff!important}.us-nav-style_4>*{min-width:calc(1.20em + 2 * 1.2em)}.us-nav-style_7>*,.navstyle_7>.owl-nav div,.us-btn-style_7{font-family:var(--font-body);font-size:13px;line-height:1!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.5em 1em;background:#F14D5D;border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_7>*:before,.navstyle_7>.owl-nav div:before,.us-btn-style_7:before{border-width:0px}.us-nav-style_7>span.current,.no-touch .us-nav-style_7>a:hover,.no-touch .navstyle_7>.owl-nav div:hover,.no-touch .us-btn-style_7:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:#2575fc;border-color:transparent;color:#ffffff!important}.us-nav-style_7>*{min-width:calc(1em + 2 * 0.5em)}.us-nav-style_5>*,.navstyle_5>.owl-nav div,.us-btn-style_5{font-family:var(--font-body);font-size:14px;line-height:1.20!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:1.20em 2em;background:transparent;border-color:#2575fc;color:#2575fc!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_5>*:before,.navstyle_5>.owl-nav div:before,.us-btn-style_5:before{border-width:2px}.us-nav-style_5>span.current,.no-touch .us-nav-style_5>a:hover,.no-touch .navstyle_5>.owl-nav div:hover,.no-touch .us-btn-style_5:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:transparent;border-color:#F14D5D;color:#F14D5D!important}.us-nav-style_5>*{min-width:calc(1.20em + 2 * 1.20em)}.woocommerce .button,.woocommerce .actions .button,.us-nav-style_2>*,.navstyle_2>.owl-nav div,.us-btn-style_2{font-family:var(--font-body);font-size:13px;line-height:1!important;font-weight:100;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:5px;padding:0.5em 1em;background:#F14D5D;border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.woocommerce .button:before,.woocommerce .actions .button:before,.us-nav-style_2>*:before,.navstyle_2>.owl-nav div:before,.us-btn-style_2:before{border-width:0px}.no-touch .woocommerce .button:hover,.no-touch .woocommerce .actions .button:hover,.us-nav-style_2>span.current,.no-touch .us-nav-style_2>a:hover,.no-touch .navstyle_2>.owl-nav div:hover,.no-touch .us-btn-style_2:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:#2575fc;border-color:transparent;color:#ffffff!important}.us-nav-style_2>*{min-width:calc(1em + 2 * 0.5em)}.us-nav-style_6>*,.navstyle_6>.owl-nav div,.us-btn-style_6{font-family:var(--font-body);font-size:15px;line-height:0!important;font-weight:400;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:5px;padding:1em 0.5em;background:#ffffff;border-color:#F14D5D;color:#F14D5D!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_6>*:before,.navstyle_6>.owl-nav div:before,.us-btn-style_6:before{border-width:2px}.us-nav-style_6>span.current,.no-touch .us-nav-style_6>a:hover,.no-touch .navstyle_6>.owl-nav div:hover,.no-touch .us-btn-style_6:hover{box-shadow:0 0.25em 0.5em rgba(51,51,51,0.10);background:#ffffff;border-color:#2575fc;color:#2575fc!important}.us-nav-style_6>*{min-width:calc(0em + 2 * 1em)}.us-nav-style_10>*,.navstyle_10>.owl-nav div,.us-btn-style_10{font-family:var(--font-body);font-size:15px;line-height:0!important;font-weight:400;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0px;padding:0.5em 0.5em;background:transparent;border-color:transparent;color:#120F2D!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_10>*:before,.navstyle_10>.owl-nav div:before,.us-btn-style_10:before{border-width:0px}.us-nav-style_10>span.current,.no-touch .us-nav-style_10>a:hover,.no-touch .navstyle_10>.owl-nav div:hover,.no-touch .us-btn-style_10:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:transparent;border-color:transparent;color:#120F2D!important}.us-nav-style_10>*{min-width:calc(0em + 2 * 0.5em)}.w-filter.state_desktop.style_drop_default .w-filter-item-title,.select2-selection,select,textarea,input:not([type=\"submit\"]),.w-form-checkbox,.w-form-radio{font-weight:100;letter-spacing:0em;border-radius:5px;background:transparent;border-color:#e8e8e8;color:inherit}.w-filter.state_desktop.style_drop_default .w-filter-item-title:focus,.select2-container--open .select2-selection,select:focus,textarea:focus,input:not([type=\"submit\"]):focus,input:focus + .w-form-checkbox,input:focus + .w-form-radio{border-color:#e8e8e8!important;box-shadow:0px 0px 0px 1px #e95095 inset}.w-form-row.move_label .w-form-row-label{font-size:15px;top:calc(3em/2 + 1px - 0.7em);margin:0 1em;background:var(--color-content-bg-grad);color:inherit}.w-form-row.with_icon.move_label .w-form-row-label{margin-right:calc(1.6em + 1em)}.color_alternate .w-form-row.move_label .w-form-row-label{background:var(--color-alt-content-bg-grad)}.color_footer-top .w-form-row.move_label .w-form-row-label{background:var(--color-subfooter-bg-grad)}.color_footer-bottom .w-form-row.move_label .w-form-row-label{background:var(--color-footer-bg-grad)}.style_phone6-1>*{background-image:url(http://abzarwp.net/pre-learning/wp-content/themes/Zephyr/img/phone-6-black-real.png)}.style_phone6-2>*{background-image:url(http://abzarwp.net/pre-learning/wp-content/themes/Zephyr/img/phone-6-white-real.png)}.style_phone6-3>*{background-image:url(http://abzarwp.net/pre-learning/wp-content/themes/Zephyr/img/phone-6-black-flat.png)}.style_phone6-4>*{background-image:url(http://abzarwp.net/pre-learning/wp-content/themes/Zephyr/img/phone-6-white-flat.png)}.leaflet-default-icon-path{background-image:url(http://abzarwp.net/pre-learning/wp-content/themes/Zephyr/common/css/vendor/images/marker-icon.png)}.woocommerce-product-gallery--columns-4 li{width:25.000%}.woocommerce-product-gallery ol{margin:2px -2px 0}.woocommerce-product-gallery ol>li{padding:2px}", "yes");
INSERT INTO `esduc_options` VALUES("574", "acf_version", "5.11.4", "yes");
INSERT INTO `esduc_options` VALUES("390", "woocommerce_onboarding_profile", "a:1:{s:7:\"skipped\";b:1;}", "yes");
INSERT INTO `esduc_options` VALUES("401", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `esduc_options` VALUES("402", "wpb_js_google_fonts_subsets", "a:1:{i:0;s:5:\"latin\";}", "yes");
INSERT INTO `esduc_options` VALUES("403", "wpb_js_gutenberg_disable", "", "yes");
INSERT INTO `esduc_options` VALUES("404", "wpb_js_default_template_post_type", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("415", "woocommerce_navigation_enabled", "no", "yes");
INSERT INTO `esduc_options` VALUES("416", "woocommerce_settings_enabled", "no", "yes");
INSERT INTO `esduc_options` VALUES("417", "woocommerce_ces_tracks_queue", "a:1:{i:0;a:6:{s:6:\"action\";s:15:\"settings_change\";s:5:\"label\";s:63:\"به روزرسانی تنظیمات چقدر آسان بود؟\";s:14:\"onsubmit_label\";s:47:\"از بازخوردتان سپاسگزاریم!\";s:7:\"pagenow\";s:28:\"woocommerce_page_wc-settings\";s:9:\"adminpage\";s:28:\"woocommerce_page_wc-settings\";s:5:\"props\";O:8:\"stdClass\":2:{s:13:\"settings_area\";s:8:\"advanced\";s:16:\"settings_section\";s:15:\"woocommerce_com\";}}}", "yes");
INSERT INTO `esduc_options` VALUES("550", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `esduc_options` VALUES("27544", "ld_course_category_children", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("460", "learndash_data_settings", "a:15:{s:10:\"db_version\";s:3:\"2.5\";s:15:\"version_history\";a:6:{i:1644314788;s:7:\"3.6.0.2\";i:1643043011;s:7:\"3.6.0.3\";i:1641852552;s:5:\"3.6.0\";i:1641850477;s:7:\"3.6.0.2\";i:1638206312;s:5:\"3.6.0\";i:0;s:3:\"new\";}s:13:\"prior_version\";s:7:\"3.6.0.3\";s:15:\"current_version\";s:7:\"3.6.0.2\";s:10:\"is_upgrade\";b:0;s:23:\"rename-wpproquiz-tables\";a:2:{s:8:\"prefixes\";a:2:{s:7:\"current\";s:10:\"learndash_\";s:3:\"alt\";s:3:\"wp_\";}s:12:\"show_upgrade\";b:0;}s:17:\"user-meta-courses\";a:3:{s:8:\"last_run\";i:1638206376;s:7:\"user_id\";i:2;s:7:\"version\";s:3:\"2.5\";}s:17:\"user-meta-quizzes\";a:3:{s:8:\"last_run\";i:1638206376;s:7:\"user_id\";i:2;s:7:\"version\";s:3:\"2.5\";}s:27:\"course-access-lists-convert\";a:3:{s:8:\"last_run\";i:1638206376;s:7:\"user_id\";i:2;s:7:\"version\";s:3:\"2.5\";}s:18:\"pro-quiz-questions\";a:3:{s:8:\"last_run\";i:1641852553;s:7:\"user_id\";i:0;s:7:\"version\";s:3:\"2.5\";}s:16:\"course-post-meta\";a:4:{s:8:\"last_run\";i:1638206376;s:7:\"user_id\";i:2;s:7:\"version\";s:5:\"3.4.1\";s:14:\"process_status\";s:8:\"complete\";}s:15:\"group-post-meta\";a:4:{s:8:\"last_run\";i:1638206376;s:7:\"user_id\";i:2;s:7:\"version\";s:5:\"3.4.1\";s:14:\"process_status\";s:8:\"complete\";}s:14:\"quiz-post-meta\";a:4:{s:8:\"last_run\";i:1638206376;s:7:\"user_id\";i:2;s:7:\"version\";s:5:\"3.4.1\";s:14:\"process_status\";s:8:\"complete\";}s:22:\"translations_installed\";i:1644851894;s:15:\"gl_role_created\";i:1643043015;}", "yes");
INSERT INTO `esduc_options` VALUES("462", "wpProQuiz_dbVersion", "22", "yes");
INSERT INTO `esduc_options` VALUES("463", "wpProQuiz_version", "0.28", "yes");
INSERT INTO `esduc_options` VALUES("464", "learndash_groups_group_leader_user_activate", "", "yes");
INSERT INTO `esduc_options` VALUES("465", "widget_sfwd-certificates-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("466", "widget_ldcourseinfo", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("467", "widget_widget_ldcoursenavigation", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("468", "widget_ldcourseprogress", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("469", "widget_sfwd-courses-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("470", "widget_sfwd-lessons-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("471", "widget_sfwd-quiz-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("472", "widget_sfwd-transactions-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("473", "widget_lduserstatus", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `esduc_options` VALUES("474", "learndash_course_dirty", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("475", "learndash_settings_per_page", "a:5:{s:12:\"progress_num\";i:20;s:8:\"quiz_num\";i:20;s:8:\"per_page\";i:20;s:12:\"question_num\";i:20;s:15:\"profile_enabled\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("476", "learndash_settings_courses_taxonomies", "a:2:{s:18:\"ld_course_category\";s:3:\"yes\";s:13:\"ld_course_tag\";s:3:\"yes\";}", "yes");
INSERT INTO `esduc_options` VALUES("477", "learndash_settings_rest_api", "a:34:{s:7:\"enabled\";s:3:\"yes\";s:12:\"sfwd-courses\";s:12:\"sfwd-courses\";s:12:\"sfwd-lessons\";s:12:\"sfwd-lessons\";s:10:\"sfwd-topic\";s:10:\"sfwd-topic\";s:9:\"sfwd-quiz\";s:9:\"sfwd-quiz\";s:13:\"sfwd-question\";s:13:\"sfwd-question\";s:5:\"users\";s:5:\"users\";s:6:\"groups\";s:6:\"groups\";s:10:\"courses_v2\";s:12:\"sfwd-courses\";s:16:\"courses-users_v2\";s:5:\"users\";s:16:\"courses-steps_v2\";s:5:\"steps\";s:17:\"courses-groups_v2\";s:6:\"groups\";s:24:\"courses-prerequisites_v2\";s:13:\"prerequisites\";s:10:\"lessons_v2\";s:12:\"sfwd-lessons\";s:9:\"topics_v2\";s:10:\"sfwd-topic\";s:10:\"quizzes_v2\";s:9:\"sfwd-quiz\";s:12:\"questions_v2\";s:13:\"sfwd-question\";s:23:\"quizzes-form-entries_v2\";s:12:\"form-entries\";s:21:\"quizzes-statistics_v2\";s:10:\"statistics\";s:31:\"quizzes-statistics-questions_v2\";s:9:\"questions\";s:9:\"groups_v2\";s:6:\"groups\";s:17:\"groups-leaders_v2\";s:7:\"leaders\";s:17:\"groups-courses_v2\";s:7:\"courses\";s:15:\"groups-users_v2\";s:5:\"users\";s:14:\"assignments_v2\";s:15:\"sfwd-assignment\";s:9:\"essays_v2\";s:11:\"sfwd-essays\";s:8:\"users_v2\";s:5:\"users\";s:16:\"users-courses_v2\";s:7:\"courses\";s:15:\"users-groups_v2\";s:6:\"groups\";s:24:\"users-course-progress_v2\";s:15:\"course-progress\";s:22:\"users-quiz-progress_v2\";s:13:\"quiz-progress\";s:18:\"progress-status_v2\";s:15:\"progress-status\";s:14:\"price-types_v2\";s:11:\"price-types\";s:17:\"question-types_v2\";s:14:\"question-types\";}", "yes");
INSERT INTO `esduc_options` VALUES("478", "learndash_settings_lessons_taxonomies", "a:4:{s:18:\"ld_lesson_category\";s:3:\"yes\";s:13:\"ld_lesson_tag\";s:3:\"yes\";s:16:\"wp_post_category\";s:0:\"\";s:11:\"wp_post_tag\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("479", "learndash_settings_topics_taxonomies", "a:4:{s:17:\"ld_topic_category\";s:3:\"yes\";s:12:\"ld_topic_tag\";s:3:\"yes\";s:16:\"wp_post_category\";s:0:\"\";s:11:\"wp_post_tag\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("480", "learndash_settings_quizzes_taxonomies", "a:4:{s:16:\"ld_quiz_category\";s:0:\"\";s:11:\"ld_quiz_tag\";s:0:\"\";s:16:\"wp_post_category\";s:0:\"\";s:11:\"wp_post_tag\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("481", "learndash_settings_questions_taxonomies", "a:6:{s:25:\"proquiz_question_category\";s:3:\"yes\";s:20:\"ld_question_category\";s:2:\"no\";s:15:\"ld_question_tag\";s:2:\"no\";s:16:\"wp_post_category\";s:2:\"no\";s:11:\"wp_post_tag\";s:2:\"no\";s:17:\"question_category\";a:1:{s:0:\"\";s:46:\"یک دسته‌بندی انتخاب کنید\";}}", "yes");
INSERT INTO `esduc_options` VALUES("482", "learndash_settings_courses_management_display", "a:6:{s:22:\"course_builder_enabled\";s:3:\"yes\";s:23:\"course_builder_per_page\";i:20;s:25:\"course_pagination_lessons\";i:20;s:24:\"course_pagination_topics\";i:20;s:18:\"lesson_topic_order\";s:3:\"ASC\";s:20:\"lesson_topic_orderby\";s:4:\"date\";}", "yes");
INSERT INTO `esduc_options` VALUES("483", "learndash_settings_permalinks", "a:6:{s:7:\"courses\";s:7:\"courses\";s:7:\"lessons\";s:7:\"lessons\";s:6:\"topics\";s:5:\"topic\";s:7:\"quizzes\";s:7:\"quizzes\";s:6:\"groups\";s:6:\"groups\";s:11:\"nested_urls\";s:2:\"no\";}", "yes");
INSERT INTO `esduc_options` VALUES("484", "learndash_settings_courses_cpt", "a:4:{s:17:\"include_in_search\";s:3:\"yes\";s:11:\"has_archive\";s:3:\"yes\";s:8:\"supports\";a:2:{i:0;s:9:\"thumbnail\";i:1;s:9:\"revisions\";}s:8:\"has_feed\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("485", "learndash_settings_lessons_cpt", "a:6:{s:17:\"include_in_search\";s:3:\"yes\";s:17:\"search_login_only\";s:0:\"\";s:20:\"search_enrolled_only\";s:0:\"\";s:11:\"has_archive\";s:0:\"\";s:8:\"has_feed\";s:0:\"\";s:8:\"supports\";a:2:{i:0;s:9:\"thumbnail\";i:1;s:9:\"revisions\";}}", "yes");
INSERT INTO `esduc_options` VALUES("486", "learndash_settings_topics_cpt", "a:6:{s:17:\"include_in_search\";s:3:\"yes\";s:17:\"search_login_only\";s:0:\"\";s:20:\"search_enrolled_only\";s:0:\"\";s:11:\"has_archive\";s:0:\"\";s:8:\"has_feed\";s:0:\"\";s:8:\"supports\";a:2:{i:0;s:9:\"thumbnail\";i:1;s:9:\"revisions\";}}", "yes");
INSERT INTO `esduc_options` VALUES("487", "learndash_settings_quizzes_cpt", "a:6:{s:17:\"include_in_search\";s:0:\"\";s:17:\"search_login_only\";s:0:\"\";s:20:\"search_enrolled_only\";s:0:\"\";s:11:\"has_archive\";s:0:\"\";s:8:\"has_feed\";s:0:\"\";s:8:\"supports\";a:2:{i:0;s:9:\"thumbnail\";i:1;s:9:\"revisions\";}}", "yes");
INSERT INTO `esduc_options` VALUES("488", "learndash_settings_groups_taxonomies", "a:4:{s:17:\"ld_group_category\";s:3:\"yes\";s:12:\"ld_group_tag\";s:3:\"yes\";s:16:\"wp_post_category\";s:3:\"yes\";s:11:\"wp_post_tag\";s:3:\"yes\";}", "yes");
INSERT INTO `esduc_options` VALUES("489", "learndash_settings_groups_cpt", "a:5:{s:6:\"public\";s:3:\"yes\";s:17:\"include_in_search\";s:3:\"yes\";s:11:\"has_archive\";s:3:\"yes\";s:8:\"has_feed\";s:0:\"\";s:8:\"supports\";a:2:{i:0;s:9:\"thumbnail\";i:1;s:9:\"revisions\";}}", "yes");
INSERT INTO `esduc_options` VALUES("490", "learndash_settings_groups_management_display", "a:6:{s:26:\"group_hierarchical_enabled\";s:0:\"\";s:24:\"group_pagination_courses\";i:20;s:24:\"group_pagination_enabled\";s:0:\"\";s:19:\"group_courses_order\";s:3:\"ASC\";s:21:\"group_courses_orderby\";s:4:\"date\";s:27:\"group_courses_order_enabled\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("491", "ld-translations", "a:2:{s:10:\"last_check\";i:1644851892;s:16:\"translation_sets\";a:1:{s:9:\"learndash\";a:22:{s:9:\"Arabic-58\";a:10:{s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:9:\"wp_locale\";s:2:\"ar\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:2289;s:18:\"untranslated_count\";i:1627;s:18:\"percent_translated\";i:58;s:17:\"last_modified_gmt\";s:19:\"2020-09-11 12:40:43\";s:5:\"links\";a:2:{s:2:\"po\";s:118:\"https://translations.learndash.com/languages/projects/learndash/ar/ar/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:118:\"https://translations.learndash.com/languages/projects/learndash/ar/ar/export-translations/?ldlms-glotpress=1&format=mo\";}}s:18:\"Chinese (China)-49\";a:10:{s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:9:\"wp_locale\";s:5:\"zh_CN\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:1230;s:18:\"untranslated_count\";i:2686;s:18:\"percent_translated\";i:31;s:17:\"last_modified_gmt\";s:19:\"2018-11-19 14:35:30\";s:5:\"links\";a:2:{s:2:\"po\";s:124:\"https://translations.learndash.com/languages/projects/learndash/zh-cn/zh_cn/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:124:\"https://translations.learndash.com/languages/projects/learndash/zh-cn/zh_cn/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"Danish-16\";a:10:{s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:9:\"wp_locale\";s:5:\"da_DK\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:632;s:18:\"untranslated_count\";i:3284;s:18:\"percent_translated\";i:16;s:17:\"last_modified_gmt\";s:19:\"2021-06-07 20:32:14\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/da/da_dk/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/da/da_dk/export-translations/?ldlms-glotpress=1&format=mo\";}}s:8:\"Dutch-48\";a:10:{s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:9:\"wp_locale\";s:5:\"nl_NL\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:3183;s:18:\"untranslated_count\";i:733;s:18:\"percent_translated\";i:81;s:17:\"last_modified_gmt\";s:19:\"2021-02-23 12:44:34\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/nl/nl_nl/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/nl/nl_nl/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"English-43\";a:10:{s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:9:\"wp_locale\";s:5:\"en_US\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:0;s:18:\"untranslated_count\";i:3916;s:18:\"percent_translated\";i:0;s:17:\"last_modified_gmt\";N;s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/en/en_us/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/en/en_us/export-translations/?ldlms-glotpress=1&format=mo\";}}s:18:\"French (Canada)-14\";a:10:{s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:9:\"wp_locale\";s:5:\"fr_CA\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:826;s:18:\"untranslated_count\";i:3090;s:18:\"percent_translated\";i:21;s:17:\"last_modified_gmt\";s:19:\"2018-01-16 01:14:14\";s:5:\"links\";a:2:{s:2:\"po\";s:124:\"https://translations.learndash.com/languages/projects/learndash/fr-ca/fr_ca/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:124:\"https://translations.learndash.com/languages/projects/learndash/fr-ca/fr_ca/export-translations/?ldlms-glotpress=1&format=mo\";}}s:17:\"French (France)-1\";a:10:{s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:9:\"wp_locale\";s:5:\"fr_FR\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:2374;s:18:\"untranslated_count\";i:1542;s:18:\"percent_translated\";i:60;s:17:\"last_modified_gmt\";s:19:\"2021-02-19 15:32:22\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/fr/fr_fr/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/fr/fr_fr/export-translations/?ldlms-glotpress=1&format=mo\";}}s:8:\"German-5\";a:10:{s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:9:\"wp_locale\";s:5:\"de_DE\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:559;s:18:\"untranslated_count\";i:3357;s:18:\"percent_translated\";i:14;s:17:\"last_modified_gmt\";s:19:\"2019-07-09 19:21:03\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/de/de_de/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/de/de_de/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"German-66\";a:10:{s:2:\"id\";s:2:\"66\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:9:\"wp_locale\";s:12:\"de_DE_formal\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:3673;s:18:\"untranslated_count\";i:243;s:18:\"percent_translated\";i:93;s:17:\"last_modified_gmt\";s:19:\"2021-06-07 20:25:28\";s:5:\"links\";a:2:{s:2:\"po\";s:128:\"https://translations.learndash.com/languages/projects/learndash/de/de_de_formal/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:128:\"https://translations.learndash.com/languages/projects/learndash/de/de_de_formal/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"Hebrew-18\";a:10:{s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:9:\"wp_locale\";s:5:\"he_IL\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:3591;s:18:\"untranslated_count\";i:325;s:18:\"percent_translated\";i:91;s:17:\"last_modified_gmt\";s:19:\"2021-05-03 13:23:36\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/he/he_il/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/he/he_il/export-translations/?ldlms-glotpress=1&format=mo\";}}s:12:\"Hungarian-64\";a:10:{s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:9:\"wp_locale\";s:5:\"hu_HU\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:3803;s:18:\"untranslated_count\";i:113;s:18:\"percent_translated\";i:97;s:17:\"last_modified_gmt\";s:19:\"2021-11-24 12:39:25\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/hu/hu_hu/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/hu/hu_hu/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"Italian-7\";a:10:{s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:9:\"wp_locale\";s:5:\"it_IT\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:1408;s:18:\"untranslated_count\";i:2508;s:18:\"percent_translated\";i:35;s:17:\"last_modified_gmt\";s:19:\"2019-07-08 21:05:01\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/it/it_it/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/it/it_it/export-translations/?ldlms-glotpress=1&format=mo\";}}s:11:\"Japanese-68\";a:10:{s:2:\"id\";s:2:\"68\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:9:\"wp_locale\";s:2:\"ja\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:2187;s:18:\"untranslated_count\";i:1729;s:18:\"percent_translated\";i:55;s:17:\"last_modified_gmt\";s:19:\"2021-10-21 11:22:21\";s:5:\"links\";a:2:{s:2:\"po\";s:118:\"https://translations.learndash.com/languages/projects/learndash/ja/ja/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:118:\"https://translations.learndash.com/languages/projects/learndash/ja/ja/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"Polish-12\";a:10:{s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:9:\"wp_locale\";s:5:\"pl_PL\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:493;s:18:\"untranslated_count\";i:3423;s:18:\"percent_translated\";i:12;s:17:\"last_modified_gmt\";s:19:\"2019-07-09 19:22:17\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/pl/pl_pl/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/pl/pl_pl/export-translations/?ldlms-glotpress=1&format=mo\";}}s:22:\"Portuguese (Brazil)-20\";a:10:{s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:9:\"wp_locale\";s:5:\"pt_BR\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:305;s:18:\"untranslated_count\";i:3611;s:18:\"percent_translated\";i:7;s:17:\"last_modified_gmt\";s:19:\"2020-10-19 11:58:35\";s:5:\"links\";a:2:{s:2:\"po\";s:124:\"https://translations.learndash.com/languages/projects/learndash/pt-br/pt_br/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:124:\"https://translations.learndash.com/languages/projects/learndash/pt-br/pt_br/export-translations/?ldlms-glotpress=1&format=mo\";}}s:24:\"Portuguese (Portugal)-80\";a:10:{s:2:\"id\";s:2:\"80\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:9:\"wp_locale\";s:5:\"pt_PT\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:106;s:18:\"untranslated_count\";i:3810;s:18:\"percent_translated\";i:2;s:17:\"last_modified_gmt\";s:19:\"2020-05-19 18:27:58\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/pt/pt_pr/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/pt/pt_pr/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"Russian-22\";a:10:{s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:9:\"wp_locale\";s:5:\"ru_RU\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:1399;s:18:\"untranslated_count\";i:2517;s:18:\"percent_translated\";i:35;s:17:\"last_modified_gmt\";s:19:\"2020-04-16 21:05:24\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/ru/ru_ru/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/ru/ru_ru/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"Serbian-72\";a:10:{s:2:\"id\";s:2:\"72\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:9:\"wp_locale\";s:5:\"sr_RS\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:2348;s:18:\"untranslated_count\";i:1568;s:18:\"percent_translated\";i:59;s:17:\"last_modified_gmt\";s:19:\"2020-04-07 19:52:56\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sr/sr_me/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sr/sr_me/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"Serbian-74\";a:10:{s:2:\"id\";s:2:\"74\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:9:\"wp_locale\";s:5:\"sr_RS\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:2348;s:18:\"untranslated_count\";i:1568;s:18:\"percent_translated\";i:59;s:17:\"last_modified_gmt\";s:19:\"2020-04-21 17:38:40\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sr/me_me/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sr/me_me/export-translations/?ldlms-glotpress=1&format=mo\";}}s:17:\"Spanish (Spain)-3\";a:10:{s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:9:\"wp_locale\";s:5:\"es_ES\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:2466;s:18:\"untranslated_count\";i:1450;s:18:\"percent_translated\";i:62;s:17:\"last_modified_gmt\";s:19:\"2021-06-16 16:20:04\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/es/es_es/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/es/es_es/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"Swedish-24\";a:10:{s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:9:\"wp_locale\";s:5:\"sv_SE\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:2300;s:18:\"untranslated_count\";i:1616;s:18:\"percent_translated\";i:58;s:17:\"last_modified_gmt\";s:19:\"2019-12-12 15:38:04\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sv/sv_se/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sv/sv_se/export-translations/?ldlms-glotpress=1&format=mo\";}}s:11:\"Turkish-282\";a:10:{s:2:\"id\";s:3:\"282\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:9:\"wp_locale\";s:5:\"tr_TR\";s:9:\"all_count\";i:3916;s:13:\"current_count\";i:3372;s:18:\"untranslated_count\";i:544;s:18:\"percent_translated\";i:86;s:17:\"last_modified_gmt\";s:19:\"2021-03-18 11:42:36\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/tr/tr_tr/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/tr/tr_tr/export-translations/?ldlms-glotpress=1&format=mo\";}}}}}", "yes");
INSERT INTO `esduc_options` VALUES("492", "learndash_settings_assignments_cpt", "a:3:{s:19:\"exclude_from_search\";s:3:\"yes\";s:18:\"publicly_queryable\";s:3:\"yes\";s:14:\"comment_status\";s:3:\"yes\";}", "yes");
INSERT INTO `esduc_options` VALUES("493", "learndash_settings_quizzes_management_display", "a:9:{s:20:\"quiz_builder_enabled\";s:3:\"yes\";s:21:\"quiz_builder_per_page\";i:20;s:29:\"quiz_builder_shared_questions\";s:0:\"\";s:18:\"force_quiz_builder\";s:0:\"\";s:22:\"force_shared_questions\";s:0:\"\";s:19:\"toplist_time_format\";s:0:\"\";s:22:\"statistics_time_format\";s:0:\"\";s:25:\"quiz_builder_time_formats\";s:0:\"\";s:14:\"quiz_templates\";a:1:{s:0:\"\";s:17:\"Select a template\";}}", "yes");
INSERT INTO `esduc_options` VALUES("494", "learndash_settings_quizzes_email", "a:6:{s:20:\"admin_mail_from_name\";s:0:\"\";s:21:\"admin_mail_from_email\";s:0:\"\";s:13:\"admin_mail_to\";s:0:\"\";s:18:\"admin_mail_subject\";s:0:\"\";s:18:\"admin_mail_message\";s:0:\"\";s:15:\"admin_mail_html\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("495", "learndash_settings_questions_management_display", "a:1:{s:18:\"question_templates\";a:1:{s:0:\"\";s:17:\"Select a template\";}}", "yes");
INSERT INTO `esduc_options` VALUES("496", "learndash_settings_certificates_cpt", "a:1:{s:8:\"supports\";a:2:{i:0;s:9:\"thumbnail\";i:1;s:9:\"revisions\";}}", "yes");
INSERT INTO `esduc_options` VALUES("497", "learndash_settings_certificates_styles", "a:1:{s:6:\"styles\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("498", "learndash_groups_group_leader_user", "a:9:{s:20:\"bypass_course_limits\";s:0:\"\";s:25:\"groups_autoenroll_managed\";s:0:\"\";s:18:\"courses_autoenroll\";s:0:\"\";s:21:\"manage_groups_enabled\";s:0:\"\";s:26:\"manage_groups_capabilities\";s:5:\"basic\";s:22:\"manage_courses_enabled\";s:0:\"\";s:27:\"manage_courses_capabilities\";s:5:\"basic\";s:20:\"manage_users_enabled\";s:0:\"\";s:25:\"manage_users_capabilities\";s:5:\"basic\";}", "yes");
INSERT INTO `esduc_options` VALUES("499", "learndash_settings_groups_membership", "a:4:{s:25:\"groups_membership_enabled\";s:0:\"\";s:25:\"groups_membership_message\";s:90:\"این صفحه محافظت شده است و دسترسی به گروه ضروری است\";s:28:\"groups_membership_post_types\";a:0:{}s:28:\"groups_membership_user_roles\";a:0:{}}", "yes");
INSERT INTO `esduc_options` VALUES("500", "learndash_settings_courses_themes", "a:1:{s:12:\"active_theme\";s:4:\"ld30\";}", "yes");
INSERT INTO `esduc_options` VALUES("501", "learndash_settings_admin_user", "a:2:{s:30:\"courses_autoenroll_admin_users\";s:3:\"yes\";s:32:\"bypass_course_limits_admin_users\";s:3:\"yes\";}", "yes");
INSERT INTO `esduc_options` VALUES("502", "learndash_settings_registration_fields", "a:16:{s:12:\"fields_order\";a:5:{i:0;s:8:\"username\";i:1;s:5:\"email\";i:2;s:10:\"first_name\";i:3;s:9:\"last_name\";i:4;s:8:\"password\";}s:16:\"username_enabled\";s:3:\"yes\";s:17:\"username_required\";s:3:\"yes\";s:14:\"username_label\";s:21:\"نام‌کاربری\";s:13:\"email_enabled\";s:3:\"yes\";s:14:\"email_required\";s:3:\"yes\";s:11:\"email_label\";s:10:\"ایمیل\";s:18:\"first_name_enabled\";s:3:\"yes\";s:19:\"first_name_required\";s:3:\"yes\";s:16:\"first_name_label\";s:6:\"نام\";s:17:\"last_name_enabled\";s:3:\"yes\";s:18:\"last_name_required\";s:3:\"yes\";s:15:\"last_name_label\";s:23:\"نام خانوداگی\";s:16:\"password_enabled\";s:3:\"yes\";s:17:\"password_required\";s:3:\"yes\";s:14:\"password_label\";s:15:\"رمز عبور\";}", "yes");
INSERT INTO `esduc_options` VALUES("503", "learndash_settings_registration_pages", "a:2:{s:12:\"registration\";s:4:\"1277\";s:20:\"registration_success\";s:3:\"398\";}", "yes");
INSERT INTO `esduc_options` VALUES("504", "learndash_settings_emails_sender", "a:2:{s:9:\"from_name\";s:0:\"\";s:10:\"from_email\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("505", "learndash_settings_emails_new_user_registration", "a:5:{s:7:\"enabled\";s:3:\"yes\";s:10:\"recipients\";s:10:\"مشتری\";s:7:\"subject\";s:0:\"\";s:7:\"message\";s:0:\"\";s:12:\"content_type\";s:9:\"text/html\";}", "yes");
INSERT INTO `esduc_options` VALUES("506", "learndash_settings_emails_course_purchase_success", "a:5:{s:7:\"enabled\";s:3:\"yes\";s:10:\"recipients\";s:10:\"مشتری\";s:7:\"subject\";s:0:\"\";s:7:\"message\";s:0:\"\";s:12:\"content_type\";s:4:\"html\";}", "yes");
INSERT INTO `esduc_options` VALUES("507", "learndash_settings_emails_group_purchase_success", "a:5:{s:7:\"enabled\";s:3:\"yes\";s:10:\"recipients\";s:10:\"مشتری\";s:7:\"subject\";s:0:\"\";s:7:\"message\";s:0:\"\";s:12:\"content_type\";s:4:\"html\";}", "yes");
INSERT INTO `esduc_options` VALUES("508", "learndash_settings_paypal", "a:7:{s:12:\"paypal_email\";s:18:\"test@demoabzar.com\";s:15:\"paypal_currency\";s:10:\"تومان\";s:14:\"paypal_country\";s:2:\"IR\";s:16:\"paypal_cancelurl\";s:0:\"\";s:16:\"paypal_returnurl\";s:0:\"\";s:16:\"paypal_notifyurl\";s:47:\"http://abzarwp.net/pre-learning/sfwd-lms/paypal\";s:7:\"enabled\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("509", "learndash_settings_custom_labels", "a:1:{s:12:\"group_leader\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("510", "learndash_settings_permalinks_taxonomies", "a:8:{s:18:\"ld_course_category\";s:15:\"course-category\";s:13:\"ld_course_tag\";s:10:\"course-tag\";s:18:\"ld_lesson_category\";s:15:\"lesson-category\";s:13:\"ld_lesson_tag\";s:10:\"lesson-tag\";s:17:\"ld_topic_category\";s:14:\"topic-category\";s:12:\"ld_topic_tag\";s:9:\"topic-tag\";s:17:\"ld_group_category\";s:14:\"group-category\";s:12:\"ld_group_tag\";s:9:\"group-tag\";}", "yes");
INSERT INTO `esduc_options` VALUES("511", "learndash_settings_theme_ld30", "a:5:{s:13:\"color_primary\";s:0:\"\";s:15:\"color_secondary\";s:0:\"\";s:14:\"color_tertiary\";s:0:\"\";s:24:\"focus_mode_content_width\";s:7:\"default\";s:10:\"login_logo\";s:0:\"\";}", "yes");
INSERT INTO `esduc_options` VALUES("512", "learndash-repositories", "a:5:{s:10:\"last_check\";i:1647163298;s:12:\"repositories\";a:22:{s:16:\"learndash-stripe\";O:8:\"stdClass\":3:{s:4:\"slug\";s:16:\"learndash-stripe\";s:7:\"version\";s:5:\"1.9.2\";s:10:\"updated_on\";s:19:\"2022-01-17 00:00:00\";}s:21:\"learndash-core-readme\";O:8:\"stdClass\":3:{s:4:\"slug\";s:21:\"learndash-core-readme\";s:7:\"version\";s:7:\"3.6.0.3\";s:10:\"updated_on\";s:19:\"2022-01-12 00:00:00\";}s:21:\"learndash-course-grid\";O:8:\"stdClass\":3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:7:\"version\";s:5:\"2.0.4\";s:10:\"updated_on\";s:19:\"2022-01-05 00:00:00\";}s:16:\"learndash-zapier\";O:8:\"stdClass\":3:{s:4:\"slug\";s:16:\"learndash-zapier\";s:7:\"version\";s:5:\"2.3.0\";s:10:\"updated_on\";s:19:\"2021-12-15 00:00:00\";}s:17:\"learndash-bbpress\";O:8:\"stdClass\":3:{s:4:\"slug\";s:17:\"learndash-bbpress\";s:7:\"version\";s:5:\"2.2.2\";s:10:\"updated_on\";s:19:\"2021-11-25 00:00:00\";}s:19:\"learndash-integrity\";O:8:\"stdClass\":3:{s:4:\"slug\";s:19:\"learndash-integrity\";s:7:\"version\";s:5:\"1.0.0\";s:10:\"updated_on\";s:19:\"2021-11-17 00:00:00\";}s:23:\"learndash-gravity-forms\";O:8:\"stdClass\":3:{s:4:\"slug\";s:23:\"learndash-gravity-forms\";s:7:\"version\";s:5:\"2.1.2\";s:10:\"updated_on\";s:19:\"2021-10-20 00:00:00\";}s:22:\"learndash-achievements\";O:8:\"stdClass\":3:{s:4:\"slug\";s:22:\"learndash-achievements\";s:7:\"version\";s:5:\"1.1.0\";s:10:\"updated_on\";s:19:\"2021-09-30 00:00:00\";}s:21:\"learndash-memberpress\";O:8:\"stdClass\":3:{s:4:\"slug\";s:21:\"learndash-memberpress\";s:7:\"version\";s:7:\"2.2.1.2\";s:10:\"updated_on\";s:19:\"2021-09-22 00:00:00\";}s:21:\"learndash-woocommerce\";O:8:\"stdClass\":3:{s:4:\"slug\";s:21:\"learndash-woocommerce\";s:7:\"version\";s:7:\"1.9.3.3\";s:10:\"updated_on\";s:19:\"2021-09-15 00:00:00\";}s:17:\"learndash-samcart\";O:8:\"stdClass\":3:{s:4:\"slug\";s:17:\"learndash-samcart\";s:7:\"version\";s:5:\"1.1.0\";s:10:\"updated_on\";s:19:\"2021-09-15 00:00:00\";}s:13:\"learndash-edd\";O:8:\"stdClass\":3:{s:4:\"slug\";s:13:\"learndash-edd\";s:7:\"version\";s:5:\"1.3.0\";s:10:\"updated_on\";s:19:\"2021-08-25 00:00:00\";}s:23:\"learndash-notifications\";O:8:\"stdClass\":3:{s:4:\"slug\";s:23:\"learndash-notifications\";s:7:\"version\";s:5:\"1.5.3\";s:10:\"updated_on\";s:19:\"2021-08-18 00:00:00\";}s:29:\"learndash-certificate-builder\";O:8:\"stdClass\":3:{s:4:\"slug\";s:29:\"learndash-certificate-builder\";s:7:\"version\";s:5:\"1.0.3\";s:10:\"updated_on\";s:19:\"2021-07-12 00:00:00\";}s:19:\"learndash-2checkout\";O:8:\"stdClass\":3:{s:4:\"slug\";s:19:\"learndash-2checkout\";s:7:\"version\";s:7:\"1.1.1.1\";s:10:\"updated_on\";s:19:\"2021-06-08 00:00:00\";}s:25:\"learndash-propanel-readme\";O:8:\"stdClass\":3:{s:4:\"slug\";s:25:\"learndash-propanel-readme\";s:7:\"version\";s:7:\"2.1.4.1\";s:10:\"updated_on\";s:19:\"2021-05-12 00:00:00\";}s:25:\"learndash-paidmemberships\";O:8:\"stdClass\":3:{s:4:\"slug\";s:25:\"learndash-paidmemberships\";s:7:\"version\";s:5:\"1.3.1\";s:10:\"updated_on\";s:19:\"2021-04-01 00:00:00\";}s:19:\"learndash-elementor\";O:8:\"stdClass\":3:{s:4:\"slug\";s:19:\"learndash-elementor\";s:7:\"version\";s:5:\"1.0.3\";s:10:\"updated_on\";s:19:\"2021-01-06 00:00:00\";}s:20:\"learndash-thrivecart\";O:8:\"stdClass\":3:{s:4:\"slug\";s:20:\"learndash-thrivecart\";s:7:\"version\";s:5:\"1.0.0\";s:10:\"updated_on\";s:19:\"2020-11-11 00:00:00\";}s:15:\"ld-multilingual\";O:8:\"stdClass\":3:{s:4:\"slug\";s:15:\"ld-multilingual\";s:7:\"version\";s:3:\"1.0\";s:10:\"updated_on\";s:19:\"2020-04-14 00:00:00\";}s:30:\"learndash-restrict-content-pro\";O:8:\"stdClass\":3:{s:4:\"slug\";s:30:\"learndash-restrict-content-pro\";s:7:\"version\";s:5:\"1.1.0\";s:10:\"updated_on\";s:19:\"2019-07-11 00:00:00\";}s:24:\"learndash-event-espresso\";O:8:\"stdClass\":3:{s:4:\"slug\";s:24:\"learndash-event-espresso\";s:7:\"version\";s:5:\"1.1.0\";s:10:\"updated_on\";s:19:\"2019-04-24 00:00:00\";}}s:7:\"plugins\";a:22:{s:16:\"learndash-stripe\";a:29:{s:4:\"name\";s:20:\"Stripe for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:36:\"https://learndash.com/add-on/stripe/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:16:\"learndash-stripe\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:15:\"payment gateway\";i:2;s:6:\"stripe\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:5:\"5.8.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.9.2\";s:17:\"short_description\";s:36:\"Integrate LearnDash LMS with Stripe.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:538:\"Integrate LearnDash LMS with Stripe.\r\n\r\nLearnDash comes with the ability to accept payment for courses by leveraging PayPal. Using this add-on, you can quickly and easily accept payments using the Stripe payment gateway. Use it with PayPal, or just use Stripe - the choice is yours!\r\n\r\n= Integration Features = \r\n\r\n* Accept payments using Stripe\r\n* Automatic user creation and enrollment\r\n* Compatible with built-in PayPal option\r\n* Lightbox overlay\r\n\r\nSee the [Add-on](https://learndash.com/add-on/stripe/) page for more information.\r\n\r\n\";s:7:\"content\";s:595:\"<p>Integrate LearnDash LMS with Stripe.</p>\n<p>LearnDash comes with the ability to accept payment for courses by leveraging PayPal. Using this add-on, you can quickly and easily accept payments using the Stripe payment gateway. Use it with PayPal, or just use Stripe - the choice is yours!</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Accept payments using Stripe</li>\n<li>Automatic user creation and enrollment</li>\n<li>Compatible with built-in PayPal option</li>\n<li>Lightbox overlay</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/stripe/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:2446:\"= 1.9.2 =\r\n\r\n* Fixed PHP notice in legacy checkout\r\n* Fixed empty amount in transaction record for recurring payments\r\n* Fixed incorrect label on translations page\r\n* Fixed Stripe payment button not honoring the \"active\" status for the gateway to be active or inactive\r\n* Fixed LearnDash purchase emails not sending \r\n* Fixed checkout not working for amounts under 10 in any currency\r\n\r\n= 1.9.1 =\r\n\r\n* Fixed error when the Stripe API key was not filled in\r\n\r\n= 1.9.0 =\r\n\r\n* Added LD 3.6 subscription trial and recurring payment limit support\r\n* Updated Stripe PHP SDK package\r\n* Updated don\'t remove course access on subscription with recurring limit and add filter hook to change its behavior\r\n* Fixed PHP warning error when saving settings\r\n* Fixed double account creation and timeout error\r\n\r\n= 1.8.2 =\r\n\r\n* Fixed typo in stripe customer id meta key name for live mode\r\n* Fixed uncaught exception and undefined methods\r\n\r\n= 1.8.1 =\r\n\r\n* Added different stripe customer user meta key for test and live mode, this enables users to buy courses in both test and live mode\r\n* Updated logged in users will always be enrolled to bought course regardless email used in Stripe checkout\r\n* Fixed course purchase button can\'t be re-clicked more than once if there\'s error in the first try\r\n\r\n= 1.8.0.2 = \r\n\r\n* Fixed load specific js-cookie version for Stripe SCA compatibility\r\n\r\n* Load specific js-cookie version\r\n\r\n= 1.8.0.1 = \r\n\r\n* Updated security review changes\r\n\r\n= 1.8.0 =\r\n\r\n* Updated the Stripe PHP SDK                                                                 \r\n* Fixed syntax error                                                                                   \r\n* Fixed 404 /customers/ Stripe error in legacy checkout                                          \r\n* Fixed undefined property error                                                                 \r\n* Fixed 404 error response when retrieving Stipe customer object\r\n\r\n= 1.7.0 =\r\n\r\n* Added dependencies check\r\n* Added allow_promotion_codes arg in Stripe session creation API\r\n* Updated add \'customer\' arg in Stripe session API so that Stripe only create 1 customer object for each WP user\r\n* Fixed token used more than once error on legacy checkout\r\n* Fixed fatal error due to uncaught Stripe API Exception\r\n* Fixed Stripe JS is loaded multiple times if there\'s multiple payment button on a page\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/stripe/).\r\n\";s:7:\"content\";s:2748:\"<h4>1.9.2</h4>\n<ul>\n<li>Fixed PHP notice in legacy checkout</li>\n<li>Fixed empty amount in transaction record for recurring payments</li>\n<li>Fixed incorrect label on translations page</li>\n<li>Fixed Stripe payment button not honoring the &quot;active&quot; status for the gateway to be active or inactive</li>\n<li>Fixed LearnDash purchase emails not sending </li>\n<li>\n<p>Fixed checkout not working for amounts under 10 in any currency</p>\n<h4>1.9.1</h4>\n</li>\n<li>\n<p>Fixed error when the Stripe API key was not filled in</p>\n<h4>1.9.0</h4>\n</li>\n<li>Added LD 3.6 subscription trial and recurring payment limit support</li>\n<li>Updated Stripe PHP SDK package</li>\n<li>Updated don\'t remove course access on subscription with recurring limit and add filter hook to change its behavior</li>\n<li>Fixed PHP warning error when saving settings</li>\n<li>\n<p>Fixed double account creation and timeout error</p>\n<h4>1.8.2</h4>\n</li>\n<li>Fixed typo in stripe customer id meta key name for live mode</li>\n<li>\n<p>Fixed uncaught exception and undefined methods</p>\n<h4>1.8.1</h4>\n</li>\n<li>Added different stripe customer user meta key for test and live mode, this enables users to buy courses in both test and live mode</li>\n<li>Updated logged in users will always be enrolled to bought course regardless email used in Stripe checkout</li>\n<li>\n<p>Fixed course purchase button can\'t be re-clicked more than once if there\'s error in the first try</p>\n<h4>1.8.0.2</h4> \n</li>\n<li>\n<p>Fixed load specific js-cookie version for Stripe SCA compatibility</p>\n</li>\n<li>\n<p>Load specific js-cookie version</p>\n<h4>1.8.0.1</h4> \n</li>\n<li>\n<p>Updated security review changes</p>\n<h4>1.8.0</h4>\n</li>\n<li>Updated the Stripe PHP SDK                                                                 </li>\n<li>Fixed syntax error                                                                                   </li>\n<li>Fixed 404 /customers/ Stripe error in legacy checkout                                          </li>\n<li>Fixed undefined property error                                                                 </li>\n<li>\n<p>Fixed 404 error response when retrieving Stipe customer object</p>\n<h4>1.7.0</h4>\n</li>\n<li>Added dependencies check</li>\n<li>Added allow_promotion_codes arg in Stripe session creation API</li>\n<li>Updated add \'customer\' arg in Stripe session API so that Stripe only create 1 customer object for each WP user</li>\n<li>Fixed token used more than once error on legacy checkout</li>\n<li>Fixed fatal error due to uncaught Stripe API Exception</li>\n<li>Fixed Stripe JS is loaded multiple times if there\'s multiple payment button on a page</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/stripe/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:595:\"<p>Integrate LearnDash LMS with Stripe.</p>\n<p>LearnDash comes with the ability to accept payment for courses by leveraging PayPal. Using this add-on, you can quickly and easily accept payments using the Stripe payment gateway. Use it with PayPal, or just use Stripe - the choice is yours!</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Accept payments using Stripe</li>\n<li>Automatic user creation and enrollment</li>\n<li>Compatible with built-in PayPal option</li>\n<li>Lightbox overlay</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/stripe/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:2748:\"<h4>1.9.2</h4>\n<ul>\n<li>Fixed PHP notice in legacy checkout</li>\n<li>Fixed empty amount in transaction record for recurring payments</li>\n<li>Fixed incorrect label on translations page</li>\n<li>Fixed Stripe payment button not honoring the &quot;active&quot; status for the gateway to be active or inactive</li>\n<li>Fixed LearnDash purchase emails not sending </li>\n<li>\n<p>Fixed checkout not working for amounts under 10 in any currency</p>\n<h4>1.9.1</h4>\n</li>\n<li>\n<p>Fixed error when the Stripe API key was not filled in</p>\n<h4>1.9.0</h4>\n</li>\n<li>Added LD 3.6 subscription trial and recurring payment limit support</li>\n<li>Updated Stripe PHP SDK package</li>\n<li>Updated don\'t remove course access on subscription with recurring limit and add filter hook to change its behavior</li>\n<li>Fixed PHP warning error when saving settings</li>\n<li>\n<p>Fixed double account creation and timeout error</p>\n<h4>1.8.2</h4>\n</li>\n<li>Fixed typo in stripe customer id meta key name for live mode</li>\n<li>\n<p>Fixed uncaught exception and undefined methods</p>\n<h4>1.8.1</h4>\n</li>\n<li>Added different stripe customer user meta key for test and live mode, this enables users to buy courses in both test and live mode</li>\n<li>Updated logged in users will always be enrolled to bought course regardless email used in Stripe checkout</li>\n<li>\n<p>Fixed course purchase button can\'t be re-clicked more than once if there\'s error in the first try</p>\n<h4>1.8.0.2</h4> \n</li>\n<li>\n<p>Fixed load specific js-cookie version for Stripe SCA compatibility</p>\n</li>\n<li>\n<p>Load specific js-cookie version</p>\n<h4>1.8.0.1</h4> \n</li>\n<li>\n<p>Updated security review changes</p>\n<h4>1.8.0</h4>\n</li>\n<li>Updated the Stripe PHP SDK                                                                 </li>\n<li>Fixed syntax error                                                                                   </li>\n<li>Fixed 404 /customers/ Stripe error in legacy checkout                                          </li>\n<li>Fixed undefined property error                                                                 </li>\n<li>\n<p>Fixed 404 error response when retrieving Stipe customer object</p>\n<h4>1.7.0</h4>\n</li>\n<li>Added dependencies check</li>\n<li>Added allow_promotion_codes arg in Stripe session creation API</li>\n<li>Updated add \'customer\' arg in Stripe session API so that Stripe only create 1 customer object for each WP user</li>\n<li>Fixed token used more than once error on legacy checkout</li>\n<li>Fixed fatal error due to uncaught Stripe API Exception</li>\n<li>Fixed Stripe JS is loaded multiple times if there\'s multiple payment button on a page</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/stripe/\">here</a>.</p>\";}s:10:\"last_check\";i:1642435694;s:8:\"external\";b:1;s:7:\"bb_slug\";s:16:\"learndash-stripe\";s:8:\"homepage\";s:36:\"https://learndash.com/add-on/stripe/\";s:12:\"last_updated\";s:19:\"2022-01-17 00:00:00\";s:7:\"version\";s:5:\"1.9.2\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.8.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_256x256.jpg\";s:2:\"2x\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_256x256.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:104:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_banner.jpg\";s:4:\"high\";s:104:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_banner.jpg\";s:7:\"default\";s:104:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.9.2\";s:4:\"file\";b:0;s:3:\"url\";s:239:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-stripe&amp;_wpnonce=068557824a&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:21:\"learndash-core-readme\";a:31:{s:4:\"name\";s:13:\"LearnDash LMS\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:21:\"https://learndash.com\";s:4:\"slug\";s:14:\"learndash-core\";s:4:\"tags\";a:0:{}s:17:\"requires_at_least\";s:3:\"5.5\";s:12:\"tested_up_to\";s:5:\"5.8.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:7:\"3.6.0.3\";s:11:\"last_update\";s:10:\"2022-01-12\";s:17:\"short_description\";s:82:\"LearnDash LMS Plugin - Turn your WordPress site into a learning management system.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:411:\"Turn your WordPress site into a learning management system.\r\n\r\nEasily create & sell courses, deliver quizzes, award certificates, manage users, download reports, and so much more! By using LearnDash you have access to the latest e-learning industry trends for creating robust learning experiences.\r\n\r\nSee the [Features](https://www.learndash.com/wordpress-course-plugin-features/) page for more information.\r\n\r\n\";s:7:\"content\";s:437:\"<p>Turn your WordPress site into a learning management system.</p>\n<p>Easily create &amp; sell courses, deliver quizzes, award certificates, manage users, download reports, and so much more! By using LearnDash you have access to the latest e-learning industry trends for creating robust learning experiences.</p>\n<p>See the <a href=\"https://www.learndash.com/wordpress-course-plugin-features/\">Features</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:494:\"If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of LearnDash LMS.\r\n2. Download the latest version of LearnDash from our [support site](https://support.learndash.com/articles/my-downloads/).\r\n3. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n4. Activate the LearnDash LMS plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:540:\"<p>If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of LearnDash LMS.</li>\n<li>Download the latest version of LearnDash from our <a href=\"https://support.learndash.com/articles/my-downloads/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the LearnDash LMS plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:12572:\"= 3.6.0.3 =\r\n\r\n* Updated licensing logic to change the request from POST to GET\r\n* Updated license checks to improve performance including checking license validation every hour\r\n\r\n= 3.6.0.2 =\r\n\r\n* Updated include admins when using the course filters in the WP admin users screen\r\n* Fixed how the fill in the blank question type calculates spaces \r\n* Fixed when continuing the quiz the first question shows at the top of the page\r\n* Fixed questions marked for \"review\" are not saved on quiz saving\r\n* Fixed registration success not working with free access mode courses \r\n* Fixed some quizzes being incorrectly marked as complete even if the quiz hasn\'t been accessed\r\n* Fixed quiz repeat logic is different between a quiz starting and a quiz processing\r\n* Fixed quiz click to continue redirecting to the parent lesson rather than the correct course step\r\n* Fixed group leader custom label empty on add user selector\r\n\r\n= 3.6.0.1 =\r\n\r\n* Fixed error with enrollment with PayPal and LearnDash groups\r\n* Fixed login modal redirecting to the wp-login.php page if the credentials were entered incorrectly\r\n* Fixed expired courses not listing in course info list by default\r\n* Fixed order overview showing $ sign when purchase was free\r\n* Fixed PayPal not creating the user account when being used from the LearnDash registration pages\r\n* Fixed LearnDash permalink changes not saving\r\n\r\n= 3.6.0 =\r\n\r\n* Added trial period and billing period options to subscriptions\r\n* Added registration page and logic\r\n* Added per course redirects post purchase for buy now and recurring access type courses\r\n* Added advanced tab that new houses data upgrades, custom labels and the REST API\r\n* Added payments tab that houses PayPal and Stripe payment gateways \r\n* Added customizable post purchase and registration emails\r\n* Added from email settings to change sender name and address rather than using the default of WordPress\r\n* Fixed REST API using 12 hours instead of 24 hours in some places\r\n* Fixed quiz filter not showing on some associated quizzes\r\n* Fixed leaderboard showing results as 0\r\n\r\n= 3.5.1.3 =\r\n\r\n* Fixed issue with section headings being removed after the previous update resulting in display issues\r\n\r\n= 3.5.1.2 =\r\n\r\n* Fixed conflict with ACF Pro in quizzes\r\n* Fixed free choice questions with an apostrophe being marked as incorrect\r\n* Fixed user not being able to progress to the next step if total quiz points are 0\r\n* Fixed saving or adding quote marks in section headings resulting in removal of all headings from that course\r\n* Fixed data upgrades getting stuck in specific use cases\r\n* Fixed topic being marked as complete even when the associated quiz is failed\r\n* Fixed minor logic issues with quiz saving and resume \r\n\r\n= 3.5.1.1 =\r\n\r\n* Added LD version and unique key to quiz attemp user meta data\r\n* Fixed matrix sorting validation not working since version 3.5.1\r\n* Fixed fill in the blank type questions only awarding 1 point even when the points to be awarded is set to a higher value\r\n* Fixed logged out users cannot access a quiz in a course that is set to the open access mode\r\n* Fixed mark complete button not showing on sample lessons for logged-in users \r\n* Fixed being unable to remove the first section heading \r\n* Fixed not being able to progress through a course when the last question in a quiz is an essay\r\n* Fixed an error with \"browser cookie answer protection\" setting\r\n\r\n= 3.5.1 =\r\n\r\n* Added new quiz saving and resume functionality\r\n* Added new endpoint to REST API V2 for quiz form entries\r\n* Added fill in the blank question type individual answer points\r\n* Added filter to not force lower case compare on quiz answer\r\n* Updated increase rows for free question answer type\r\n* Updated quiz questions settings fields in REST API V2\r\n* Updated binary selector post_status display logic\r\n* Updated validated that the user inputted recurring billing cycle value is correct\r\n* Fixed if free quiz answer is 0 the answer is not being stored correctly in the statistics table\r\n* Fixed focus mode arrows getting reversed on tablets\r\n* Fixed leaderboard on front-end not displaying maximum points\r\n* Fixed quiz builder sometimes loading with an unexpected error in the console\r\n* Fixed lessons ordering changes after saving\r\n* Fixed individual point values being incorrect in the REST API\r\n* Fixed custom quiz time format options not saving\r\n* Fixed calendar icons not displaying the date on hover in focus mode\r\n* Fixed incorrect variable name in the REST API V2\r\n* Fixed some quiz settings not displaying in the WordPress admin when importing quizzes\r\n* Fixed PHP deprecated notice $block_editor_context\r\n* Fixed issue where update notice trigger triggers on the wrong plugin\r\n* Fixed quiz custom field dates not translated in the certificate builder\r\n* Fixed page scrolling to top on quiz start\r\n* Fixed support tab showing upgrade notice \r\n* Fixed Assessment questions not grading correctly \r\n* Fixed warnings/notices \r\n* Fixed umlauts not working in section headings \r\n* Fixed quiz score delete \r\n* Fixed error when accessing a deleted step of a course \r\n* Fixed quiz Assessment question radio input can select multiple\r\n\r\n= 3.4.2.1 =\r\n\r\n* Fixed ld_course_list not linking to courses when groups aren\'t set to public \r\n\r\n= 3.4.2 = \r\n\r\n* Added display alert when group CPT is not public\r\n* Added [user_groups] shortcode section to shortcode inserter\r\n* Added compatibility for WordPress 5.8\r\n* Fixed PHP warning illegal string \"offset\" warning \r\n* Fixed private lessons not displaying in the lesson selector\r\n* Fixed quiz statistics not loading when user search for a course a LD30 profile\r\n* Fixed focus mode sub-steps list being collapsed by default on active step\r\n* Fixed PHP notice in CSV reports\r\n* Fixed question display setting not displaying questions in pagination format when selected\r\n\r\n= 3.4.1.1 = \r\n\r\n* Fixed learndash_process_mark_complete() function\r\n\r\n= 3.4.0.8 = \r\n\r\n* Fixed quizzes not showing in the course builder\r\n* Fixed Fixed activity table records not getting updated when manually marking content as completed\r\n\r\n= 3.4.0.7 =\r\n\r\n* Fixed recurring payment duration resetting to 1 day\r\n* Fixed quizzes not showing on course builder \r\n* Fixed sprint() too few arguments warnings \r\n* Fixed warning illegal offset percentage \r\n\r\n= 3.4.0.6 = \r\n\r\n* Fixed Course Grid pagination resetting after going to the next page on a filtered grid \r\n* Fixed issue with course progression where some users were unable to progress to the next step when taking a quiz multiple times \r\n* Fixed learndash_get_global_quiz_list() causing infinite loop in Legacy Mode templates \r\n\r\n= 3.4.0.5 = \r\n\r\n* Fixed lesson progress bar showing in focus mode \r\n* Fixed issue where course grid was still showing in progress even when it should show completed\r\n* Fixed lesson/topic content not showing if the course builder is disabled \r\n* Fixed Error Call to undefined function learndash_get_custom_lower_label()\r\n\r\n= 3.4.0.4 = \r\n\r\n* Updated use php timestamp for quiz completion times rather than a JS based value\r\n* Fixed modifying course progress from the backend user profile in the wp-admin resets all incomplete courses\r\n* Fixed sprintf warning too few arguments\r\n\r\n= 3.4.0.3 = \r\n\r\n* Added show progress bar in lesson overview page\r\n* Added support for duplicate post plugins\r\n* Updated import block dependencies instead of using the wp global\r\n* Updated compatibility for Spotlightr API v2 videos for video player\r\n* Fixed warning messages under overview section (class-simplepie.php)\r\n* Fixed [ld_course_list] using legacy templates causes infinite looping \r\n* Fixed group access mode reverting to previous saved value when updating \r\n* Fixed PHP notice on transaction listing \r\n* Fixed expired course alert not showing \r\n\r\n= 3.4.0.2 =\r\n\r\n* Added associated lesson/topic/quiz course selectors\r\n* Fixed span html tag never closes\r\n* Fixed lesson list not visible to those without a user role \r\n* Fixed users list inaccessible if the admin user also has the group leader role \r\n* Fixed group leader can\'t edit assignments \r\n\r\n= 3.4.0.1 = \r\n\r\n* Fixed problem where content was not showing on the front-end\r\n* Fixed the label missing from the drip lesson \r\n\r\n= 3.4.0 = \r\n\r\n* Added return to current lesson button\r\n* Added filter to check for the duration of uploaded videos in assignments\r\n* Added REST support on the video_resume and video_focus_pause settings fields for Lesson and Topics\r\n* Added disable auto complete/input on form fields in quizzes\r\n* Added progress_status to REST API V2\r\n* Added Gutenberg block for [quizinfo] shortcode (only for the new certificate builder post type)\r\n* Updated performance improvement throughout the plugin\r\n* Updated REST API V2 to show success/failure messages when deleting a user from a course\r\n* Updated improved quizzes list display loading time (part of performance improvements)\r\n* Fixed showing incorrect DB version in support information overview\r\n* Fixed delete LearnDash MU plugin from the mu-plugins folder automatically when LearnDash is deleted\r\n* Fixed group leader can edit any assignment \r\n* Fixed public step in private course viewable \r\n* Fixed in Progress parameter showing complete courses as well for non-admin user\r\n* Fixed group Leader cannot create/modify LD content with Gutenberg with manage courses/groups option\r\n* Fixed quiz only lessons not displaying steps in Focus Mode sidebar\r\n* Fixed \"All Certificates\" label not translatable\r\n* Fixed accessing free course via the REST API\r\n* Fixed essay type upload questions: File format not recognized if uppercase extension is used\r\n* Fixed register_rest_field() does not work with v2\r\n* Fixed incorrect breadcrumb order when course/step title using RTL language\r\n* Fixed removing user through REST API V2 not working\r\n* Fixed PHP warnings and notices\r\n\r\n= 3.3.0.3 = \r\n\r\n* Fixed fatal error on WordPress 5.5 based LearnDash websites\r\n\r\n= 3.3.0.2 =\r\n\r\n* Added filter \"learndash_use_wp_safe_redirect\" to be used if a user is being redirected to the wp-admin when marking a lesson or course as complete\r\n* Added warning when using an older PHP version\r\n* Updated ReactDND library\r\n* Fixed download quiz certificate link not showing when a quiz has an essay type question with \"Not graded\" status\r\n* Fixed styling issue with Elementor and the [ld_profile] shortcode \r\n* Fixed subsequent pages do not respect the filter condition, for example when filtering completed courses only\r\n* Fixed styling issue on the quiz question overview page where the second row isn\'t correctly aligned to the left\r\n* Fixed warning when foreach() isn\'t run over an array\r\n* Fixed unexpected token < in JSON when Elementor and LearnDash are activated\r\n* Fixed essay bulk approval not working \r\n* Fixed essay/open type questions showing a default white space\r\n* Fixed course grid block not saving the column numbers\r\n* Fixed two buttons showing (publish and update) when reviewing a submitted essay in Gutenberg/the block editor \r\n* Fixed not being able to approve submitted essays \r\n* Fixed Video Pause on Window Unfocused causing YT videos to autoplay\r\n* Fixed PHP notices\r\n* Fixed matrix sorting view questions results not displaying matching answers correctly\r\n\r\n= 3.3.0.1 = \r\n\r\n* Fixed E_PARSE error causing Error message: syntax error, unexpected \"?\"\" In REST API v2 for PHP versions below 7.3 \r\n* Fixed an issue where when loading the REST API endpoints metabox_init_filter caused problems with third-party plugins and groups\r\n* Fixed users can�t upload assignments\r\n* Fixed custom course label not applying to LD user status widget\r\n* Fixed unsupported operand types\r\n* Fixed deprecation warnings when using PHP 8\r\n\r\n= 3.3.0 =\r\n\r\n* Added LearnDash REST API v2 (beta)\r\n* Added course export performance improvements\r\n* Added quiz messages for the question answered state\r\n* Updated quiz retry logic \r\n* Updated packages used in the builder\r\n* Updated coding standards \r\n* Fixed quiz answer spacing \r\n* Fixed translations not updating \r\n* Fixed header distorted in focus mode\r\n* Fixed marking a course complete via the profile page in the wp-admin\r\n* Fixed course list in ld_profile shortcode not showing \r\n* Fixed missing latest quiz statistic \r\n* Fixed mark complete button cut off in focus mode\r\n* Fixed lesson title not changing when using the_title filter\r\n* Fixed group leaders not being able to filter assingments/essays \r\n* Fixed LearnDash blocks throwing a warning\r\n* Fixed RTL breadcrumbs being the wrong direction\r\n* Fixed PayPal recurring payments not enrolling users\r\n\r\nView our full changelog [here](https://www.learndash.com/changelog/).\r\n\r\n\";s:7:\"content\";s:13962:\"<h4>3.6.0.3</h4>\n<ul>\n<li>Updated licensing logic to change the request from POST to GET</li>\n<li>\n<p>Updated license checks to improve performance including checking license validation every hour</p>\n<h4>3.6.0.2</h4>\n</li>\n<li>Updated include admins when using the course filters in the WP admin users screen</li>\n<li>Fixed how the fill in the blank question type calculates spaces </li>\n<li>Fixed when continuing the quiz the first question shows at the top of the page</li>\n<li>Fixed questions marked for &quot;review&quot; are not saved on quiz saving</li>\n<li>Fixed registration success not working with free access mode courses </li>\n<li>Fixed some quizzes being incorrectly marked as complete even if the quiz hasn\'t been accessed</li>\n<li>Fixed quiz repeat logic is different between a quiz starting and a quiz processing</li>\n<li>Fixed quiz click to continue redirecting to the parent lesson rather than the correct course step</li>\n<li>\n<p>Fixed group leader custom label empty on add user selector</p>\n<h4>3.6.0.1</h4>\n</li>\n<li>Fixed error with enrollment with PayPal and LearnDash groups</li>\n<li>Fixed login modal redirecting to the wp-login.php page if the credentials were entered incorrectly</li>\n<li>Fixed expired courses not listing in course info list by default</li>\n<li>Fixed order overview showing $ sign when purchase was free</li>\n<li>Fixed PayPal not creating the user account when being used from the LearnDash registration pages</li>\n<li>\n<p>Fixed LearnDash permalink changes not saving</p>\n<h4>3.6.0</h4>\n</li>\n<li>Added trial period and billing period options to subscriptions</li>\n<li>Added registration page and logic</li>\n<li>Added per course redirects post purchase for buy now and recurring access type courses</li>\n<li>Added advanced tab that new houses data upgrades, custom labels and the REST API</li>\n<li>Added payments tab that houses PayPal and Stripe payment gateways </li>\n<li>Added customizable post purchase and registration emails</li>\n<li>Added from email settings to change sender name and address rather than using the default of WordPress</li>\n<li>Fixed REST API using 12 hours instead of 24 hours in some places</li>\n<li>Fixed quiz filter not showing on some associated quizzes</li>\n<li>\n<p>Fixed leaderboard showing results as 0</p>\n<h4>3.5.1.3</h4>\n</li>\n<li>\n<p>Fixed issue with section headings being removed after the previous update resulting in display issues</p>\n<h4>3.5.1.2</h4>\n</li>\n<li>Fixed conflict with ACF Pro in quizzes</li>\n<li>Fixed free choice questions with an apostrophe being marked as incorrect</li>\n<li>Fixed user not being able to progress to the next step if total quiz points are 0</li>\n<li>Fixed saving or adding quote marks in section headings resulting in removal of all headings from that course</li>\n<li>Fixed data upgrades getting stuck in specific use cases</li>\n<li>Fixed topic being marked as complete even when the associated quiz is failed</li>\n<li>\n<p>Fixed minor logic issues with quiz saving and resume </p>\n<h4>3.5.1.1</h4>\n</li>\n<li>Added LD version and unique key to quiz attemp user meta data</li>\n<li>Fixed matrix sorting validation not working since version 3.5.1</li>\n<li>Fixed fill in the blank type questions only awarding 1 point even when the points to be awarded is set to a higher value</li>\n<li>Fixed logged out users cannot access a quiz in a course that is set to the open access mode</li>\n<li>Fixed mark complete button not showing on sample lessons for logged-in users </li>\n<li>Fixed being unable to remove the first section heading </li>\n<li>Fixed not being able to progress through a course when the last question in a quiz is an essay</li>\n<li>\n<p>Fixed an error with &quot;browser cookie answer protection&quot; setting</p>\n<h4>3.5.1</h4>\n</li>\n<li>Added new quiz saving and resume functionality</li>\n<li>Added new endpoint to REST API V2 for quiz form entries</li>\n<li>Added fill in the blank question type individual answer points</li>\n<li>Added filter to not force lower case compare on quiz answer</li>\n<li>Updated increase rows for free question answer type</li>\n<li>Updated quiz questions settings fields in REST API V2</li>\n<li>Updated binary selector post_status display logic</li>\n<li>Updated validated that the user inputted recurring billing cycle value is correct</li>\n<li>Fixed if free quiz answer is 0 the answer is not being stored correctly in the statistics table</li>\n<li>Fixed focus mode arrows getting reversed on tablets</li>\n<li>Fixed leaderboard on front-end not displaying maximum points</li>\n<li>Fixed quiz builder sometimes loading with an unexpected error in the console</li>\n<li>Fixed lessons ordering changes after saving</li>\n<li>Fixed individual point values being incorrect in the REST API</li>\n<li>Fixed custom quiz time format options not saving</li>\n<li>Fixed calendar icons not displaying the date on hover in focus mode</li>\n<li>Fixed incorrect variable name in the REST API V2</li>\n<li>Fixed some quiz settings not displaying in the WordPress admin when importing quizzes</li>\n<li>Fixed PHP deprecated notice $block_editor_context</li>\n<li>Fixed issue where update notice trigger triggers on the wrong plugin</li>\n<li>Fixed quiz custom field dates not translated in the certificate builder</li>\n<li>Fixed page scrolling to top on quiz start</li>\n<li>Fixed support tab showing upgrade notice </li>\n<li>Fixed Assessment questions not grading correctly </li>\n<li>Fixed warnings/notices </li>\n<li>Fixed umlauts not working in section headings </li>\n<li>Fixed quiz score delete </li>\n<li>Fixed error when accessing a deleted step of a course </li>\n<li>\n<p>Fixed quiz Assessment question radio input can select multiple</p>\n<h4>3.4.2.1</h4>\n</li>\n<li>\n<p>Fixed ld_course_list not linking to courses when groups aren\'t set to public </p>\n<h4>3.4.2</h4> \n</li>\n<li>Added display alert when group CPT is not public</li>\n<li>Added [user_groups] shortcode section to shortcode inserter</li>\n<li>Added compatibility for WordPress 5.8</li>\n<li>Fixed PHP warning illegal string &quot;offset&quot; warning </li>\n<li>Fixed private lessons not displaying in the lesson selector</li>\n<li>Fixed quiz statistics not loading when user search for a course a LD30 profile</li>\n<li>Fixed focus mode sub-steps list being collapsed by default on active step</li>\n<li>Fixed PHP notice in CSV reports</li>\n<li>\n<p>Fixed question display setting not displaying questions in pagination format when selected</p>\n<h4>3.4.1.1</h4> \n</li>\n<li>\n<p>Fixed learndash_process_mark_complete() function</p>\n<h4>3.4.0.8</h4> \n</li>\n<li>Fixed quizzes not showing in the course builder</li>\n<li>\n<p>Fixed Fixed activity table records not getting updated when manually marking content as completed</p>\n<h4>3.4.0.7</h4>\n</li>\n<li>Fixed recurring payment duration resetting to 1 day</li>\n<li>Fixed quizzes not showing on course builder </li>\n<li>Fixed sprint() too few arguments warnings </li>\n<li>\n<p>Fixed warning illegal offset percentage </p>\n<h4>3.4.0.6</h4> \n</li>\n<li>Fixed Course Grid pagination resetting after going to the next page on a filtered grid </li>\n<li>Fixed issue with course progression where some users were unable to progress to the next step when taking a quiz multiple times </li>\n<li>\n<p>Fixed learndash_get_global_quiz_list() causing infinite loop in Legacy Mode templates </p>\n<h4>3.4.0.5</h4> \n</li>\n<li>Fixed lesson progress bar showing in focus mode </li>\n<li>Fixed issue where course grid was still showing in progress even when it should show completed</li>\n<li>Fixed lesson/topic content not showing if the course builder is disabled </li>\n<li>\n<p>Fixed Error Call to undefined function learndash_get_custom_lower_label()</p>\n<h4>3.4.0.4</h4> \n</li>\n<li>Updated use php timestamp for quiz completion times rather than a JS based value</li>\n<li>Fixed modifying course progress from the backend user profile in the wp-admin resets all incomplete courses</li>\n<li>\n<p>Fixed sprintf warning too few arguments</p>\n<h4>3.4.0.3</h4> \n</li>\n<li>Added show progress bar in lesson overview page</li>\n<li>Added support for duplicate post plugins</li>\n<li>Updated import block dependencies instead of using the wp global</li>\n<li>Updated compatibility for Spotlightr API v2 videos for video player</li>\n<li>Fixed warning messages under overview section (class-simplepie.php)</li>\n<li>Fixed [ld_course_list] using legacy templates causes infinite looping </li>\n<li>Fixed group access mode reverting to previous saved value when updating </li>\n<li>Fixed PHP notice on transaction listing </li>\n<li>\n<p>Fixed expired course alert not showing </p>\n<h4>3.4.0.2</h4>\n</li>\n<li>Added associated lesson/topic/quiz course selectors</li>\n<li>Fixed span html tag never closes</li>\n<li>Fixed lesson list not visible to those without a user role </li>\n<li>Fixed users list inaccessible if the admin user also has the group leader role </li>\n<li>\n<p>Fixed group leader can\'t edit assignments </p>\n<h4>3.4.0.1</h4> \n</li>\n<li>Fixed problem where content was not showing on the front-end</li>\n<li>\n<p>Fixed the label missing from the drip lesson </p>\n<h4>3.4.0</h4> \n</li>\n<li>Added return to current lesson button</li>\n<li>Added filter to check for the duration of uploaded videos in assignments</li>\n<li>Added REST support on the video_resume and video_focus_pause settings fields for Lesson and Topics</li>\n<li>Added disable auto complete/input on form fields in quizzes</li>\n<li>Added progress_status to REST API V2</li>\n<li>Added Gutenberg block for [quizinfo] shortcode (only for the new certificate builder post type)</li>\n<li>Updated performance improvement throughout the plugin</li>\n<li>Updated REST API V2 to show success/failure messages when deleting a user from a course</li>\n<li>Updated improved quizzes list display loading time (part of performance improvements)</li>\n<li>Fixed showing incorrect DB version in support information overview</li>\n<li>Fixed delete LearnDash MU plugin from the mu-plugins folder automatically when LearnDash is deleted</li>\n<li>Fixed group leader can edit any assignment </li>\n<li>Fixed public step in private course viewable </li>\n<li>Fixed in Progress parameter showing complete courses as well for non-admin user</li>\n<li>Fixed group Leader cannot create/modify LD content with Gutenberg with manage courses/groups option</li>\n<li>Fixed quiz only lessons not displaying steps in Focus Mode sidebar</li>\n<li>Fixed &quot;All Certificates&quot; label not translatable</li>\n<li>Fixed accessing free course via the REST API</li>\n<li>Fixed essay type upload questions: File format not recognized if uppercase extension is used</li>\n<li>Fixed register_rest_field() does not work with v2</li>\n<li>Fixed incorrect breadcrumb order when course/step title using RTL language</li>\n<li>Fixed removing user through REST API V2 not working</li>\n<li>\n<p>Fixed PHP warnings and notices</p>\n<h4>3.3.0.3</h4> \n</li>\n<li>\n<p>Fixed fatal error on WordPress 5.5 based LearnDash websites</p>\n<h4>3.3.0.2</h4>\n</li>\n<li>Added filter &quot;learndash_use_wp_safe_redirect&quot; to be used if a user is being redirected to the wp-admin when marking a lesson or course as complete</li>\n<li>Added warning when using an older PHP version</li>\n<li>Updated ReactDND library</li>\n<li>Fixed download quiz certificate link not showing when a quiz has an essay type question with &quot;Not graded&quot; status</li>\n<li>Fixed styling issue with Elementor and the [ld_profile] shortcode </li>\n<li>Fixed subsequent pages do not respect the filter condition, for example when filtering completed courses only</li>\n<li>Fixed styling issue on the quiz question overview page where the second row isn\'t correctly aligned to the left</li>\n<li>Fixed warning when foreach() isn\'t run over an array</li>\n<li>Fixed unexpected token &lt; in JSON when Elementor and LearnDash are activated</li>\n<li>Fixed essay bulk approval not working </li>\n<li>Fixed essay/open type questions showing a default white space</li>\n<li>Fixed course grid block not saving the column numbers</li>\n<li>Fixed two buttons showing (publish and update) when reviewing a submitted essay in Gutenberg/the block editor </li>\n<li>Fixed not being able to approve submitted essays </li>\n<li>Fixed Video Pause on Window Unfocused causing YT videos to autoplay</li>\n<li>Fixed PHP notices</li>\n<li>\n<p>Fixed matrix sorting view questions results not displaying matching answers correctly</p>\n<h4>3.3.0.1</h4> \n</li>\n<li>Fixed E_PARSE error causing Error message: syntax error, unexpected &quot;?&quot;&quot; In REST API v2 for PHP versions below 7.3 </li>\n<li>Fixed an issue where when loading the REST API endpoints metabox_init_filter caused problems with third-party plugins and groups</li>\n<li>Fixed users can�t upload assignments</li>\n<li>Fixed custom course label not applying to LD user status widget</li>\n<li>Fixed unsupported operand types</li>\n<li>\n<p>Fixed deprecation warnings when using PHP 8</p>\n<h4>3.3.0</h4>\n</li>\n<li>Added LearnDash REST API v2 (beta)</li>\n<li>Added course export performance improvements</li>\n<li>Added quiz messages for the question answered state</li>\n<li>Updated quiz retry logic </li>\n<li>Updated packages used in the builder</li>\n<li>Updated coding standards </li>\n<li>Fixed quiz answer spacing </li>\n<li>Fixed translations not updating </li>\n<li>Fixed header distorted in focus mode</li>\n<li>Fixed marking a course complete via the profile page in the wp-admin</li>\n<li>Fixed course list in ld_profile shortcode not showing </li>\n<li>Fixed missing latest quiz statistic </li>\n<li>Fixed mark complete button cut off in focus mode</li>\n<li>Fixed lesson title not changing when using the_title filter</li>\n<li>Fixed group leaders not being able to filter assingments/essays </li>\n<li>Fixed LearnDash blocks throwing a warning</li>\n<li>Fixed RTL breadcrumbs being the wrong direction</li>\n<li>Fixed PayPal recurring payments not enrolling users</li>\n</ul>\n<p>View our full changelog <a href=\"https://www.learndash.com/changelog/\">here</a>.</p>\";}s:14:\"upgrade_notice\";a:3:{s:5:\"title\";s:14:\"Upgrade Notice\";s:11:\"content_raw\";s:69:\"= 3.1.3 = \r\nImportant security update: please update immediately.\r\n\r\n\";s:7:\"content\";a:1:{s:5:\"3.1.3\";s:60:\"<p>Important security update: please update immediately.</p>\";}}s:3:\"faq\";a:3:{s:5:\"title\";s:3:\"FAQ\";s:11:\"content_raw\";s:1146:\"= Do I need to update? =\r\n\r\nIt is always recommended to update. However given the nature of WordPress and the option to have many other plugins installed, custom code, etc. it is possible that a conflict would arise. This is why we always recommend testing the update on a development environment first. \r\n\r\n= Why am I getting an error notice when trying to update? =\r\n\r\nIf you are getting an error while trying to update your version of LearnDash LMS, verify that your license is still valid. \r\n\r\nBoth your license key and email address should be entered via LEARNDASH LMS > SETTINGS > LMS LICENSE. You should then see a \"Your license is valid\" message appear. \r\n\r\nIf not, you can find your correct information via our [Support Site](https://support.learndash.com/articles/my-downloads/).\r\n\r\nIf your license has expired, you can purchase a new one [here](https://www.learndash.com/pricing-and-purchase/).\r\n\r\n= What will happen to my customizations when updating? =\r\n\r\nAs long as the customizations were not done directly in the core LearnDash plugin files, there should be no problem. We provide many template files and hooks for this purpose.\r\n\";s:7:\"content\";s:0:\"\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:437:\"<p>Turn your WordPress site into a learning management system.</p>\n<p>Easily create &amp; sell courses, deliver quizzes, award certificates, manage users, download reports, and so much more! By using LearnDash you have access to the latest e-learning industry trends for creating robust learning experiences.</p>\n<p>See the <a href=\"https://www.learndash.com/wordpress-course-plugin-features/\">Features</a> page for more information.</p>\";s:12:\"installation\";s:540:\"<p>If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of LearnDash LMS.</li>\n<li>Download the latest version of LearnDash from our <a href=\"https://support.learndash.com/articles/my-downloads/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the LearnDash LMS plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:13962:\"<h4>3.6.0.3</h4>\n<ul>\n<li>Updated licensing logic to change the request from POST to GET</li>\n<li>\n<p>Updated license checks to improve performance including checking license validation every hour</p>\n<h4>3.6.0.2</h4>\n</li>\n<li>Updated include admins when using the course filters in the WP admin users screen</li>\n<li>Fixed how the fill in the blank question type calculates spaces </li>\n<li>Fixed when continuing the quiz the first question shows at the top of the page</li>\n<li>Fixed questions marked for &quot;review&quot; are not saved on quiz saving</li>\n<li>Fixed registration success not working with free access mode courses </li>\n<li>Fixed some quizzes being incorrectly marked as complete even if the quiz hasn\'t been accessed</li>\n<li>Fixed quiz repeat logic is different between a quiz starting and a quiz processing</li>\n<li>Fixed quiz click to continue redirecting to the parent lesson rather than the correct course step</li>\n<li>\n<p>Fixed group leader custom label empty on add user selector</p>\n<h4>3.6.0.1</h4>\n</li>\n<li>Fixed error with enrollment with PayPal and LearnDash groups</li>\n<li>Fixed login modal redirecting to the wp-login.php page if the credentials were entered incorrectly</li>\n<li>Fixed expired courses not listing in course info list by default</li>\n<li>Fixed order overview showing $ sign when purchase was free</li>\n<li>Fixed PayPal not creating the user account when being used from the LearnDash registration pages</li>\n<li>\n<p>Fixed LearnDash permalink changes not saving</p>\n<h4>3.6.0</h4>\n</li>\n<li>Added trial period and billing period options to subscriptions</li>\n<li>Added registration page and logic</li>\n<li>Added per course redirects post purchase for buy now and recurring access type courses</li>\n<li>Added advanced tab that new houses data upgrades, custom labels and the REST API</li>\n<li>Added payments tab that houses PayPal and Stripe payment gateways </li>\n<li>Added customizable post purchase and registration emails</li>\n<li>Added from email settings to change sender name and address rather than using the default of WordPress</li>\n<li>Fixed REST API using 12 hours instead of 24 hours in some places</li>\n<li>Fixed quiz filter not showing on some associated quizzes</li>\n<li>\n<p>Fixed leaderboard showing results as 0</p>\n<h4>3.5.1.3</h4>\n</li>\n<li>\n<p>Fixed issue with section headings being removed after the previous update resulting in display issues</p>\n<h4>3.5.1.2</h4>\n</li>\n<li>Fixed conflict with ACF Pro in quizzes</li>\n<li>Fixed free choice questions with an apostrophe being marked as incorrect</li>\n<li>Fixed user not being able to progress to the next step if total quiz points are 0</li>\n<li>Fixed saving or adding quote marks in section headings resulting in removal of all headings from that course</li>\n<li>Fixed data upgrades getting stuck in specific use cases</li>\n<li>Fixed topic being marked as complete even when the associated quiz is failed</li>\n<li>\n<p>Fixed minor logic issues with quiz saving and resume </p>\n<h4>3.5.1.1</h4>\n</li>\n<li>Added LD version and unique key to quiz attemp user meta data</li>\n<li>Fixed matrix sorting validation not working since version 3.5.1</li>\n<li>Fixed fill in the blank type questions only awarding 1 point even when the points to be awarded is set to a higher value</li>\n<li>Fixed logged out users cannot access a quiz in a course that is set to the open access mode</li>\n<li>Fixed mark complete button not showing on sample lessons for logged-in users </li>\n<li>Fixed being unable to remove the first section heading </li>\n<li>Fixed not being able to progress through a course when the last question in a quiz is an essay</li>\n<li>\n<p>Fixed an error with &quot;browser cookie answer protection&quot; setting</p>\n<h4>3.5.1</h4>\n</li>\n<li>Added new quiz saving and resume functionality</li>\n<li>Added new endpoint to REST API V2 for quiz form entries</li>\n<li>Added fill in the blank question type individual answer points</li>\n<li>Added filter to not force lower case compare on quiz answer</li>\n<li>Updated increase rows for free question answer type</li>\n<li>Updated quiz questions settings fields in REST API V2</li>\n<li>Updated binary selector post_status display logic</li>\n<li>Updated validated that the user inputted recurring billing cycle value is correct</li>\n<li>Fixed if free quiz answer is 0 the answer is not being stored correctly in the statistics table</li>\n<li>Fixed focus mode arrows getting reversed on tablets</li>\n<li>Fixed leaderboard on front-end not displaying maximum points</li>\n<li>Fixed quiz builder sometimes loading with an unexpected error in the console</li>\n<li>Fixed lessons ordering changes after saving</li>\n<li>Fixed individual point values being incorrect in the REST API</li>\n<li>Fixed custom quiz time format options not saving</li>\n<li>Fixed calendar icons not displaying the date on hover in focus mode</li>\n<li>Fixed incorrect variable name in the REST API V2</li>\n<li>Fixed some quiz settings not displaying in the WordPress admin when importing quizzes</li>\n<li>Fixed PHP deprecated notice $block_editor_context</li>\n<li>Fixed issue where update notice trigger triggers on the wrong plugin</li>\n<li>Fixed quiz custom field dates not translated in the certificate builder</li>\n<li>Fixed page scrolling to top on quiz start</li>\n<li>Fixed support tab showing upgrade notice </li>\n<li>Fixed Assessment questions not grading correctly </li>\n<li>Fixed warnings/notices </li>\n<li>Fixed umlauts not working in section headings </li>\n<li>Fixed quiz score delete </li>\n<li>Fixed error when accessing a deleted step of a course </li>\n<li>\n<p>Fixed quiz Assessment question radio input can select multiple</p>\n<h4>3.4.2.1</h4>\n</li>\n<li>\n<p>Fixed ld_course_list not linking to courses when groups aren\'t set to public </p>\n<h4>3.4.2</h4> \n</li>\n<li>Added display alert when group CPT is not public</li>\n<li>Added [user_groups] shortcode section to shortcode inserter</li>\n<li>Added compatibility for WordPress 5.8</li>\n<li>Fixed PHP warning illegal string &quot;offset&quot; warning </li>\n<li>Fixed private lessons not displaying in the lesson selector</li>\n<li>Fixed quiz statistics not loading when user search for a course a LD30 profile</li>\n<li>Fixed focus mode sub-steps list being collapsed by default on active step</li>\n<li>Fixed PHP notice in CSV reports</li>\n<li>\n<p>Fixed question display setting not displaying questions in pagination format when selected</p>\n<h4>3.4.1.1</h4> \n</li>\n<li>\n<p>Fixed learndash_process_mark_complete() function</p>\n<h4>3.4.0.8</h4> \n</li>\n<li>Fixed quizzes not showing in the course builder</li>\n<li>\n<p>Fixed Fixed activity table records not getting updated when manually marking content as completed</p>\n<h4>3.4.0.7</h4>\n</li>\n<li>Fixed recurring payment duration resetting to 1 day</li>\n<li>Fixed quizzes not showing on course builder </li>\n<li>Fixed sprint() too few arguments warnings </li>\n<li>\n<p>Fixed warning illegal offset percentage </p>\n<h4>3.4.0.6</h4> \n</li>\n<li>Fixed Course Grid pagination resetting after going to the next page on a filtered grid </li>\n<li>Fixed issue with course progression where some users were unable to progress to the next step when taking a quiz multiple times </li>\n<li>\n<p>Fixed learndash_get_global_quiz_list() causing infinite loop in Legacy Mode templates </p>\n<h4>3.4.0.5</h4> \n</li>\n<li>Fixed lesson progress bar showing in focus mode </li>\n<li>Fixed issue where course grid was still showing in progress even when it should show completed</li>\n<li>Fixed lesson/topic content not showing if the course builder is disabled </li>\n<li>\n<p>Fixed Error Call to undefined function learndash_get_custom_lower_label()</p>\n<h4>3.4.0.4</h4> \n</li>\n<li>Updated use php timestamp for quiz completion times rather than a JS based value</li>\n<li>Fixed modifying course progress from the backend user profile in the wp-admin resets all incomplete courses</li>\n<li>\n<p>Fixed sprintf warning too few arguments</p>\n<h4>3.4.0.3</h4> \n</li>\n<li>Added show progress bar in lesson overview page</li>\n<li>Added support for duplicate post plugins</li>\n<li>Updated import block dependencies instead of using the wp global</li>\n<li>Updated compatibility for Spotlightr API v2 videos for video player</li>\n<li>Fixed warning messages under overview section (class-simplepie.php)</li>\n<li>Fixed [ld_course_list] using legacy templates causes infinite looping </li>\n<li>Fixed group access mode reverting to previous saved value when updating </li>\n<li>Fixed PHP notice on transaction listing </li>\n<li>\n<p>Fixed expired course alert not showing </p>\n<h4>3.4.0.2</h4>\n</li>\n<li>Added associated lesson/topic/quiz course selectors</li>\n<li>Fixed span html tag never closes</li>\n<li>Fixed lesson list not visible to those without a user role </li>\n<li>Fixed users list inaccessible if the admin user also has the group leader role </li>\n<li>\n<p>Fixed group leader can\'t edit assignments </p>\n<h4>3.4.0.1</h4> \n</li>\n<li>Fixed problem where content was not showing on the front-end</li>\n<li>\n<p>Fixed the label missing from the drip lesson </p>\n<h4>3.4.0</h4> \n</li>\n<li>Added return to current lesson button</li>\n<li>Added filter to check for the duration of uploaded videos in assignments</li>\n<li>Added REST support on the video_resume and video_focus_pause settings fields for Lesson and Topics</li>\n<li>Added disable auto complete/input on form fields in quizzes</li>\n<li>Added progress_status to REST API V2</li>\n<li>Added Gutenberg block for [quizinfo] shortcode (only for the new certificate builder post type)</li>\n<li>Updated performance improvement throughout the plugin</li>\n<li>Updated REST API V2 to show success/failure messages when deleting a user from a course</li>\n<li>Updated improved quizzes list display loading time (part of performance improvements)</li>\n<li>Fixed showing incorrect DB version in support information overview</li>\n<li>Fixed delete LearnDash MU plugin from the mu-plugins folder automatically when LearnDash is deleted</li>\n<li>Fixed group leader can edit any assignment </li>\n<li>Fixed public step in private course viewable </li>\n<li>Fixed in Progress parameter showing complete courses as well for non-admin user</li>\n<li>Fixed group Leader cannot create/modify LD content with Gutenberg with manage courses/groups option</li>\n<li>Fixed quiz only lessons not displaying steps in Focus Mode sidebar</li>\n<li>Fixed &quot;All Certificates&quot; label not translatable</li>\n<li>Fixed accessing free course via the REST API</li>\n<li>Fixed essay type upload questions: File format not recognized if uppercase extension is used</li>\n<li>Fixed register_rest_field() does not work with v2</li>\n<li>Fixed incorrect breadcrumb order when course/step title using RTL language</li>\n<li>Fixed removing user through REST API V2 not working</li>\n<li>\n<p>Fixed PHP warnings and notices</p>\n<h4>3.3.0.3</h4> \n</li>\n<li>\n<p>Fixed fatal error on WordPress 5.5 based LearnDash websites</p>\n<h4>3.3.0.2</h4>\n</li>\n<li>Added filter &quot;learndash_use_wp_safe_redirect&quot; to be used if a user is being redirected to the wp-admin when marking a lesson or course as complete</li>\n<li>Added warning when using an older PHP version</li>\n<li>Updated ReactDND library</li>\n<li>Fixed download quiz certificate link not showing when a quiz has an essay type question with &quot;Not graded&quot; status</li>\n<li>Fixed styling issue with Elementor and the [ld_profile] shortcode </li>\n<li>Fixed subsequent pages do not respect the filter condition, for example when filtering completed courses only</li>\n<li>Fixed styling issue on the quiz question overview page where the second row isn\'t correctly aligned to the left</li>\n<li>Fixed warning when foreach() isn\'t run over an array</li>\n<li>Fixed unexpected token &lt; in JSON when Elementor and LearnDash are activated</li>\n<li>Fixed essay bulk approval not working </li>\n<li>Fixed essay/open type questions showing a default white space</li>\n<li>Fixed course grid block not saving the column numbers</li>\n<li>Fixed two buttons showing (publish and update) when reviewing a submitted essay in Gutenberg/the block editor </li>\n<li>Fixed not being able to approve submitted essays </li>\n<li>Fixed Video Pause on Window Unfocused causing YT videos to autoplay</li>\n<li>Fixed PHP notices</li>\n<li>\n<p>Fixed matrix sorting view questions results not displaying matching answers correctly</p>\n<h4>3.3.0.1</h4> \n</li>\n<li>Fixed E_PARSE error causing Error message: syntax error, unexpected &quot;?&quot;&quot; In REST API v2 for PHP versions below 7.3 </li>\n<li>Fixed an issue where when loading the REST API endpoints metabox_init_filter caused problems with third-party plugins and groups</li>\n<li>Fixed users can�t upload assignments</li>\n<li>Fixed custom course label not applying to LD user status widget</li>\n<li>Fixed unsupported operand types</li>\n<li>\n<p>Fixed deprecation warnings when using PHP 8</p>\n<h4>3.3.0</h4>\n</li>\n<li>Added LearnDash REST API v2 (beta)</li>\n<li>Added course export performance improvements</li>\n<li>Added quiz messages for the question answered state</li>\n<li>Updated quiz retry logic </li>\n<li>Updated packages used in the builder</li>\n<li>Updated coding standards </li>\n<li>Fixed quiz answer spacing </li>\n<li>Fixed translations not updating </li>\n<li>Fixed header distorted in focus mode</li>\n<li>Fixed marking a course complete via the profile page in the wp-admin</li>\n<li>Fixed course list in ld_profile shortcode not showing </li>\n<li>Fixed missing latest quiz statistic </li>\n<li>Fixed mark complete button cut off in focus mode</li>\n<li>Fixed lesson title not changing when using the_title filter</li>\n<li>Fixed group leaders not being able to filter assingments/essays </li>\n<li>Fixed LearnDash blocks throwing a warning</li>\n<li>Fixed RTL breadcrumbs being the wrong direction</li>\n<li>Fixed PayPal recurring payments not enrolling users</li>\n</ul>\n<p>View our full changelog <a href=\"https://www.learndash.com/changelog/\">here</a>.</p>\";}s:10:\"last_check\";i:1642002094;s:8:\"external\";b:1;s:7:\"bb_slug\";s:21:\"learndash-core-readme\";s:8:\"homepage\";s:21:\"https://learndash.com\";s:12:\"last_updated\";s:19:\"2022-01-12 00:00:00\";s:7:\"version\";s:7:\"3.6.0.3\";s:8:\"requires\";s:3:\"5.5\";s:6:\"tested\";s:5:\"5.8.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:103:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_256x256.jpg\";s:2:\"2x\";s:103:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_256x256.jpg\";s:7:\"default\";s:103:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:102:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_banner.jpg\";s:4:\"high\";s:102:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_banner.jpg\";s:7:\"default\";s:102:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_banner.jpg\";}s:11:\"show-add-on\";s:2:\"no\";}s:21:\"learndash-course-grid\";a:29:{s:4:\"name\";s:21:\"LearnDash Course Grid\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:41:\"https://learndash.com/add-on/course-grid/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"tags\";a:3:{i:0;s:4:\"grid\";i:1;s:4:\"view\";i:2;s:7:\"display\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:5:\"5.8.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"2.0.4\";s:17:\"short_description\";s:79:\"Transform the course list created with shortcode [ld_course_list] to grid view.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:604:\"The Course Grid add-on gives you the ability to create a responsive course library that can be inserted on any page or post of your site. This is a perfect feature if you have a variety of course offerings and want to give users the ability to filter through them by category.\r\n\r\n= Add-on Features = \r\n\r\n* Responsive grid layout of courses\r\n* Filtering by category\r\n* Display course featured image and short description\r\n* Featured video support\r\n* Dynamic course price listing\r\n* Dynamic course status listing\r\n\r\nSee the [Add-on](https://learndash.com/add-on/course-grid/) page for more information.\r\n\r\n\";s:7:\"content\";s:669:\"<p>The Course Grid add-on gives you the ability to create a responsive course library that can be inserted on any page or post of your site. This is a perfect feature if you have a variety of course offerings and want to give users the ability to filter through them by category.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Responsive grid layout of courses</li>\n<li>Filtering by category</li>\n<li>Display course featured image and short description</li>\n<li>Featured video support</li>\n<li>Dynamic course price listing</li>\n<li>Dynamic course status listing</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/course-grid/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:3117:\"= 2.0.4 =\r\n\r\n* Added icon supported element for cards\r\n* Added conditional for element color selector\r\n* Added custom color selector for ribbon, icon, and button elements\r\n* Updated not started label text on CG 2.0 templates based on user activity for LD lesson and topic post type\r\n* Updated not Started label based on user activity for lesson and topic\r\n* Fixed card layouts and styles\r\n* Fixed minor cards layout and CSS styles\r\n* Fixed block editor meta setting value is not passed to front end templates\r\n* Fixed incorrect variable name\r\n* Fixed translations meta box on translations setting page is not loaded\r\n* Fixed update translations metabox to match with plugin name\r\n* Fixed undefined index error\r\n* Fixed undefined JS function\r\n* Fixed missing translation slug\r\n* Fixed legacy v1 course grid is not detected if the shortcode already stored in HTML format in DB\r\n\r\n= 2.0.3 =\r\n\r\n* Updated masonry script\r\n* Updated grid skin selector\r\n* Fixed PHP deprecated notice\r\n* Fixed legacy v1 assets are not loaded when using ld course list block\r\n* Fixed compatibility error with Elementor for v1 course grid element\r\n\r\n= 2.0.2 =\r\n\r\n* Fixed asset loading for legacy course grids\r\n\r\n= 2.0.1 =\r\n\r\n* Added course enrollment status attributes and block option\r\n* Udated removed fixed 4:3 aspect ratio to prevent distorted images\r\n* Fixed course grid assets not loading when Elementor is being used\r\n\r\n= 2.0.0 =\r\n\r\n* Added course grid Gutenberg block\r\n* Added learndash_course_grid shortcode\r\n* Added learndash_course_grid_filter shortcode\r\n* Added ability to add and use custom template\r\n* Added support for CG 1.0 shortcode\r\n\r\n= 1.7.0 =\r\n\r\n* Added ability to use HTML in the short description box\r\n* Added custom text support for groups in the Course Grid\r\n* Added Completed/In Progress/Not Available status for Course Grid ribbons\r\n* Added support for the Course Grid ribbon to show for students enrolled in a group\r\n* Added filter \'learndash_course_grid_load_resources\' to load styles/scripts dynamically wherever they are wanted using conditional logic\r\n* Updated deprecated .load in jQuery with .on(\'load)\' instead\r\n* Fixed Course Grid styles not being loaded when the shortcode is used in Elementor\r\n* Fixed groups progress indicator \r\n* Fixed undefined variable\r\n* Fixed array index error \r\n\r\n= 1.6.0 =\r\n\r\n* Added hook to filter course grid html output\r\n* Added docblock for html output filter\r\n* Added class container class names and its filter hook\r\n* Updated ribbon text escaping to wp_kses_post instead of esc_attr\r\n* Updated load grid resources on LD courses archive page\r\n* Updated plugin name and description\r\n* Updated LD get course price helper function to allow users filter the values\r\n* Updated to remove #ld_course_list wrapper on course grid shortcode to prevent conflicts with page builder plugins\r\n* Fixed thumbnail course URL redirects to bare URL instead of nested URL\r\n* Fixed short description unable to be set to empty because legacy value is not saved when saving new value\r\n* Fixed undefined index error\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/course-grid/).\r\n\";s:7:\"content\";s:3498:\"<h4>2.0.4</h4>\n<ul>\n<li>Added icon supported element for cards</li>\n<li>Added conditional for element color selector</li>\n<li>Added custom color selector for ribbon, icon, and button elements</li>\n<li>Updated not started label text on CG 2.0 templates based on user activity for LD lesson and topic post type</li>\n<li>Updated not Started label based on user activity for lesson and topic</li>\n<li>Fixed card layouts and styles</li>\n<li>Fixed minor cards layout and CSS styles</li>\n<li>Fixed block editor meta setting value is not passed to front end templates</li>\n<li>Fixed incorrect variable name</li>\n<li>Fixed translations meta box on translations setting page is not loaded</li>\n<li>Fixed update translations metabox to match with plugin name</li>\n<li>Fixed undefined index error</li>\n<li>Fixed undefined JS function</li>\n<li>Fixed missing translation slug</li>\n<li>\n<p>Fixed legacy v1 course grid is not detected if the shortcode already stored in HTML format in DB</p>\n<h4>2.0.3</h4>\n</li>\n<li>Updated masonry script</li>\n<li>Updated grid skin selector</li>\n<li>Fixed PHP deprecated notice</li>\n<li>Fixed legacy v1 assets are not loaded when using ld course list block</li>\n<li>\n<p>Fixed compatibility error with Elementor for v1 course grid element</p>\n<h4>2.0.2</h4>\n</li>\n<li>\n<p>Fixed asset loading for legacy course grids</p>\n<h4>2.0.1</h4>\n</li>\n<li>Added course enrollment status attributes and block option</li>\n<li>Udated removed fixed 4:3 aspect ratio to prevent distorted images</li>\n<li>\n<p>Fixed course grid assets not loading when Elementor is being used</p>\n<h4>2.0.0</h4>\n</li>\n<li>Added course grid Gutenberg block</li>\n<li>Added learndash_course_grid shortcode</li>\n<li>Added learndash_course_grid_filter shortcode</li>\n<li>Added ability to add and use custom template</li>\n<li>\n<p>Added support for CG 1.0 shortcode</p>\n<h4>1.7.0</h4>\n</li>\n<li>Added ability to use HTML in the short description box</li>\n<li>Added custom text support for groups in the Course Grid</li>\n<li>Added Completed/In Progress/Not Available status for Course Grid ribbons</li>\n<li>Added support for the Course Grid ribbon to show for students enrolled in a group</li>\n<li>Added filter \'learndash_course_grid_load_resources\' to load styles/scripts dynamically wherever they are wanted using conditional logic</li>\n<li>Updated deprecated .load in jQuery with .on(\'load)\' instead</li>\n<li>Fixed Course Grid styles not being loaded when the shortcode is used in Elementor</li>\n<li>Fixed groups progress indicator </li>\n<li>Fixed undefined variable</li>\n<li>\n<p>Fixed array index error </p>\n<h4>1.6.0</h4>\n</li>\n<li>Added hook to filter course grid html output</li>\n<li>Added docblock for html output filter</li>\n<li>Added class container class names and its filter hook</li>\n<li>Updated ribbon text escaping to wp_kses_post instead of esc_attr</li>\n<li>Updated load grid resources on LD courses archive page</li>\n<li>Updated plugin name and description</li>\n<li>Updated LD get course price helper function to allow users filter the values</li>\n<li>Updated to remove #ld_course_list wrapper on course grid shortcode to prevent conflicts with page builder plugins</li>\n<li>Fixed thumbnail course URL redirects to bare URL instead of nested URL</li>\n<li>Fixed short description unable to be set to empty because legacy value is not saved when saving new value</li>\n<li>Fixed undefined index error</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/course-grid/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:669:\"<p>The Course Grid add-on gives you the ability to create a responsive course library that can be inserted on any page or post of your site. This is a perfect feature if you have a variety of course offerings and want to give users the ability to filter through them by category.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Responsive grid layout of courses</li>\n<li>Filtering by category</li>\n<li>Display course featured image and short description</li>\n<li>Featured video support</li>\n<li>Dynamic course price listing</li>\n<li>Dynamic course status listing</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/course-grid/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:3498:\"<h4>2.0.4</h4>\n<ul>\n<li>Added icon supported element for cards</li>\n<li>Added conditional for element color selector</li>\n<li>Added custom color selector for ribbon, icon, and button elements</li>\n<li>Updated not started label text on CG 2.0 templates based on user activity for LD lesson and topic post type</li>\n<li>Updated not Started label based on user activity for lesson and topic</li>\n<li>Fixed card layouts and styles</li>\n<li>Fixed minor cards layout and CSS styles</li>\n<li>Fixed block editor meta setting value is not passed to front end templates</li>\n<li>Fixed incorrect variable name</li>\n<li>Fixed translations meta box on translations setting page is not loaded</li>\n<li>Fixed update translations metabox to match with plugin name</li>\n<li>Fixed undefined index error</li>\n<li>Fixed undefined JS function</li>\n<li>Fixed missing translation slug</li>\n<li>\n<p>Fixed legacy v1 course grid is not detected if the shortcode already stored in HTML format in DB</p>\n<h4>2.0.3</h4>\n</li>\n<li>Updated masonry script</li>\n<li>Updated grid skin selector</li>\n<li>Fixed PHP deprecated notice</li>\n<li>Fixed legacy v1 assets are not loaded when using ld course list block</li>\n<li>\n<p>Fixed compatibility error with Elementor for v1 course grid element</p>\n<h4>2.0.2</h4>\n</li>\n<li>\n<p>Fixed asset loading for legacy course grids</p>\n<h4>2.0.1</h4>\n</li>\n<li>Added course enrollment status attributes and block option</li>\n<li>Udated removed fixed 4:3 aspect ratio to prevent distorted images</li>\n<li>\n<p>Fixed course grid assets not loading when Elementor is being used</p>\n<h4>2.0.0</h4>\n</li>\n<li>Added course grid Gutenberg block</li>\n<li>Added learndash_course_grid shortcode</li>\n<li>Added learndash_course_grid_filter shortcode</li>\n<li>Added ability to add and use custom template</li>\n<li>\n<p>Added support for CG 1.0 shortcode</p>\n<h4>1.7.0</h4>\n</li>\n<li>Added ability to use HTML in the short description box</li>\n<li>Added custom text support for groups in the Course Grid</li>\n<li>Added Completed/In Progress/Not Available status for Course Grid ribbons</li>\n<li>Added support for the Course Grid ribbon to show for students enrolled in a group</li>\n<li>Added filter \'learndash_course_grid_load_resources\' to load styles/scripts dynamically wherever they are wanted using conditional logic</li>\n<li>Updated deprecated .load in jQuery with .on(\'load)\' instead</li>\n<li>Fixed Course Grid styles not being loaded when the shortcode is used in Elementor</li>\n<li>Fixed groups progress indicator </li>\n<li>Fixed undefined variable</li>\n<li>\n<p>Fixed array index error </p>\n<h4>1.6.0</h4>\n</li>\n<li>Added hook to filter course grid html output</li>\n<li>Added docblock for html output filter</li>\n<li>Added class container class names and its filter hook</li>\n<li>Updated ribbon text escaping to wp_kses_post instead of esc_attr</li>\n<li>Updated load grid resources on LD courses archive page</li>\n<li>Updated plugin name and description</li>\n<li>Updated LD get course price helper function to allow users filter the values</li>\n<li>Updated to remove #ld_course_list wrapper on course grid shortcode to prevent conflicts with page builder plugins</li>\n<li>Fixed thumbnail course URL redirects to bare URL instead of nested URL</li>\n<li>Fixed short description unable to be set to empty because legacy value is not saved when saving new value</li>\n<li>Fixed undefined index error</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/course-grid/\">here</a>.</p>\";}s:10:\"last_check\";i:1641626066;s:8:\"external\";b:1;s:7:\"bb_slug\";s:21:\"learndash-course-grid\";s:8:\"homepage\";s:41:\"https://learndash.com/add-on/course-grid/\";s:12:\"last_updated\";s:19:\"2022-01-05 00:00:00\";s:7:\"version\";s:5:\"2.0.4\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.8.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_256x256.jpg\";s:2:\"2x\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_256x256.jpg\";s:7:\"default\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_banner.jpg\";s:4:\"high\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_banner.jpg\";s:7:\"default\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"2.0.4\";s:4:\"file\";b:0;s:3:\"url\";s:244:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-course-grid&amp;_wpnonce=47a7422367&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:16:\"learndash-zapier\";a:29:{s:4:\"name\";s:20:\"Zapier for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:48:\"https://learndash.com/add-on/zapier-integration/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:16:\"learndash-zapier\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:6:\"zapier\";i:2;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:1:\"7\";s:10:\"stable_tag\";s:5:\"2.3.0\";s:17:\"short_description\";s:36:\"Integrate LearnDash LMS with Zapier.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:648:\"Integrate LearnDash LMS with Zapier.\r\n\r\n\r\nZapier is a service that makes it easy for you to connect two applications without the need to know code, currently with a library of over 300 applications. Zapier calls these connections Zaps, and this integration lets you create Zaps that include LearnDash activities.\r\n\r\n= Integration Features = \r\n\r\n* Perform actions in over 300 applications based on seven specific LearnDash activities\r\n* Supports both global and specific LearnDash activity\r\n* Easily connect LearnDash to the popular Zapier program without code\r\n\r\nSee the [Add-on](https://learndash.com/add-on/zapier/) page for more information.\r\n\r\n\";s:7:\"content\";s:697:\"<p>Integrate LearnDash LMS with Zapier.</p>\n<p>Zapier is a service that makes it easy for you to connect two applications without the need to know code, currently with a library of over 300 applications. Zapier calls these connections Zaps, and this integration lets you create Zaps that include LearnDash activities.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Perform actions in over 300 applications based on seven specific LearnDash activities</li>\n<li>Supports both global and specific LearnDash activity</li>\n<li>Easily connect LearnDash to the popular Zapier program without code</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/zapier/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:3582:\"= 2.3.0 =\r\n\r\n* Added quiz filter before sending trigger\r\n* Added topic filter before sending trigger\r\n* Added lesson filter before sending trigger\r\n* Added groups ids filter\r\n* Added get object list methods and update get sample to use courses_ids arg\r\n* Added get courses list trigger handler and add filter course before sending triggers\r\n* Updated return object list in ascending title order\r\n* Updated add trigger arguments to pull sample\r\n* Updated add request and payload arguments to polling triggers\r\n* Updated get object sample based on selected objects\r\n* Updated improve triggers hook filter before being sent\r\n* Fixed quiz completed zap is not triggered after taking a quiz\r\n* Fixed PHP warning for uncountable object\r\n* Fixed get object list methods may return data in incorrect format\r\n* Fixed undefined property error\r\n* Fixed undefined variable\r\n* Fixed make sure only return quiz result sample if it has same keys and value types as live data\r\n\r\n= 2.2.3 = \r\n\r\n* Fixed can\'t call Zapier URL preventing some triggers from working\r\n\r\n= 2.2.2 =\r\n\r\n* Fixed can\'t send trigger due to incorrect hookUrl payload key name when adding subscription hook\r\n* Fixed non static method can\'t be called statically\r\n\r\n= 2.2.1 =\r\n\r\n* Added course enrollment via group\r\n* Added \"added to group\" trigger\r\n* Added \"group completed\" trigger\r\n* Added course certificate link data in course completed trigger\r\n* Added ability to set username and display name\r\n* Updated get quiz result sample from the least recent user\r\n* Updated improve course payload\r\n* Updated make action payload filterable\r\n* Fixed group certificate link sample\r\n* Fixed error response\r\n* Fixed WP 5.8 compatibility error\r\n\r\n= 2.2.0 =\r\n\r\n* Fixed quiz_result response doesn\'t match between sample and live data\r\n* Fixed undefined variables error\r\n* Fixed syntax error that causes PHP warning error to be thrown\r\n* Updated pass enrolled into course response payload to get_response method to get the same live and sample data\r\n* Updated change Zapier app learndash_before_course_completed hook to learndash\r\n* Updated Add site URL format validation to prevent integration issues\r\n* Updated make API response of user creation error more verbose\r\n* Added dependencies check\r\n* Added course_info sample data in course completed trigger\r\n* Added file_link value in essay payload response\r\n* Added user_groups information to API payload data\r\n* Added logic to ensure adding and sending hook only to unique hook URL\r\n* Added course_info response to course_completed trigger with data from courseinfo shortcode\r\n\r\n= 2.1.0 =\r\n\r\n* Added first name and last name to user response\r\n* Added create user param to toggle course access function\r\n* Added create user param to get user and toggle group membership functions\r\n* Added `add_to_group` and `remove_from_group` actions handler and add toggle membership helper\r\n* Added `get_user helper` to automatically create user if it does not exist or return it if it exists\r\n* Updated to return the last quiz result sample from the last user to get the latest quiz result possible\r\n* Updated `get_trigger_sample` and `get_object_sample` to be more efficient\r\n* Updated `get_response()` parser method and update respective sections accordingly\r\n* Updated to make first and last name field not required\r\n* Updated `get_group_field` action handler and its helpers\r\n* Fixed add array wrapper for `get_sample` response because it is expected by Zapier\r\n* Fixed get sample method returns wrapped response in array\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/zapier/).\r\n\";s:7:\"content\";s:4098:\"<h4>2.3.0</h4>\n<ul>\n<li>Added quiz filter before sending trigger</li>\n<li>Added topic filter before sending trigger</li>\n<li>Added lesson filter before sending trigger</li>\n<li>Added groups ids filter</li>\n<li>Added get object list methods and update get sample to use courses_ids arg</li>\n<li>Added get courses list trigger handler and add filter course before sending triggers</li>\n<li>Updated return object list in ascending title order</li>\n<li>Updated add trigger arguments to pull sample</li>\n<li>Updated add request and payload arguments to polling triggers</li>\n<li>Updated get object sample based on selected objects</li>\n<li>Updated improve triggers hook filter before being sent</li>\n<li>Fixed quiz completed zap is not triggered after taking a quiz</li>\n<li>Fixed PHP warning for uncountable object</li>\n<li>Fixed get object list methods may return data in incorrect format</li>\n<li>Fixed undefined property error</li>\n<li>Fixed undefined variable</li>\n<li>\n<p>Fixed make sure only return quiz result sample if it has same keys and value types as live data</p>\n<h4>2.2.3</h4> \n</li>\n<li>\n<p>Fixed can\'t call Zapier URL preventing some triggers from working</p>\n<h4>2.2.2</h4>\n</li>\n<li>Fixed can\'t send trigger due to incorrect hookUrl payload key name when adding subscription hook</li>\n<li>\n<p>Fixed non static method can\'t be called statically</p>\n<h4>2.2.1</h4>\n</li>\n<li>Added course enrollment via group</li>\n<li>Added &quot;added to group&quot; trigger</li>\n<li>Added &quot;group completed&quot; trigger</li>\n<li>Added course certificate link data in course completed trigger</li>\n<li>Added ability to set username and display name</li>\n<li>Updated get quiz result sample from the least recent user</li>\n<li>Updated improve course payload</li>\n<li>Updated make action payload filterable</li>\n<li>Fixed group certificate link sample</li>\n<li>Fixed error response</li>\n<li>\n<p>Fixed WP 5.8 compatibility error</p>\n<h4>2.2.0</h4>\n</li>\n<li>Fixed quiz_result response doesn\'t match between sample and live data</li>\n<li>Fixed undefined variables error</li>\n<li>Fixed syntax error that causes PHP warning error to be thrown</li>\n<li>Updated pass enrolled into course response payload to get_response method to get the same live and sample data</li>\n<li>Updated change Zapier app learndash_before_course_completed hook to learndash</li>\n<li>Updated Add site URL format validation to prevent integration issues</li>\n<li>Updated make API response of user creation error more verbose</li>\n<li>Added dependencies check</li>\n<li>Added course_info sample data in course completed trigger</li>\n<li>Added file_link value in essay payload response</li>\n<li>Added user_groups information to API payload data</li>\n<li>Added logic to ensure adding and sending hook only to unique hook URL</li>\n<li>\n<p>Added course_info response to course_completed trigger with data from courseinfo shortcode</p>\n<h4>2.1.0</h4>\n</li>\n<li>Added first name and last name to user response</li>\n<li>Added create user param to toggle course access function</li>\n<li>Added create user param to get user and toggle group membership functions</li>\n<li>Added <code>add_to_group</code> and <code>remove_from_group</code> actions handler and add toggle membership helper</li>\n<li>Added <code>get_user helper</code> to automatically create user if it does not exist or return it if it exists</li>\n<li>Updated to return the last quiz result sample from the last user to get the latest quiz result possible</li>\n<li>Updated <code>get_trigger_sample</code> and <code>get_object_sample</code> to be more efficient</li>\n<li>Updated <code>get_response()</code> parser method and update respective sections accordingly</li>\n<li>Updated to make first and last name field not required</li>\n<li>Updated <code>get_group_field</code> action handler and its helpers</li>\n<li>Fixed add array wrapper for <code>get_sample</code> response because it is expected by Zapier</li>\n<li>Fixed get sample method returns wrapped response in array</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/zapier/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:697:\"<p>Integrate LearnDash LMS with Zapier.</p>\n<p>Zapier is a service that makes it easy for you to connect two applications without the need to know code, currently with a library of over 300 applications. Zapier calls these connections Zaps, and this integration lets you create Zaps that include LearnDash activities.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Perform actions in over 300 applications based on seven specific LearnDash activities</li>\n<li>Supports both global and specific LearnDash activity</li>\n<li>Easily connect LearnDash to the popular Zapier program without code</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/zapier/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:4098:\"<h4>2.3.0</h4>\n<ul>\n<li>Added quiz filter before sending trigger</li>\n<li>Added topic filter before sending trigger</li>\n<li>Added lesson filter before sending trigger</li>\n<li>Added groups ids filter</li>\n<li>Added get object list methods and update get sample to use courses_ids arg</li>\n<li>Added get courses list trigger handler and add filter course before sending triggers</li>\n<li>Updated return object list in ascending title order</li>\n<li>Updated add trigger arguments to pull sample</li>\n<li>Updated add request and payload arguments to polling triggers</li>\n<li>Updated get object sample based on selected objects</li>\n<li>Updated improve triggers hook filter before being sent</li>\n<li>Fixed quiz completed zap is not triggered after taking a quiz</li>\n<li>Fixed PHP warning for uncountable object</li>\n<li>Fixed get object list methods may return data in incorrect format</li>\n<li>Fixed undefined property error</li>\n<li>Fixed undefined variable</li>\n<li>\n<p>Fixed make sure only return quiz result sample if it has same keys and value types as live data</p>\n<h4>2.2.3</h4> \n</li>\n<li>\n<p>Fixed can\'t call Zapier URL preventing some triggers from working</p>\n<h4>2.2.2</h4>\n</li>\n<li>Fixed can\'t send trigger due to incorrect hookUrl payload key name when adding subscription hook</li>\n<li>\n<p>Fixed non static method can\'t be called statically</p>\n<h4>2.2.1</h4>\n</li>\n<li>Added course enrollment via group</li>\n<li>Added &quot;added to group&quot; trigger</li>\n<li>Added &quot;group completed&quot; trigger</li>\n<li>Added course certificate link data in course completed trigger</li>\n<li>Added ability to set username and display name</li>\n<li>Updated get quiz result sample from the least recent user</li>\n<li>Updated improve course payload</li>\n<li>Updated make action payload filterable</li>\n<li>Fixed group certificate link sample</li>\n<li>Fixed error response</li>\n<li>\n<p>Fixed WP 5.8 compatibility error</p>\n<h4>2.2.0</h4>\n</li>\n<li>Fixed quiz_result response doesn\'t match between sample and live data</li>\n<li>Fixed undefined variables error</li>\n<li>Fixed syntax error that causes PHP warning error to be thrown</li>\n<li>Updated pass enrolled into course response payload to get_response method to get the same live and sample data</li>\n<li>Updated change Zapier app learndash_before_course_completed hook to learndash</li>\n<li>Updated Add site URL format validation to prevent integration issues</li>\n<li>Updated make API response of user creation error more verbose</li>\n<li>Added dependencies check</li>\n<li>Added course_info sample data in course completed trigger</li>\n<li>Added file_link value in essay payload response</li>\n<li>Added user_groups information to API payload data</li>\n<li>Added logic to ensure adding and sending hook only to unique hook URL</li>\n<li>\n<p>Added course_info response to course_completed trigger with data from courseinfo shortcode</p>\n<h4>2.1.0</h4>\n</li>\n<li>Added first name and last name to user response</li>\n<li>Added create user param to toggle course access function</li>\n<li>Added create user param to get user and toggle group membership functions</li>\n<li>Added <code>add_to_group</code> and <code>remove_from_group</code> actions handler and add toggle membership helper</li>\n<li>Added <code>get_user helper</code> to automatically create user if it does not exist or return it if it exists</li>\n<li>Updated to return the last quiz result sample from the last user to get the latest quiz result possible</li>\n<li>Updated <code>get_trigger_sample</code> and <code>get_object_sample</code> to be more efficient</li>\n<li>Updated <code>get_response()</code> parser method and update respective sections accordingly</li>\n<li>Updated to make first and last name field not required</li>\n<li>Updated <code>get_group_field</code> action handler and its helpers</li>\n<li>Fixed add array wrapper for <code>get_sample</code> response because it is expected by Zapier</li>\n<li>Fixed get sample method returns wrapped response in array</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/zapier/\">here</a>.</p>\";}s:10:\"last_check\";i:1639804596;s:8:\"external\";b:1;s:7:\"bb_slug\";s:16:\"learndash-zapier\";s:8:\"homepage\";s:48:\"https://learndash.com/add-on/zapier-integration/\";s:12:\"last_updated\";s:19:\"2021-12-15 00:00:00\";s:7:\"version\";s:5:\"2.3.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_256x256.jpg\";s:2:\"2x\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_256x256.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:104:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_banner.jpg\";s:4:\"high\";s:104:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_banner.jpg\";s:7:\"default\";s:104:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"2.3.0\";s:4:\"file\";b:0;s:3:\"url\";s:239:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-zapier&amp;_wpnonce=36853f64e3&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:17:\"learndash-bbpress\";a:29:{s:4:\"name\";s:21:\"bbPress for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:37:\"https://learndash.com/add-on/bbpress/\";s:20:\"ld_requires_at_least\";s:5:\"3.0.0\";s:4:\"slug\";s:17:\"learndash-bbpress\";s:4:\"tags\";a:3:{i:0;s:7:\"bbpress\";i:1;s:6:\"forums\";i:2;s:12:\"integrations\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"2.2.2\";s:17:\"short_description\";s:37:\"Integrate LearnDash LMS with bbPress.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:589:\"Integrate LearnDash LMS with bbPress.\r\n\r\nbbPress is a forum plugin for WordPress with over 1.5 million downloads. This integration makes it easy for you to add forums to your courses. You can protect the forums so that only users who are enrolled into your courses are able to view content and to post new threads & topics.\r\n\r\n= Integration Features = \r\n\r\n* Automatic forum access\r\n* Public or private forums\r\n* Multi-forum support\r\n* Custom Access Denied messages\r\n* Dynamic associated forum widget\r\n\r\nSee the [Add-on](https://learndash.com/add-on/bbpress/) page for more information.\r\n\r\n\";s:7:\"content\";s:656:\"<p>Integrate LearnDash LMS with bbPress.</p>\n<p>bbPress is a forum plugin for WordPress with over 1.5 million downloads. This integration makes it easy for you to add forums to your courses. You can protect the forums so that only users who are enrolled into your courses are able to view content and to post new threads &amp; topics.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Automatic forum access</li>\n<li>Public or private forums</li>\n<li>Multi-forum support</li>\n<li>Custom Access Denied messages</li>\n<li>Dynamic associated forum widget</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/bbpress/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:1376:\"= 2.2.2 =\r\n\r\n* Fixed setting field labels don\'t point to their fields\r\n* Fixed some formatting and improved variable names\r\n* Fixed incorrect and refactor forum access check logic\r\n* Fixed custom message on topic page doesn\'t follow forum setting\r\n\r\n= 2.2.1 =\r\n\r\n* Added group support ld bbpress shortcodes and widgets\r\n* Added ld_bbpress_forum_courses shortcode tag\r\n* Added add get forum courses function and change some styles\r\n* Added class shortcode file and register ld_bbpress_course_forums shortcode tag\r\n* Added get course forums html function and refactor course forums widget\r\n* Updated refactor get forum courses widget\r\n* Fixed undefined index error in saving post meta function\r\n* Fixed bug that allow user access forums if forum view setting is set to any and one of course / group selectors is empty\r\n\r\n= 2.2.0 =\r\n\r\n* Added dependency check\r\n* Added LearnDash group support\r\n* Updated post limit message for group\r\n* Fixed undefined error notices\r\n\r\n= 2.1.1 =\r\n\r\n* Added course forum widget\r\n* Updated name and moved `functions.php` and `forum-widget.php`\r\n* Updated load translation function\r\n* Updated addon name to match the other addons\r\n* Fixed issue with forum link not working for non logged in users\r\n* Fixed course forums not displaying on bbp page other than forums page\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/bbpress/).\r\n\";s:7:\"content\";s:1584:\"<h4>2.2.2</h4>\n<ul>\n<li>Fixed setting field labels don\'t point to their fields</li>\n<li>Fixed some formatting and improved variable names</li>\n<li>Fixed incorrect and refactor forum access check logic</li>\n<li>\n<p>Fixed custom message on topic page doesn\'t follow forum setting</p>\n<h4>2.2.1</h4>\n</li>\n<li>Added group support ld bbpress shortcodes and widgets</li>\n<li>Added ld_bbpress_forum_courses shortcode tag</li>\n<li>Added add get forum courses function and change some styles</li>\n<li>Added class shortcode file and register ld_bbpress_course_forums shortcode tag</li>\n<li>Added get course forums html function and refactor course forums widget</li>\n<li>Updated refactor get forum courses widget</li>\n<li>Fixed undefined index error in saving post meta function</li>\n<li>\n<p>Fixed bug that allow user access forums if forum view setting is set to any and one of course / group selectors is empty</p>\n<h4>2.2.0</h4>\n</li>\n<li>Added dependency check</li>\n<li>Added LearnDash group support</li>\n<li>Updated post limit message for group</li>\n<li>\n<p>Fixed undefined error notices</p>\n<h4>2.1.1</h4>\n</li>\n<li>Added course forum widget</li>\n<li>Updated name and moved <code>functions.php</code> and <code>forum-widget.php</code></li>\n<li>Updated load translation function</li>\n<li>Updated addon name to match the other addons</li>\n<li>Fixed issue with forum link not working for non logged in users</li>\n<li>Fixed course forums not displaying on bbp page other than forums page</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/bbpress/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:656:\"<p>Integrate LearnDash LMS with bbPress.</p>\n<p>bbPress is a forum plugin for WordPress with over 1.5 million downloads. This integration makes it easy for you to add forums to your courses. You can protect the forums so that only users who are enrolled into your courses are able to view content and to post new threads &amp; topics.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Automatic forum access</li>\n<li>Public or private forums</li>\n<li>Multi-forum support</li>\n<li>Custom Access Denied messages</li>\n<li>Dynamic associated forum widget</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/bbpress/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:1584:\"<h4>2.2.2</h4>\n<ul>\n<li>Fixed setting field labels don\'t point to their fields</li>\n<li>Fixed some formatting and improved variable names</li>\n<li>Fixed incorrect and refactor forum access check logic</li>\n<li>\n<p>Fixed custom message on topic page doesn\'t follow forum setting</p>\n<h4>2.2.1</h4>\n</li>\n<li>Added group support ld bbpress shortcodes and widgets</li>\n<li>Added ld_bbpress_forum_courses shortcode tag</li>\n<li>Added add get forum courses function and change some styles</li>\n<li>Added class shortcode file and register ld_bbpress_course_forums shortcode tag</li>\n<li>Added get course forums html function and refactor course forums widget</li>\n<li>Updated refactor get forum courses widget</li>\n<li>Fixed undefined index error in saving post meta function</li>\n<li>\n<p>Fixed bug that allow user access forums if forum view setting is set to any and one of course / group selectors is empty</p>\n<h4>2.2.0</h4>\n</li>\n<li>Added dependency check</li>\n<li>Added LearnDash group support</li>\n<li>Updated post limit message for group</li>\n<li>\n<p>Fixed undefined error notices</p>\n<h4>2.1.1</h4>\n</li>\n<li>Added course forum widget</li>\n<li>Updated name and moved <code>functions.php</code> and <code>forum-widget.php</code></li>\n<li>Updated load translation function</li>\n<li>Updated addon name to match the other addons</li>\n<li>Fixed issue with forum link not working for non logged in users</li>\n<li>Fixed course forums not displaying on bbp page other than forums page</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/bbpress/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:17:\"learndash-bbpress\";s:8:\"homepage\";s:37:\"https://learndash.com/add-on/bbpress/\";s:12:\"last_updated\";s:19:\"2021-11-25 00:00:00\";s:7:\"version\";s:5:\"2.2.2\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_256x256.jpg\";s:2:\"2x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_256x256.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_banner.jpg\";s:4:\"high\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_banner.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"2.2.2\";s:4:\"file\";b:0;s:3:\"url\";s:240:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-bbpress&amp;_wpnonce=60cb115294&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:19:\"learndash-integrity\";a:29:{s:4:\"name\";s:19:\"LearnDash Integrity\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:49:\"https://learndash.com/add-on/learndash-integrity/\";s:20:\"ld_requires_at_least\";s:5:\"3.0.0\";s:4:\"slug\";s:19:\"learndash-integrity\";s:4:\"tags\";a:2:{i:0;s:6:\"course\";i:1;s:10:\"protection\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:5:\"5.8.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.0.0\";s:17:\"short_description\";s:46:\"Protect your course content from being shared.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:547:\"Helps protect your course content and your website from spam, and abuse with multiple modules including:\r\n\r\n* Hotlink protection\r\n* Concurrent login protection\r\n* Content protection (right click copy and paste)\r\n* reCAPTCHA integration for v2 and v3.\r\n\r\n= Integration Features = \r\n\r\n* Hotlink protection\r\n* Concurrent login protection\r\n* Content protection (right click copy and paste)\r\n* reCAPTCHA integration for v2 and v3\r\n* Hassle free setup\r\n\r\nSee the [Add-on](https://learndash.com/add-on/learndash-integrity/) page for more information.\r\n\r\n\";s:7:\"content\";s:637:\"<p>Helps protect your course content and your website from spam, and abuse with multiple modules including:</p>\n<ul>\n<li>Hotlink protection</li>\n<li>Concurrent login protection</li>\n<li>Content protection (right click copy and paste)</li>\n<li>\n<p>reCAPTCHA integration for v2 and v3.</p>\n<h4>Integration Features</h4> \n</li>\n<li>Hotlink protection</li>\n<li>Concurrent login protection</li>\n<li>Content protection (right click copy and paste)</li>\n<li>reCAPTCHA integration for v2 and v3</li>\n<li>Hassle free setup</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/learndash-integrity/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:161:\"= 1.0.0 =\r\n\r\n* Added new LearnDash integrity add-on (initial release)\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/learndash-integrity/).\r\n\";s:7:\"content\";s:194:\"<h4>1.0.0</h4>\n<ul>\n<li>Added new LearnDash integrity add-on (initial release)</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/learndash-integrity/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:637:\"<p>Helps protect your course content and your website from spam, and abuse with multiple modules including:</p>\n<ul>\n<li>Hotlink protection</li>\n<li>Concurrent login protection</li>\n<li>Content protection (right click copy and paste)</li>\n<li>\n<p>reCAPTCHA integration for v2 and v3.</p>\n<h4>Integration Features</h4> \n</li>\n<li>Hotlink protection</li>\n<li>Concurrent login protection</li>\n<li>Content protection (right click copy and paste)</li>\n<li>reCAPTCHA integration for v2 and v3</li>\n<li>Hassle free setup</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/learndash-integrity/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:194:\"<h4>1.0.0</h4>\n<ul>\n<li>Added new LearnDash integrity add-on (initial release)</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/learndash-integrity/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:19:\"learndash-integrity\";s:8:\"homepage\";s:49:\"https://learndash.com/add-on/learndash-integrity/\";s:12:\"last_updated\";s:19:\"2021-11-17 00:00:00\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.8.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:2:\"2x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:4:\"high\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.0.0\";s:4:\"file\";b:0;s:3:\"url\";s:242:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-integrity&amp;_wpnonce=c5a6e0a112&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:23:\"learndash-gravity-forms\";a:29:{s:4:\"name\";s:27:\"Gravity Forms for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:43:\"https://learndash.com/add-on/gravity-forms/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:23:\"learndash-gravity-forms\";s:4:\"tags\";a:2:{i:0;s:11:\"integration\";i:1;s:13:\"gravity forms\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"2.1.2\";s:17:\"short_description\";s:44:\"Integrates LearnDash LMS with Gravity Forms.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:621:\"Integrate LearnDash LMS with Gravity Forms.\r\n\r\nGravity Forms is hands-down the industry\'s best custom form development plugin.\r\n\r\nWith this integration, you can create a completely custom course registration form and associate your online courses to it so that when users register, they are auto-enrolled.\r\n\r\n= Integration Features = \r\n\r\n* Create a unique registration form\r\n* Automatically enrolls user\r\n* Accept payments using Gravity Forms add-ons\r\n\r\nNote: this integration requires a Developer License from Gravity Forms.\r\n\r\nSee the [Add-on](https://learndash.com/add-on/gravity-forms/) page for more information.\r\n\r\n\";s:7:\"content\";s:680:\"<p>Integrate LearnDash LMS with Gravity Forms.</p>\n<p>Gravity Forms is hands-down the industry\'s best custom form development plugin.</p>\n<p>With this integration, you can create a completely custom course registration form and associate your online courses to it so that when users register, they are auto-enrolled.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Create a unique registration form</li>\n<li>Automatically enrolls user</li>\n<li>Accept payments using Gravity Forms add-ons</li>\n</ul>\n<p>Note: this integration requires a Developer License from Gravity Forms.</p>\n<p>See the <a href=\"https://learndash.com/add-on/gravity-forms/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:691:\"= 2.1.2 =\r\n\r\n* Added ability to assign a LearnDash group\r\n* Added allow conditional group enrollment based upon a form input\r\n* Added ability to support Gravity Forms conditonal logic \r\n* Fixed PHP notice\r\n* Fixed users not being enrolled when a Stripe payment field is part of the form\r\n\r\n= 2.1.1 =\r\n\r\n* Added payment refunded hooked function for paid form\r\n* Added payment completed hooked function for paid form\r\n* Added logic to bail course enrollment in user registration hook if the submitted form is a paid form\r\n* Added paid form setting field to mark a paid form on user registration feed setting\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/gravity-forms/).\r\n\";s:7:\"content\";s:781:\"<h4>2.1.2</h4>\n<ul>\n<li>Added ability to assign a LearnDash group</li>\n<li>Added allow conditional group enrollment based upon a form input</li>\n<li>Added ability to support Gravity Forms conditonal logic </li>\n<li>Fixed PHP notice</li>\n<li>\n<p>Fixed users not being enrolled when a Stripe payment field is part of the form</p>\n<h4>2.1.1</h4>\n</li>\n<li>Added payment refunded hooked function for paid form</li>\n<li>Added payment completed hooked function for paid form</li>\n<li>Added logic to bail course enrollment in user registration hook if the submitted form is a paid form</li>\n<li>Added paid form setting field to mark a paid form on user registration feed setting</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/gravity-forms/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:680:\"<p>Integrate LearnDash LMS with Gravity Forms.</p>\n<p>Gravity Forms is hands-down the industry\'s best custom form development plugin.</p>\n<p>With this integration, you can create a completely custom course registration form and associate your online courses to it so that when users register, they are auto-enrolled.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Create a unique registration form</li>\n<li>Automatically enrolls user</li>\n<li>Accept payments using Gravity Forms add-ons</li>\n</ul>\n<p>Note: this integration requires a Developer License from Gravity Forms.</p>\n<p>See the <a href=\"https://learndash.com/add-on/gravity-forms/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:781:\"<h4>2.1.2</h4>\n<ul>\n<li>Added ability to assign a LearnDash group</li>\n<li>Added allow conditional group enrollment based upon a form input</li>\n<li>Added ability to support Gravity Forms conditonal logic </li>\n<li>Fixed PHP notice</li>\n<li>\n<p>Fixed users not being enrolled when a Stripe payment field is part of the form</p>\n<h4>2.1.1</h4>\n</li>\n<li>Added payment refunded hooked function for paid form</li>\n<li>Added payment completed hooked function for paid form</li>\n<li>Added logic to bail course enrollment in user registration hook if the submitted form is a paid form</li>\n<li>Added paid form setting field to mark a paid form on user registration feed setting</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/gravity-forms/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:23:\"learndash-gravity-forms\";s:8:\"homepage\";s:43:\"https://learndash.com/add-on/gravity-forms/\";s:12:\"last_updated\";s:19:\"2021-10-20 00:00:00\";s:7:\"version\";s:5:\"2.1.2\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_256x256.jpg\";s:2:\"2x\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_256x256.jpg\";s:7:\"default\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:111:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_banner.jpg\";s:4:\"high\";s:111:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_banner.jpg\";s:7:\"default\";s:111:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"2.1.2\";s:4:\"file\";b:0;s:3:\"url\";s:246:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-gravity-forms&amp;_wpnonce=720dddb8ea&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:22:\"learndash-achievements\";a:30:{s:4:\"name\";s:22:\"LearnDash Achievements\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:51:\"https://learndash.com/add-on/learndash-achievements\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:22:\"learndash-achievements\";s:4:\"tags\";a:3:{i:0;s:12:\"achievements\";i:1;s:12:\"gamification\";i:2;s:6:\"awards\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.1.0\";s:17:\"short_description\";s:127:\"Create an awards program with achievements including badges awarded based on a number of both WordPress and LearnDash triggers.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:540:\"Create an awards program with achievements including badges awarded based on a number of both WordPress and LearnDash triggers.\r\n\r\nThis add-on enables you to create a gamification program to compell learners to keep on pushing through the course to get awarded with badges.\r\n\r\n= Add-on Features = \r\n\r\n* Award badges\r\n* WordPress and LearnDash triggers\r\n* Gutenberg blocks support for leaderboards and personal profile of awards earned.\r\n\r\nSee the [Add-on](https://learndash.com/add-on/learndash-achievements/) page for more information.\r\n\r\n\";s:7:\"content\";s:591:\"<p>Create an awards program with achievements including badges awarded based on a number of both WordPress and LearnDash triggers.</p>\n<p>This add-on enables you to create a gamification program to compell learners to keep on pushing through the course to get awarded with badges.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Award badges</li>\n<li>WordPress and LearnDash triggers</li>\n<li>Gutenberg blocks support for leaderboards and personal profile of awards earned.</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/learndash-achievements/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:812:\"= 1.1.0 =\r\n\r\n* Added group leaders can now see achievements of their students\r\n* Added users can now use achievement points to purchase a course \r\n* Added trigger for awarding an achievement if a quiz score is above a set percentage\r\n* Added restrict achievements to a specific LearnDash group\r\n* Updated the achievement image is now optional \r\n* Updated achievement badge icons can now be set to a larger size\r\n\r\n= 1.0.1 = \r\n\r\n* Updated occurrences to be on a per user basis rather than global\r\n* Fixed not being able to change or update the trigger once the achievement had been initially created\r\n* Fixed incorrect text domain on some strings\r\n* Fixed title not showing on hover\r\n\r\n= 1.0.0 = \r\n\r\n* Initial release\r\n\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/learndash-achievements/)\r\n\";s:7:\"content\";s:921:\"<h4>1.1.0</h4>\n<ul>\n<li>Added group leaders can now see achievements of their students</li>\n<li>Added users can now use achievement points to purchase a course </li>\n<li>Added trigger for awarding an achievement if a quiz score is above a set percentage</li>\n<li>Added restrict achievements to a specific LearnDash group</li>\n<li>Updated the achievement image is now optional </li>\n<li>\n<p>Updated achievement badge icons can now be set to a larger size</p>\n<h4>1.0.1</h4> \n</li>\n<li>Updated occurrences to be on a per user basis rather than global</li>\n<li>Fixed not being able to change or update the trigger once the achievement had been initially created</li>\n<li>Fixed incorrect text domain on some strings</li>\n<li>\n<p>Fixed title not showing on hover</p>\n<h4>1.0.0</h4> \n</li>\n<li>Initial release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/learndash-achievements/\">here</a></p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:591:\"<p>Create an awards program with achievements including badges awarded based on a number of both WordPress and LearnDash triggers.</p>\n<p>This add-on enables you to create a gamification program to compell learners to keep on pushing through the course to get awarded with badges.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Award badges</li>\n<li>WordPress and LearnDash triggers</li>\n<li>Gutenberg blocks support for leaderboards and personal profile of awards earned.</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/learndash-achievements/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:921:\"<h4>1.1.0</h4>\n<ul>\n<li>Added group leaders can now see achievements of their students</li>\n<li>Added users can now use achievement points to purchase a course </li>\n<li>Added trigger for awarding an achievement if a quiz score is above a set percentage</li>\n<li>Added restrict achievements to a specific LearnDash group</li>\n<li>Updated the achievement image is now optional </li>\n<li>\n<p>Updated achievement badge icons can now be set to a larger size</p>\n<h4>1.0.1</h4> \n</li>\n<li>Updated occurrences to be on a per user basis rather than global</li>\n<li>Fixed not being able to change or update the trigger once the achievement had been initially created</li>\n<li>Fixed incorrect text domain on some strings</li>\n<li>\n<p>Fixed title not showing on hover</p>\n<h4>1.0.0</h4> \n</li>\n<li>Initial release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/learndash-achievements/\">here</a></p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:22:\"learndash-achievements\";s:8:\"homepage\";s:51:\"https://learndash.com/add-on/learndash-achievements\";s:12:\"last_updated\";s:19:\"2021-09-30 00:00:00\";s:7:\"version\";s:5:\"1.1.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:2:\"2x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:4:\"high\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.1.0\";s:4:\"file\";b:0;s:3:\"url\";s:245:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-achievements&amp;_wpnonce=3d36d39f02&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}s:7:\"wp_slug\";s:49:\"learndash-achievements/learndash-achievements.php\";}s:21:\"learndash-memberpress\";a:29:{s:4:\"name\";s:25:\"MemberPress for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:41:\"https://learndash.com/add-on/memberpress/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:21:\"learndash-memberpress\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:10:\"membership\";i:2;s:11:\"memberpress\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:7:\"2.2.1.2\";s:17:\"short_description\";s:41:\"Integrate LearnDash LMS with MemberPress.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:673:\"Integrate LearnDash LMS with MemberPress.\r\n\r\nMemberPress is a premium WordPress membership plugin that excels in memberships, grouping, coupons, reminders, reports, and more.\r\n\r\nWith this integration you can create membership levels in MemberPress and associate the access levels to LearnDash courses. Customers are then auto-enrolled into courses after signing-up for membership.\r\n\r\n= Integration Features = \r\n\r\n* Associate membership levels to one or more courses\r\n* Automatic removal upon membership cancellation\r\n* Create trial membership levels with various payment gateways\r\n\r\nSee the [Add-on](https://learndash.com/add-on/memberpress/) page for more information.\r\n\r\n\";s:7:\"content\";s:728:\"<p>Integrate LearnDash LMS with MemberPress.</p>\n<p>MemberPress is a premium WordPress membership plugin that excels in memberships, grouping, coupons, reminders, reports, and more.</p>\n<p>With this integration you can create membership levels in MemberPress and associate the access levels to LearnDash courses. Customers are then auto-enrolled into courses after signing-up for membership.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Associate membership levels to one or more courses</li>\n<li>Automatic removal upon membership cancellation</li>\n<li>Create trial membership levels with various payment gateways</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/memberpress/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:1617:\"= 2.2.1.2 =\r\n\r\n* Fixed free trial subscriptions not enrolling users\r\n\r\n= 2.2.1.1 =\r\n\r\n* Updated set default retroactive process to 5 per batch\r\n* Fixed trial subscriptions not being enrolled in courses/groups\r\n\r\n= 2.2.1 =\r\n\r\n* Updated make retroactive notice dismissible\r\n* Fixed PHP 8 compatibility\r\n* Fixed undefined index error\r\n\r\n= 2.2.0 =\r\n\r\n* Added dependencies check\r\n* Added filter hook for retroactive tool per batch value\r\n* Added LD group support in retroactive tool\r\n* Added LearnDash group support\r\n* Added Groups selector in membership edit page and its saving function\r\n* Added warning notice when adding courses to a membership\r\n* Updated use only transaction data to decide user access in retroactive tool\r\n* Updated notice to set up server cron job if there are more than 5 courses/groups added in a membership\r\n* Updated select2 element focus styles\r\n* Updated change dropdown style\r\n* Updated change courses selector to select2 select field\r\n* Fixed incorrect string text domain resulting in untranslatable words\r\n* Fixed cron update course access reset course enrollment date to update time instead of transaction/subscription time\r\n* Fixed PHP warning\r\n* Fixed retroactive tool for old subscription integration\r\n\r\n= 2.1.1 =\r\n* Updated process course queue update 1 at a time\r\n* Updated make sure the returned membership associated courses value is unique\r\n* Fixed cron update course access run in batch for transactions and subscriptions to prevent timeout error\r\n* Fixed missing cron schedules filter parameter\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/memberpress/).\r\n\";s:7:\"content\";s:1823:\"<h4>2.2.1.2</h4>\n<ul>\n<li>\n<p>Fixed free trial subscriptions not enrolling users</p>\n<h4>2.2.1.1</h4>\n</li>\n<li>Updated set default retroactive process to 5 per batch</li>\n<li>\n<p>Fixed trial subscriptions not being enrolled in courses/groups</p>\n<h4>2.2.1</h4>\n</li>\n<li>Updated make retroactive notice dismissible</li>\n<li>Fixed PHP 8 compatibility</li>\n<li>\n<p>Fixed undefined index error</p>\n<h4>2.2.0</h4>\n</li>\n<li>Added dependencies check</li>\n<li>Added filter hook for retroactive tool per batch value</li>\n<li>Added LD group support in retroactive tool</li>\n<li>Added LearnDash group support</li>\n<li>Added Groups selector in membership edit page and its saving function</li>\n<li>Added warning notice when adding courses to a membership</li>\n<li>Updated use only transaction data to decide user access in retroactive tool</li>\n<li>Updated notice to set up server cron job if there are more than 5 courses/groups added in a membership</li>\n<li>Updated select2 element focus styles</li>\n<li>Updated change dropdown style</li>\n<li>Updated change courses selector to select2 select field</li>\n<li>Fixed incorrect string text domain resulting in untranslatable words</li>\n<li>Fixed cron update course access reset course enrollment date to update time instead of transaction/subscription time</li>\n<li>Fixed PHP warning</li>\n<li>Fixed retroactive tool for old subscription integration\n<h4>2.1.1</h4></li>\n<li>Updated process course queue update 1 at a time</li>\n<li>Updated make sure the returned membership associated courses value is unique</li>\n<li>Fixed cron update course access run in batch for transactions and subscriptions to prevent timeout error</li>\n<li>Fixed missing cron schedules filter parameter</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/memberpress/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:728:\"<p>Integrate LearnDash LMS with MemberPress.</p>\n<p>MemberPress is a premium WordPress membership plugin that excels in memberships, grouping, coupons, reminders, reports, and more.</p>\n<p>With this integration you can create membership levels in MemberPress and associate the access levels to LearnDash courses. Customers are then auto-enrolled into courses after signing-up for membership.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Associate membership levels to one or more courses</li>\n<li>Automatic removal upon membership cancellation</li>\n<li>Create trial membership levels with various payment gateways</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/memberpress/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:1823:\"<h4>2.2.1.2</h4>\n<ul>\n<li>\n<p>Fixed free trial subscriptions not enrolling users</p>\n<h4>2.2.1.1</h4>\n</li>\n<li>Updated set default retroactive process to 5 per batch</li>\n<li>\n<p>Fixed trial subscriptions not being enrolled in courses/groups</p>\n<h4>2.2.1</h4>\n</li>\n<li>Updated make retroactive notice dismissible</li>\n<li>Fixed PHP 8 compatibility</li>\n<li>\n<p>Fixed undefined index error</p>\n<h4>2.2.0</h4>\n</li>\n<li>Added dependencies check</li>\n<li>Added filter hook for retroactive tool per batch value</li>\n<li>Added LD group support in retroactive tool</li>\n<li>Added LearnDash group support</li>\n<li>Added Groups selector in membership edit page and its saving function</li>\n<li>Added warning notice when adding courses to a membership</li>\n<li>Updated use only transaction data to decide user access in retroactive tool</li>\n<li>Updated notice to set up server cron job if there are more than 5 courses/groups added in a membership</li>\n<li>Updated select2 element focus styles</li>\n<li>Updated change dropdown style</li>\n<li>Updated change courses selector to select2 select field</li>\n<li>Fixed incorrect string text domain resulting in untranslatable words</li>\n<li>Fixed cron update course access reset course enrollment date to update time instead of transaction/subscription time</li>\n<li>Fixed PHP warning</li>\n<li>Fixed retroactive tool for old subscription integration\n<h4>2.1.1</h4></li>\n<li>Updated process course queue update 1 at a time</li>\n<li>Updated make sure the returned membership associated courses value is unique</li>\n<li>Fixed cron update course access run in batch for transactions and subscriptions to prevent timeout error</li>\n<li>Fixed missing cron schedules filter parameter</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/memberpress/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:21:\"learndash-memberpress\";s:8:\"homepage\";s:41:\"https://learndash.com/add-on/memberpress/\";s:12:\"last_updated\";s:19:\"2021-09-22 00:00:00\";s:7:\"version\";s:7:\"2.2.1.2\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_256x256.jpg\";s:2:\"2x\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_256x256.jpg\";s:7:\"default\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_banner.jpg\";s:4:\"high\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_banner.jpg\";s:7:\"default\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:7:\"2.2.1.2\";s:4:\"file\";b:0;s:3:\"url\";s:244:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-memberpress&amp;_wpnonce=3e6d85242f&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:21:\"learndash-woocommerce\";a:30:{s:4:\"name\";s:25:\"WooCommerce for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:41:\"https://learndash.com/add-on/woocommerce/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:21:\"learndash-woocommerce\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:11:\"woocommerce\";i:2;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:7:\"1.9.3.3\";s:17:\"short_description\";s:41:\"Integrate LearnDash LMS with WooCommerce.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:592:\"Integrate LearnDash LMS with WooCommerce.\r\n\r\nWooCommerce is the most popular shopping cart software for WordPress. Most WordPress themes are compatible with WooCommerce. This add-on allows you to sell your LearnDash created courses with the WooCommerce shopping cart.\r\n\r\n= Integration Features = \r\n\r\n* Easily map courses to products\r\n* Associate one, or multiple courses to a single product\r\n* Automatic course access removal\r\n* Works with any payment gateway\r\n* Works with WooCommerce Subscription\r\n\r\nSee the [Add-on](https://learndash.com/add-on/woocommerce/) page for more information.\r\n\r\n\";s:7:\"content\";s:655:\"<p>Integrate LearnDash LMS with WooCommerce.</p>\n<p>WooCommerce is the most popular shopping cart software for WordPress. Most WordPress themes are compatible with WooCommerce. This add-on allows you to sell your LearnDash created courses with the WooCommerce shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easily map courses to products</li>\n<li>Associate one, or multiple courses to a single product</li>\n<li>Automatic course access removal</li>\n<li>Works with any payment gateway</li>\n<li>Works with WooCommerce Subscription</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/woocommerce/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:2100:\"= 1.9.3.3 =\r\n\r\n* Fixed checking logic to prevent errors\r\n\r\n= 1.9.3.2 =\r\n\r\n* Fixed Uncaught Error: Call to a member function get_type() on bool\r\n\r\n= 1.9.3.1 =\r\n\r\n* Fixed courses being added to users with the incorrect payment status. Courses are now only added on processing or complete rather than on hold or pending\r\n\r\n= 1.9.3 = \r\n\r\n* Added new added order item to existing order will trigger course enrollment\r\n* Fixed retroactive tool and some variables are not compatible with WC 5.6\r\n* Fixed retroactive tool doesn\'t honor the expired subscription course removal setting\r\n* Fixed renewal subscription payment reset access date for expired courses\r\n\r\n= 1.9.2 = \r\n\r\n* Updated use global variable instead of debug backtrace to enable subscription products filter  \r\n* Fixed conflict with WooCommerce product bundle extension, better code logic                                                                                      \r\n* Fixed typo in get_type method name\r\n\r\n= 1.9.1 = \r\n\r\n* Added a setting to skip disabling course access on subscription expiry\r\n* Added an action hook to remove course access for failed and cancelled subscriptions\r\n* Fixed subscription renewal changing the course enrollment date\r\n* Fixed pricing fields missing on the product edit page\r\n\r\n= 1.9.0 =\r\n\r\n* Added dependencies check\r\n* Added WPML multi language course selector support\r\n* Added background course enrollment warning above course selector field\r\n* Added WC subscription switching feature support\r\n* Updated allow retroactive tool to process course enrollment directly instead of storing the queue in DB\r\n* Updated remove old code that process retroactive tool using cron\r\n* Updated change learndash_woocommerce_silent_course_enrollment_queue option to be non autoload to improve performance\r\n* Updated Use custom label if set\r\n* Fixed renewal process unenroll and reenroll users to courses\r\n* Fixed PHP notice error because of deprecated class property\r\n* Fixed retroactive tool reset enrollment date to the tool run date\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/woocommerce/).\r\n\";s:7:\"content\";s:2331:\"<h4>1.9.3.3</h4>\n<ul>\n<li>\n<p>Fixed checking logic to prevent errors</p>\n<h4>1.9.3.2</h4>\n</li>\n<li>\n<p>Fixed Uncaught Error: Call to a member function get_type() on bool</p>\n<h4>1.9.3.1</h4>\n</li>\n<li>\n<p>Fixed courses being added to users with the incorrect payment status. Courses are now only added on processing or complete rather than on hold or pending</p>\n<h4>1.9.3</h4> \n</li>\n<li>Added new added order item to existing order will trigger course enrollment</li>\n<li>Fixed retroactive tool and some variables are not compatible with WC 5.6</li>\n<li>Fixed retroactive tool doesn\'t honor the expired subscription course removal setting</li>\n<li>\n<p>Fixed renewal subscription payment reset access date for expired courses</p>\n<h4>1.9.2</h4> \n</li>\n<li>Updated use global variable instead of debug backtrace to enable subscription products filter  </li>\n<li>Fixed conflict with WooCommerce product bundle extension, better code logic                                                                                      </li>\n<li>\n<p>Fixed typo in get_type method name</p>\n<h4>1.9.1</h4> \n</li>\n<li>Added a setting to skip disabling course access on subscription expiry</li>\n<li>Added an action hook to remove course access for failed and cancelled subscriptions</li>\n<li>Fixed subscription renewal changing the course enrollment date</li>\n<li>\n<p>Fixed pricing fields missing on the product edit page</p>\n<h4>1.9.0</h4>\n</li>\n<li>Added dependencies check</li>\n<li>Added WPML multi language course selector support</li>\n<li>Added background course enrollment warning above course selector field</li>\n<li>Added WC subscription switching feature support</li>\n<li>Updated allow retroactive tool to process course enrollment directly instead of storing the queue in DB</li>\n<li>Updated remove old code that process retroactive tool using cron</li>\n<li>Updated change learndash_woocommerce_silent_course_enrollment_queue option to be non autoload to improve performance</li>\n<li>Updated Use custom label if set</li>\n<li>Fixed renewal process unenroll and reenroll users to courses</li>\n<li>Fixed PHP notice error because of deprecated class property</li>\n<li>Fixed retroactive tool reset enrollment date to the tool run date</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/woocommerce/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:655:\"<p>Integrate LearnDash LMS with WooCommerce.</p>\n<p>WooCommerce is the most popular shopping cart software for WordPress. Most WordPress themes are compatible with WooCommerce. This add-on allows you to sell your LearnDash created courses with the WooCommerce shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easily map courses to products</li>\n<li>Associate one, or multiple courses to a single product</li>\n<li>Automatic course access removal</li>\n<li>Works with any payment gateway</li>\n<li>Works with WooCommerce Subscription</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/woocommerce/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:2331:\"<h4>1.9.3.3</h4>\n<ul>\n<li>\n<p>Fixed checking logic to prevent errors</p>\n<h4>1.9.3.2</h4>\n</li>\n<li>\n<p>Fixed Uncaught Error: Call to a member function get_type() on bool</p>\n<h4>1.9.3.1</h4>\n</li>\n<li>\n<p>Fixed courses being added to users with the incorrect payment status. Courses are now only added on processing or complete rather than on hold or pending</p>\n<h4>1.9.3</h4> \n</li>\n<li>Added new added order item to existing order will trigger course enrollment</li>\n<li>Fixed retroactive tool and some variables are not compatible with WC 5.6</li>\n<li>Fixed retroactive tool doesn\'t honor the expired subscription course removal setting</li>\n<li>\n<p>Fixed renewal subscription payment reset access date for expired courses</p>\n<h4>1.9.2</h4> \n</li>\n<li>Updated use global variable instead of debug backtrace to enable subscription products filter  </li>\n<li>Fixed conflict with WooCommerce product bundle extension, better code logic                                                                                      </li>\n<li>\n<p>Fixed typo in get_type method name</p>\n<h4>1.9.1</h4> \n</li>\n<li>Added a setting to skip disabling course access on subscription expiry</li>\n<li>Added an action hook to remove course access for failed and cancelled subscriptions</li>\n<li>Fixed subscription renewal changing the course enrollment date</li>\n<li>\n<p>Fixed pricing fields missing on the product edit page</p>\n<h4>1.9.0</h4>\n</li>\n<li>Added dependencies check</li>\n<li>Added WPML multi language course selector support</li>\n<li>Added background course enrollment warning above course selector field</li>\n<li>Added WC subscription switching feature support</li>\n<li>Updated allow retroactive tool to process course enrollment directly instead of storing the queue in DB</li>\n<li>Updated remove old code that process retroactive tool using cron</li>\n<li>Updated change learndash_woocommerce_silent_course_enrollment_queue option to be non autoload to improve performance</li>\n<li>Updated Use custom label if set</li>\n<li>Fixed renewal process unenroll and reenroll users to courses</li>\n<li>Fixed PHP notice error because of deprecated class property</li>\n<li>Fixed retroactive tool reset enrollment date to the tool run date</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/woocommerce/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:21:\"learndash-woocommerce\";s:8:\"homepage\";s:41:\"https://learndash.com/add-on/woocommerce/\";s:12:\"last_updated\";s:19:\"2021-09-15 00:00:00\";s:7:\"version\";s:7:\"1.9.3.3\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_256x256.jpg\";s:2:\"2x\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_256x256.jpg\";s:7:\"default\";s:110:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_banner.jpg\";s:4:\"high\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_banner.jpg\";s:7:\"default\";s:109:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:16:\"latest_installed\";s:3:\"url\";b:0;s:7:\"version\";b:0;s:4:\"file\";s:47:\"learndash-woocommerce/learndash_woocommerce.php\";}s:7:\"wp_slug\";s:47:\"learndash-woocommerce/learndash_woocommerce.php\";}s:17:\"learndash-samcart\";a:29:{s:4:\"name\";s:35:\"LearnDash LMS - Samcart Integration\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:41:\"https://www.learndash.com/add-on/samcart/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:17:\"learndash-samcart\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:7:\"samcart\";i:2;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.1.0\";s:17:\"short_description\";s:38:\"Integrates LearnDash LMS with Samcart.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:566:\"Integrate LearnDash LMS with Samcart.\r\n\r\nSamCart is a hosted shopping cart built by marketers, for marketers. It is optimized for conversions so as to increase your total revenue. This integration makes it possible to sell LearnDash courses with this high-converting shopping cart.\r\n\r\n= Integration Features = \r\n\r\n* Automatic account creation\r\n* Easily map courses\r\n* Associate one, or multiple courses\r\n* Works with any SamCart payment gateway\r\n* Works with Subscriptions\r\n\r\nSee the [Add-on](https://www.learndash.com/add-on/samcart/) page for more information.\r\n\r\n\";s:7:\"content\";s:629:\"<p>Integrate LearnDash LMS with Samcart.</p>\n<p>SamCart is a hosted shopping cart built by marketers, for marketers. It is optimized for conversions so as to increase your total revenue. This integration makes it possible to sell LearnDash courses with this high-converting shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Automatic account creation</li>\n<li>Easily map courses</li>\n<li>Associate one, or multiple courses</li>\n<li>Works with any SamCart payment gateway</li>\n<li>Works with Subscriptions</li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/add-on/samcart/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:237:\"= 1.1.0 =\r\n\r\n* Added filter hook to control process_notification_url\r\n* Added dependency check\r\n* Fixed undefined index error\r\n\r\n= 1.0 =\r\n\r\n* Initial Release\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/samcart/).\r\n\";s:7:\"content\";s:297:\"<h4>1.1.0</h4>\n<ul>\n<li>Added filter hook to control process_notification_url</li>\n<li>Added dependency check</li>\n<li>\n<p>Fixed undefined index error</p>\n<h4>1.0</h4>\n</li>\n<li>Initial Release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/samcart/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:629:\"<p>Integrate LearnDash LMS with Samcart.</p>\n<p>SamCart is a hosted shopping cart built by marketers, for marketers. It is optimized for conversions so as to increase your total revenue. This integration makes it possible to sell LearnDash courses with this high-converting shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Automatic account creation</li>\n<li>Easily map courses</li>\n<li>Associate one, or multiple courses</li>\n<li>Works with any SamCart payment gateway</li>\n<li>Works with Subscriptions</li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/add-on/samcart/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:297:\"<h4>1.1.0</h4>\n<ul>\n<li>Added filter hook to control process_notification_url</li>\n<li>Added dependency check</li>\n<li>\n<p>Fixed undefined index error</p>\n<h4>1.0</h4>\n</li>\n<li>Initial Release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/samcart/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:17:\"learndash-samcart\";s:8:\"homepage\";s:41:\"https://www.learndash.com/add-on/samcart/\";s:12:\"last_updated\";s:19:\"2021-09-15 00:00:00\";s:7:\"version\";s:5:\"1.1.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_256x256.jpg\";s:2:\"2x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_256x256.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_banner.jpg\";s:4:\"high\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_banner.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.1.0\";s:4:\"file\";b:0;s:3:\"url\";s:240:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-samcart&amp;_wpnonce=08f0bcd692&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:13:\"learndash-edd\";a:29:{s:4:\"name\";s:17:\"EDD for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:52:\"https://learndash.com/add-on/easy-digital-downloads/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:13:\"learndash-edd\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:10:\"membership\";i:2;s:3:\"edd\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.3.0\";s:17:\"short_description\";s:53:\"Integrates LearnDash LMS with Easy Digital Downloads.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:520:\"Integrate LearnDash LMS with Easy Digital Downloads.\r\n\r\nEasy Digital Downloads is a popular shopping cart for WordPress with over 400,000 downloads. This integration makes it possible to sell LearnDash created courses using the Easy Digital Downloads shopping cart.\r\n\r\n= Integration Features = \r\n\r\n* Easy course mapping\r\n* Associate one, or multiple courses\r\n* Auto-User Enrollment\r\n* Works with any payment gateway\r\n\r\nSee the [Add-on](https://learndash.com/add-on/easy-digital-downloads/) page for more information.\r\n\r\n\";s:7:\"content\";s:577:\"<p>Integrate LearnDash LMS with Easy Digital Downloads.</p>\n<p>Easy Digital Downloads is a popular shopping cart for WordPress with over 400,000 downloads. This integration makes it possible to sell LearnDash created courses using the Easy Digital Downloads shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easy course mapping</li>\n<li>Associate one, or multiple courses</li>\n<li>Auto-User Enrollment</li>\n<li>Works with any payment gateway</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/easy-digital-downloads/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:637:\"= 1.3.0 =\r\n\r\n* Added LearnDash group support \r\n* Updated user course access is attched to each product rather than the overall order allowing refunds of individual products whilst retaining access to others\r\n* Updated updating product’s related courses will update existing customers course access\r\n* Fixed PHP warnings \r\n* Fixed broken metabox styling\r\n\r\n= 1.2.0 =\r\n\r\n* Added a check on expired transaction status when removing course access\r\n* Fixed users not being unenrolled on payment status change\r\n* Fixed course unenrollment issue\r\n\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/easy-digital-downloads/).\r\n\";s:7:\"content\";s:719:\"<h4>1.3.0</h4>\n<ul>\n<li>Added LearnDash group support </li>\n<li>Updated user course access is attched to each product rather than the overall order allowing refunds of individual products whilst retaining access to others</li>\n<li>Updated updating product’s related courses will update existing customers course access</li>\n<li>Fixed PHP warnings </li>\n<li>\n<p>Fixed broken metabox styling</p>\n<h4>1.2.0</h4>\n</li>\n<li>Added a check on expired transaction status when removing course access</li>\n<li>Fixed users not being unenrolled on payment status change</li>\n<li>Fixed course unenrollment issue</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/easy-digital-downloads/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:577:\"<p>Integrate LearnDash LMS with Easy Digital Downloads.</p>\n<p>Easy Digital Downloads is a popular shopping cart for WordPress with over 400,000 downloads. This integration makes it possible to sell LearnDash created courses using the Easy Digital Downloads shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easy course mapping</li>\n<li>Associate one, or multiple courses</li>\n<li>Auto-User Enrollment</li>\n<li>Works with any payment gateway</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/easy-digital-downloads/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:719:\"<h4>1.3.0</h4>\n<ul>\n<li>Added LearnDash group support </li>\n<li>Updated user course access is attched to each product rather than the overall order allowing refunds of individual products whilst retaining access to others</li>\n<li>Updated updating product’s related courses will update existing customers course access</li>\n<li>Fixed PHP warnings </li>\n<li>\n<p>Fixed broken metabox styling</p>\n<h4>1.2.0</h4>\n</li>\n<li>Added a check on expired transaction status when removing course access</li>\n<li>Fixed users not being unenrolled on payment status change</li>\n<li>Fixed course unenrollment issue</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/easy-digital-downloads/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:13:\"learndash-edd\";s:8:\"homepage\";s:52:\"https://learndash.com/add-on/easy-digital-downloads/\";s:12:\"last_updated\";s:19:\"2021-08-25 00:00:00\";s:7:\"version\";s:5:\"1.3.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:102:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_256x256.jpg\";s:2:\"2x\";s:102:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_256x256.jpg\";s:7:\"default\";s:102:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:101:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_banner.jpg\";s:4:\"high\";s:101:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_banner.jpg\";s:7:\"default\";s:101:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.3.0\";s:4:\"file\";b:0;s:3:\"url\";s:236:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-edd&amp;_wpnonce=417bb73d55&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:23:\"learndash-notifications\";a:29:{s:4:\"name\";s:23:\"LearnDash Notifications\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:53:\"https://learndash.com/add-on/learndash-notifications/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:23:\"learndash-notifications\";s:4:\"tags\";a:2:{i:0;s:13:\"notifications\";i:1;s:6:\"emails\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.5.3\";s:17:\"short_description\";s:52:\"Send email notifications based on LearnDash actions.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:625:\"Send email notifications based on LearnDash actions.\r\n\r\nThis add-on enables a new level of learner engagement within your LearnDash courses. Configure various notifications to be sent out automatically based on what learners do (and do not do) in a course.\r\n\r\nThis is a perfect tool for bolstering learner engagement, encouragement, promotions, and cross-selling.\r\n\r\n= Add-on Features = \r\n\r\n* Automatically Send Notifications\r\n* 13 Available Triggers\r\n* 34 Dynamic Shortcodes\r\n* Delay Notifications\r\n* Choose Recipients\r\n\r\nSee the [Add-on](https://learndash.com/add-on/learndash-notifications/) page for more information.\r\n\r\n\";s:7:\"content\";s:692:\"<p>Send email notifications based on LearnDash actions.</p>\n<p>This add-on enables a new level of learner engagement within your LearnDash courses. Configure various notifications to be sent out automatically based on what learners do (and do not do) in a course.</p>\n<p>This is a perfect tool for bolstering learner engagement, encouragement, promotions, and cross-selling.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Automatically Send Notifications</li>\n<li>13 Available Triggers</li>\n<li>34 Dynamic Shortcodes</li>\n<li>Delay Notifications</li>\n<li>Choose Recipients</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/learndash-notifications/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:1954:\"= 1.5.3 =\r\n\r\n* Added a filter to switch the notification content to RTL learndash_notifications_email_rtl\r\n* Updated the trigger \"user hasn\'t logged in for X days\" to group the emails into one rather than sending out mass separate emails\r\n* Fixed Notification for drip lesson doesn\'t update the send time if enrollment date gets changed\r\n* Fixed PHP warnings/notices\r\n\r\n= 1.5.2 =\r\n\r\n* Fixed issue where when a quiz notification was set in some rare instances this prevented the student from being able to complete the quiz\r\n\r\n= 1.5.1 = \r\n\r\n* Added ability to chose if the notification should only send one time or recurring for the trigger “User hasn’t logged In for “X” days\r\n* Fixed email sending issue with group leaders\r\n* Fixed emails sending in bulk on updating \r\n\r\n= 1.5.0 = \r\n\r\n* Added notifications can now be updated after they have been saved\r\n* Added duration unit can now be minutes, hours, and days\r\n* Updated the triggers codebase to improve notifications sending system\r\n* Updated the log screen to make it easier to track what is happening within the system\r\n* Removed the every minute cron and replaced with a single scheduled event to check rather than running blind checks\r\n\r\n= 1.4.1 =\r\n\r\n* Updated delay field unchangeable for edit to prevent issue with delayed emails\r\n* Updated use of global delete function instead of create new queries in delete functions\r\n* Updated remove `learndash_notifications_delete_delayed_emails_when_unenrolled` hooked function because it already exists in `includes/database.php`\r\n* Updated use of `learndash_get_users_for_course()` to pull course users instead of access list meta only\r\n* Fixed lesson available notification not queueing multiple notifications in DB if there are more than 1 notifications posts\r\n* Fixed regex pattern for searching notifications by shortcode data key value pair\r\n\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/learndash-notifications/).\r\n\";s:7:\"content\";s:2172:\"<h4>1.5.3</h4>\n<ul>\n<li>Added a filter to switch the notification content to RTL learndash_notifications_email_rtl</li>\n<li>Updated the trigger &quot;user hasn\'t logged in for X days&quot; to group the emails into one rather than sending out mass separate emails</li>\n<li>Fixed Notification for drip lesson doesn\'t update the send time if enrollment date gets changed</li>\n<li>\n<p>Fixed PHP warnings/notices</p>\n<h4>1.5.2</h4>\n</li>\n<li>\n<p>Fixed issue where when a quiz notification was set in some rare instances this prevented the student from being able to complete the quiz</p>\n<h4>1.5.1</h4> \n</li>\n<li>Added ability to chose if the notification should only send one time or recurring for the trigger “User hasn’t logged In for “X” days</li>\n<li>Fixed email sending issue with group leaders</li>\n<li>\n<p>Fixed emails sending in bulk on updating </p>\n<h4>1.5.0</h4> \n</li>\n<li>Added notifications can now be updated after they have been saved</li>\n<li>Added duration unit can now be minutes, hours, and days</li>\n<li>Updated the triggers codebase to improve notifications sending system</li>\n<li>Updated the log screen to make it easier to track what is happening within the system</li>\n<li>\n<p>Removed the every minute cron and replaced with a single scheduled event to check rather than running blind checks</p>\n<h4>1.4.1</h4>\n</li>\n<li>Updated delay field unchangeable for edit to prevent issue with delayed emails</li>\n<li>Updated use of global delete function instead of create new queries in delete functions</li>\n<li>Updated remove <code>learndash_notifications_delete_delayed_emails_when_unenrolled</code> hooked function because it already exists in <code>includes/database.php</code></li>\n<li>Updated use of <code>learndash_get_users_for_course()</code> to pull course users instead of access list meta only</li>\n<li>Fixed lesson available notification not queueing multiple notifications in DB if there are more than 1 notifications posts</li>\n<li>Fixed regex pattern for searching notifications by shortcode data key value pair</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/learndash-notifications/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:692:\"<p>Send email notifications based on LearnDash actions.</p>\n<p>This add-on enables a new level of learner engagement within your LearnDash courses. Configure various notifications to be sent out automatically based on what learners do (and do not do) in a course.</p>\n<p>This is a perfect tool for bolstering learner engagement, encouragement, promotions, and cross-selling.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Automatically Send Notifications</li>\n<li>13 Available Triggers</li>\n<li>34 Dynamic Shortcodes</li>\n<li>Delay Notifications</li>\n<li>Choose Recipients</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/learndash-notifications/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:2172:\"<h4>1.5.3</h4>\n<ul>\n<li>Added a filter to switch the notification content to RTL learndash_notifications_email_rtl</li>\n<li>Updated the trigger &quot;user hasn\'t logged in for X days&quot; to group the emails into one rather than sending out mass separate emails</li>\n<li>Fixed Notification for drip lesson doesn\'t update the send time if enrollment date gets changed</li>\n<li>\n<p>Fixed PHP warnings/notices</p>\n<h4>1.5.2</h4>\n</li>\n<li>\n<p>Fixed issue where when a quiz notification was set in some rare instances this prevented the student from being able to complete the quiz</p>\n<h4>1.5.1</h4> \n</li>\n<li>Added ability to chose if the notification should only send one time or recurring for the trigger “User hasn’t logged In for “X” days</li>\n<li>Fixed email sending issue with group leaders</li>\n<li>\n<p>Fixed emails sending in bulk on updating </p>\n<h4>1.5.0</h4> \n</li>\n<li>Added notifications can now be updated after they have been saved</li>\n<li>Added duration unit can now be minutes, hours, and days</li>\n<li>Updated the triggers codebase to improve notifications sending system</li>\n<li>Updated the log screen to make it easier to track what is happening within the system</li>\n<li>\n<p>Removed the every minute cron and replaced with a single scheduled event to check rather than running blind checks</p>\n<h4>1.4.1</h4>\n</li>\n<li>Updated delay field unchangeable for edit to prevent issue with delayed emails</li>\n<li>Updated use of global delete function instead of create new queries in delete functions</li>\n<li>Updated remove <code>learndash_notifications_delete_delayed_emails_when_unenrolled</code> hooked function because it already exists in <code>includes/database.php</code></li>\n<li>Updated use of <code>learndash_get_users_for_course()</code> to pull course users instead of access list meta only</li>\n<li>Fixed lesson available notification not queueing multiple notifications in DB if there are more than 1 notifications posts</li>\n<li>Fixed regex pattern for searching notifications by shortcode data key value pair</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/learndash-notifications/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:23:\"learndash-notifications\";s:8:\"homepage\";s:53:\"https://learndash.com/add-on/learndash-notifications/\";s:12:\"last_updated\";s:19:\"2021-08-18 00:00:00\";s:7:\"version\";s:5:\"1.5.3\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_256x256.jpg\";s:2:\"2x\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_256x256.jpg\";s:7:\"default\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:111:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_banner.jpg\";s:4:\"high\";s:111:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_banner.jpg\";s:7:\"default\";s:111:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.5.3\";s:4:\"file\";b:0;s:3:\"url\";s:246:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-notifications&amp;_wpnonce=75a4e88df3&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:29:\"learndash-certificate-builder\";a:29:{s:4:\"name\";s:29:\"LearnDash Certificate Builder\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:48:\"https://learndash.com/add-on/certificate-builder\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:29:\"learndash-certificate-builder\";s:4:\"tags\";a:3:{i:0;s:12:\"certificates\";i:1;s:19:\"course certificates\";i:2;s:17:\"quiz certificates\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.0.3\";s:17:\"short_description\";s:53:\"Create certificates using the Gutenberg block editor.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:497:\"Create certificates using the Gutenberg block editor.\r\n\r\nThis add-on enables a new level of certificate creation utilizing the WordPress block editor to give you a real time visual drag and drop interface for building your certificates quickly and easily.\r\n\r\n= Add-on Features = \r\n\r\n* Drag and drop certificate builder\r\n* Compatible with all standard Gutenberg features\r\n* Live preview available\r\n\r\nSee the [Add-on](https://learndash.com/add-on/certificate-builder/) page for more information.\r\n\r\n\";s:7:\"content\";s:548:\"<p>Create certificates using the Gutenberg block editor.</p>\n<p>This add-on enables a new level of certificate creation utilizing the WordPress block editor to give you a real time visual drag and drop interface for building your certificates quickly and easily.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Drag and drop certificate builder</li>\n<li>Compatible with all standard Gutenberg features</li>\n<li>Live preview available</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/certificate-builder/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:684:\"= 1.0.3 =\r\n\r\n* Added support for WordPress 5.8\r\n* Fixed font conflict with the Gutenberg plugin\r\n\r\n= 1.0.2 = \r\n\r\n* Fixed error background image is missing when a relative protocol was used or the site address did match the forced protocol set (http/https)\r\n* Fixed prevent cert builder type column duplication\r\n\r\n= 1.0.1 =\r\n\r\n* Added support for the Leardash Quizinfo block\r\n* Fixed error when trying to use a custom font\r\n* Fixed columns background color doesn\'t display in certificate PDF\r\n* Fixed PHP warning about LD_CERTIFICATE_BUILDER_CONTAINER_WIDTH\r\n\r\n= 1.0.0 = \r\n\r\n* Initial release\r\n\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/certificate-builder/)\r\n\";s:7:\"content\";s:790:\"<h4>1.0.3</h4>\n<ul>\n<li>Added support for WordPress 5.8</li>\n<li>\n<p>Fixed font conflict with the Gutenberg plugin</p>\n<h4>1.0.2</h4> \n</li>\n<li>Fixed error background image is missing when a relative protocol was used or the site address did match the forced protocol set (http/https)</li>\n<li>\n<p>Fixed prevent cert builder type column duplication</p>\n<h4>1.0.1</h4>\n</li>\n<li>Added support for the Leardash Quizinfo block</li>\n<li>Fixed error when trying to use a custom font</li>\n<li>Fixed columns background color doesn\'t display in certificate PDF</li>\n<li>\n<p>Fixed PHP warning about LD_CERTIFICATE_BUILDER_CONTAINER_WIDTH</p>\n<h4>1.0.0</h4> \n</li>\n<li>Initial release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/certificate-builder/\">here</a></p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:548:\"<p>Create certificates using the Gutenberg block editor.</p>\n<p>This add-on enables a new level of certificate creation utilizing the WordPress block editor to give you a real time visual drag and drop interface for building your certificates quickly and easily.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Drag and drop certificate builder</li>\n<li>Compatible with all standard Gutenberg features</li>\n<li>Live preview available</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/certificate-builder/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:790:\"<h4>1.0.3</h4>\n<ul>\n<li>Added support for WordPress 5.8</li>\n<li>\n<p>Fixed font conflict with the Gutenberg plugin</p>\n<h4>1.0.2</h4> \n</li>\n<li>Fixed error background image is missing when a relative protocol was used or the site address did match the forced protocol set (http/https)</li>\n<li>\n<p>Fixed prevent cert builder type column duplication</p>\n<h4>1.0.1</h4>\n</li>\n<li>Added support for the Leardash Quizinfo block</li>\n<li>Fixed error when trying to use a custom font</li>\n<li>Fixed columns background color doesn\'t display in certificate PDF</li>\n<li>\n<p>Fixed PHP warning about LD_CERTIFICATE_BUILDER_CONTAINER_WIDTH</p>\n<h4>1.0.0</h4> \n</li>\n<li>Initial release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/certificate-builder/\">here</a></p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:29:\"learndash-certificate-builder\";s:8:\"homepage\";s:48:\"https://learndash.com/add-on/certificate-builder\";s:12:\"last_updated\";s:19:\"2021-07-12 00:00:00\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.8\";s:5:\"icons\";a:3:{s:2:\"1x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:2:\"2x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:4:\"high\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.0.3\";s:4:\"file\";b:0;s:3:\"url\";s:252:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-certificate-builder&amp;_wpnonce=3355a4cb36&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:19:\"learndash-2checkout\";a:29:{s:4:\"name\";s:23:\"2Checkout for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:39:\"https://learndash.com/add-on/2checkout/\";s:20:\"ld_requires_at_least\";s:5:\"2.5.0\";s:4:\"slug\";s:19:\"learndash-2checkout\";s:4:\"tags\";a:2:{i:0;s:15:\"payment gateway\";i:1;s:9:\"2checkout\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:3:\"5.7\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:7:\"1.1.1.1\";s:17:\"short_description\";s:51:\"Integrate 2checkout payment gateway with LearnDash.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:442:\"Integrate 2checkout payment gateway with LearnDash.\r\n\r\nUsing this add-on, you can quickly and easily accept payments using the 2CheckOut payment gateway. Use it with PayPal, or just use 2CheckOut the choice is yours!\r\n\r\n= Integration Features = \r\n\r\n* Use 2Checkout to sell courses\r\n* Automatically delivers username and password\r\n* Hassle-free set-up\r\n\r\nSee the [Add-on](https://learndash.com/add-on/2checkout/) page for more information.\r\n\r\n\";s:7:\"content\";s:493:\"<p>Integrate 2checkout payment gateway with LearnDash.</p>\n<p>Using this add-on, you can quickly and easily accept payments using the 2CheckOut payment gateway. Use it with PayPal, or just use 2CheckOut the choice is yours!</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Use 2Checkout to sell courses</li>\n<li>Automatically delivers username and password</li>\n<li>Hassle-free set-up</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/2checkout/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:591:\"= 1.1.1.1 =\r\n\r\n* Updated security review changes\r\n\r\n= 1.1.1 =\r\n\r\n* Added LearnDash group purchasing support\r\n* Updated 2Checkout INS secret link and buy settings for compatibility\r\n* Updated to latest 2Checkout Sandbox mode support\r\n* Fixed transactions not validating \r\n\r\n= 1.1.0 =\r\n\r\n* Added language directory and POT file\r\n* Updated setting field text and description\r\n* Updated disable attribute to readonly for 2checkout approved URL field\r\n* Updated to send new user notification to both user and admin\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/2checkout/).\r\n\";s:7:\"content\";s:690:\"<h4>1.1.1.1</h4>\n<ul>\n<li>\n<p>Updated security review changes</p>\n<h4>1.1.1</h4>\n</li>\n<li>Added LearnDash group purchasing support</li>\n<li>Updated 2Checkout INS secret link and buy settings for compatibility</li>\n<li>Updated to latest 2Checkout Sandbox mode support</li>\n<li>\n<p>Fixed transactions not validating </p>\n<h4>1.1.0</h4>\n</li>\n<li>Added language directory and POT file</li>\n<li>Updated setting field text and description</li>\n<li>Updated disable attribute to readonly for 2checkout approved URL field</li>\n<li>Updated to send new user notification to both user and admin</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/2checkout/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:493:\"<p>Integrate 2checkout payment gateway with LearnDash.</p>\n<p>Using this add-on, you can quickly and easily accept payments using the 2CheckOut payment gateway. Use it with PayPal, or just use 2CheckOut the choice is yours!</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Use 2Checkout to sell courses</li>\n<li>Automatically delivers username and password</li>\n<li>Hassle-free set-up</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/2checkout/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:690:\"<h4>1.1.1.1</h4>\n<ul>\n<li>\n<p>Updated security review changes</p>\n<h4>1.1.1</h4>\n</li>\n<li>Added LearnDash group purchasing support</li>\n<li>Updated 2Checkout INS secret link and buy settings for compatibility</li>\n<li>Updated to latest 2Checkout Sandbox mode support</li>\n<li>\n<p>Fixed transactions not validating </p>\n<h4>1.1.0</h4>\n</li>\n<li>Added language directory and POT file</li>\n<li>Updated setting field text and description</li>\n<li>Updated disable attribute to readonly for 2checkout approved URL field</li>\n<li>Updated to send new user notification to both user and admin</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/2checkout/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:19:\"learndash-2checkout\";s:8:\"homepage\";s:39:\"https://learndash.com/add-on/2checkout/\";s:12:\"last_updated\";s:19:\"2021-06-08 00:00:00\";s:7:\"version\";s:7:\"1.1.1.1\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:3:\"5.7\";s:5:\"icons\";a:3:{s:2:\"1x\";s:108:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_256x256.jpg\";s:2:\"2x\";s:108:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_256x256.jpg\";s:7:\"default\";s:108:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:107:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_banner.jpg\";s:4:\"high\";s:107:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_banner.jpg\";s:7:\"default\";s:107:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:7:\"1.1.1.1\";s:4:\"file\";b:0;s:3:\"url\";s:242:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-2checkout&amp;_wpnonce=94feb66de4&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:25:\"learndash-propanel-readme\";a:31:{s:4:\"name\";s:21:\"ProPanel by LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:44:\"https://learndash.com/propanel-by-learndash/\";s:20:\"ld_requires_at_least\";s:5:\"2.4.0\";s:4:\"slug\";s:18:\"learndash-propanel\";s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:5:\"5.7.1\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:7:\"2.1.4.1\";s:11:\"last_update\";s:10:\"2021-05-12\";s:17:\"short_description\";s:51:\"Easily manage and view your LearnDash LMS activity.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:372:\"Easily manage and view your LearnDash LMS activity.\r\n\r\nProPanel enhances your LearnDash admin experience by consolidating reporting and assignment management, giving you the ability to send course specific communications, and showing real-time activity of your courses!\r\n\r\nSee the [Features](https://www.learndash.com/propanel-by-learndash/) page for more information.\r\n\r\n\";s:7:\"content\";s:394:\"<p>Easily manage and view your LearnDash LMS activity.</p>\n<p>ProPanel enhances your LearnDash admin experience by consolidating reporting and assignment management, giving you the ability to send course specific communications, and showing real-time activity of your courses!</p>\n<p>See the <a href=\"https://www.learndash.com/propanel-by-learndash/\">Features</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:483:\"If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of ProPanel.\r\n1. Download the latest version of ProPanel from our [support site](https://support.learndash.com/articles/my-downloads/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the ProPanel plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:529:\"<p>If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of ProPanel.</li>\n<li>Download the latest version of ProPanel from our <a href=\"https://support.learndash.com/articles/my-downloads/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the ProPanel plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:1155:\"= 2.1.4.1 =\r\n\r\n* Added progress icon on front end when reports are displayed \r\n* Fixed latex not rendering on quiz stats when accessed from ProPanel widget\r\n* Fixed time format with timezone not working on start/end dates\r\n* Fixed SQL error missing syntax for multisite\r\n* Fixed in progress/not started filters not showing data when start date filter is set \r\n* Fixed PHP 8 deprecation notices\r\n* Fixed reporting widget not working without filtering widget \r\n* Fixed email sending message never goes away\r\n* Fixed selected hour not showing in new start/end filters\r\n* Fixed date picker format \r\n\r\n= 2.1.4 = \r\n\r\n* Added Filter by dates\r\n* Added RTL support\r\n* Fixed ProPanel Reporting widget not updating\r\n* Fixed Users results stats not showing in dashboard\r\n* Fixed 403 errors \r\n* Fixed ProPanel translation issues\r\n* Fixed Issue with LearnDash shortcodes when ProPanel is activated\r\n* Fixed Error on quiz statistics loading on front-end from ProPanel activity widget\r\n\r\n= 2.1.3.1 =\r\n\r\n* Updated license and update calls to use SSL for secure connections.\r\n\r\nView our full changelog [here](https://support.learndash.com/articles/propanel-changelog/).\r\n\r\n\";s:7:\"content\";s:1312:\"<h4>2.1.4.1</h4>\n<ul>\n<li>Added progress icon on front end when reports are displayed </li>\n<li>Fixed latex not rendering on quiz stats when accessed from ProPanel widget</li>\n<li>Fixed time format with timezone not working on start/end dates</li>\n<li>Fixed SQL error missing syntax for multisite</li>\n<li>Fixed in progress/not started filters not showing data when start date filter is set </li>\n<li>Fixed PHP 8 deprecation notices</li>\n<li>Fixed reporting widget not working without filtering widget </li>\n<li>Fixed email sending message never goes away</li>\n<li>Fixed selected hour not showing in new start/end filters</li>\n<li>\n<p>Fixed date picker format </p>\n<h4>2.1.4</h4> \n</li>\n<li>Added Filter by dates</li>\n<li>Added RTL support</li>\n<li>Fixed ProPanel Reporting widget not updating</li>\n<li>Fixed Users results stats not showing in dashboard</li>\n<li>Fixed 403 errors </li>\n<li>Fixed ProPanel translation issues</li>\n<li>Fixed Issue with LearnDash shortcodes when ProPanel is activated</li>\n<li>\n<p>Fixed Error on quiz statistics loading on front-end from ProPanel activity widget</p>\n<h4>2.1.3.1</h4>\n</li>\n<li>Updated license and update calls to use SSL for secure connections.</li>\n</ul>\n<p>View our full changelog <a href=\"https://support.learndash.com/articles/propanel-changelog/\">here</a>.</p>\";}s:3:\"faq\";a:3:{s:5:\"title\";s:3:\"FAQ\";s:11:\"content_raw\";s:931:\"= Do I need to update? =\r\n\r\nIt is always recommended to update. However given the nature of WordPress and the option to have many other plugins installed, custom code, etc. it is possible that a conflict would arise. This is why we always recommend testing the update on a development environment first. \r\n\r\n= Why am I getting an error notice when trying to update? =\r\n\r\nIf you are getting an error while trying to update your version of LearnDash LMS, verify that your license is still valid. \r\n\r\nBoth your license key and email address should be entered via LEARNDASH LMS > SETTINGS > PROPANEL LICENSE.\r\n\r\nIf you see an invalid license message, you can find your correct information via our [Support Site](https://support.learndash.com/articles/my-downloads/).\r\n\r\nIf your license has expired, you can purchase a new one [here](https://www.learndash.com/pricing-and-purchase/). ProPanel is part of both the Plus and Pro package.\r\n\";s:7:\"content\";s:0:\"\";}s:4:\"tags\";a:0:{}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:394:\"<p>Easily manage and view your LearnDash LMS activity.</p>\n<p>ProPanel enhances your LearnDash admin experience by consolidating reporting and assignment management, giving you the ability to send course specific communications, and showing real-time activity of your courses!</p>\n<p>See the <a href=\"https://www.learndash.com/propanel-by-learndash/\">Features</a> page for more information.</p>\";s:12:\"installation\";s:529:\"<p>If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of ProPanel.</li>\n<li>Download the latest version of ProPanel from our <a href=\"https://support.learndash.com/articles/my-downloads/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the ProPanel plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:1312:\"<h4>2.1.4.1</h4>\n<ul>\n<li>Added progress icon on front end when reports are displayed </li>\n<li>Fixed latex not rendering on quiz stats when accessed from ProPanel widget</li>\n<li>Fixed time format with timezone not working on start/end dates</li>\n<li>Fixed SQL error missing syntax for multisite</li>\n<li>Fixed in progress/not started filters not showing data when start date filter is set </li>\n<li>Fixed PHP 8 deprecation notices</li>\n<li>Fixed reporting widget not working without filtering widget </li>\n<li>Fixed email sending message never goes away</li>\n<li>Fixed selected hour not showing in new start/end filters</li>\n<li>\n<p>Fixed date picker format </p>\n<h4>2.1.4</h4> \n</li>\n<li>Added Filter by dates</li>\n<li>Added RTL support</li>\n<li>Fixed ProPanel Reporting widget not updating</li>\n<li>Fixed Users results stats not showing in dashboard</li>\n<li>Fixed 403 errors </li>\n<li>Fixed ProPanel translation issues</li>\n<li>Fixed Issue with LearnDash shortcodes when ProPanel is activated</li>\n<li>\n<p>Fixed Error on quiz statistics loading on front-end from ProPanel activity widget</p>\n<h4>2.1.3.1</h4>\n</li>\n<li>Updated license and update calls to use SSL for secure connections.</li>\n</ul>\n<p>View our full changelog <a href=\"https://support.learndash.com/articles/propanel-changelog/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:25:\"learndash-propanel-readme\";s:8:\"homepage\";s:44:\"https://learndash.com/propanel-by-learndash/\";s:12:\"last_updated\";s:19:\"2021-05-12 00:00:00\";s:7:\"version\";s:7:\"2.1.4.1\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.7.1\";s:5:\"icons\";a:3:{s:2:\"1x\";s:107:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_256x256.jpg\";s:2:\"2x\";s:107:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_256x256.jpg\";s:7:\"default\";s:107:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_banner.jpg\";s:4:\"high\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_banner.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_banner.jpg\";}s:11:\"show-add-on\";s:2:\"no\";}s:25:\"learndash-paidmemberships\";a:29:{s:4:\"name\";s:32:\"PaidMembershipsPro for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:48:\"https://learndash.com/add-on/paidmembershipspro/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:25:\"learndash-paidmemberships\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:10:\"membership\";i:2;s:20:\"paid memberships pro\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.3.1\";s:17:\"short_description\";s:50:\"Integrate LearnDash LMS with Paid Memberships Pro.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:712:\"Integrate LearnDash LMS with Paid Memberships Pro.\r\n\r\nPaidMemberships Pro is one of the most popular free membership plugins available for WordPress with robust user statistics and reporting of membership levels. \r\n\r\nWith this integration, you can create membership level access and associate the access levels to LearnDash courses. Customers are auto-enrolled into courses after signing-up for membership.\r\n\r\n= Integration Features = \r\n\r\n* Associate membership levels to one or more courses\r\n* Auto-expire membership levels after X amount of time\r\n* Create trial membership levels with various payment gateways\r\n\r\nSee the [Add-on](https://learndash.com/add-on/paidmembershipspro/) page for more information.\r\n\r\n\";s:7:\"content\";s:767:\"<p>Integrate LearnDash LMS with Paid Memberships Pro.</p>\n<p>PaidMemberships Pro is one of the most popular free membership plugins available for WordPress with robust user statistics and reporting of membership levels. </p>\n<p>With this integration, you can create membership level access and associate the access levels to LearnDash courses. Customers are auto-enrolled into courses after signing-up for membership.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Associate membership levels to one or more courses</li>\n<li>Auto-expire membership levels after X amount of time</li>\n<li>Create trial membership levels with various payment gateways</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/paidmembershipspro/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:638:\"= 1.3.1 =\r\n\r\n* Fixed compatibility issue with PHP versions less than 7.3\r\n\r\n= 1.3.0 = \r\n\r\n* Added integration with LearnDash groups membership functionality\r\n* Updated code refactor for improved documentation blocks, spacing, and function names\r\n* Fixed untranslatable strings\r\n\r\n= 1.2.0 =\r\n* Added LD integration PMP submenu page and add retroactive tool button\r\n* Added retroactive tool\r\n* Added disable PMP protection for courses page\r\n* Updated improve metabox saving function to require membership option\r\n* Fixed undefined index error notice\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/paidmembershipspro/).\r\n\";s:7:\"content\";s:730:\"<h4>1.3.1</h4>\n<ul>\n<li>\n<p>Fixed compatibility issue with PHP versions less than 7.3</p>\n<h4>1.3.0</h4> \n</li>\n<li>Added integration with LearnDash groups membership functionality</li>\n<li>Updated code refactor for improved documentation blocks, spacing, and function names</li>\n<li>Fixed untranslatable strings\n<h4>1.2.0</h4></li>\n<li>Added LD integration PMP submenu page and add retroactive tool button</li>\n<li>Added retroactive tool</li>\n<li>Added disable PMP protection for courses page</li>\n<li>Updated improve metabox saving function to require membership option</li>\n<li>Fixed undefined index error notice</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/paidmembershipspro/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:767:\"<p>Integrate LearnDash LMS with Paid Memberships Pro.</p>\n<p>PaidMemberships Pro is one of the most popular free membership plugins available for WordPress with robust user statistics and reporting of membership levels. </p>\n<p>With this integration, you can create membership level access and associate the access levels to LearnDash courses. Customers are auto-enrolled into courses after signing-up for membership.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Associate membership levels to one or more courses</li>\n<li>Auto-expire membership levels after X amount of time</li>\n<li>Create trial membership levels with various payment gateways</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/paidmembershipspro/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:730:\"<h4>1.3.1</h4>\n<ul>\n<li>\n<p>Fixed compatibility issue with PHP versions less than 7.3</p>\n<h4>1.3.0</h4> \n</li>\n<li>Added integration with LearnDash groups membership functionality</li>\n<li>Updated code refactor for improved documentation blocks, spacing, and function names</li>\n<li>Fixed untranslatable strings\n<h4>1.2.0</h4></li>\n<li>Added LD integration PMP submenu page and add retroactive tool button</li>\n<li>Added retroactive tool</li>\n<li>Added disable PMP protection for courses page</li>\n<li>Updated improve metabox saving function to require membership option</li>\n<li>Fixed undefined index error notice</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/paidmembershipspro/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:25:\"learndash-paidmemberships\";s:8:\"homepage\";s:48:\"https://learndash.com/add-on/paidmembershipspro/\";s:12:\"last_updated\";s:19:\"2021-04-01 00:00:00\";s:7:\"version\";s:5:\"1.3.1\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:114:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_256x256.jpg\";s:2:\"2x\";s:114:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_256x256.jpg\";s:7:\"default\";s:114:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:113:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_banner.jpg\";s:4:\"high\";s:113:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_banner.jpg\";s:7:\"default\";s:113:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.3.1\";s:4:\"file\";b:0;s:3:\"url\";s:248:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-paidmemberships&amp;_wpnonce=08ac5946ec&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:19:\"learndash-elementor\";a:28:{s:4:\"name\";s:23:\"Elementor for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:22:\"https://learndash.com/\";s:4:\"slug\";s:19:\"learndash-elementor\";s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.0.3\";s:17:\"short_description\";s:75:\"LearnDash LMS add-on to add support native Elementor templates and widgets.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:227:\"Integrate LearnDash LMS with Elementor. \r\n\r\n= Integration Features = \r\n\r\n* Native Elementor templates and widgets\r\n\r\nSee the [Add-on](https://www.learndash.com/support/docs/add-ons/compatibility/) page for more information.\r\n\r\n\";s:7:\"content\";s:262:\"<p>Integrate LearnDash LMS with Elementor. </p>\n<h4>Integration Features</h4> \n<ul>\n<li>Native Elementor templates and widgets</li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:826:\"= 1.0.3 =\r\n\r\n* Fixed PHP notices/warnings\r\n* Fixed LearnDash Elementor widgets not appearing when other Elementor add-ons are active\r\n* Fixed Lesson content not showing for some users\r\n* Fixed Unlimited quiz retries when using an Elementor quiz template\r\n* Fixed LearnDash shortcode wizard not working in Elementor text element\r\n* Removed \"Show Progress Bar” on Lesson, Topic, and Quiz list widgets \r\n\r\n= 1.0.2 =\r\n\r\n* Fixed conflict with other premium Elementor add-on plugins\r\n\r\n= 1.0.1 =\r\n* Updated Assignment widget output within Lesson and Topic templates\r\n* Updated issue with duplicate output via `post_content` widget\r\n* Updated style settings on some widgets\r\n* Added support for Course Grid settings in some widgets\r\n\r\nView the full changelog [here](https://www.learndash.com/support/docs/add-ons/compatibility/).\r\n\";s:7:\"content\";s:946:\"<h4>1.0.3</h4>\n<ul>\n<li>Fixed PHP notices/warnings</li>\n<li>Fixed LearnDash Elementor widgets not appearing when other Elementor add-ons are active</li>\n<li>Fixed Lesson content not showing for some users</li>\n<li>Fixed Unlimited quiz retries when using an Elementor quiz template</li>\n<li>Fixed LearnDash shortcode wizard not working in Elementor text element</li>\n<li>\n<p>Removed &quot;Show Progress Bar” on Lesson, Topic, and Quiz list widgets </p>\n<h4>1.0.2</h4>\n</li>\n<li>Fixed conflict with other premium Elementor add-on plugins\n<h4>1.0.1</h4></li>\n<li>Updated Assignment widget output within Lesson and Topic templates</li>\n<li>Updated issue with duplicate output via <code>post_content</code> widget</li>\n<li>Updated style settings on some widgets</li>\n<li>Added support for Course Grid settings in some widgets</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">here</a>.</p>\";}s:4:\"tags\";a:0:{}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:262:\"<p>Integrate LearnDash LMS with Elementor. </p>\n<h4>Integration Features</h4> \n<ul>\n<li>Native Elementor templates and widgets</li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:946:\"<h4>1.0.3</h4>\n<ul>\n<li>Fixed PHP notices/warnings</li>\n<li>Fixed LearnDash Elementor widgets not appearing when other Elementor add-ons are active</li>\n<li>Fixed Lesson content not showing for some users</li>\n<li>Fixed Unlimited quiz retries when using an Elementor quiz template</li>\n<li>Fixed LearnDash shortcode wizard not working in Elementor text element</li>\n<li>\n<p>Removed &quot;Show Progress Bar” on Lesson, Topic, and Quiz list widgets </p>\n<h4>1.0.2</h4>\n</li>\n<li>Fixed conflict with other premium Elementor add-on plugins\n<h4>1.0.1</h4></li>\n<li>Updated Assignment widget output within Lesson and Topic templates</li>\n<li>Updated issue with duplicate output via <code>post_content</code> widget</li>\n<li>Updated style settings on some widgets</li>\n<li>Added support for Course Grid settings in some widgets</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:19:\"learndash-elementor\";s:8:\"homepage\";s:22:\"https://learndash.com/\";s:12:\"last_updated\";s:19:\"2021-01-06 00:00:00\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:2:\"2x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:4:\"high\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.0.3\";s:4:\"file\";b:0;s:3:\"url\";s:242:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-elementor&amp;_wpnonce=7408fd15b3&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:20:\"learndash-thrivecart\";a:30:{s:4:\"name\";s:24:\"ThriveCart for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:40:\"https://learndash.com/add-on/thrivecart/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:20:\"learndash-thrivecart\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:10:\"thrivecart\";i:2;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.5\";s:10:\"stable_tag\";s:3:\"1.0\";s:7:\"license\";s:14:\"GPLv2 or later\";s:11:\"license_uri\";s:41:\"https://www.gnu.org/licenses/gpl-2.0.html\";s:17:\"short_description\";s:41:\"Integrates LearnDash LMS with Thrivecart.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:646:\"Integrate LearnDash LMS with Thrivecart.\r\n\r\nThriveCart is a powerful eCommerce solution for selling digital products with features such as order bumps and upsells. \r\nWith this integration you can create products in ThirveCart and then create a product in WordPress and associate it with a LearnDash courses. Customers are then auto-enrolled into courses after payment.\r\n\r\n= Integration Features = \r\n\r\n* Supports all ThriveCart functionality including order bumps and upsells\r\n* Automatic enrollment upon successful payment\r\n* Coupon and discount support\r\n\r\nSee the [Add-on](https://learndash.com/add-on/thrivecart/) page for more information.\r\n\r\n\";s:7:\"content\";s:695:\"<p>Integrate LearnDash LMS with Thrivecart.</p>\n<p>ThriveCart is a powerful eCommerce solution for selling digital products with features such as order bumps and upsells.\nWith this integration you can create products in ThirveCart and then create a product in WordPress and associate it with a LearnDash courses. Customers are then auto-enrolled into courses after payment.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Supports all ThriveCart functionality including order bumps and upsells</li>\n<li>Automatic enrollment upon successful payment</li>\n<li>Coupon and discount support</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/thrivecart/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:115:\"= 1.0.0 =\r\n\r\n* Initial release  \r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/thrivecart/).\r\n\";s:7:\"content\";s:148:\"<h4>1.0.0</h4>\n<ul>\n<li>Initial release  </li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/thrivecart/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:695:\"<p>Integrate LearnDash LMS with Thrivecart.</p>\n<p>ThriveCart is a powerful eCommerce solution for selling digital products with features such as order bumps and upsells.\nWith this integration you can create products in ThirveCart and then create a product in WordPress and associate it with a LearnDash courses. Customers are then auto-enrolled into courses after payment.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Supports all ThriveCart functionality including order bumps and upsells</li>\n<li>Automatic enrollment upon successful payment</li>\n<li>Coupon and discount support</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/thrivecart/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:148:\"<h4>1.0.0</h4>\n<ul>\n<li>Initial release  </li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/thrivecart/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:20:\"learndash-thrivecart\";s:8:\"homepage\";s:40:\"https://learndash.com/add-on/thrivecart/\";s:12:\"last_updated\";s:19:\"2020-11-11 00:00:00\";s:7:\"version\";s:3:\"1.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.5\";s:5:\"icons\";a:3:{s:2:\"1x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:2:\"2x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:4:\"high\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:3:\"1.0\";s:4:\"file\";b:0;s:3:\"url\";s:243:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-thrivecart&amp;_wpnonce=7b90a047cd&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:15:\"ld-multilingual\";a:28:{s:4:\"name\";s:34:\"LearnDash Multilingual Integration\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:22:\"https://learndash.com/\";s:4:\"slug\";s:15:\"ld-multilingual\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:12:\"translations\";i:2;s:4:\"wpml\";i:3;s:8:\"polylang\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.0.0\";s:17:\"short_description\";s:57:\"Adds Multilingual support with WPML and Polylang plugins.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:261:\"Integrate LearnDash LMS with WPML and Polylang. \r\n\r\n= Integration Features = \r\n\r\n* Compatibility with course and quiz builder\r\n* Translatable URLs \r\n\r\nSee the [Add-on](https://www.learndash.com/support/docs/add-ons/compatibility/) page for more information.\r\n\r\n\";s:7:\"content\";s:302:\"<p>Integrate LearnDash LMS with WPML and Polylang. </p>\n<h4>Integration Features</h4> \n<ul>\n<li>Compatibility with course and quiz builder</li>\n<li>Translatable URLs </li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:128:\"= 1.0.0 =\r\n* Initial release\r\n\r\nView the full changelog [here](https://www.learndash.com/support/docs/add-ons/compatibility/).\r\n\";s:7:\"content\";s:163:\"<h4>1.0.0</h4>\n<ul>\n<li>Initial release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:302:\"<p>Integrate LearnDash LMS with WPML and Polylang. </p>\n<h4>Integration Features</h4> \n<ul>\n<li>Compatibility with course and quiz builder</li>\n<li>Translatable URLs </li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:163:\"<h4>1.0.0</h4>\n<ul>\n<li>Initial release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:15:\"ld-multilingual\";s:8:\"homepage\";s:22:\"https://learndash.com/\";s:12:\"last_updated\";s:19:\"2020-04-14 00:00:00\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:2:\"2x\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:7:\"default\";s:106:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:4:\"high\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:7:\"default\";s:105:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.0.0\";s:4:\"file\";b:0;s:3:\"url\";s:238:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=ld-multilingual&amp;_wpnonce=4a1a137413&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:30:\"learndash-restrict-content-pro\";a:28:{s:4:\"name\";s:34:\"Restrict Content Pro for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:0:\"\";s:20:\"ld_requires_at_least\";s:3:\"2.5\";s:4:\"slug\";s:30:\"learndash-restrict-content-pro\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:10:\"membership\";i:2;s:20:\"restrict content pro\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:3:\"5.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.1.0\";s:17:\"short_description\";s:50:\"Integrate LearnDash LMS with Restrict Content Pro.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:153:\"Integrate LearnDash LMS with Restrict Content Pro.\r\n\r\n= Integration Features = \r\n\r\nSee the [Add-on](https://learndash.com) page for more information.\r\n\r\n\";s:7:\"content\";s:173:\"<p>Integrate LearnDash LMS with Restrict Content Pro.</p>\n<h4>Integration Features</h4> \n<p>See the <a href=\"https://learndash.com\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:143:\"= 1.1.0 =\r\n\r\n* Added RCP 3.0 compatibility hook function\r\n* Fixed course association\r\n\r\nView the full changelog [here](https://learndash.com)\r\n\";s:7:\"content\";s:182:\"<h4>1.1.0</h4>\n<ul>\n<li>Added RCP 3.0 compatibility hook function</li>\n<li>Fixed course association</li>\n</ul>\n<p>View the full changelog <a href=\"https://learndash.com\">here</a></p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:173:\"<p>Integrate LearnDash LMS with Restrict Content Pro.</p>\n<h4>Integration Features</h4> \n<p>See the <a href=\"https://learndash.com\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:182:\"<h4>1.1.0</h4>\n<ul>\n<li>Added RCP 3.0 compatibility hook function</li>\n<li>Fixed course association</li>\n</ul>\n<p>View the full changelog <a href=\"https://learndash.com\">here</a></p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:30:\"learndash-restrict-content-pro\";s:12:\"last_updated\";s:19:\"2019-07-11 00:00:00\";s:7:\"version\";s:5:\"1.1.0\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:3:\"5.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:119:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_256x256.jpg\";s:2:\"2x\";s:119:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_256x256.jpg\";s:7:\"default\";s:119:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:118:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_banner.jpg\";s:4:\"high\";s:118:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_banner.jpg\";s:7:\"default\";s:118:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.1.0\";s:4:\"file\";b:0;s:3:\"url\";s:253:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-restrict-content-pro&amp;_wpnonce=9b707744cd&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}s:24:\"learndash-event-espresso\";a:29:{s:4:\"name\";s:28:\"Event Espresso for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:44:\"https://learndash.com/add-on/event-espresso/\";s:20:\"ld_requires_at_least\";s:3:\"2.5\";s:4:\"slug\";s:24:\"learndash-event-espresso\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:5:\"event\";i:2;s:14:\"event espresso\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:3:\"5.1\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.1.0\";s:17:\"short_description\";s:44:\"Integrate LearnDash LMS with Event Espresso.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:693:\"Integrate LearnDash LMS with Event Espresso.\r\n\r\nEvent Espresso is the leading live event and ticket management solution for WordPress. With this integration, you can associate your online courses to live events so that when users register, they are auto-enrolled. Perfect for anyone offering live training, seminars, or classrooms.\r\n\r\n= Integration Features = \r\n\r\n* Easily map an event to a course\r\n* Associate one, or many, courses\r\n* Drip-feed course content leading up to an event\r\n* Works with any Event Espresso payment gateway\r\n\r\nNote: this integration requires Event Espresso v4 or higher.\r\n\r\nSee the [Add-on](https://learndash.com/add-on/event-espresso/) page for more information.\r\n\r\n\";s:7:\"content\";s:754:\"<p>Integrate LearnDash LMS with Event Espresso.</p>\n<p>Event Espresso is the leading live event and ticket management solution for WordPress. With this integration, you can associate your online courses to live events so that when users register, they are auto-enrolled. Perfect for anyone offering live training, seminars, or classrooms.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easily map an event to a course</li>\n<li>Associate one, or many, courses</li>\n<li>Drip-feed course content leading up to an event</li>\n<li>Works with any Event Espresso payment gateway</li>\n</ul>\n<p>Note: this integration requires Event Espresso v4 or higher.</p>\n<p>See the <a href=\"https://learndash.com/add-on/event-espresso/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:156:\"= 1.1.0 =\r\n* Added language directory and POT file\r\n* Added constants\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/event-espresso/).\r\n\";s:7:\"content\";s:197:\"<h4>1.1.0</h4>\n<ul>\n<li>Added language directory and POT file</li>\n<li>Added constants</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/event-espresso/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:754:\"<p>Integrate LearnDash LMS with Event Espresso.</p>\n<p>Event Espresso is the leading live event and ticket management solution for WordPress. With this integration, you can associate your online courses to live events so that when users register, they are auto-enrolled. Perfect for anyone offering live training, seminars, or classrooms.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easily map an event to a course</li>\n<li>Associate one, or many, courses</li>\n<li>Drip-feed course content leading up to an event</li>\n<li>Works with any Event Espresso payment gateway</li>\n</ul>\n<p>Note: this integration requires Event Espresso v4 or higher.</p>\n<p>See the <a href=\"https://learndash.com/add-on/event-espresso/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:197:\"<h4>1.1.0</h4>\n<ul>\n<li>Added language directory and POT file</li>\n<li>Added constants</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/event-espresso/\">here</a>.</p>\";}s:10:\"last_check\";i:1638344470;s:8:\"external\";b:1;s:7:\"bb_slug\";s:24:\"learndash-event-espresso\";s:8:\"homepage\";s:44:\"https://learndash.com/add-on/event-espresso/\";s:12:\"last_updated\";s:19:\"2019-04-24 00:00:00\";s:7:\"version\";s:5:\"1.1.0\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:3:\"5.1\";s:5:\"icons\";a:3:{s:2:\"1x\";s:113:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_256x256.jpg\";s:2:\"2x\";s:113:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_256x256.jpg\";s:7:\"default\";s:113:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_banner.jpg\";s:4:\"high\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_banner.jpg\";s:7:\"default\";s:112:\"//abzarwp.net/pre-learning/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.1.0\";s:4:\"file\";b:0;s:3:\"url\";s:247:\"https://pre-websites.ir/elementor/learndash/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-event-espresso&amp;_wpnonce=5cd7863b35&ld-return-addons=/elementor/learndash/wp-admin/admin.php?page=duplicator&tab=new3&_wpnonce=44c5a2033f\";}}}s:4:\"tags\";a:0:{}s:7:\"updates\";a:0:{}}", "no");
INSERT INTO `esduc_options` VALUES("31509", "_transient_product_query-transient-version", "1647239546", "yes");
INSERT INTO `esduc_options` VALUES("31510", "_site_transient_timeout_community-events-cadb040c13657d29fd73c5c4ce49f3d5", "1647282749", "no");
INSERT INTO `esduc_options` VALUES("31511", "_site_transient_community-events-cadb040c13657d29fd73c5c4ce49f3d5", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"94.183.93.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `esduc_options` VALUES("31497", "_transient_timeout_elementor_pro_rollback_versions_3.6.1", "1647844260", "no");
INSERT INTO `esduc_options` VALUES("28718", "jet-tabs-db-version", "2.1.15", "yes");
INSERT INTO `esduc_options` VALUES("26618", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("26712", "elementor_use_mini_cart_template", "yes", "yes");
INSERT INTO `esduc_options` VALUES("17149", "thwcfd_notice_status", "a:1:{i:0;s:5:\"1.5.2\";}", "no");
INSERT INTO `esduc_options` VALUES("11073", "woocommerce_gateway_order", "a:3:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;}", "yes");
INSERT INTO `esduc_options` VALUES("9671", "gf_db_version", "2.5.15.3", "no");
INSERT INTO `esduc_options` VALUES("9672", "rg_form_version", "2.5.15.3", "no");
INSERT INTO `esduc_options` VALUES("9673", "gform_enable_background_updates", "1", "yes");
INSERT INTO `esduc_options` VALUES("31517", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1647282751", "no");
INSERT INTO `esduc_options` VALUES("31518", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1647239551", "no");
INSERT INTO `esduc_options` VALUES("31519", "_transient_timeout_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27", "1647282772", "no");
INSERT INTO `esduc_options` VALUES("31520", "_transient_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2022/03/wordpress-5-9-2-security-maintenance-release/\'>WordPress 5.9.2 Security and Maintenance Release</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2022/03/episode-26-matt-mullenweg-on-ukraine-community-and-wordpress/\'>WP Briefing: Episode 26: Matt Mullenweg on Ukraine, Community, and WordPress</a></li></ul></div><div class=\"rss-widget\"><p><strong>خطای RSS:</strong> WP HTTP Error: نشانی معتبر نیست.</p></div>", "no");
INSERT INTO `esduc_options` VALUES("31547", "_transient_timeout_GFCache_ae77f699eae585a543cd6950009fcefc", "1647240481", "no");
INSERT INTO `esduc_options` VALUES("31548", "_transient_GFCache_ae77f699eae585a543cd6950009fcefc", "a:1:{i:0;O:8:\"stdClass\":2:{s:7:\"form_id\";s:1:\"2\";s:11:\"entry_count\";s:1:\"2\";}}", "no");
INSERT INTO `esduc_options` VALUES("31526", "_transient_woocommerce_reports-transient-version", "1647240531", "yes");
INSERT INTO `esduc_options` VALUES("31549", "_transient_timeout_GFCache_ce819000e42f8a40aedf5cdbefe9946a", "1647240481", "no");
INSERT INTO `esduc_options` VALUES("31550", "_transient_GFCache_ce819000e42f8a40aedf5cdbefe9946a", "a:4:{i:0;O:8:\"stdClass\":2:{s:7:\"form_id\";s:1:\"1\";s:10:\"view_count\";s:2:\"94\";}i:1;O:8:\"stdClass\":2:{s:7:\"form_id\";s:1:\"2\";s:10:\"view_count\";s:2:\"49\";}i:2;O:8:\"stdClass\":2:{s:7:\"form_id\";s:1:\"3\";s:10:\"view_count\";s:2:\"47\";}i:3;O:8:\"stdClass\":2:{s:7:\"form_id\";s:1:\"4\";s:10:\"view_count\";s:2:\"37\";}}", "no");
INSERT INTO `esduc_options` VALUES("31540", "_transient_GFCache_eeeb02282be661fc32c57b85c2a9de61", "0", "no");
INSERT INTO `esduc_options` VALUES("31541", "_transient_timeout_GFCache_77164e133ca1cbcc74b500642e044c35", "1647244018", "no");
INSERT INTO `esduc_options` VALUES("31542", "_transient_GFCache_77164e133ca1cbcc74b500642e044c35", "0", "no");
INSERT INTO `esduc_options` VALUES("31543", "_transient_timeout_GFCache_2c0e586bc62293205ec95ce121f13718", "1647244018", "no");
INSERT INTO `esduc_options` VALUES("31544", "_transient_GFCache_2c0e586bc62293205ec95ce121f13718", "0", "no");
INSERT INTO `esduc_options` VALUES("31545", "_transient_timeout_GFCache_452b2b0338188aebc0bad48feecee278", "1647244018", "no");
INSERT INTO `esduc_options` VALUES("31546", "_transient_GFCache_452b2b0338188aebc0bad48feecee278", "0", "no");
INSERT INTO `esduc_options` VALUES("31552", "_transient_timeout_orders-all-statuses", "1647845288", "no");
INSERT INTO `esduc_options` VALUES("31553", "_transient_orders-all-statuses", "a:2:{s:7:\"version\";s:10:\"1647239697\";s:5:\"value\";a:2:{i:0;s:12:\"wc-completed\";i:1;s:13:\"wc-processing\";}}", "no");
INSERT INTO `esduc_options` VALUES("31554", "_transient_timeout_wc_onboarding_themes", "1647326889", "no");
INSERT INTO `esduc_options` VALUES("31555", "_transient_wc_onboarding_themes", "a:47:{s:15:\"hello-elementor\";a:6:{s:4:\"slug\";s:15:\"hello-elementor\";s:5:\"title\";s:15:\"Hello Elementor\";s:5:\"price\";s:4:\"0.00\";s:12:\"is_installed\";b:1;s:5:\"image\";s:92:\"https://pre-websites.ir/elementor/learndash/wp-content/themes/hello-elementor/screenshot.png\";s:23:\"has_woocommerce_support\";b:1;}s:10:\"storefront\";a:16:{s:5:\"title\";s:10:\"Storefront\";s:5:\"image\";s:110:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2014/11/woocommerce-theme-storefront-iupsib.png\";s:7:\"excerpt\";s:161:\"Storefront is an intuitive &amp; flexible, free theme offering deep integration with WooCommerce.\r\n\r\nIt\'s the perfect platform for your next WooCommerce project.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/storefront/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:42:\"https://themes.woocommerce.com/storefront/\";s:5:\"price\";s:9:\"&#36;0.00\";s:4:\"hash\";s:32:\"5714dad8f8d0b930bd6cc9c99657b930\";s:4:\"slug\";s:10:\"storefront\";s:2:\"id\";i:565154;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";s:96:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2016/02/woo-Storefront-ipreuh.png\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"blooms\";a:16:{s:5:\"title\";s:6:\"Blooms\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2022/02/blooms-regular-card-xbdwaz.png\";s:7:\"excerpt\";s:96:\"Showcase your flowers, plants, or other natural products with the clean and lovely Blooms theme.\";s:4:\"link\";s:109:\"https://woocommerce.com/products/blooms/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:30:\"https://blooms.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"dc4d2136-308f-4e39-8a1f-532ae43d55d1\";s:4:\"slug\";s:6:\"blooms\";s:2:\"id\";i:18734000119314;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";s:66:\"https://woocommerce.com/wp-content/uploads/2022/02/icon-5.png?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:15:\"vegan-food-shop\";a:16:{s:5:\"title\";s:15:\"Vegan Food Shop\";s:5:\"image\";s:106:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2022/02/vegan-product-card-large-ltsscl.png\";s:7:\"excerpt\";s:172:\"A mobile-friendly theme suitable for all food and drinks stores, grocery markets or food delivery services. Add it to your online store and start attracting more customers!\";s:4:\"link\";s:118:\"https://woocommerce.com/products/vegan-food-shop/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:41:\"https://veganfoodshop.thunder-stores.com/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"deec353e-5603-40ba-9734-3ad0172e3b97\";s:4:\"slug\";s:15:\"vegan-food-shop\";s:2:\"id\";i:18734000077086;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:13:\"Thunderstores\";s:10:\"vendor_url\";s:45:\"https://woocommerce.com/vendor/thunderstores/\";s:4:\"icon\";s:70:\"https://woocommerce.com/wp-content/uploads/2022/02/vegan-logo.jpg?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:5:\"outer\";a:16:{s:5:\"title\";s:5:\"Outer\";s:5:\"image\";s:107:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2022/02/Regular-Card-Product-Logo-af549w.png\";s:7:\"excerpt\";s:129:\"Take your shop design to the next level with Outer, a scalable theme powered by sharp, minimal design and flexible theme options.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/outer/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:31:\"https://demo.codestag.com/outer\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"fef7b047-2152-44dc-ac1a-05796d0977f5\";s:4:\"slug\";s:5:\"outer\";s:2:\"id\";i:18734000055124;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:8:\"Codestag\";s:10:\"vendor_url\";s:40:\"https://woocommerce.com/vendor/codestag/\";s:4:\"icon\";s:72:\"https://woocommerce.com/wp-content/uploads/2021/12/Product-Icon.png?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:12:\"cbd-retailer\";a:16:{s:5:\"title\";s:12:\"CBD Retailer\";s:5:\"image\";s:81:\"https://woocommerce.com/wp-content/uploads/2022/01/cbd-retailer-regular-card.webp\";s:7:\"excerpt\";s:132:\"CBD Retailer is a clean and flexible block theme suitable for a CBD-based online store selling beauty, health, or cosmetic products.\";s:4:\"link\";s:115:\"https://woocommerce.com/products/cbd-retailer/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://cbdretailer.thunder-stores.com/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"2f8e2c03-b4a0-4bcc-aafb-bca83714f6d8\";s:4:\"slug\";s:12:\"cbd-retailer\";s:2:\"id\";i:9098384;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:13:\"Thunderstores\";s:10:\"vendor_url\";s:45:\"https://woocommerce.com/vendor/thunderstores/\";s:4:\"icon\";s:82:\"https://woocommerce.com/wp-content/uploads/2022/01/cbd-retailer-logo-icon.png?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:10:\"wine-house\";a:16:{s:5:\"title\";s:10:\"Wine House\";s:5:\"image\";s:65:\"https://woocommerce.com/wp-content/uploads/2022/01/screenshot.jpg\";s:7:\"excerpt\";s:70:\"Sell food and drinks with the clean, subtle, upscale Wine House theme.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/wine-house/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:33:\"https://winehouse.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"a4566e8d-ea8e-4e8f-af6e-5bcf01834abb\";s:4:\"slug\";s:10:\"wine-house\";s:2:\"id\";i:9055701;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";s:61:\"https://woocommerce.com/wp-content/uploads/2021/12/icon-2.png\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"dololo\";a:16:{s:5:\"title\";s:6:\"Dololo\";s:5:\"image\";s:93:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2021/12/main-dololo-je34s3.png\";s:7:\"excerpt\";s:104:\"Dololo is an elegant block-based theme ideal for WooCommerce stores selling children\'s apparel and toys.\";s:4:\"link\";s:109:\"https://woocommerce.com/products/dololo/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://demo.anarieldesign.com/dololo/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"607c22b6-339f-468a-95fd-d46ae33544da\";s:4:\"slug\";s:6:\"dololo\";s:2:\"id\";i:9011976;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:14:\"Anariel Design\";s:10:\"vendor_url\";s:46:\"https://woocommerce.com/vendor/anariel-design/\";s:4:\"icon\";s:74:\"https://woocommerce.com/wp-content/uploads/2021/12/product-icon-1.jpg?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:5:\"emoly\";a:16:{s:5:\"title\";s:5:\"Emoly\";s:5:\"image\";s:103:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2021/12/emoly-wordpress-theme-ugrxpl.png\";s:7:\"excerpt\";s:112:\"Showcase and sell wedding fashion, accessories, and services with Emoly, a modern block-based WooCommerce theme.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/emoly/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:37:\"https://demo.anarieldesign.com/emoly/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"3a614885-1d63-4905-81c9-51997a88e186\";s:4:\"slug\";s:5:\"emoly\";s:2:\"id\";i:9011975;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:14:\"Anariel Design\";s:10:\"vendor_url\";s:46:\"https://woocommerce.com/vendor/anariel-design/\";s:4:\"icon\";s:72:\"https://woocommerce.com/wp-content/uploads/2021/12/product-icon.jpg?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:11:\"marketplace\";a:16:{s:5:\"title\";s:11:\"Marketplace\";s:5:\"image\";s:102:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2021/12/marketplace-featured-lyiykm.jpg\";s:7:\"excerpt\";s:100:\"Create a multi-vendor eCommerce website like Etsy or Amazon using the WooCommerce Marketplace theme.\";s:4:\"link\";s:114:\"https://woocommerce.com/products/marketplace/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:43:\"https://organicthemes.com/demo/marketplace/\";s:5:\"price\";s:10:\"&#36;99.00\";s:4:\"hash\";s:36:\"49c1e6f0-5791-42c1-8f67-3c8a8cb1974c\";s:4:\"slug\";s:11:\"marketplace\";s:2:\"id\";i:8958726;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:14:\"Organic Themes\";s:10:\"vendor_url\";s:46:\"https://woocommerce.com/vendor/organic-themes/\";s:4:\"icon\";s:76:\"https://woocommerce.com/wp-content/uploads/2021/11/marketplace-logo.png?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"affiche\";a:16:{s:5:\"title\";s:7:\"Affiche\";s:5:\"image\";s:87:\"https://woocommerce.com/wp-content/uploads/2021/11/affiche-regular-card-green.jpg?w=620\";s:7:\"excerpt\";s:139:\"Add a clean, stylish, and artistic block-based theme to your store with Affiche and you will definitely have an edge over the other sites.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/affiche/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:35:\"https://affiche.thunder-stores.com/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"ebbeaae6-20e6-4911-8c3c-2abe99fc8475\";s:4:\"slug\";s:7:\"affiche\";s:2:\"id\";i:8903388;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:13:\"Thunderstores\";s:10:\"vendor_url\";s:45:\"https://woocommerce.com/vendor/thunderstores/\";s:4:\"icon\";s:80:\"https://woocommerce.com/wp-content/uploads/2021/11/affiche-product-icon.png?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"olorien\";a:16:{s:5:\"title\";s:7:\"Olorien\";s:5:\"image\";s:69:\"https://woocommerce.com/wp-content/uploads/2021/11/olorien-main-1.jpg\";s:7:\"excerpt\";s:122:\"Olorien is a modern block-based WooCommerce theme with sophisticated look ideal for selling cosmetics and beauty products.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/olorien/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://demo.anarieldesign.com/olorien/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"a5f932ff-9408-4ba8-8962-38db8d1ee96c\";s:4:\"slug\";s:7:\"olorien\";s:2:\"id\";i:8839595;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:14:\"Anariel Design\";s:10:\"vendor_url\";s:46:\"https://woocommerce.com/vendor/anariel-design/\";s:4:\"icon\";s:72:\"https://woocommerce.com/wp-content/uploads/2021/11/product-icon.jpg?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:10:\"urban-wear\";a:16:{s:5:\"title\";s:10:\"Urban Wear\";s:5:\"image\";s:114:\"https://woocommerce.com/wp-content/uploads/2021/11/urbanwear-fashion-and-clothing-woocommerce-theme-streetwear.jpg\";s:7:\"excerpt\";s:207:\"Urban Wear is a modern block-based theme ideal for fashion-forward sites with street wear style. Streamline your customers shopping experience and maximize your conversion rate with this storytelling theme.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/urban-wear/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:36:\"https://urbanwear.thunder-stores.com\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"6a726af7-ca42-4510-a99a-61d611d673b9\";s:4:\"slug\";s:10:\"urban-wear\";s:2:\"id\";i:8744465;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:13:\"Thunderstores\";s:10:\"vendor_url\";s:45:\"https://woocommerce.com/vendor/thunderstores/\";s:4:\"icon\";s:80:\"https://woocommerce.com/wp-content/uploads/2021/10/product-icon-80x80-1.png?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"webshop\";a:16:{s:5:\"title\";s:7:\"WebShop\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2021/09/webshop-screenshot-ettbu7.jpg\";s:7:\"excerpt\";s:108:\"WebShop for WooCommerce is a clean, Gutenberg-powered, modern theme set on a background of open white space.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/webshop/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:36:\"https://themegrilldemos.com/webshop/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"1f3798fd-529d-4e6e-807f-93f8be709f16\";s:4:\"slug\";s:7:\"webshop\";s:2:\"id\";i:8578321;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:10:\"ThemeGrill\";s:10:\"vendor_url\";s:42:\"https://woocommerce.com/vendor/themegrill/\";s:4:\"icon\";s:103:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2021/09/ws-logo-color-80x80-1-virg1d.jpg\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:11:\"wild-sports\";a:16:{s:5:\"title\";s:11:\"Wild Sports\";s:5:\"image\";s:65:\"https://woocommerce.com/wp-content/uploads/2021/09/wildsports.jpg\";s:7:\"excerpt\";s:93:\"A sports-oriented WooCommerce theme with bright accent colors to help you express your brand.\";s:4:\"link\";s:114:\"https://woocommerce.com/products/wild-sports/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:34:\"https://wildsports.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"7d09a71c-ff8f-4b94-8c84-a2f500a0f031\";s:4:\"slug\";s:11:\"wild-sports\";s:2:\"id\";i:8521104;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";s:64:\"https://woocommerce.com/wp-content/uploads/2021/09/icon.png?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:5:\"nelly\";a:16:{s:5:\"title\";s:5:\"Nelly\";s:5:\"image\";s:91:\"https://woocommerce.com/wp-content/uploads/2021/09/nelly-pets-fashion-wordpress-theme-1.jpg\";s:7:\"excerpt\";s:122:\"Nelly is an eye-catching WooCommerce theme crafted for selling fashion products and accessories for our animal companions.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/nelly/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:37:\"https://demo.anarieldesign.com/nelly/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"18dec028-fb28-489b-8ae5-a5ff79e2ffef\";s:4:\"slug\";s:5:\"nelly\";s:2:\"id\";i:8512788;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:14:\"Anariel Design\";s:10:\"vendor_url\";s:46:\"https://woocommerce.com/vendor/anariel-design/\";s:4:\"icon\";s:69:\"https://woocommerce.com/wp-content/uploads/2021/08/thumbnail.jpg?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:16:\"organic-goodness\";a:16:{s:5:\"title\";s:16:\"Organic Goodness\";s:5:\"image\";s:107:\"https://woocommerce.com/wp-content/uploads/2021/08/organic-goodness-health-and-beauty-woocommerce-theme.jpg\";s:7:\"excerpt\";s:178:\"A mobile-friendly theme suitable for health and beauty stores. Clean, flexible and with an intuitive visual interface, your online store will definitely stand out from the crowd.\";s:4:\"link\";s:119:\"https://woocommerce.com/products/organic-goodness/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:43:\"https://organicgoodness.thunder-stores.com/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"705fea70-54f7-4b0b-a0f5-b87c32fc1a17\";s:4:\"slug\";s:16:\"organic-goodness\";s:2:\"id\";i:8485741;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:13:\"Thunderstores\";s:10:\"vendor_url\";s:45:\"https://woocommerce.com/vendor/thunderstores/\";s:4:\"icon\";s:87:\"https://woocommerce.com/wp-content/uploads/2021/08/organic-goodness-theme-icon.png?w=80\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"maudern\";a:16:{s:5:\"title\";s:7:\"Maudern\";s:5:\"image\";s:115:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2021/08/maudern-minimal-woocommerce-theme-ebzjvl.jpg\";s:7:\"excerpt\";s:161:\"A contemporary block-based theme that helps you effortlessly design a minimalistic online store with WooCommerce and present your product collection beautifully.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/maudern/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:35:\"https://maudern.thunder-stores.com/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"e5afb6cf-4a53-4aed-9b05-280d3df3afc1\";s:4:\"slug\";s:7:\"maudern\";s:2:\"id\";i:8424179;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:13:\"Thunderstores\";s:10:\"vendor_url\";s:45:\"https://woocommerce.com/vendor/thunderstores/\";s:4:\"icon\";s:102:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2021/08/maudern-product-icon-f1qi03.png\";s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:5:\"olymp\";a:16:{s:5:\"title\";s:5:\"Olymp\";s:5:\"image\";s:71:\"https://woocommerce.com/wp-content/uploads/2021/05/screenshot-olymp.png\";s:7:\"excerpt\";s:135:\"Olymp is a WooCommerce and Gutenberg WordPress theme. Fully responsive and beautifully designed will get you up and running in no time.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/olymp/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:41:\"https://demo.vivathemes.com/themes/olymp/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"5f900199-70e6-4c0a-b533-293f0c4ba707\";s:4:\"slug\";s:5:\"olymp\";s:2:\"id\";i:8384551;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Viva Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/viva-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:9:\"miniature\";a:16:{s:5:\"title\";s:9:\"Miniature\";s:5:\"image\";s:74:\"https://woocommerce.com/wp-content/uploads/2021/07/featured_miniature2.jpg\";s:7:\"excerpt\";s:185:\"Miniature is a playful WordPress theme designed for stores selling children’s products. Fun and lively, Miniature will definitely add an extra touch of character to your online store.\";s:4:\"link\";s:112:\"https://woocommerce.com/products/miniature/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:49:\"https://www.cssigniter.com/woocommerce/miniature/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"28b97cd1-5b52-415c-8c9a-7f697e013a87\";s:4:\"slug\";s:9:\"miniature\";s:2:\"id\";i:8292607;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:10:\"CSSIgniter\";s:10:\"vendor_url\";s:42:\"https://woocommerce.com/vendor/cssigniter/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:5:\"frame\";a:16:{s:5:\"title\";s:5:\"Frame\";s:5:\"image\";s:60:\"https://woocommerce.com/wp-content/uploads/2021/06/frame.jpg\";s:7:\"excerpt\";s:114:\"Frame is a Gutenberg Powered WooCommerce theme suitable for stores with a large number of products and categories.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/frame/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:29:\"https://frame.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"1b480c21-8122-478e-a728-68e235b0b9cf\";s:4:\"slug\";s:5:\"frame\";s:2:\"id\";i:8152078;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:10:\"smart-home\";a:16:{s:5:\"title\";s:10:\"Smart Home\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2021/04/browser.jpg\";s:7:\"excerpt\";s:131:\"Smart Home is a beautiful Gutenberg-powered theme with a technology-style look suitable for all stores selling smart home products.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/smart-home/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:33:\"https://smarthome.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"d1d581ad-3efa-40c2-b7e0-bb6722779a0b\";s:4:\"slug\";s:10:\"smart-home\";s:2:\"id\";i:7916465;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"skinny\";a:16:{s:5:\"title\";s:6:\"Skinny\";s:5:\"image\";s:71:\"https://woocommerce.com/wp-content/uploads/2021/04/SKfeatured.png?w=800\";s:7:\"excerpt\";s:123:\"Create a beautiful online shop with Skinny, and optionally allow your site visitors to switch between light and dark skins.\";s:4:\"link\";s:109:\"https://woocommerce.com/products/skinny/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:32:\"https://demo.codestag.com/skinny\";s:5:\"price\";s:10:\"&#36;69.00\";s:4:\"hash\";s:36:\"a21bf5b9-3c45-4d6c-bf24-74ddae21023f\";s:4:\"slug\";s:6:\"skinny\";s:2:\"id\";i:7753168;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:8:\"Codestag\";s:10:\"vendor_url\";s:40:\"https://woocommerce.com/vendor/codestag/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:12:\"pure-fashion\";a:16:{s:5:\"title\";s:12:\"Pure Fashion\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2021/03/browser.jpg\";s:7:\"excerpt\";s:88:\"Beautiful WooCommerce theme with soft colors and a unique layout using Gutenberg editor.\";s:4:\"link\";s:115:\"https://woocommerce.com/products/pure-fashion/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:35:\"https://purefashion.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"9d7ed165-8435-4b0f-8315-8e4a5868f0b0\";s:4:\"slug\";s:12:\"pure-fashion\";s:2:\"id\";i:7704815;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"overline\";a:16:{s:5:\"title\";s:8:\"Overline\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2020/11/overline.jpg\";s:7:\"excerpt\";s:171:\"Overline is designed for the new generation of beauty brands and influencers opening their own e-commerce shops. Custom Gutenberg elements allow for increased flexibility.\";s:4:\"link\";s:111:\"https://woocommerce.com/products/overline/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:32:\"https://overline.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"6eab91f2-ca09-4f7e-9022-df55fd8540a9\";s:4:\"slug\";s:8:\"overline\";s:2:\"id\";i:7320744;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"agency\";a:16:{s:5:\"title\";s:6:\"Agency\";s:5:\"image\";s:70:\"https://woocommerce.com/wp-content/uploads/2020/10/agency-featured.jpg\";s:7:\"excerpt\";s:134:\"Agency is a Gutenberg and WooCommerce optimized WordPress theme for marketing, advertising, and creative agencies. Sell your services!\";s:4:\"link\";s:109:\"https://woocommerce.com/products/agency/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://organicthemes.com/demo/agency/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"4a3a3a22-a5f0-4fa4-8c09-4f37575602ef\";s:4:\"slug\";s:6:\"agency\";s:2:\"id\";i:6674855;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:14:\"Organic Themes\";s:10:\"vendor_url\";s:46:\"https://woocommerce.com/vendor/organic-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"rhodes\";a:16:{s:5:\"title\";s:6:\"Rhodes\";s:5:\"image\";s:66:\"https://woocommerce.com/wp-content/uploads/2020/09/rhodes-home.jpg\";s:7:\"excerpt\";s:193:\"The perfect WooCommerce theme for retailers. Whether you\'re selling high-street fashion, beauty products, or home accessories, Rhodes will just stand out of the way letting your products shine.\";s:4:\"link\";s:109:\"https://woocommerce.com/products/rhodes/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:46:\"https://www.cssigniter.com/woocommerce/rhodes/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"b95c0103-23b9-43f3-af49-ee7eaa35e49b\";s:4:\"slug\";s:6:\"rhodes\";s:2:\"id\";i:6509339;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:10:\"CSSIgniter\";s:10:\"vendor_url\";s:42:\"https://woocommerce.com/vendor/cssigniter/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:11:\"restoration\";a:16:{s:5:\"title\";s:11:\"Restoration\";s:5:\"image\";s:78:\"https://woocommerce.com/wp-content/uploads/2020/09/restoration-woocommerce.jpg\";s:7:\"excerpt\";s:90:\"An elegant and sophisticated mobile-first, Gutenberg-powered theme for WooCommerce stores.\";s:4:\"link\";s:114:\"https://woocommerce.com/products/restoration/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:35:\"https://restoration.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"e793e6af-f338-4e92-b268-e0576ddb137b\";s:4:\"slug\";s:11:\"restoration\";s:2:\"id\";i:6454820;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"matthew\";a:16:{s:5:\"title\";s:7:\"Matthew\";s:5:\"image\";s:73:\"https://woocommerce.com/wp-content/uploads/2020/07/matthew-screenshot.jpg\";s:7:\"excerpt\";s:145:\"Matthew is a Gutenberg-powered WooCommerce theme designed for building a professional online store so that you can sell goods or services online.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/matthew/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://demo.themesharbor.com/matthew/\";s:5:\"price\";s:11:\"&#36;129.00\";s:4:\"hash\";s:36:\"b3983408-c4f6-4751-8bd7-ae65ae34cf3b\";s:4:\"slug\";s:7:\"matthew\";s:2:\"id\";i:6214538;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:13:\"Themes Harbor\";s:10:\"vendor_url\";s:45:\"https://woocommerce.com/vendor/themes-harbor/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:11:\"fifthavenue\";a:16:{s:5:\"title\";s:12:\"Fifth Avenue\";s:5:\"image\";s:78:\"https://woocommerce.com/wp-content/uploads/2020/06/fifthavenue-woocommerce.jpg\";s:7:\"excerpt\";s:103:\"Beautiful Gutenberg powered WooCommerce theme designed to be easily customized for all types of stores.\";s:4:\"link\";s:115:\"https://woocommerce.com/products/fifth-avenue/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:35:\"https://fifthavenue.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"9e093a9f-3d49-4fcd-bec7-c87b097d9df8\";s:4:\"slug\";s:11:\"fifthavenue\";s:2:\"id\";i:5989481;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Fuel Themes\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/fuel-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"artisan\";a:16:{s:5:\"title\";s:7:\"Artisan\";s:5:\"image\";s:71:\"https://woocommerce.com/wp-content/uploads/2020/03/artisan-featured.jpg\";s:7:\"excerpt\";s:79:\"Sell your hand-crafted products online using the Artisan Theme for WooCommerce.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/artisan/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://organicthemes.com/demo/artisan/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"64529812-81f6-4efd-9686-ecb34e527421\";s:4:\"slug\";s:7:\"artisan\";s:2:\"id\";i:5576887;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:14:\"Organic Themes\";s:10:\"vendor_url\";s:46:\"https://woocommerce.com/vendor/organic-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"threads\";a:16:{s:5:\"title\";s:7:\"Threads\";s:5:\"image\";s:75:\"https://woocommerce.com/wp-content/uploads/2019/08/threads-home-cropped.jpg\";s:7:\"excerpt\";s:79:\"Create a stunning website for your apparel brand using Threads for WooCommerce.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/threads/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://organicthemes.com/demo/threads/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"7ca579a6-6aaf-498c-9ee7-e15280ace9e9\";s:4:\"slug\";s:7:\"threads\";s:2:\"id\";i:4663191;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:14:\"Organic Themes\";s:10:\"vendor_url\";s:46:\"https://woocommerce.com/vendor/organic-themes/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:10:\"block-shop\";a:16:{s:5:\"title\";s:10:\"Block Shop\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/uploads/2019/08/block-shop-theme-preview.jpg\";s:7:\"excerpt\";s:148:\"A hassle-free block-based theme for your next WooCommerce project. You can call it hassle-free Online Store Builder. Compatible with WooCommerce 6.x\";s:4:\"link\";s:113:\"https://woocommerce.com/products/block-shop/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:34:\"https://blockshop.wp-theme.design/\";s:5:\"price\";s:10:\"&#36;59.00\";s:4:\"hash\";s:36:\"21fa433c-6c31-4be7-83ab-8d2cc8986130\";s:4:\"slug\";s:10:\"block-shop\";s:2:\"id\";i:4660093;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"Get Bowtied\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/get-bowtied/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"bistro\";a:16:{s:5:\"title\";s:6:\"Bistro\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2016/07/bistro.png\";s:7:\"excerpt\";s:174:\"Bistro is a Storefront child theme designed for stores selling organic goods and other consumables. It features a friendly and warm design that lends itself to this industry.\";s:4:\"link\";s:109:\"https://woocommerce.com/products/bistro/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:37:\"https://themes.woocommerce.com/bistro\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"58e753f91fddf40abe8ebe4486f8c378\";s:4:\"slug\";s:6:\"bistro\";s:2:\"id\";i:1822936;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:10:\"stationery\";a:16:{s:5:\"title\";s:10:\"Stationery\";s:5:\"image\";s:65:\"https://woocommerce.com/wp-content/uploads/2016/04/stationery.jpg\";s:7:\"excerpt\";s:186:\"Stationery is a Storefront child theme designed for stores selling office supplies and/or arts &amp; crafts. The design has subtle tactile decorations while also being clean and elegant.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/stationery/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:42:\"https://themes.woocommerce.com/stationery/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"b939225b8b8ccdc7b14ffb6d7eab2ac2\";s:4:\"slug\";s:10:\"stationery\";s:2:\"id\";i:1629126;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"petshop\";a:16:{s:5:\"title\";s:7:\"Petshop\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2016/03/petshop.png\";s:7:\"excerpt\";s:181:\"Petshop is a Storefront child theme designed for stores selling products in the pet industry. The design is organic and friendly, featuring many details that point to pet ownership.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/petshop/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://themes.woocommerce.com/petshop/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"8060743c9031974326850f539aba5196\";s:4:\"slug\";s:7:\"petshop\";s:2:\"id\";i:1587689;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:5:\"hotel\";a:16:{s:5:\"title\";s:5:\"Hotel\";s:5:\"image\";s:69:\"https://woocommerce.com/wp-content/uploads/2016/03/hotel-featured.jpg\";s:7:\"excerpt\";s:246:\"Hotel is designed for businesses selling time, services and accommodation, offering unique integration with WooCommerce Bookings and Accommodation Bookings. The design is bold yet simple, allowing your content and imagery to do all the talking.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/hotel/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:37:\"https://themes.woocommerce.com/hotel/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"0b0df891aa46f289f4e49bae2389bb04\";s:4:\"slug\";s:5:\"hotel\";s:2:\"id\";i:1554532;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"bookshop\";a:16:{s:5:\"title\";s:8:\"Bookshop\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2016/02/featured.png\";s:7:\"excerpt\";s:183:\"Bookshop comes with a unique homepage layout that prominently displays product categories and a variety of products in an arrangement that is popular with bookstores and collectibles.\";s:4:\"link\";s:111:\"https://woocommerce.com/products/bookshop/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:40:\"https://themes.woocommerce.com/bookshop/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"9fe861227e3e82fde8fe5d7e8cc3340e\";s:4:\"slug\";s:8:\"bookshop\";s:2:\"id\";i:1508713;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"arcade\";a:16:{s:5:\"title\";s:6:\"Arcade\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2016/01/arcade.png\";s:7:\"excerpt\";s:216:\"Upgrade your video game shops look and feel with Arcade. It\'s bold and modern design will engage visitors and the unique homepage layout will present them with a variety of products as soon as they hit your homepage.\";s:4:\"link\";s:109:\"https://woocommerce.com/products/arcade/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://themes.woocommerce.com/arcade/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"5af09d4e590eec977c6b9519b517f479\";s:4:\"slug\";s:6:\"arcade\";s:2:\"id\";i:1418260;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:9:\"homestore\";a:16:{s:5:\"title\";s:9:\"Homestore\";s:5:\"image\";s:64:\"https://woocommerce.com/wp-content/uploads/2015/12/homestore.jpg\";s:7:\"excerpt\";s:166:\"Give your Department Store a classic look with Homestore. Its clean and efficient design will work well whether you\'re a boutique independent or a high street giant.\";s:4:\"link\";s:112:\"https://woocommerce.com/products/homestore/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:41:\"https://themes.woocommerce.com/homestore/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"d79fe7a1beba26523aafa6ce6d3e1e85\";s:4:\"slug\";s:9:\"homestore\";s:2:\"id\";i:1365559;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"pharmacy\";a:16:{s:5:\"title\";s:8:\"Pharmacy\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2015/12/pharmacy.jpg\";s:7:\"excerpt\";s:235:\"Give your health store a professional, trust-worthy design with the Pharmacy Storefront Child Theme. Built upon our rock solid Storefront Parent theme you\'ll also enjoy reliable integration with current and future WooCommerce releases.\";s:4:\"link\";s:111:\"https://woocommerce.com/products/pharmacy/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:40:\"https://themes.woocommerce.com/pharmacy/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"ebeff3c0f89cd3169fb6b3e7e137e513\";s:4:\"slug\";s:8:\"pharmacy\";s:2:\"id\";i:1365557;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"toyshop\";a:16:{s:5:\"title\";s:7:\"ToyShop\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2015/09/toyshop.jpg\";s:7:\"excerpt\";s:269:\"Add some fun to your store with ToyShop. The engaging and colorful design of ToyShop makes it a perfect child theme or any store that sells exciting products that are aimed at customers that like to have fun. The outdoorsy style would even be perfect for a flower shop.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/toyshop/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://themes.woocommerce.com/toyshop/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"3e2520021b41ee49a55b93362aaced98\";s:4:\"slug\";s:7:\"toyshop\";s:2:\"id\";i:1230716;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"outlet\";a:16:{s:5:\"title\";s:6:\"Outlet\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2015/09/outlet.jpg\";s:7:\"excerpt\";s:221:\"Overclock your tech store with Outlet! Whether you sell boutique iPad jewellery or the nuts and bolts of hardware itself, Outlet will give your shop a stylish look and feel while enjoying the stability of Storefront core.\";s:4:\"link\";s:109:\"https://woocommerce.com/products/outlet/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://themes.woocommerce.com/outlet/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"4c311cb3a3131570946b8799715a0991\";s:4:\"slug\";s:6:\"outlet\";s:2:\"id\";i:1212805;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"proshop\";a:16:{s:5:\"title\";s:7:\"ProShop\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2015/06/proshop.jpg\";s:7:\"excerpt\";s:176:\"Unlock the true potential of your sports clothing and equipment store with ProShop! It\'s metropolitan design provides an active aesthetic giving your store oodles of character.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/proshop/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://themes.woocommerce.com/proshop/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"1d51b8633bbd1782dc17fce15f8bd2af\";s:4:\"slug\";s:7:\"proshop\";s:2:\"id\";i:1000757;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"galleria\";a:16:{s:5:\"title\";s:8:\"Galleria\";s:5:\"image\";s:68:\"https://woocommerce.com/wp-content/uploads/2015/05/galleria-hero.png\";s:7:\"excerpt\";s:162:\"Galleria is a Storefront child theme perfect for fashion and design stores. Stylish and minimalist, it gives sites a classy look and keeps products center stage.\";s:4:\"link\";s:111:\"https://woocommerce.com/products/galleria/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:40:\"https://themes.woocommerce.com/galleria/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"2429c1dde521031cd053886b15844bbf\";s:4:\"slug\";s:8:\"galleria\";s:2:\"id\";i:887931;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:4:\"deli\";a:16:{s:5:\"title\";s:4:\"Deli\";s:5:\"image\";s:59:\"https://woocommerce.com/wp-content/uploads/2015/03/deli.jpg\";s:7:\"excerpt\";s:135:\"Deli is a Storefront child theme featuring a texturised, earthy design, perfect for stores selling natural, organic or hand made goods.\";s:4:\"link\";s:107:\"https://woocommerce.com/products/deli/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:36:\"https://themes.woocommerce.com/deli/\";s:5:\"price\";s:9:\"&#36;0.00\";s:4:\"hash\";s:32:\"83c6db94c8ebf9da56b59fb97f724e88\";s:4:\"slug\";s:4:\"deli\";s:2:\"id\";i:784823;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"boutique\";a:16:{s:5:\"title\";s:8:\"Boutique\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2015/01/boutique.png\";s:7:\"excerpt\";s:168:\"Boutique is a simple, traditionally designed Storefront child theme, ideal for small stores or boutiques. Add your logo, create a unique color scheme and start selling!\";s:4:\"link\";s:111:\"https://woocommerce.com/products/boutique/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\";s:8:\"demo_url\";s:40:\"https://themes.woocommerce.com/boutique/\";s:5:\"price\";s:9:\"&#36;0.00\";s:4:\"hash\";s:32:\"71815288e266d58031727d48d6deee25\";s:4:\"slug\";s:8:\"boutique\";s:2:\"id\";i:605777;s:6:\"rating\";N;s:13:\"reviews_count\";N;s:11:\"vendor_name\";s:11:\"WooCommerce\";s:10:\"vendor_url\";s:43:\"https://woocommerce.com/vendor/woocommerce/\";s:4:\"icon\";N;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}}", "no");
INSERT INTO `esduc_options` VALUES("9660", "thwcfd_since", "1640939915", "no");
INSERT INTO `esduc_options` VALUES("9661", "wc_fields_billing", "a:11:{s:18:\"billing_first_name\";a:9:{s:5:\"label\";s:6:\"نام\";s:8:\"required\";b:1;s:5:\"class\";a:1:{i:0;s:14:\"form-row-first\";}s:12:\"autocomplete\";s:10:\"given-name\";s:8:\"priority\";i:10;s:6:\"custom\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:17:\"billing_last_name\";a:9:{s:5:\"label\";s:23:\"نام خانوادگی\";s:8:\"required\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-last\";}s:12:\"autocomplete\";s:11:\"family-name\";s:8:\"priority\";i:20;s:6:\"custom\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:15:\"billing_company\";a:15:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:15:\"billing_company\";s:5:\"label\";s:15:\"نام شرکت\";s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"validate\";s:0:\"\";s:8:\"required\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:0;s:13:\"show_in_order\";i:0;s:7:\"options\";s:0:\"\";s:12:\"autocomplete\";s:12:\"organization\";s:8:\"priority\";i:30;s:6:\"custom\";i:0;}s:15:\"billing_country\";a:15:{s:4:\"type\";s:7:\"country\";s:4:\"name\";s:15:\"billing_country\";s:5:\"label\";s:21:\"کشور / منطقه\";s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"class\";a:3:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";i:2;s:23:\"update_totals_on_change\";}s:8:\"validate\";s:0:\"\";s:8:\"required\";i:1;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:0;s:13:\"show_in_order\";i:0;s:7:\"options\";s:0:\"\";s:12:\"autocomplete\";s:7:\"country\";s:8:\"priority\";i:40;s:6:\"custom\";i:0;}s:17:\"billing_address_1\";a:10:{s:5:\"label\";s:21:\"آدرس خیابان\";s:11:\"placeholder\";s:40:\"نام خیابان و پلاک خانه\";s:8:\"required\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:12:\"autocomplete\";s:13:\"address-line1\";s:8:\"priority\";i:50;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:17:\"billing_address_2\";a:15:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:17:\"billing_address_2\";s:5:\"label\";s:46:\"آپارتمان، مجتمع، واحد و...\";s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:63:\"آپارتمان، مجتمع، واحد و... (اختیاری)\";s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"validate\";s:0:\"\";s:8:\"required\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:0;s:13:\"show_in_order\";i:0;s:7:\"options\";s:0:\"\";s:12:\"autocomplete\";s:13:\"address-line2\";s:8:\"priority\";i:60;s:6:\"custom\";i:0;}s:12:\"billing_city\";a:9:{s:5:\"label\";s:6:\"شهر\";s:8:\"required\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:12:\"autocomplete\";s:14:\"address-level2\";s:8:\"priority\";i:70;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:13:\"billing_state\";a:15:{s:4:\"type\";s:5:\"state\";s:4:\"name\";s:13:\"billing_state\";s:5:\"label\";s:10:\"استان\";s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"validate\";a:1:{i:0;s:5:\"state\";}s:8:\"required\";i:1;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:0;s:13:\"show_in_order\";i:0;s:7:\"options\";s:0:\"\";s:12:\"autocomplete\";s:14:\"address-level1\";s:8:\"priority\";i:80;s:6:\"custom\";i:0;}s:16:\"billing_postcode\";a:10:{s:5:\"label\";s:68:\"کدپستی (بدون فاصله و با اعداد انگلیسی)\";s:8:\"required\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"validate\";a:1:{i:0;s:8:\"postcode\";}s:12:\"autocomplete\";s:11:\"postal-code\";s:8:\"priority\";i:90;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:13:\"billing_phone\";a:11:{s:5:\"label\";s:8:\"تلفن\";s:8:\"required\";b:1;s:4:\"type\";s:3:\"tel\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"validate\";a:1:{i:0;s:5:\"phone\";}s:12:\"autocomplete\";s:3:\"tel\";s:8:\"priority\";i:100;s:6:\"custom\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:13:\"billing_email\";a:11:{s:5:\"label\";s:19:\"آدرس ایمیل\";s:8:\"required\";b:1;s:4:\"type\";s:5:\"email\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"validate\";a:1:{i:0;s:5:\"email\";}s:12:\"autocomplete\";s:14:\"email username\";s:8:\"priority\";i:110;s:6:\"custom\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}}", "no");
INSERT INTO `esduc_options` VALUES("9663", "wc_fields_additional", "a:1:{s:14:\"order_comments\";a:9:{s:4:\"type\";s:8:\"textarea\";s:5:\"class\";a:1:{i:0;s:5:\"notes\";}s:5:\"label\";s:11:\"Order Notes\";s:11:\"placeholder\";s:56:\"Notes about your order, e.g. special notes for delivery.\";s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;s:8:\"priority\";i:10;}}", "no");
INSERT INTO `esduc_options` VALUES("9701", "gravityformsaddon_feed-base_version", "0.14", "yes");
INSERT INTO `esduc_options` VALUES("9999", "learndash_achievements_settings_popup", "a:4:{s:10:\"popup_time\";i:0;s:16:\"background_color\";s:7:\"#2575fc\";s:10:\"text_color\";s:7:\"#ffffff\";s:3:\"rtl\";s:1:\"1\";}", "yes");
INSERT INTO `esduc_options` VALUES("514", "wpProQuiz_addRawShortcode", "", "yes");
INSERT INTO `esduc_options` VALUES("515", "wpProQuiz_jsLoadInHead", "", "yes");
INSERT INTO `esduc_options` VALUES("516", "wpProQuiz_touchLibraryDeactivate", "", "yes");
INSERT INTO `esduc_options` VALUES("517", "wpProQuiz_corsActivated", "", "yes");
INSERT INTO `esduc_options` VALUES("519", "nss_plugin_license_sfwd_lms", "", "yes");
INSERT INTO `esduc_options` VALUES("520", "nss_plugin_license_email_sfwd_lms", "", "yes");
INSERT INTO `esduc_options` VALUES("557", "us_flush_rules", "1", "yes");
INSERT INTO `esduc_options` VALUES("20823", "category_children", "a:0:{}", "yes");
INSERT INTO `esduc_options` VALUES("2861", "__uagb_do_redirect", "", "yes");
INSERT INTO `esduc_options` VALUES("2862", "__uagb_asset_version", "1638808046", "yes");
INSERT INTO `esduc_options` VALUES("2863", "_uagb_allow_file_generation", "enabled", "yes");
INSERT INTO `esduc_options` VALUES("2864", "uagb-version", "1.25.2", "yes");
INSERT INTO `esduc_options` VALUES("2865", "ast-block-templates-categories", "a:18:{i:0;a:5:{s:2:\"id\";i:832;s:5:\"count\";i:43;s:4:\"name\";s:14:\"Call To Action\";s:4:\"slug\";s:14:\"call-to-action\";s:6:\"parent\";i:0;}i:1;a:5:{s:2:\"id\";i:825;s:5:\"count\";i:60;s:4:\"name\";s:5:\"About\";s:4:\"slug\";s:5:\"about\";s:6:\"parent\";i:0;}i:2;a:5:{s:2:\"id\";i:1091;s:5:\"count\";i:20;s:4:\"name\";s:7:\"Clients\";s:4:\"slug\";s:7:\"clients\";s:6:\"parent\";i:0;}i:3;a:5:{s:2:\"id\";i:1416;s:5:\"count\";i:42;s:4:\"name\";s:7:\"Contact\";s:4:\"slug\";s:7:\"contact\";s:6:\"parent\";i:0;}i:4;a:5:{s:2:\"id\";i:1001;s:5:\"count\";i:31;s:4:\"name\";s:3:\"FAQ\";s:4:\"slug\";s:3:\"faq\";s:6:\"parent\";i:0;}i:5;a:5:{s:2:\"id\";i:919;s:5:\"count\";i:51;s:4:\"name\";s:8:\"Features\";s:4:\"slug\";s:8:\"features\";s:6:\"parent\";i:0;}i:6;a:5:{s:2:\"id\";i:1094;s:5:\"count\";i:30;s:4:\"name\";s:7:\"Heading\";s:4:\"slug\";s:7:\"heading\";s:6:\"parent\";i:0;}i:7;a:5:{s:2:\"id\";i:831;s:5:\"count\";i:61;s:4:\"name\";s:4:\"Hero\";s:4:\"slug\";s:4:\"hero\";s:6:\"parent\";i:0;}i:8;a:5:{s:2:\"id\";i:1948;s:5:\"count\";i:30;s:4:\"name\";s:14:\"Image and Text\";s:4:\"slug\";s:14:\"image-and-text\";s:6:\"parent\";i:0;}i:9;a:5:{s:2:\"id\";i:1950;s:5:\"count\";i:16;s:4:\"name\";s:18:\"Location And Hours\";s:4:\"slug\";s:18:\"location-and-hours\";s:6:\"parent\";i:0;}i:10;a:5:{s:2:\"id\";i:1425;s:5:\"count\";i:36;s:4:\"name\";s:9:\"Portfolio\";s:4:\"slug\";s:9:\"portfolio\";s:6:\"parent\";i:0;}i:11;a:5:{s:2:\"id\";i:952;s:5:\"count\";i:51;s:4:\"name\";s:8:\"Services\";s:4:\"slug\";s:8:\"services\";s:6:\"parent\";i:0;}i:12;a:5:{s:2:\"id\";i:1424;s:5:\"count\";i:28;s:4:\"name\";s:12:\"Single Quote\";s:4:\"slug\";s:12:\"single-quote\";s:6:\"parent\";i:0;}i:13;a:5:{s:2:\"id\";i:1096;s:5:\"count\";i:26;s:4:\"name\";s:10:\"Statistics\";s:4:\"slug\";s:10:\"statistics\";s:6:\"parent\";i:0;}i:14;a:5:{s:2:\"id\";i:1953;s:5:\"count\";i:18;s:4:\"name\";s:14:\"Subscribe Form\";s:4:\"slug\";s:14:\"subscribe-form\";s:6:\"parent\";i:0;}i:15;a:5:{s:2:\"id\";i:829;s:5:\"count\";i:46;s:4:\"name\";s:4:\"Team\";s:4:\"slug\";s:4:\"team\";s:6:\"parent\";i:0;}i:16;a:5:{s:2:\"id\";i:830;s:5:\"count\";i:48;s:4:\"name\";s:12:\"Testimonials\";s:4:\"slug\";s:12:\"testimonials\";s:6:\"parent\";i:0;}i:17;a:5:{s:2:\"id\";i:1946;s:5:\"count\";i:27;s:4:\"name\";s:4:\"Text\";s:4:\"slug\";s:4:\"text\";s:6:\"parent\";i:0;}}", "no");
INSERT INTO `esduc_options` VALUES("3614", "us_widget_areas", "a:1:{s:24:\"us_widget_area_mega_menu\";s:9:\"mega menu\";}", "yes");
INSERT INTO `esduc_options` VALUES("3644", "_us_used_icons", "a:2:{s:5:\"icons\";a:30:{i:0;s:12:\"fab|facebook\";i:1;s:11:\"fab|twitter\";i:2;s:12:\"fab|whatsapp\";i:3;s:12:\"fab|telegram\";i:4;s:14:\"fas|angle-left\";i:5;s:8:\"fas|play\";i:6;s:17:\"fas|user-graduate\";i:7;s:10:\"fas|search\";i:8;s:9:\"fas|phone\";i:9;s:12:\"fas|envelope\";i:10;s:17:\"fas|shopping-cart\";i:11;s:13:\"fab|instagram\";i:12;s:9:\"fas|tools\";i:13;s:9:\"fas|award\";i:14;s:15:\"fas|dollar-sign\";i:15;s:18:\"fas|graduation-cap\";i:16;s:11:\"fas|headset\";i:17;s:12:\"fas|download\";i:18;s:15:\"fas|book-reader\";i:19;s:12:\"fas|calendar\";i:20;s:12:\"fas|comments\";i:21;s:8:\"fas|plus\";i:22;s:9:\"far|smile\";i:23;s:8:\"far|file\";i:24;s:14:\"fas|arrow-left\";i:25;s:12:\"far|comments\";i:26;s:8:\"far|star\";i:27;s:10:\"fab|google\";i:28;s:12:\"fab|linkedin\";i:29;s:11:\"fab|youtube\";}s:5:\"posts\";a:30:{s:12:\"fab|facebook\";a:4:{i:0;s:2:\"28\";i:2;s:2:\"43\";i:10;s:3:\"414\";i:18;s:3:\"447\";}s:11:\"fab|twitter\";a:4:{i:0;s:2:\"28\";i:2;s:2:\"43\";i:10;s:3:\"414\";i:18;s:3:\"447\";}s:12:\"fab|whatsapp\";a:1:{i:0;s:2:\"28\";}s:12:\"fab|telegram\";a:1:{i:0;s:2:\"28\";}s:14:\"fas|angle-left\";a:5:{i:0;s:2:\"28\";i:77;s:2:\"43\";i:275;s:3:\"371\";i:277;s:3:\"414\";i:475;s:3:\"430\";}s:8:\"fas|play\";a:1:{i:0;s:2:\"28\";}s:17:\"fas|user-graduate\";a:1:{i:0;s:2:\"28\";}s:10:\"fas|search\";a:4:{i:0;s:2:\"29\";i:2;s:2:\"43\";i:4;s:3:\"414\";i:6;s:3:\"447\";}s:9:\"fas|phone\";a:3:{i:0;s:2:\"29\";i:2;s:2:\"43\";i:200;s:3:\"414\";}s:12:\"fas|envelope\";a:1:{i:0;s:2:\"29\";}s:17:\"fas|shopping-cart\";a:2:{i:0;s:2:\"29\";i:2;s:3:\"447\";}s:13:\"fab|instagram\";a:2:{i:0;s:2:\"43\";i:8;s:3:\"414\";}s:9:\"fas|tools\";a:2:{i:0;s:2:\"43\";i:198;s:3:\"414\";}s:9:\"fas|award\";a:2:{i:0;s:2:\"43\";i:198;s:3:\"414\";}s:15:\"fas|dollar-sign\";a:2:{i:0;s:2:\"43\";i:198;s:3:\"414\";}s:18:\"fas|graduation-cap\";a:2:{i:0;s:2:\"43\";i:198;s:3:\"414\";}s:11:\"fas|headset\";a:2:{i:0;s:2:\"43\";i:198;s:3:\"414\";}s:12:\"fas|download\";a:2:{i:0;s:2:\"43\";i:198;s:3:\"414\";}s:15:\"fas|book-reader\";a:1:{i:0;s:3:\"246\";}s:12:\"fas|calendar\";a:2:{i:0;s:3:\"308\";i:2;s:3:\"437\";}s:12:\"fas|comments\";a:2:{i:0;s:3:\"308\";i:2;s:3:\"437\";}s:8:\"fas|plus\";a:2:{i:0;s:3:\"308\";i:2;s:3:\"437\";}s:9:\"far|smile\";a:3:{i:0;s:3:\"321\";i:2;s:3:\"432\";i:4;s:3:\"443\";}s:8:\"far|file\";a:3:{i:0;s:3:\"321\";i:2;s:3:\"432\";i:4;s:3:\"443\";}s:14:\"fas|arrow-left\";a:3:{i:0;s:3:\"321\";i:2;s:3:\"432\";i:4;s:3:\"443\";}s:12:\"far|comments\";a:3:{i:0;s:3:\"321\";i:2;s:3:\"432\";i:4;s:3:\"443\";}s:8:\"far|star\";a:2:{i:0;s:3:\"321\";i:1;s:3:\"432\";}s:10:\"fab|google\";a:1:{i:0;s:3:\"447\";}s:12:\"fab|linkedin\";a:1:{i:0;s:3:\"447\";}s:11:\"fab|youtube\";a:1:{i:0;s:3:\"447\";}}}", "yes");
INSERT INTO `esduc_options` VALUES("1475", "learndash_woocommerce_silent_course_enrollment_queue", "a:0:{}", "no");
INSERT INTO `esduc_options` VALUES("1494", "learndash_zarinpal_settings", "a:5:{s:10:\"MerchantID\";s:0:\"\";s:9:\"test_mode\";s:1:\"0\";s:8:\"currency\";s:8:\"ریال\";s:10:\"return_url\";s:0:\"\";s:8:\"zaringit\";s:1:\"0\";}", "yes");
INSERT INTO `esduc_options` VALUES("1476", "learndash_woocommerce_version", "1.9.3.4", "yes");
INSERT INTO `esduc_options` VALUES("2832", "new_admin_email", "test-theme@demoabzar.com", "yes");
INSERT INTO `esduc_options` VALUES("3085", "recovery_mode_email_last_sent", "1644826342", "yes");
INSERT INTO `esduc_options` VALUES("3094", "ir_active_modules", "a:14:{i:0;s:20:\"multiple_instructors\";i:1;s:8:\"comments\";i:2;s:7:\"reports\";i:3;s:6:\"groups\";i:4;s:13:\"notifications\";i:5;s:7:\"payouts\";i:6;s:7:\"profile\";i:7;s:6:\"emails\";i:8;s:11:\"woocommerce\";i:9;s:17:\"learndash_handler\";i:10;s:22:\"learndash_menu_handler\";i:11;s:10:\"commission\";i:12;s:8:\"settings\";i:13;s:6:\"review\";}", "yes");
INSERT INTO `esduc_options` VALUES("3099", "edd_license_send_data_status", "no", "yes");
INSERT INTO `esduc_options` VALUES("2866", "ast-block-templates-sites-1", "a:78:{s:8:\"id-56593\";a:13:{s:5:\"title\";s:18:\"Meditation Courses\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-homepage-gb-400x1256.jpg\";s:14:\"astra-site-url\";s:38:\"//websitedemos.net/learn-meditation-08\";s:20:\"astra-site-parent-id\";i:2242;s:15:\"astra-sites-tag\";a:5:{i:462;s:7:\"courses\";i:467;s:9:\"learndash\";i:1850;s:10:\"meditation\";i:975;s:15:\"online-learning\";i:720;s:9:\"tutorials\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-56595\";a:12:{s:5:\"title\";s:7:\"Classes\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-classes-gb.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-classes-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/learn-meditation-08/wp-json/wp/v2/pages/607\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/learn-meditation-08/classes/\";s:15:\"astra-sites-tag\";a:1:{i:557;s:7:\"classes\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56596\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/learn-meditation-08/wp-json/wp/v2/pages/617\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/learn-meditation-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56594\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/learn-meditation-08/wp-json/wp/v2/pages/612\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/learn-meditation-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56597\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2021/06/meditation-courses-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/learn-meditation-08/wp-json/wp/v2/pages/572\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/learn-meditation-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}}}s:8:\"id-48078\";a:13:{s:5:\"title\";s:17:\"Outdoor Adventure\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home-400x956.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/outdoor-adventure-08\";s:20:\"astra-site-parent-id\";i:1698;s:15:\"astra-sites-tag\";a:6:{i:544;s:9:\"adventure\";i:545;s:7:\"camping\";i:543;s:14:\"extreme-sports\";i:541;s:9:\"mountains\";i:542;s:4:\"park\";i:546;s:6:\"sports\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48081\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/outdoor-adventure-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48079\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-about.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/outdoor-adventure-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48083\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-services.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/outdoor-adventure-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48082\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-projects.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-projects-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/outdoor-adventure-08/projects/\";s:15:\"astra-sites-tag\";a:1:{i:1613;s:8:\"projects\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48080\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/outdoor-adventure-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48050\";a:13:{s:5:\"title\";s:10:\"Brandstore\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-1-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-1-400x1090.jpg\";s:14:\"astra-site-url\";s:32:\"//websitedemos.net/brandstore-08\";s:20:\"astra-site-parent-id\";i:1695;s:15:\"astra-sites-tag\";a:8:{i:639;s:11:\"accessories\";i:638;s:11:\"brand-store\";i:640;s:11:\"cloth-store\";i:637;s:8:\"clothing\";i:496;s:9:\"ecommerce\";i:383;s:12:\"online-store\";i:733;s:4:\"shop\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:3:{i:27;s:8:\"business\";i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:3:{s:8:\"id-48053\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/brandstore-08/wp-json/wp/v2/pages/61\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:33:\"//websitedemos.net/brandstore-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:60;s:8:\"business\";i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48051\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-about-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/brandstore-08/wp-json/wp/v2/pages/59\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/brandstore-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:60;s:8:\"business\";i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48052\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-contact-1.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-contact-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/brandstore-08/wp-json/wp/v2/pages/60\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/brandstore-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:60;s:8:\"business\";i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48121\";a:13:{s:5:\"title\";s:13:\"Organic Store\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop01-home.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop01-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop01-home-400x1367.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/organic-shop-08\";s:20:\"astra-site-parent-id\";i:1702;s:15:\"astra-sites-tag\";a:6:{i:496;s:9:\"ecommerce\";i:369;s:7:\"natural\";i:368;s:7:\"organic\";i:967;s:13:\"product-store\";i:733;s:4:\"shop\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:1;a:3:{s:4:\"slug\";s:29:\"woo-cart-abandonment-recovery\";s:4:\"init\";s:63:\"woo-cart-abandonment-recovery/woo-cart-abandonment-recovery.php\";s:4:\"name\";s:37:\"WooCommerce Cart Abandonment Recovery\";}}s:5:\"pages\";a:3:{s:8:\"id-48124\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop01-home.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop01-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/organic-shop-08/wp-json/wp/v2/pages/3610\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/organic-shop-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48122\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/organic-shop-08/wp-json/wp/v2/pages/3612\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/organic-shop-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48123\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/organic-shop-08/wp-json/wp/v2/pages/3614\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/organic-shop-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-47984\";a:13:{s:5:\"title\";s:17:\"LearnDash Academy\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1-400x1242.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/learndash-academy-08\";s:20:\"astra-site-parent-id\";i:1691;s:15:\"astra-sites-tag\";a:5:{i:462;s:7:\"courses\";i:468;s:9:\"elearning\";i:467;s:9:\"learndash\";i:460;s:8:\"learning\";i:466;s:14:\"online-courses\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47988\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/learndash-academy-08/wp-json/wp/v2/pages/25407\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/learndash-academy-08/\";s:15:\"astra-sites-tag\";a:2:{i:423;s:4:\"home\";i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47986\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-courses-1.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-courses-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/learndash-academy-08/wp-json/wp/v2/pages/25403\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:52:\"//websitedemos.net/learndash-academy-08/all-courses/\";s:15:\"astra-sites-tag\";a:2:{i:1692;s:11:\"all-courses\";i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47985\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-about-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/learndash-academy-08/wp-json/wp/v2/pages/25401\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/learndash-academy-08/about/\";s:15:\"astra-sites-tag\";a:2:{i:352;s:5:\"about\";i:455;s:8:\"about-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47987\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-contact-1.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-contact-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/learndash-academy-08/wp-json/wp/v2/pages/25405\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/learndash-academy-08/contact/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:454;s:10:\"contact-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47932\";a:13:{s:5:\"title\";s:19:\"Online Health Coach\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-home.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-home-400x1209.jpg\";s:14:\"astra-site-url\";s:41:\"//websitedemos.net/online-health-coach-08\";s:20:\"astra-site-parent-id\";i:1684;s:15:\"astra-sites-tag\";a:8:{i:462;s:7:\"courses\";i:469;s:7:\"ecourse\";i:468;s:9:\"elearning\";i:518;s:12:\"health-coach\";i:467;s:9:\"learndash\";i:460;s:8:\"learning\";i:466;s:14:\"online-courses\";i:975;s:15:\"online-learning\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47941\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-home.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/online-health-coach-08/wp-json/wp/v2/pages/24365\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/online-health-coach-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:1:{i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47939\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-courses.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-courses-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/online-health-coach-08/wp-json/wp/v2/pages/24366\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:54:\"//websitedemos.net/online-health-coach-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:1:{i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47938\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-about-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/online-health-coach-08/wp-json/wp/v2/pages/24368\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/online-health-coach-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:1:{i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47940\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-contact-1.jpg\";s:19:\"thumbnail-image-url\";s:96:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-contact-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/online-health-coach-08/wp-json/wp/v2/pages/24369\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/online-health-coach-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:1:{i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48431\";a:13:{s:5:\"title\";s:14:\"Simply Natural\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb-400x1268.jpg\";s:14:\"astra-site-url\";s:33:\"//websitedemos.net/plant-store-08\";s:20:\"astra-site-parent-id\";i:1732;s:15:\"astra-sites-tag\";a:6:{i:496;s:9:\"ecommerce\";i:383;s:12:\"online-store\";i:497;s:11:\"plant-store\";i:967;s:13:\"product-store\";i:733;s:4:\"shop\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:2;a:3:{s:4:\"slug\";s:29:\"woo-cart-abandonment-recovery\";s:4:\"init\";s:63:\"woo-cart-abandonment-recovery/woo-cart-abandonment-recovery.php\";s:4:\"name\";s:37:\"WooCommerce Cart Abandonment Recovery\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:3:{s:8:\"id-48432\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/plant-store-08/wp-json/wp/v2/pages/119\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/plant-store-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48433\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/plant-store-08/wp-json/wp/v2/pages/120\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/plant-store-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48434\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/plant-store-08/wp-json/wp/v2/pages/15\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/plant-store-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-55315\";a:13:{s:5:\"title\";s:14:\"Local Business\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-400x1264.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/local-business-08\";s:20:\"astra-site-parent-id\";i:2066;s:15:\"astra-sites-tag\";a:15:{i:586;s:8:\"car-wash\";i:2085;s:9:\"carpentry\";i:2089;s:16:\"cleaning-company\";i:2088;s:20:\"construction-company\";i:341;s:11:\"electrician\";i:2090;s:16:\"flooring-company\";i:1021;s:14:\"local-business\";i:2086;s:12:\"local-worker\";i:2094;s:8:\"mechanic\";i:2093;s:16:\"painting-company\";i:508;s:8:\"plumbing\";i:2092;s:16:\"plumbing-company\";i:2091;s:15:\"roofing-company\";i:2087;s:20:\"services-maintenance\";i:441;s:10:\"technician\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-55317\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/local-business-08/wp-json/wp/v2/pages/13\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/local-business-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-55318\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/local-business-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/local-business-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-55319\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-services.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/local-business-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/local-business-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-55316\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2021/05/local-business-08-about-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/local-business-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/local-business-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-54338\";a:13:{s:5:\"title\";s:11:\"Steak House\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-home.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-home-400x1472.jpg\";s:14:\"astra-site-url\";s:33:\"//websitedemos.net/steak-house-08\";s:20:\"astra-site-parent-id\";i:2025;s:15:\"astra-sites-tag\";a:9:{i:2071;s:15:\"chef-restaurant\";i:336;s:4:\"food\";i:2068;s:15:\"food-and-drinks\";i:2067;s:19:\"food-and-restaurant\";i:2070;s:10:\"food-house\";i:350;s:5:\"hotel\";i:2069;s:25:\"non-vegetarian-restaurant\";i:335;s:10:\"restaurant\";i:2072;s:11:\"steak-house\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-54341\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-home.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/steak-house-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/steak-house-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-54339\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-about.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/steak-house-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/steak-house-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-54340\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/steak-house-08/wp-json/wp/v2/pages/14\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/steak-house-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-54342\";a:12:{s:5:\"title\";s:4:\"Menu\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-menu.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/05/steak-house-08-menu-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/steak-house-08/wp-json/wp/v2/pages/13\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/steak-house-08/menu/\";s:15:\"astra-sites-tag\";a:2:{i:1579;s:9:\"food-menu\";i:565;s:4:\"menu\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-54463\";a:13:{s:5:\"title\";s:14:\"Digital Agency\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-400x1469.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/digital-agency-08\";s:20:\"astra-site-parent-id\";i:2051;s:15:\"astra-sites-tag\";a:13:{i:1587;s:18:\"advertising-agency\";i:663;s:6:\"agency\";i:2050;s:27:\"business-consulting-company\";i:2037;s:13:\"design-agency\";i:2048;s:13:\"design-studio\";i:2039;s:14:\"digital-agency\";i:2036;s:22:\"digital-marketing-firm\";i:2040;s:4:\"firm\";i:2049;s:21:\"graphic-design-studio\";i:2038;s:11:\"it-services\";i:1588;s:16:\"marketing-agency\";i:2035;s:18:\"marketing-services\";i:1762;s:16:\"software-company\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-54464\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-about-us-1.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-about-us-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/digital-agency-08/wp-json/wp/v2/pages/139\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/digital-agency-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-54465\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/digital-agency-08/wp-json/wp/v2/pages/141\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/digital-agency-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-54466\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/digital-agency-08/wp-json/wp/v2/pages/135\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/digital-agency-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-54467\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-services.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2021/05/digital-agency-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/digital-agency-08/wp-json/wp/v2/pages/137\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/digital-agency-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-57046\";a:13:{s:5:\"title\";s:35:\"Business Coaching &#038; Consulting\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-400x1559.jpg\";s:14:\"astra-site-url\";s:41:\"//websitedemos.net/business-consulting-08\";s:20:\"astra-site-parent-id\";i:2261;s:15:\"astra-sites-tag\";a:6:{i:1878;s:14:\"business-coach\";i:1620;s:19:\"business-consultant\";i:1879;s:14:\"business-guide\";i:854;s:5:\"coach\";i:1880;s:6:\"mentor\";i:855;s:20:\"motivational-speaker\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-57050\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-services.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/business-consulting-08/wp-json/wp/v2/pages/966\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/business-consulting-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57047\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-about.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/business-consulting-08/wp-json/wp/v2/pages/964\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/business-consulting-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57048\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/business-consulting-08/wp-json/wp/v2/pages/968\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/business-consulting-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-57049\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/business-consulting-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/business-consulting-08/wp-json/wp/v2/pages/961\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/business-consulting-08/\";s:15:\"astra-sites-tag\";a:0:{}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}}}s:8:\"id-57071\";a:13:{s:5:\"title\";s:18:\"Bestselling Author\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08-400x1380.jpg\";s:14:\"astra-site-url\";s:40:\"//websitedemos.net/bestselling-author-08\";s:20:\"astra-site-parent-id\";i:2265;s:15:\"astra-sites-tag\";a:5:{i:724;s:6:\"author\";i:1911;s:23:\"bestselling-book-author\";i:1910;s:11:\"book-author\";i:1740;s:5:\"books\";i:725;s:6:\"writer\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-57075\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:70:\"https://websitedemos.net/bestselling-author-08/wp-json/wp/v2/pages/896\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/bestselling-author-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57072\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08-about.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:70:\"https://websitedemos.net/bestselling-author-08/wp-json/wp/v2/pages/902\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/bestselling-author-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57073\";a:12:{s:5:\"title\";s:5:\"Books\";s:18:\"featured-image-url\";s:0:\"\";s:19:\"thumbnail-image-url\";s:0:\"\";s:18:\"astra-page-api-url\";s:70:\"https://websitedemos.net/bestselling-author-08/wp-json/wp/v2/pages/900\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/bestselling-author-08/books/\";s:15:\"astra-sites-tag\";a:1:{i:1740;s:5:\"books\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57074\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2021/07/bestselling-author-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:70:\"https://websitedemos.net/bestselling-author-08/wp-json/wp/v2/pages/898\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/bestselling-author-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-56739\";a:13:{s:5:\"title\";s:14:\"Public Speaker\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-home.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-home-400x1742.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/public-speaker-08\";s:20:\"astra-site-parent-id\";i:2256;s:15:\"astra-sites-tag\";a:9:{i:724;s:6:\"author\";i:854;s:5:\"coach\";i:612;s:10:\"life-coach\";i:1866;s:10:\"life-guide\";i:1880;s:6:\"mentor\";i:855;s:20:\"motivational-speaker\";i:1903;s:16:\"personal-website\";i:1939;s:14:\"public-speaker\";i:1940;s:11:\"storyteller\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-56743\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-home.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/public-speaker-08/wp-json/wp/v2/pages/1066\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/public-speaker-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56744\";a:12:{s:5:\"title\";s:12:\"What I Offer\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-what-i-offer.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-what-i-offer-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/public-speaker-08/wp-json/wp/v2/pages/1072\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/public-speaker-08/what-i-offer/\";s:15:\"astra-sites-tag\";a:2:{i:425;s:8:\"services\";i:1938;s:12:\"what-i-offer\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56740\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-about.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/public-speaker-08/wp-json/wp/v2/pages/1068\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/public-speaker-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56741\";a:12:{s:5:\"title\";s:5:\"Books\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-books.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-books-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/public-speaker-08/wp-json/wp/v2/pages/1070\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/public-speaker-08/books/\";s:15:\"astra-sites-tag\";a:1:{i:1740;s:5:\"books\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56742\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2021/07/public-speaker-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/public-speaker-08/wp-json/wp/v2/pages/1076\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/public-speaker-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}}}s:8:\"id-57085\";a:13:{s:5:\"title\";s:27:\"Relationship and Life Coach\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-400x1893.jpg\";s:14:\"astra-site-url\";s:40:\"//websitedemos.net/relationship-coach-08\";s:20:\"astra-site-parent-id\";i:2279;s:15:\"astra-sites-tag\";a:5:{i:854;s:5:\"coach\";i:1876;s:10:\"counsellor\";i:612;s:10:\"life-coach\";i:1866;s:10:\"life-guide\";i:1877;s:18:\"relationship-coach\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:3:{i:37;s:4:\"blog\";i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-57091\";a:12:{s:5:\"title\";s:21:\"One-on-One Counseling\";s:18:\"featured-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-one-on-one-counseling.jpg\";s:19:\"thumbnail-image-url\";s:107:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-one-on-one-counseling-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/relationship-coach-08/wp-json/wp/v2/pages/1024\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:63:\"//websitedemos.net/relationship-coach-08/one-on-one-counseling/\";s:15:\"astra-sites-tag\";a:1:{i:610;s:8:\"coaching\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:74;s:4:\"blog\";i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57092\";a:12:{s:5:\"title\";s:11:\"Stage Shows\";s:18:\"featured-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-stage-shows.jpg\";s:19:\"thumbnail-image-url\";s:97:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-stage-shows-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/relationship-coach-08/wp-json/wp/v2/pages/1026\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:53:\"//websitedemos.net/relationship-coach-08/stage-shows/\";s:15:\"astra-sites-tag\";a:1:{i:1875;s:11:\"stage-shows\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:74;s:4:\"blog\";i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57086\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-about.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/relationship-coach-08/wp-json/wp/v2/pages/1014\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/relationship-coach-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:74;s:4:\"blog\";i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57090\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/relationship-coach-08/wp-json/wp/v2/pages/1022\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/relationship-coach-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:74;s:4:\"blog\";i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57088\";a:12:{s:5:\"title\";s:5:\"Books\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-books.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-books-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/relationship-coach-08/wp-json/wp/v2/pages/1018\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/relationship-coach-08/books/\";s:15:\"astra-sites-tag\";a:1:{i:1740;s:5:\"books\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:74;s:4:\"blog\";i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-57089\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2021/07/relationship-coach-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/relationship-coach-08/wp-json/wp/v2/pages/1020\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/relationship-coach-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:74;s:4:\"blog\";i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-56607\";a:13:{s:5:\"title\";s:18:\"Creative Podcaster\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-400x1380.jpg\";s:14:\"astra-site-url\";s:40:\"//websitedemos.net/creative-podcaster-08\";s:20:\"astra-site-parent-id\";i:2244;s:15:\"astra-sites-tag\";a:5:{i:1654;s:15:\"content-creator\";i:1928;s:16:\"creative-podcast\";i:1929;s:9:\"creatives\";i:1927;s:15:\"podcast-website\";i:1926;s:9:\"podcaster\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-56611\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/creative-podcaster-08/wp-json/wp/v2/pages/1254\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/creative-podcaster-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56610\";a:12:{s:5:\"title\";s:8:\"Episodes\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-episodes.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-episodes-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/creative-podcaster-08/wp-json/wp/v2/pages/1263\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/creative-podcaster-08/episodes/\";s:15:\"astra-sites-tag\";a:1:{i:1924;s:8:\"episodes\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56609\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/creative-podcaster-08/wp-json/wp/v2/pages/1274\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/creative-podcaster-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56608\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-about.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/07/creative-podcaster-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/creative-podcaster-08/wp-json/wp/v2/pages/1271\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/creative-podcaster-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}}}s:8:\"id-56525\";a:13:{s:5:\"title\";s:23:\"Learn Digital Marketing\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-home.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:96:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-home-400x1961.jpg\";s:14:\"astra-site-url\";s:45:\"//websitedemos.net/learn-digital-marketing-08\";s:20:\"astra-site-parent-id\";i:2239;s:15:\"astra-sites-tag\";a:5:{i:462;s:7:\"courses\";i:1855;s:17:\"digital-marketing\";i:467;s:9:\"learndash\";i:975;s:15:\"online-learning\";i:720;s:9:\"tutorials\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-56526\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-about.jpg\";s:19:\"thumbnail-image-url\";s:96:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:74:\"https://websitedemos.net/learn-digital-marketing-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:52:\"//websitedemos.net/learn-digital-marketing-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56527\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-blog.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-blog-600x800.jpg\";s:18:\"astra-page-api-url\";s:74:\"https://websitedemos.net/learn-digital-marketing-08/wp-json/wp/v2/pages/15\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/learn-digital-marketing-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56528\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:98:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:74:\"https://websitedemos.net/learn-digital-marketing-08/wp-json/wp/v2/pages/17\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:54:\"//websitedemos.net/learn-digital-marketing-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56531\";a:12:{s:5:\"title\";s:8:\"Resource\";s:18:\"featured-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-resource.jpg\";s:19:\"thumbnail-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-resource-600x800.jpg\";s:18:\"astra-page-api-url\";s:74:\"https://websitedemos.net/learn-digital-marketing-08/wp-json/wp/v2/pages/19\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/learn-digital-marketing-08/resource/\";s:15:\"astra-sites-tag\";a:1:{i:1854;s:8:\"resource\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56529\";a:12:{s:5:\"title\";s:7:\"Courses\";s:18:\"featured-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-course.jpg\";s:19:\"thumbnail-image-url\";s:97:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-course-600x800.jpg\";s:18:\"astra-page-api-url\";s:74:\"https://websitedemos.net/learn-digital-marketing-08/wp-json/wp/v2/pages/13\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:58:\"//websitedemos.net/learn-digital-marketing-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}}}s:8:\"id-56530\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-home.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2021/07/learn-digital-marketing-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/learn-digital-marketing-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/learn-digital-marketing-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}}}}}s:8:\"id-48348\";a:13:{s:5:\"title\";s:8:\"Mountain\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-home.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-home-400x980.jpg\";s:14:\"astra-site-url\";s:30:\"//websitedemos.net/mountain-08\";s:20:\"astra-site-parent-id\";i:1724;s:15:\"astra-sites-tag\";a:4:{i:692;s:8:\"business\";i:1525;s:8:\"mountain\";i:1526;s:13:\"multi-purpose\";i:535;s:6:\"nature\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48349\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-about-1.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/mountain-08/wp-json/wp/v2/pages/218\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/mountain-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48350\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-contact-1.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-contact-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/mountain-08/wp-json/wp/v2/pages/220\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/mountain-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48351\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-home.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/mountain-08/wp-json/wp/v2/pages/217\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:31:\"//websitedemos.net/mountain-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48352\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-services-1.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-services-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/mountain-08/wp-json/wp/v2/pages/219\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/mountain-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-56573\";a:13:{s:5:\"title\";s:28:\"Injury and Accidental Lawyer\";s:18:\"featured-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:100:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:101:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-homepage-gb-400x1482.jpg\";s:14:\"astra-site-url\";s:44:\"//websitedemos.net/injury-accident-lawyer-08\";s:20:\"astra-site-parent-id\";i:2241;s:15:\"astra-sites-tag\";a:4:{i:1869;s:16:\"accident-lawyers\";i:1867;s:14:\"injury-lawyers\";i:1870;s:11:\"lawyer-firm\";i:1868;s:7:\"lawyers\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-56574\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:97:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:75:\"https://websitedemos.net/injury-accident-lawyer-08/wp-json/wp/v2/pages/1526\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/injury-accident-lawyer-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56575\";a:12:{s:5:\"title\";s:9:\"Attorneys\";s:18:\"featured-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-attorneys-gb.jpg\";s:19:\"thumbnail-image-url\";s:101:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-attorneys-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:75:\"https://websitedemos.net/injury-accident-lawyer-08/wp-json/wp/v2/pages/1539\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/injury-accident-lawyer-08/attorneys/\";s:15:\"astra-sites-tag\";a:1:{i:912;s:9:\"attorneys\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56576\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:75:\"https://websitedemos.net/injury-accident-lawyer-08/wp-json/wp/v2/pages/1547\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:53:\"//websitedemos.net/injury-accident-lawyer-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56577\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:100:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:75:\"https://websitedemos.net/injury-accident-lawyer-08/wp-json/wp/v2/pages/1503\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/injury-accident-lawyer-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56578\";a:12:{s:5:\"title\";s:14:\"Practice Areas\";s:18:\"featured-image-url\";s:98:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-practice-areas-gb.jpg\";s:19:\"thumbnail-image-url\";s:106:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-practice-areas-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:75:\"https://websitedemos.net/injury-accident-lawyer-08/wp-json/wp/v2/pages/1541\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:60:\"//websitedemos.net/injury-accident-lawyer-08/practice-areas/\";s:15:\"astra-sites-tag\";a:1:{i:1863;s:14:\"practice-areas\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56579\";a:12:{s:5:\"title\";s:7:\"Results\";s:18:\"featured-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-results-gb.jpg\";s:19:\"thumbnail-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2021/06/injury-accidental-lawyer-results-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:75:\"https://websitedemos.net/injury-accident-lawyer-08/wp-json/wp/v2/pages/1543\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:53:\"//websitedemos.net/injury-accident-lawyer-08/results/\";s:15:\"astra-sites-tag\";a:1:{i:1864;s:7:\"results\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-56632\";a:13:{s:5:\"title\";s:19:\"Musical Instruments\";s:18:\"featured-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-home.jpg\";s:19:\"thumbnail-image-url\";s:96:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:97:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-home-400x1399.jpg\";s:14:\"astra-site-url\";s:46:\"//websitedemos.net/musical-instrument-maker-08\";s:20:\"astra-site-parent-id\";i:2245;s:15:\"astra-sites-tag\";a:6:{i:2248;s:12:\"guitar-maker\";i:2249;s:15:\"instrumentalist\";i:407;s:5:\"music\";i:2250;s:18:\"music-craftsperson\";i:2246;s:16:\"music-instrument\";i:1814;s:24:\"musical-instrument-maker\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-56633\";a:12:{s:5:\"title\";s:7:\"Artists\";s:18:\"featured-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-artists.jpg\";s:19:\"thumbnail-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-artists-600x800.jpg\";s:18:\"astra-page-api-url\";s:76:\"https://websitedemos.net/musical-instrument-maker-08/wp-json/wp/v2/pages/984\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/musical-instrument-maker-08/artists/\";s:15:\"astra-sites-tag\";a:1:{i:339;s:6:\"artist\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56634\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:76:\"https://websitedemos.net/musical-instrument-maker-08/wp-json/wp/v2/pages/988\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/musical-instrument-maker-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56635\";a:12:{s:5:\"title\";s:7:\"Guitars\";s:18:\"featured-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-guitars.jpg\";s:19:\"thumbnail-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-guitars-600x800.jpg\";s:18:\"astra-page-api-url\";s:76:\"https://websitedemos.net/musical-instrument-maker-08/wp-json/wp/v2/pages/982\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/musical-instrument-maker-08/guitars/\";s:15:\"astra-sites-tag\";a:1:{i:1815;s:7:\"guitars\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56636\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-home.jpg\";s:19:\"thumbnail-image-url\";s:96:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:76:\"https://websitedemos.net/musical-instrument-maker-08/wp-json/wp/v2/pages/980\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/musical-instrument-maker-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56637\";a:12:{s:5:\"title\";s:9:\"Our Story\";s:18:\"featured-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-our-story.jpg\";s:19:\"thumbnail-image-url\";s:101:\"https://websitedemos.net/wp-content/uploads/2021/06/musical-instrument-maker-08-our-story-600x800.jpg\";s:18:\"astra-page-api-url\";s:76:\"https://websitedemos.net/musical-instrument-maker-08/wp-json/wp/v2/pages/986\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:57:\"//websitedemos.net/musical-instrument-maker-08/our-story/\";s:15:\"astra-sites-tag\";a:2:{i:352;s:5:\"about\";i:905;s:9:\"our-story\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}}}s:8:\"id-48026\";a:13:{s:5:\"title\";s:13:\"Online Course\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-400x1449.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/online-courses-08\";s:20:\"astra-site-parent-id\";i:1694;s:15:\"astra-sites-tag\";a:6:{i:462;s:7:\"courses\";i:468;s:9:\"elearning\";i:467;s:9:\"learndash\";i:460;s:8:\"learning\";i:466;s:14:\"online-courses\";i:975;s:15:\"online-learning\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48030\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/online-courses-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48028\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-all-courses.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-all-courses-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/14\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/online-courses-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48027\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-about-us.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-about-us-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/online-courses-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48031\";a:12:{s:5:\"title\";s:11:\"Instructors\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-instructors.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-instructors-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/18\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/online-courses-08/instructors/\";s:15:\"astra-sites-tag\";a:1:{i:1677;s:11:\"instructors\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48032\";a:12:{s:5:\"title\";s:18:\"Pricing &#038; FAQ\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-pricing-faq.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-pricing-faq-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/20\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/online-courses-08/pricing-faq/\";s:15:\"astra-sites-tag\";a:1:{i:585;s:7:\"pricing\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48029\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/16\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/online-courses-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48648\";a:13:{s:5:\"title\";s:16:\"Roofing Services\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home-400x1637.jpg\";s:14:\"astra-site-url\";s:38:\"//websitedemos.net/roofing-services-08\";s:20:\"astra-site-parent-id\";i:1754;s:15:\"astra-sites-tag\";a:5:{i:1630;s:18:\"commercial-roofing\";i:1629;s:19:\"residential-roofing\";i:1633;s:11:\"roof-repair\";i:1631;s:16:\"roof-replacement\";i:1632;s:16:\"roofing-services\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48651\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/296\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/roofing-services-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48649\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-about.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/297\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/roofing-services-08/about-us/\";s:15:\"astra-sites-tag\";a:2:{i:352;s:5:\"about\";i:455;s:8:\"about-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48653\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-services.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/298\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/roofing-services-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48652\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-projects.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-projects-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/299\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/roofing-services-08/projects/\";s:15:\"astra-sites-tag\";a:3:{i:444;s:9:\"portfolio\";i:1613;s:8:\"projects\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48650\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/300\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/roofing-services-08/contact-us/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:377;s:12:\"get-in-touch\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47896\";a:13:{s:5:\"title\";s:25:\"Online Programming Course\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home-400x1470.jpg\";s:14:\"astra-site-url\";s:42:\"//websitedemos.net/online-coding-course-08\";s:20:\"astra-site-parent-id\";i:1681;s:15:\"astra-sites-tag\";a:7:{i:462;s:7:\"courses\";i:469;s:7:\"ecourse\";i:468;s:9:\"elearning\";i:467;s:9:\"learndash\";i:466;s:14:\"online-courses\";i:975;s:15:\"online-learning\";i:1673;s:18:\"programming-course\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47900\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-coding-course-08/wp-json/wp/v2/pages/523\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/online-coding-course-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47898\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-all-courses.jpg\";s:19:\"thumbnail-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-all-courses-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-coding-course-08/wp-json/wp/v2/pages/519\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/online-coding-course-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47897\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-about.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-coding-course-08/wp-json/wp/v2/pages/517\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/online-coding-course-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47899\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-contact.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-coding-course-08/wp-json/wp/v2/pages/521\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/online-coding-course-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-48149\";a:13:{s:5:\"title\";s:10:\"Life Coach\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home-1-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home-1-400x856.jpg\";s:14:\"astra-site-url\";s:42:\"//websitedemos.net/life-coach-sara-john-08\";s:20:\"astra-site-parent-id\";i:1704;s:15:\"astra-sites-tag\";a:5:{i:610;s:8:\"coaching\";i:608;s:8:\"guidance\";i:612;s:10:\"life-coach\";i:609;s:9:\"motivator\";i:611;s:16:\"self-improvement\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:1;a:3:{s:4:\"slug\";s:29:\"woo-cart-abandonment-recovery\";s:4:\"init\";s:63:\"woo-cart-abandonment-recovery/woo-cart-abandonment-recovery.php\";s:4:\"name\";s:37:\"WooCommerce Cart Abandonment Recovery\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48171\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-about-3.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-about-3-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1368\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/life-coach-sara-john-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48172\";a:12:{s:5:\"title\";s:5:\"Books\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-books-1.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-books-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1370\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/life-coach-sara-john-08/books/\";s:15:\"astra-sites-tag\";a:1:{i:727;s:4:\"book\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48173\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-contact-1.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-contact-1.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1372\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/life-coach-sara-john-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48174\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1376\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/life-coach-sara-john-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48175\";a:12:{s:5:\"title\";s:12:\"Work With Me\";s:18:\"featured-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-pricing-1.jpg\";s:19:\"thumbnail-image-url\";s:97:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-pricing-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1374\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:56:\"//websitedemos.net/life-coach-sara-john-08/work-with-me/\";s:15:\"astra-sites-tag\";a:1:{i:784;s:12:\"work-with-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-47672\";a:13:{s:5:\"title\";s:15:\"Diagnostics Lab\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home-400x2475.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/diagnostics-lab-08\";s:20:\"astra-site-parent-id\";i:1657;s:15:\"astra-sites-tag\";a:6:{i:1756;s:10:\"blood-bank\";i:337;s:6:\"clinic\";i:1757;s:15:\"diagnostics-lab\";i:1640;s:10:\"laboratory\";i:603;s:7:\"medical\";i:1755;s:16:\"medical-research\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-47675\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/242\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/diagnostics-lab-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47673\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-about.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/247\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/diagnostics-lab-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47676\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-services.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/252\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/diagnostics-lab-08/services/\";s:15:\"astra-sites-tag\";a:2:{i:425;s:8:\"services\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47677\";a:12:{s:5:\"title\";s:11:\"Testimonial\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-reviews.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-reviews-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/254\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/diagnostics-lab-08/testimonial/\";s:15:\"astra-sites-tag\";a:2:{i:1615;s:7:\"reviews\";i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47674\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/256\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/diagnostics-lab-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48061\";a:13:{s:5:\"title\";s:21:\"Online Cooking Course\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-1.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-1-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-1-400x1006.jpg\";s:14:\"astra-site-url\";s:43:\"//websitedemos.net/online-cooking-course-08\";s:20:\"astra-site-parent-id\";i:1696;s:15:\"astra-sites-tag\";a:6:{i:462;s:7:\"courses\";i:468;s:9:\"elearning\";i:467;s:9:\"learndash\";i:460;s:8:\"learning\";i:466;s:14:\"online-courses\";i:975;s:15:\"online-learning\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:1;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48065\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-1.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/online-cooking-course-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/online-cooking-course-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48063\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-all-courses-1.jpg\";s:19:\"thumbnail-image-url\";s:102:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-all-courses-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-cooking-course-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:56:\"//websitedemos.net/online-cooking-course-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48062\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:96:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-about-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-cooking-course-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/online-cooking-course-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48064\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-contact-1.jpg\";s:19:\"thumbnail-image-url\";s:98:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-contact-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-cooking-course-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:52:\"//websitedemos.net/online-cooking-course-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48447\";a:13:{s:5:\"title\";s:21:\"Women Empowerment NGO\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-400x1508.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/women-empowerment-08\";s:20:\"astra-site-parent-id\";i:1735;s:15:\"astra-sites-tag\";a:3:{i:625;s:7:\"charity\";i:1592;s:3:\"ngo\";i:1591;s:17:\"women-empowerment\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:39;s:4:\"free\";i:36;s:5:\"other\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48448\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-about-us.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-about-us-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/357\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/women-empowerment-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48449\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/442\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/women-empowerment-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48450\";a:12:{s:5:\"title\";s:6:\"Events\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-events.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-events-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/418\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/women-empowerment-08/events/\";s:15:\"astra-sites-tag\";a:1:{i:409;s:5:\"event\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48451\";a:12:{s:5:\"title\";s:7:\"Gallery\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-gallery.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-gallery-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/426\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/women-empowerment-08/gallery/\";s:15:\"astra-sites-tag\";a:1:{i:461;s:7:\"gallery\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48452\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/297\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/women-empowerment-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48453\";a:12:{s:5:\"title\";s:10:\"What We Do\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-what-we-do.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-what-we-do-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/403\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/women-empowerment-08/what-we-do/\";s:15:\"astra-sites-tag\";a:1:{i:628;s:10:\"what-we-do\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48611\";a:13:{s:5:\"title\";s:8:\"Musician\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-400x1735.jpg\";s:14:\"astra-site-url\";s:30:\"//websitedemos.net/musician-08\";s:20:\"astra-site-parent-id\";i:1752;s:15:\"astra-sites-tag\";a:5:{i:339;s:6:\"artist\";i:969;s:8:\"musician\";i:1572;s:9:\"performer\";i:1571;s:6:\"singer\";i:1573;s:8:\"vocalist\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48612\";a:12:{s:5:\"title\";s:6:\"Albums\";s:18:\"featured-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-albums.jpg\";s:19:\"thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-albums-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/437\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/musician-08/albums/\";s:15:\"astra-sites-tag\";a:2:{i:1565;s:6:\"albums\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48617\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/296\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:31:\"//websitedemos.net/musician-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48613\";a:12:{s:5:\"title\";s:9:\"Biography\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-biography.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-biography-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/408\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/musician-08/biography/\";s:15:\"astra-sites-tag\";a:2:{i:352;s:5:\"about\";i:1566;s:9:\"biography\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48614\";a:12:{s:5:\"title\";s:8:\"Concerts\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-concerts.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-concerts-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/432\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/musician-08/concerts/\";s:15:\"astra-sites-tag\";a:1:{i:755;s:7:\"concert\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48616\";a:12:{s:5:\"title\";s:7:\"Gallery\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-gallery.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-gallery-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/443\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/musician-08/gallery/\";s:15:\"astra-sites-tag\";a:2:{i:461;s:7:\"gallery\";i:444;s:9:\"portfolio\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48615\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/451\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/musician-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-55511\";a:13:{s:5:\"title\";s:19:\"Portfolio &#038; CV\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-400x1308.jpg\";s:14:\"astra-site-url\";s:31:\"//websitedemos.net/portfolio-08\";s:20:\"astra-site-parent-id\";i:2148;s:15:\"astra-sites-tag\";a:6:{i:2151;s:16:\"curriculum-vitae\";i:2150;s:2:\"cv\";i:1903;s:16:\"personal-website\";i:444;s:9:\"portfolio\";i:2153;s:6:\"resume\";i:2152;s:12:\"work-profile\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:39;s:4:\"free\";i:36;s:5:\"other\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-55512\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-about.jpg\";s:19:\"thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/portfolio-08/wp-json/wp/v2/pages/345\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/portfolio-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-55513\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/portfolio-08/wp-json/wp/v2/pages/375\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/portfolio-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-55514\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/portfolio-08/wp-json/wp/v2/pages/298\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:32:\"//websitedemos.net/portfolio-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-55515\";a:12:{s:5:\"title\";s:9:\"Portfolio\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-portfolio.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-portfolio-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/portfolio-08/wp-json/wp/v2/pages/366\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/portfolio-08/portfolio/\";s:15:\"astra-sites-tag\";a:2:{i:444;s:9:\"portfolio\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-55516\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-services.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/05/portfolio-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/portfolio-08/wp-json/wp/v2/pages/359\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/portfolio-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-48671\";a:13:{s:5:\"title\";s:12:\"Tech Startup\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home-400x1256.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/tech-startup-08\";s:20:\"astra-site-parent-id\";i:1758;s:15:\"astra-sites-tag\";a:7:{i:1761;s:11:\"application\";i:745;s:12:\"organization\";i:1762;s:16:\"software-company\";i:1760;s:13:\"software-firm\";i:1665;s:7:\"startup\";i:1759;s:13:\"tech-business\";i:1763;s:12:\"tech-startup\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48672\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/tech-startup-08/wp-json/wp/v2/pages/248\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/tech-startup-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48673\";a:12:{s:5:\"title\";s:8:\"Features\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-features.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-features-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/tech-startup-08/wp-json/wp/v2/pages/249\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/tech-startup-08/features/\";s:15:\"astra-sites-tag\";a:1:{i:453;s:8:\"features\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48674\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/tech-startup-08/wp-json/wp/v2/pages/247\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/tech-startup-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48675\";a:12:{s:5:\"title\";s:4:\"Plan\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-plan.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-plan-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/tech-startup-08/wp-json/wp/v2/pages/250\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/tech-startup-08/plan/\";s:15:\"astra-sites-tag\";a:2:{i:1663;s:4:\"plan\";i:585;s:7:\"pricing\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-48519\";a:13:{s:5:\"title\";s:12:\"Elderly Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home-400x1558.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/elderly-care-08\";s:20:\"astra-site-parent-id\";i:1744;s:15:\"astra-sites-tag\";a:5:{i:1598;s:24:\"assisted-living-facility\";i:1596;s:10:\"elder-home\";i:1595;s:11:\"elders-care\";i:1594;s:12:\"old-age-home\";i:1597;s:15:\"retirement-home\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48523\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/elderly-care-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48520\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/elderly-care-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48524\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-services.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/elderly-care-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48522\";a:12:{s:5:\"title\";s:10:\"Facilities\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-facilities.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-facilities-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/elderly-care-08/facilities/\";s:15:\"astra-sites-tag\";a:1:{i:1599;s:10:\"facilities\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48521\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/elderly-care-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47723\";a:13:{s:5:\"title\";s:12:\"Horticulture\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-400x1517.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/horticulture-08\";s:20:\"astra-site-parent-id\";i:1669;s:15:\"astra-sites-tag\";a:4:{i:1601;s:11:\"agriculture\";i:1603;s:13:\"farm-products\";i:632;s:7:\"farming\";i:1602;s:12:\"horticulture\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-47725\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/5\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/horticulture-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47726\";a:12:{s:5:\"title\";s:8:\"Our Farm\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-our-farm.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-our-farm-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/horticulture-08/our-farm/\";s:15:\"astra-sites-tag\";a:2:{i:1737;s:4:\"farm\";i:1736;s:8:\"our-farm\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47727\";a:12:{s:5:\"title\";s:11:\"Our Produce\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-our-produce.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-our-produce-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/horticulture-08/our-produce/\";s:15:\"astra-sites-tag\";a:1:{i:1606;s:12:\"our-products\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47728\";a:12:{s:5:\"title\";s:12:\"Testimonials\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-testimonials.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-testimonials-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/horticulture-08/testimonials/\";s:15:\"astra-sites-tag\";a:3:{i:1738;s:9:\"feedbacks\";i:432;s:6:\"review\";i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47724\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-contact-us.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-contact-us-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/horticulture-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-55500\";a:13:{s:5:\"title\";s:6:\"School\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-home.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-home-400x1665.jpg\";s:14:\"astra-site-url\";s:28:\"//websitedemos.net/school-08\";s:20:\"astra-site-parent-id\";i:2147;s:15:\"astra-sites-tag\";a:10:{i:2154;s:9:\"academics\";i:610;s:8:\"coaching\";i:2156;s:7:\"daycare\";i:459;s:9:\"education\";i:2158;s:8:\"educator\";i:2155;s:11:\"high-school\";i:617;s:12:\"kindergarten\";i:2157;s:9:\"preschool\";i:456;s:6:\"school\";i:458;s:10:\"university\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:39;s:4:\"free\";i:36;s:5:\"other\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-55504\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-contact.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/school-08/wp-json/wp/v2/pages/117\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/school-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-55501\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-about.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:57:\"https://websitedemos.net/school-08/wp-json/wp/v2/pages/62\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/school-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-55502\";a:12:{s:5:\"title\";s:9:\"Academics\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-academics.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-academics-600x800.jpg\";s:18:\"astra-page-api-url\";s:57:\"https://websitedemos.net/school-08/wp-json/wp/v2/pages/79\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/school-08/academics/\";s:15:\"astra-sites-tag\";a:1:{i:2114;s:8:\"academic\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-55503\";a:12:{s:5:\"title\";s:10:\"Activities\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-activities.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-activities-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/school-08/wp-json/wp/v2/pages/102\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/school-08/activities/\";s:15:\"astra-sites-tag\";a:1:{i:1922;s:10:\"activities\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-55505\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-home.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/05/school-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:56:\"https://websitedemos.net/school-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:29:\"//websitedemos.net/school-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48472\";a:13:{s:5:\"title\";s:13:\"e-book Author\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-400x1471.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/ebook-author-08\";s:20:\"astra-site-parent-id\";i:1739;s:15:\"astra-sites-tag\";a:4:{i:724;s:6:\"author\";i:727;s:4:\"book\";i:748;s:5:\"ebook\";i:725;s:6:\"writer\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48473\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/252\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/ebook-author-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48474\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-contact-page.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-contact-page-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/258\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/ebook-author-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48475\";a:12:{s:5:\"title\";s:7:\"e-Books\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-e-books.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-e-books-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/254\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/ebook-author-08/e-books/\";s:15:\"astra-sites-tag\";a:2:{i:1740;s:5:\"books\";i:748;s:5:\"ebook\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48476\";a:12:{s:5:\"title\";s:6:\"Events\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-events.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-events-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/256\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/ebook-author-08/events/\";s:15:\"astra-sites-tag\";a:1:{i:1569;s:6:\"events\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48477\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/250\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/ebook-author-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47979\";a:13:{s:5:\"title\";s:14:\"BBQ Restaurant\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home-1-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home-1-400x1555.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/bbq-restaurant-08\";s:20:\"astra-site-parent-id\";i:1690;s:15:\"astra-sites-tag\";a:10:{i:566;s:14:\"bbq-restaurant\";i:562;s:6:\"bistro\";i:972;s:4:\"club\";i:560;s:7:\"cuisine\";i:561;s:6:\"eatery\";i:336;s:4:\"food\";i:350;s:5:\"hotel\";i:559;s:6:\"outlet\";i:335;s:10:\"restaurant\";i:970;s:6:\"restro\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47982\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/bbq-restaurant-08/wp-json/wp/v2/pages/531\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/bbq-restaurant-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47980\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-about-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/bbq-restaurant-08/wp-json/wp/v2/pages/533\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/bbq-restaurant-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:455;s:8:\"about-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47983\";a:12:{s:5:\"title\";s:4:\"Menu\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-menu-1.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-menu-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/bbq-restaurant-08/wp-json/wp/v2/pages/535\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/bbq-restaurant-08/menu/\";s:15:\"astra-sites-tag\";a:2:{i:1579;s:9:\"food-menu\";i:565;s:4:\"menu\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-47981\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-contact-1.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-contact-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/bbq-restaurant-08/wp-json/wp/v2/pages/537\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/bbq-restaurant-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48631\";a:13:{s:5:\"title\";s:15:\"Yoga Instructor\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home-400x1394.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/yoga-instructor-08\";s:20:\"astra-site-parent-id\";i:1753;s:15:\"astra-sites-tag\";a:7:{i:499;s:7:\"fitness\";i:976;s:14:\"gym-instructor\";i:849;s:11:\"health-yoga\";i:1020;s:8:\"personal\";i:395;s:15:\"yoga-instructor\";i:397;s:11:\"yoga-studio\";i:398;s:12:\"yoga-trainer\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48635\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/51\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/yoga-instructor-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48632\";a:12:{s:5:\"title\";s:8:\"About Me\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-about-me.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-about-me-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/52\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/yoga-instructor-08/about-me/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48633\";a:12:{s:5:\"title\";s:7:\"Classes\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-classes.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-classes-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/53\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/yoga-instructor-08/classes/\";s:15:\"astra-sites-tag\";a:1:{i:557;s:7:\"classes\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48636\";a:12:{s:5:\"title\";s:12:\"Publications\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-publications.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-publications-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/54\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/yoga-instructor-08/publications/\";s:15:\"astra-sites-tag\";a:1:{i:558;s:11:\"publication\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48634\";a:12:{s:5:\"title\";s:7:\"Get Fit\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-get-fit.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-get-fit-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/55\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/yoga-instructor-08/get-fit/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:377;s:12:\"get-in-touch\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-49936\";a:13:{s:5:\"title\";s:11:\"Recipe Blog\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-400x1042.jpg\";s:14:\"astra-site-url\";s:33:\"//websitedemos.net/recipe-blog-08\";s:20:\"astra-site-parent-id\";i:1858;s:15:\"astra-sites-tag\";a:5:{i:792;s:7:\"cooking\";i:787;s:6:\"dinner\";i:336;s:4:\"food\";i:793;s:11:\"food-making\";i:788;s:5:\"snack\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:37;s:4:\"blog\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-49940\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/recipe-blog-08/wp-json/wp/v2/pages/1055\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/recipe-blog-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:74;s:4:\"blog\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-49937\";a:12:{s:5:\"title\";s:8:\"About Me\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-about-me.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-about-me-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/recipe-blog-08/wp-json/wp/v2/pages/1071\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/recipe-blog-08/about-me/\";s:15:\"astra-sites-tag\";a:1:{i:1007;s:8:\"about-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:74;s:4:\"blog\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-49938\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-blog.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-blog-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/recipe-blog-08/wp-json/wp/v2/pages/1067\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/recipe-blog-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:74;s:4:\"blog\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-49939\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/03/recipe-blog-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/recipe-blog-08/wp-json/wp/v2/pages/1074\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/recipe-blog-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:74;s:4:\"blog\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48591\";a:13:{s:5:\"title\";s:15:\"Cosmetics Store\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home-400x1625.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/cosmetics-store-08\";s:20:\"astra-site-parent-id\";i:1748;s:15:\"astra-sites-tag\";a:7:{i:1023;s:6:\"beauty\";i:1465;s:15:\"beauty-products\";i:1466;s:17:\"cosmetic-products\";i:1464;s:14:\"cosmetic-store\";i:1463;s:9:\"cosmetics\";i:496;s:9:\"ecommerce\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48594\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/cosmetics-store-08/wp-json/wp/v2/pages/542\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/cosmetics-store-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48592\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-about.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/cosmetics-store-08/wp-json/wp/v2/pages/545\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/cosmetics-store-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48595\";a:12:{s:5:\"title\";s:12:\"Testimonials\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-testinomials.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-testinomials-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/cosmetics-store-08/wp-json/wp/v2/pages/544\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/cosmetics-store-08/testimonials/\";s:15:\"astra-sites-tag\";a:1:{i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48593\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/cosmetics-store-08/wp-json/wp/v2/pages/546\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/cosmetics-store-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:64;s:9:\"ecommerce\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48318\";a:13:{s:5:\"title\";s:12:\"Nutritionist\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01-400x1626.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/nutritionist-08\";s:20:\"astra-site-parent-id\";i:1722;s:15:\"astra-sites-tag\";a:6:{i:753;s:9:\"dietitian\";i:1726;s:15:\"nutrition-coach\";i:1727;s:18:\"nutrition-coaching\";i:1725;s:17:\"nutrition-trainer\";i:754;s:12:\"nutritionist\";i:1454;s:16:\"personal-trainer\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48321\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/nutritionist-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48319\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/134\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/nutritionist-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48322\";a:12:{s:5:\"title\";s:8:\"Programs\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-program.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-program-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/164\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/nutritionist-08/programs/\";s:15:\"astra-sites-tag\";a:1:{i:989;s:8:\"programs\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48323\";a:12:{s:5:\"title\";s:15:\"Success Stories\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-success-stories.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-success-stories-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/180\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/nutritionist-08/success-stories/\";s:15:\"astra-sites-tag\";a:3:{i:432;s:6:\"review\";i:990;s:15:\"success-stories\";i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48320\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/196\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/nutritionist-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-49726\";a:13:{s:5:\"title\";s:12:\"Entrepreneur\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-400x1134.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/entrepreneur-08\";s:20:\"astra-site-parent-id\";i:1847;s:15:\"astra-sites-tag\";a:7:{i:795;s:10:\"contractor\";i:1848;s:12:\"entrepreneur\";i:796;s:9:\"executive\";i:801;s:7:\"founder\";i:798;s:7:\"manager\";i:799;s:9:\"organizer\";i:804;s:8:\"promoter\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-49727\";a:12:{s:5:\"title\";s:8:\"About Me\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-about-me.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-about-me-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/entrepreneur-08/wp-json/wp/v2/pages/25265\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/entrepreneur-08/about-me/\";s:15:\"astra-sites-tag\";a:1:{i:1007;s:8:\"about-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-49728\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-blog.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-blog-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/entrepreneur-08/wp-json/wp/v2/pages/25266\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/entrepreneur-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-49729\";a:12:{s:5:\"title\";s:10:\"Contact Me\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-contact-me.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-contact-me-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/entrepreneur-08/wp-json/wp/v2/pages/25267\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/entrepreneur-08/contact-me/\";s:15:\"astra-sites-tag\";a:1:{i:1009;s:10:\"contact-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-49730\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/02/entrepreneur-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/entrepreneur-08/wp-json/wp/v2/pages/25264\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/entrepreneur-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:0:{}}}}s:8:\"id-48076\";a:13:{s:5:\"title\";s:24:\"Personal Fitness Trainer\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage-400x1695.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/fitness-trainer-08\";s:20:\"astra-site-parent-id\";i:1697;s:15:\"astra-sites-tag\";a:9:{i:502;s:8:\"exercise\";i:499;s:7:\"fitness\";i:506;s:19:\"functional-training\";i:500;s:3:\"gym\";i:504;s:11:\"gym-trainer\";i:399;s:8:\"one-page\";i:463;s:11:\"single-page\";i:503;s:7:\"trainer\";i:501;s:8:\"work-out\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:1:{s:8:\"id-48077\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/fitness-trainer-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/fitness-trainer-08/\";s:15:\"astra-sites-tag\";a:3:{i:423;s:4:\"home\";i:814;s:8:\"homepage\";i:463;s:11:\"single-page\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-56682\";a:13:{s:5:\"title\";s:20:\"Chartered Accountant\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-1.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-1-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-1-400x1356.jpg\";s:14:\"astra-site-url\";s:32:\"//websitedemos.net/accountant-08\";s:20:\"astra-site-parent-id\";i:2252;s:15:\"astra-sites-tag\";a:3:{i:447;s:10:\"accountant\";i:449;s:20:\"chartered-accountant\";i:2254;s:22:\"finance-and-accounting\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-56686\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-services-1.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-services-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/accountant-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/accountant-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56687\";a:12:{s:5:\"title\";s:12:\"Testimonials\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-testimonials-1.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-testimonials-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/accountant-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/accountant-08/testimonials/\";s:15:\"astra-sites-tag\";a:1:{i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56688\";a:12:{s:5:\"title\";s:13:\"Why Choose Me\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-why-choose-me-1.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-why-choose-me-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/accountant-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/accountant-08/why-choose-me/\";s:15:\"astra-sites-tag\";a:3:{i:453;s:8:\"features\";i:760;s:13:\"why-choose-us\";i:852;s:6:\"why-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-56684\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-contact-2.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-contact-2-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/accountant-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/accountant-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56685\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-1.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/accountant-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:33:\"//websitedemos.net/accountant-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-56683\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-about-2.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/07/accountant-08-about-2-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/accountant-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/accountant-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";s:0:\"\";}}}s:8:\"id-48490\";a:13:{s:5:\"title\";s:14:\"Animal Welfare\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home-400x1536.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/animal-welfare-08\";s:20:\"astra-site-parent-id\";i:1741;s:15:\"astra-sites-tag\";a:7:{i:625;s:7:\"charity\";i:735;s:6:\"donate\";i:1013;s:8:\"donation\";i:624;s:10:\"foundation\";i:1482;s:6:\"givewp\";i:745;s:12:\"organization\";i:1012;s:7:\"welfare\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:39;s:4:\"free\";i:36;s:5:\"other\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:4:\"give\";s:4:\"init\";s:13:\"give/give.php\";s:4:\"name\";s:22:\"Give - Donation Plugin\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48493\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1026\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/animal-welfare-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48491\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-about.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1027\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/animal-welfare-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:0:{}}s:8:\"id-48494\";a:12:{s:5:\"title\";s:17:\"See All Campaigns\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-campaigns.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-campaigns-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1028\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/animal-welfare-08/see-all-campaigns/\";s:15:\"astra-sites-tag\";a:1:{i:1479;s:9:\"campaigns\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:4:\"give\";s:4:\"init\";s:13:\"give/give.php\";s:4:\"name\";s:22:\"Give - Donation Plugin\";}}}s:8:\"id-48495\";a:12:{s:5:\"title\";s:17:\"Star Contributors\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-contributors.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-contributors-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1029\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/animal-welfare-08/star-contributors/\";s:15:\"astra-sites-tag\";a:2:{i:1014;s:10:\"contribute\";i:1481;s:11:\"star-donors\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:4:\"give\";s:4:\"init\";s:13:\"give/give.php\";s:4:\"name\";s:22:\"Give - Donation Plugin\";}}}s:8:\"id-48492\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1030\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/animal-welfare-08/contact/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:454;s:10:\"contact-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48442\";a:13:{s:5:\"title\";s:14:\"Dentist Clinic\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08-400x1411.jpg\";s:14:\"astra-site-url\";s:29:\"//websitedemos.net/dentist-08\";s:20:\"astra-site-parent-id\";i:1733;s:15:\"astra-sites-tag\";a:3:{i:338;s:6:\"dental\";i:623;s:7:\"dentist\";i:1734;s:14:\"dentist-clinic\";}s:16:\"astra-sites-type\";s:4:\"free\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:10:\"categories\";a:0:{}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:1:{s:8:\"id-48443\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/dentist-08/wp-json/wp/v2/pages/409\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:30:\"//websitedemos.net/dentist-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47862\";a:13:{s:5:\"title\";s:11:\"Pet Sitting\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.